
// Part 1 about finding and counting Knight's tours
//==================================================

object CW7a extends App{

type Pos = (Int, Int)    // a position on a chessboard 
type Path = List[Pos]    // a path...a list of positions

//(1a) Complete the function that tests whether the position 
//     is inside the board and not yet element in the path.

//def is_legal(dim: Int, path: Path)(x: Pos) : Boolean = ...

def is_legal(dim: Int, path: Path)(x: Pos) : Boolean = {
  
// if ((x._1<dim && x._2<dim) && (x._1>0 || x._2>0)) false else !path.contains(x)
 
  if (x._1 < 0 || x._2 < 0) false 
  else if (x._1 < dim && x._2 < dim && !path.contains(x)) true 
  else false
 
  
}



def legal_moves(dim: Int, path: Path, x: Pos) : List[Pos] = {
  
  val allPossibleMoves = List((x._1+1, x._2+2), (x._1+2, x._2+1), (x._1+2, x._2-1), (x._1+1, x._2-2), (x._1-1, x._2-2), (x._1-2, x._2-1), (x._1-2, x._2+1), (x._1-1, x._2+2));
 
  //val finalList = allPossibleMoves.filter((a=>a._1<dim && a._2<dim && x._1 >= 0 && a._2 >= 0));
  
  val finalList = for(pos<-allPossibleMoves if(is_legal(dim,path)(pos))) yield pos;
  
  // println("Space in board: " + dim*dim + " for dim: " + dim)
   
  
  finalList.toList;
    
  
}

println(legal_moves(8, Nil, (2,2)))
println(legal_moves(8, Nil, (7,7)))
println(legal_moves(8, List((4,1), (1,0)), (2,2)))
println(legal_moves(8, List((6,6)), (7,7)))
println(legal_moves(1, Nil, (0,0)))
println(legal_moves(2, Nil, (0,0)))
println(legal_moves(3, Nil, (0,0)))

println("=================================================================================")
println("================================Comparision output===============================")
println("=================================================================================")

println(legal_moves(8, Nil, (2,2)) == List((3,4), (4,3), (4,1), (3,0), (1,0), (0,1), (0,3), (1,4)))
println(legal_moves(8, Nil, (7,7)) == List((6,5), (5,6)))
println(legal_moves(8, List((4,1), (1,0)), (2,2)) == List((3,4), (4,3), (3,0), (0,1), (0,3), (1,4)))
println(legal_moves(8, List((6,6)), (7,7)) == List((6,5), (5,6)))
println(legal_moves(1, Nil, (0,0)) == Nil)
println(legal_moves(2, Nil, (0,0)) == Nil)
println(legal_moves(3, Nil, (0,0)) == List((1,2), (2,1)))


def count_tours(dim: Int, path: Path) : Int = {
     
  val allMovesFromCurrentPosition = legal_moves(dim, path, path.head);
  
  if (path.length == dim*dim) 1 else  {
    
    if (allMovesFromCurrentPosition.size == 0 ) 0  else {
      
      allMovesFromCurrentPosition.map( element => count_tours(dim, element::path)).sum
      
      
    }
    
  }
  
}
    
  

println ( count_tours(5, List((0,0))) )

def enum_tours(dim: Int, path: Path) : List[Path] = {
  
     val allMovesFromCurrentPosition = legal_moves(dim, path, path.head);
  
  if (path.length == dim*dim) List(path) else  {
    
  allMovesFromCurrentPosition.map( element => enum_tours(dim, element::path)).flatten ;
      
      
      }
    }
  println ( enum_tours(6, List((0,2))).size)
}





 
 
//(1b) Complete the function that calculates for a position 
//     all legal onward moves that are not already in the path. 
//     The moves should be ordered in a "clockwise" manner.
 
//def legal_moves(dim: Int, path: Path, x: Pos) : List[Pos] = ...




//some test cases
//
//assert(legal_moves(8, Nil, (2,2)) == 
//  List((3,4), (4,3), (4,1), (3,0), (1,0), (0,1), (0,3), (1,4)))
//assert(legal_moves(8, Nil, (7,7)) == List((6,5), (5,6)))
//assert(legal_moves(8, List((4,1), (1,0)), (2,2)) == 
//  List((3,4), (4,3), (3,0), (0,1), (0,3), (1,4)))
//assert(legal_moves(8, List((6,6)), (7,7)) == List((6,5), (5,6)))


//(1c) Complete the two recursive functions below. 
//     They exhaustively search for knight's tours starting from the 
//     given path. The first function counts all possible tours, 
//     and the second collects all tours in a list of paths.

//def count_tours(dim: Int, path: Path) : Int = ...


//def enum_tours(dim: Int, path: Path) : List[Path] = ...
