#!/bin/bash
set -e

out=${1:-output}

echo -e "" > $out

echo -e "Below is the feedback for your submission of CW 10, Part 2." >> $out
echo -e "" >> $out


# compilation tests

function scala_compile {
   (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala "$1" 2>> $out 1>> $out)
}

# functional tests

function scala_assert {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -i "$1" "$2" -e "")  #2> /dev/null 1> /dev/null)   
}

# purity test

function scala_vars {
   (egrep '\bvar\b|\breturn\b|\.par|ListBuffer|mutable|new Array' "$1" 2> /dev/null 1> /dev/null)
}


# var, return, ListBuffer test
#
echo -e "bfc.scala does not contain vars, returns etc?" >> $out

if (scala_vars bfc.scala)
then
  echo -e "   --> fail (make triple-sure your program conforms to the required format)" >> $out  
  tsts0=$(( 0 ))
else
  echo -e "  --> success" >> $out
  tsts0=$(( 0 )) 
fi


# compilation test
if  [ $tsts0 -eq 0 ]
then    
  echo -e "bfc.scala runs?" >> $out

  if (scala_compile bfc.scala)
  then
    echo -e "  --> success" >> $out
    tsts1=$(( 0 ))
  else
    echo -e "  -->   --> SCALA DID NOT RUN BFC.SCALA\nx" >> $out
    tsts1=$(( 1 )) 
  fi
else
  tsts1=$(( 1 ))     
fi


### bfc tests

if [ $tsts1 -eq 0 ]
then
  echo -e " jtable(\"\"\"+++++[->++++++++++<]>--<+++[->>++++++++++<<]>>++<<----------[+>.>.<+<]\"\"\") ==" >> $out
  echo -e "     Map(69 -> 61, 5 -> 20, 60 -> 70, 27 -> 44, 43 -> 28, 19 -> 6)" >> $out  
  
  if (scala_assert "bfc.scala" "bf_test5.scala")
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> \n ONE TEST FAILED\n" >> $out
  fi
fi



if [ $tsts1 -eq 0 ]
then
  echo -e " optimise(load_bff(\"benchmark.bf\")).length == 181" >> $out
  echo -e " optimise(load_bff(\"mandelbrot.bf\")).length == 11203" >> $out  
  
  if (scala_assert "bfc.scala" "bf_test6.scala")
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> \n ONE TEST FAILED\n" >> $out
  fi
fi



if [ $tsts1 -eq 0 ]
then
    echo -e " combine(optimise(load_bff(\"benchmark.bf\"))).length == 134" >> $out
    echo -e " combine(optimise(load_bff(\"mandelbrot.bf\"))).length == 6509" >> $out
  
  if (scala_assert "bfc.scala" "bf_test7.scala")
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> \n ONE TEST FAILED\n" >> $out   
  fi
fi



