def myassert(cond : => Boolean) = {
  try {
    assert(cond)
  } catch { 
    case _ : Throwable => System.exit(1)
  }
}

// get_prices(List("GOOG", "AAPL"), 2010 to 2012)
val urban_prices = List(List(Some(312.204773), Some(26.782711)), 
                        List(Some(301.0466), Some(41.244694)), 
                        List(Some(331.462585), Some(51.464207)))


myassert(get_deltas(urban_prices) == List(List(Some(-0.03573991804411003), Some(0.539974575389325)), 
                                          List(Some(0.10103414222249969), Some(0.24777764141006836))))


//get_prices(List("BIDU"), 2004 to 2008)
val urban_prices2 = List(List(None), List(None), 
                         List(Some(6.35)), List(Some(12.241)), 
                         List(Some(38.188)))


myassert(get_deltas(urban_prices2) == List(List(None), List(None), 
                                        List(Some(0.9277165354330709)), 
                                        List(Some(2.119679764725104))))
