#!/bin/bash
set -e

out=${1:-output}

echo -e "" > $out

echo -e "Below is the feedback for your submission advanced part of drumb.scala:" >> $out
echo -e "" >> $out

# compilation tests

function scala_compile {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala "$1" 2>> $out 1>> $out) 
}

# functional tests

function scala_assert {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -i "$1" "$2" -e "" 2> /dev/null 1> /dev/null)
}

# purity test

function scala_vars {
   (egrep '\bvar\b|\breturn\b|\.par|ListBuffer|mutable|new Array' "$1" 2> /dev/null 1> /dev/null)
}


# var, .par return, ListBuffer test
#
echo -e "drumb.scala does not contain vars, returns etc?" >> $out

if (scala_vars drumb.scala)
then
  echo -e "  --> fail (make triple-sure your program conforms to the required format)" >> $out
  tsts0=$(( 0 ))
else
  echo -e "  --> success" >> $out
  tsts0=$(( 0 )) 
fi


# compilation test
if  [ $tsts0 -eq 0 ]
then 
  echo -e "drumb.scala runs?" >> $out

  if (scala_compile drumb.scala)
  then
    echo -e "  --> success" >> $out
    tsts=$(( 0 ))
  else
    echo -e "  --> SCALA DID NOT RUN DRUMB.SCALA\n" >> $out
    tsts=$(( 1 )) 
  fi
else
  tsts=$(( 1 ))     
fi

### get_deltas_test

if [ $tsts -eq 0 ]
then
  echo -e "  get_deltas(get_prices(List(\"GOOG\", \"AAPL\"), 2010 to 2012)) == " >> $out
  echo -e "    List(List(Some(-0.03573992567129673), Some(0.539975124774038)), " >> $out
  echo -e "         List(Some(0.10103412653643493), Some(0.24777709700099845)))" >> $out
  echo -e "" >> $out
  echo -e "  get_deltas(get_prices(List(\"BIDU\"), 2004 to 2008)) == " >> $out
  echo -e "    List(List(None), List(None),                          " >> $out
  echo -e "         List(Some(0.9277165354330709)), List(Some(2.119679764725104)))) " >> $out
  
  if (scala_assert "drumb.scala" "drumb_test5.scala") 
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> \n ONE TEST FAILED\n" >> $out
  fi
fi


### yield_tests

if [ $tsts -eq 0 ]
then
  echo -e "  val ds = get_deltas(get_prices(List(\"GOOG\", \"AAPL\"), 2010 to 2012))" >> $out
  echo -e "  yearly_yield(get_deltas(ds, 100, 0) == 125" >> $out
  echo -e "  yearly_yield(get_deltas(ds, 100, 1) == 117" >> $out
  
  if (scala_assert "drumb.scala" "drumb_test6.scala") 
  then
      echo -e "  --> success" >> $out
  else
      echo -e "  --> \n ONE TEST FAILED\n" >> $out  
  fi
fi

### investment_test

if [ $tsts -eq 0 ]
then
  echo -e "  investment(List(\"GOOG\", \"AAPL\", \"BIDU\"), 2000 to 2000, 100) == 100"   >> $out
  echo -e "  investment(List(\"GOOG\", \"AAPL\", \"BIDU\"), 2000 to 2001, 100) == 27 "   >> $out
  echo -e "  investment(List(\"GOOG\", \"AAPL\", \"BIDU\"), 2000 to 2002, 100) == 42 "   >> $out
  echo -e "  investment(List(\"GOOG\", \"AAPL\", \"BIDU\"), 2000 to 2003, 100) == 27 "   >> $out
  echo -e "  investment(List(\"GOOG\", \"AAPL\", \"BIDU\"), 2000 to 2004, 100) == 38 "   >> $out
  echo -e "  investment(List(\"GOOG\", \"AAPL\", \"BIDU\"), 2000 to 2005, 100) == 113"   >> $out
  echo -e "  investment(List(\"GOOG\", \"AAPL\", \"BIDU\"), 2000 to 2006, 100) == 254"   >> $out
  echo -e "  investment(List(\"GOOG\", \"AAPL\", \"BIDU\"), 2000 to 2007, 100) == 349"   >> $out
  
  if (scala_assert "drumb.scala" "drumb_test7.scala") 
  then
      echo -e "  --> success" >> $out
  else
      echo -e "  --> \n ONE TEST FAILED\n" >> $out    
  fi
fi

