#!/bin/bash

# to make the script fail safely
set -euo pipefail


out=${1:-output}

# read marks for CW7 part 1
marks=$(( `tail -1 $out` ))

echo $marks

echo "" >> $out

echo "Below is the feedback for your submission danube.scala" >> $out
echo "" >> $out


# compilation tests

function scala_compile {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala "$1" 2>> $out 1>> $out) 
}

# functional tests

function scala_assert {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -i "$1" "$2" -e "" 2> /dev/null 1> /dev/null)
}

# purity test

function scala_vars {
   (egrep '\bvar\b|\breturn\b|ListBuffer|mutable' "$1" 2> /dev/null 1> /dev/null)
}


# var, .par return, ListBuffer test
#
echo "danube.scala does not contain vars, returns etc?" | tee -a $out

if (scala_vars danube.scala)
then
  echo "  --> test failed" | tee -a $out
  tsts0=$(( 1 ))  
  echo "  --> fail (make triple-sure your program conforms to the required format)" | tee -a $out
  tsts0=$(( 0 ))
else
  echo "  --> success" | tee -a $out
  tsts0=$(( 0 )) 
fi

### compilation test


if  [ $tsts0 -eq 0 ]
then 
  echo "danube.scala runs?" | tee -a $out

  if (scala_compile danube.scala)
  then
    echo "  --> success" | tee -a $out
    tsts=$(( 0 ))
  else
    echo "  --> scala did not run danube.scala" | tee -a $out
    tsts=$(( 1 )) 
  fi
else
  tsts=$(( 1 ))     
fi

### danube get_cvs_url tests

if [ $tsts -eq 0 ]
then
  echo "danube.scala tests:" | tee -a $out
  echo "  val movies_url = \"\"\"https://nms.kcl.ac.uk/christian.urban/movies.csv\"\"\"" | tee -a $out
  echo "  get_csv_url(movies_url).length == 9742" | tee -a $out

  if (scala_assert "danube.scala" "danube_test1.scala")
  then
      echo "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
    echo "  --> one of the tests failed" | tee -a $out
  fi
fi

### danube processing tests

if [ $tsts -eq 0 ]
then
  echo "  val good_ratings = process_ratings(ratings)" | tee -a $out
  echo "  val movie_names = process_movies(movies)" | tee -a $out  
  echo "  " | tee -a $out
  echo "  good_ratings.length == 48580 " | tee -a $out
  echo "  movie_names.length == 9742 " | tee -a $out

  if (scala_assert "danube.scala" "danube_test2.scala") 
  then
      echo "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
    echo "  --> one of the tests failed" | tee -a $out
  fi
fi



## final marks
echo "Overall mark for CW 7, Part 1 + 2" | tee -a $out
echo "$marks" | tee -a $out


