#!/bin/bash
set -e

out=${1:-output}

echo "" > $out

echo "Below is the feedback for your submission of CW 8, Part 2." >> $out
echo "" >> $out


# compilation tests

function scala_compile {
  (ulimit -t 30 -m 1024000 ; scala "$1" 2>> $out 1>> $out) 
}

# functional tests

function scala_assert {
  (ulimit -t 30 -m 1024000 ; scala -i "$1" "$2" -e "" 2> /dev/null 1> /dev/null)
}

# purity test

function scala_vars {
   (egrep '\bvar\b|\breturn\b|\.par|ListBuffer|mutable|new Array' "$1" 2> /dev/null 1> /dev/null)
}


# var, return, ListBuffer test
#
echo "bf.scala does not contain vars, returns etc?" >> $out

if (scala_vars bf.scala)
then
  echo "  --> fail" >> $out
  tsts0=$(( 1 ))
else
  echo "  --> success" >> $out
  tsts0=$(( 0 )) 
fi


# compilation test
if  [ $tsts0 -eq 0 ]
then    
  echo "bf.scala runs?" >> $out

  if (scala_compile bf.scala)
  then
    echo "  --> success" >> $out
    tsts1=$(( 0 ))
  else
    echo "  --> scala bf.scala did not run successfully" >> $out
    tsts1=$(( 1 )) 
  fi
else
  tsts1=$(( 1 ))     
fi



if [ $tsts1 -eq 0 ]
then
  echo " sread(Map(), 2) == 0" >> $out
  echo " sread(Map(2 -> 1), 2) == 1" >> $out  
  echo " write(Map(), 1, 2) == Map(1 -> 2)" >> $out
  echo " write(Map(1 -> 0), 1, 2) == Map(1 -> 2)" >> $out
  
  if (scala_assert "bf.scala" "bf1a_test.scala")
  then
    echo "  --> success" >> $out
  else
    echo "  --> test failed" >> $out
  fi
fi



if [ $tsts1 -eq 0 ]
then
    echo " jumpRight(\"[******]***\", 1, 0) == 8" >> $out
    echo " jumpRight(\"[**[*]*]***\", 1, 0) == 8" >> $out
    echo " jumpRight(\"[**[*]*]***\", 1, 0) == 8" >> $out
    echo " jumpRight(\"[**[***]***\", 1, 0) == 11" >> $out
    echo " jumpRight(\"[*[][]*]***\", 1, 0) == 8" >> $out
    echo " jumpLeft(\"[******]***\", 6, 0) == 1" >> $out
    echo " jumpLeft(\"[******]***\", 7, 0) == -1" >> $out
    echo " jumpLeft(\"[*[][]*]***\", 6, 0) == 1" >> $out
  
  if (scala_assert "bf.scala" "bf1b_test.scala")
  then
    echo "  --> success" >> $out
  else
    echo "  --> test failed" >> $out
  fi
fi



if [ $tsts1 -eq 0 ]
then
  echo " start(\"[-]\", Map(0 -> 100)) == Map(0 -> 0)" >> $out
  echo " start(\"[->+<]\", Map(0 -> 10)) == Map(0 -> 0, 1 -> 10)" >> $out
  echo " start(\"[>>+>>+<<<<-]\", Map(0 -> 42)) == Map(0 -> 0, 2 -> 42, 4 -> 42)" >> $out
  echo " start({{hello world prg 1}}, Map()) == " >> $out
  echo "        Map(0 -> 0, 5 -> 33, 1 -> 0, 6 -> 10, 2 -> 72, 3 -> 100, 4 -> 87)" >> $out

  if (scala_assert "bf.scala" "bf1c_test.scala")
  then
    echo "  --> success" >> $out
  else
    echo "  --> test failed" >> $out
  fi
fi




