#!/bin/bash

# to make the script fail safely
set -euo pipefail


out=${1:-output}

echo "" > $out

echo "Below is the feedback and provisional marks for your submission" >> $out
echo "for assignment 7 Part 1 + 2.  Please note all marks are provisional until" >> $out
echo "ratified by the assessment board -- this is not an official" >> $out
echo "results transcript." >> $out
echo "" >> $out

echo "Below is the feedback for your submission docdiff.scala" >> $out
echo "" >> $out

# marks for CW7 parts 1 + 2
marks=$(( 0 ))


# compilation tests

function scala_compile {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -nc "$1" 2>> $out 1>> $out) 
}

# functional tests

function scala_assert {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -nc -i "$1" "$2" -e "" 2> /dev/null 1> /dev/null)
}

# purity test

function scala_vars {
   (egrep '\bvar\b|\breturn\b|ListBuffer|mutable' "$1" 2> /dev/null 1> /dev/null)
}


# var, .par return, ListBuffer test
#
echo "docdiff.scala does not contain vars, returns etc?" |  tee -a $out

if (scala_vars docdiff.scala)
then
  echo "  --> test failed" | tee -a $out  
  tsts0=$(( 1 ))
else
  echo "  --> success" |  tee -a $out
  tsts0=$(( 0 )) 
fi

### compilation test


if  [ $tsts0 -eq 0 ]
then 
  echo "docdiff.scala runs?" |  tee -a $out

  if (scala_compile docdiff.scala)
  then
    echo "  --> success" |  tee -a $out
    tsts=$(( 0 ))
  else
    echo "  --> scala did not run docdiff.scala" |  tee -a $out
    tsts=$(( 1 )) 
  fi
else
  tsts=$(( 1 ))     
fi

### docdiff clean tests

if [ $tsts -eq 0 ]
then
  echo "docdiff.scala tests:" |  tee -a $out
  echo "  clean(\"ab a abc\") == List(\"ab\", \"a\", \"abc\")" |  tee -a $out
  echo "  clean(\"ab*a abc1\") == List(\"ab\", \"a\", \"abc1\")" |  tee -a $out

  if (scala_assert "docdiff.scala" "docdiff_test1.scala")
  then
      echo "  --> success" |  tee -a $out
      marks=$(( marks + 1 ))
  else
    echo "  --> one of the tests failed" |  tee -a $out
  fi
fi

### docdiff occurrences tests

if [ $tsts -eq 0 ]
then
  echo "  occurrences(List(\"a\", \"b\", \"b\", \"c\", \"d\")) == " |  tee -a $out
  echo "      Map(\"a\" -> 1, \"b\" -> 2, \"c\" -> 1, \"d\" -> 1)" |  tee -a $out
  echo "  " |  tee -a $out
  echo "  occurrences(List(\"d\", \"b\", \"d\", \"b\", \"d\")) == " |  tee -a $out
  echo "      Map(\"d\" -> 3, \"b\" -> 2)" |  tee -a $out

  if (scala_assert "docdiff.scala" "docdiff_test2.scala") 
  then
      echo "  --> success" |  tee -a $out
      marks=$(( marks + 1 ))
  else
    echo "  --> one of the tests failed" |  tee -a $out
  fi
fi

### docdiff prod tests

if [ $tsts -eq 0 ]
then
  echo "  val l1 = List(\"a\", \"b\", \"b\", \"c\", \"d\")" |  tee -a $out
  echo "  val l2 = List(\"d\", \"b\", \"d\", \"b\", \"d\")" |  tee -a $out
  echo "  " |  tee -a $out
  echo "  prod(l1, l2) == 7 " |  tee -a $out
  echo "  prod(l1, l1) == 7 " |  tee -a $out
  echo "  prod(l2, l2) == 13 " |  tee -a $out

  if (scala_assert "docdiff.scala" "docdiff_test3.scala") 
  then
      echo "  --> success" |  tee -a $out
      marks=$(( marks + 1 ))
  else
    echo "  --> one of the tests failed" |  tee -a $out
  fi
fi

### docdiff overlap tests

if [ $tsts -eq 0 ]
then
  echo "  val l1 = List(\"a\", \"b\", \"b\", \"c\", \"d\")" |  tee -a $out
  echo "  val l2 = List(\"d\", \"b\", \"d\", \"b\", \"d\")" |  tee -a $out
  echo "  " |  tee -a $out
  echo "  overlap(l1, l2) == 0.5384615384615384 " |  tee -a $out
  echo "  overlap(l1, l1) == 1.0 " |  tee -a $out
  echo "  overlap(l2, l2) == 1.0 " |  tee -a $out

  if (scala_assert "docdiff.scala" "docdiff_test4.scala") 
  then
      echo "  --> success" |  tee -a $out
      marks=$(( marks + 1 ))
  else
    echo "  --> one of the tests failed" |  tee -a $out
  fi
fi


## final marks
echo "Overall mark for Part 1" | tee -a $out
echo " $marks" | tee -a $out

