#!/bin/bash
set -e

out=${1:-output}

echo "" > $out

echo "Below is the feedback for your submission of CW 8, Part 1." >> $out
echo "" >> $out


# compilation tests

function scala_compile {
  (ulimit -t 30 -m 1024000 ; scala "$1" 2>> $out 1>> $out) 
}

# functional tests

function scala_assert {
  (ulimit -t 30 -m 1024000 ; scala -i "$1" "$2" -e "" 2> /dev/null 1> /dev/null)
}

# purity test

function scala_vars {
   (egrep '\bvar\b|\breturn\b|\.par|ListBuffer|mutable|new Array' "$1" 2> /dev/null 1> /dev/null)
}


# var, return, ListBuffer test
#
echo "re.scala does not contain vars, returns etc?" >> $out

if (scala_vars re.scala)
then
  echo "  --> fail" >> $out
  tsts0=$(( 1 ))
else
  echo "  --> yes" >> $out
  tsts0=$(( 0 )) 
fi


# compilation test
if  [ $tsts0 -eq 0 ]
then    
  echo "re.scala runs?" >> $out

  if (scala_compile re.scala)
  then
    echo "  --> yes" >> $out
    tsts1=$(( 0 ))
  else
    echo "  --> scala re.scala did not run successfully" >> $out
    tsts1=$(( 1 )) 
  fi
else
  tsts1=$(( 1 ))     
fi



if [ $tsts1 -eq 0 ]
then
  echo " nullable(ZERO) == false" >> $out
  echo " nullable(ONE) == true" >> $out
  echo " nullable(CHAR('a')) == false" >> $out
  echo " nullable(ZERO | ONE) == true" >> $out
  echo " nullable(ZERO | CHAR('a')) == false" >> $out
  echo " nullable(ONE ~  ONE) == true" >> $out
  echo " nullable(ONE ~ CHAR('a')) == false" >> $out
  echo " nullable(STAR(ZERO)) == true" >> $out
  
  if (scala_assert "re.scala" "re1a_test.scala")
  then
    echo "  --> success" >> $out
  else
    echo "  --> test failed" >> $out
  fi
fi



if [ $tsts1 -eq 0 ]
then
  echo " der('a', ZERO | ONE) == (ZERO | ZERO)" >> $out
  echo " der('a', (CHAR('a') | ONE) ~ CHAR('a')) == ALT((ONE | ZERO) ~ CHAR('a'), ONE)" >> $out
  echo " der('a', STAR(CHAR('a'))) == (ONE ~ STAR(CHAR('a')))" >> $out
  echo " der('b', STAR(CHAR('a'))) == (ZERO ~ STAR(CHAR('a')))" >> $out
  
  if (scala_assert "re.scala" "re1b_test.scala")
  then
    echo "  --> success" >> $out
  else
    echo "  --> test failed" >> $out
  fi
fi



if [ $tsts1 -eq 0 ]
then
  echo " simp(ZERO | ONE) == ONE" >> $out
  echo " simp(STAR(ZERO | ONE)) == STAR(ZERO | ONE)" >> $out
  echo " simp(ONE ~ (ONE ~ (ONE ~ CHAR('a')))) == CHAR('a')" >> $out
  echo " simp(ONE ~ (ONE ~ (ONE ~ ZERO))) == ZERO" >> $out
  echo " simp(ALT(ONE ~ (ONE ~ (ONE ~ ZERO)), CHAR('a'))) == CHAR('a')" >> $out
  echo " simp(CHAR('a') | CHAR('a')) == CHAR('a')" >> $out
  echo " simp(ONE | CHAR('a')) == (ONE | CHAR('a'))" >> $out
  
  if (scala_assert "re.scala" "re1c_test.scala")
  then
    echo "  --> success" >> $out
  else
    echo "  --> test failed" >> $out
  fi
fi


if [ $tsts1 -eq 0 ]
then
  echo " let EVIL = (a*)* b" >> $out
  echo " ders(List.fill(5)('a'),EVIL) == SEQ(SEQ(STAR(CHAR('a')),STAR(STAR(CHAR('a')))),CHAR('b'))" >> $out
  echo " ders(List('b'),EVIL) == ONE" >> $out
  echo " ders(List('b','b'),EVIL) == ZERO" >> $out
  echo " matcher(EVIL, \"a\" * 5 ++ \"b\") == true" >> $out
  echo " matcher(EVIL, \"b\") == true" >> $out
  echo " matcher(EVIL, \"bb\") == false" >> $out
  echo " matcher(\"abc\", \"abc\") == true" >> $out
  echo " matcher((\"ab\" | \"a\") ~ (ONE | \"bc\"), \"abc\") == true" >> $out
  echo " matcher(ONE, \"\") == true" >> $out
  echo " matcher(ZERO, \"\") == false" >> $out
  echo " matcher(ONE | CHAR('a'), \"\") == true" >> $out
  echo " matcher(ONE | CHAR('a'), \"a\") == true" >> $out
  
  if (scala_assert "re.scala" "re1d_test.scala")
  then
    echo "  --> success" >> $out
  else
    echo "  --> test failed" >> $out
  fi
fi


if [ $tsts1 -eq 0 ]
then
  echo " let EVIL = (a*)* b" >> $out  
  echo " size(der('a', der('a', EVIL))) == 28" >> $out
  echo " size(der('a', der('a', der('a', EVIL)))) == 58" >> $out
  echo " size(ders(\"aaaaaa\".toList, EVIL)) == 8" >> $out
  
  if (scala_assert "re.scala" "re1e_test.scala")
  then
    echo "  --> success" >> $out
  else
    echo "  --> test failed" >> $out
  fi
fi


