#!/bin/bash

# to make the script fail safely
set -euo pipefail

out=${1:-output}

echo "" > $out

echo -e `date` >> $out
echo -e "" >> $out
echo -e "Below is the feedback and provisional marks for your submission" >> $out
echo -e "for the Core Part of Assignment 6.  Please note all marks are provisional until" >> $out
echo -e "ratified by the assessment board -- this is not an official" >> $out
echo -e "results transcript." >> $out
echo -e "" >> $out

# marks for CW6 main part 
marks=$(( 0 ))


echo -e "" >> $out
echo -e "Below is the feedback for your submission drumb.scala" >> $out
echo -e "" >> $out


# compilation tests

function scala_compile {
    (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala "$1" 2> /dev/null 1> /dev/null)
}

# functional tests

function scala_assert {
    (ulimit -t 30; JAVA_OPTS="-Xmx4g" scala -i "$1" -- "$2" -e "" 2> /dev/null 1> /dev/null)
}


# purity test

#function scala_vars {
#   (egrep '\bvar\b|\breturn\b|\.par|ListBuffer|mutable|new Array' "$1" 2> /dev/null 1> /dev/null)
#}

function scala_vars {
   (egrep '\bvar\b|\breturn\b|\.par|ListBuffer|new Array' "$1" 2> /dev/null 1> /dev/null)
}

# var, .par return, ListBuffer test
#
echo -e "drumb.scala does not contain vars, returns, Arrays, ListBuffers etc?" | tee -a $out

if (scala_vars drumb.scala)
then
  echo -e "  --> TEST FAILED\n" | tee -a $out
  tsts0=$(( 1 ))
else
  echo -e "  --> success" | tee -a $out
  tsts0=$(( 0 )) 
fi


# compilation test
if  [ $tsts0 -eq 0 ]
then 
  echo -e "drumb.scala runs?" | tee -a $out

  if (scala_compile drumb.scala)
  then
    echo -e "  --> success" | tee -a $out
    tsts=$(( 0 ))
  else
    echo -e "  --> SCALA DID NOT RUN drumb.scala" | tee -a $out
    tsts=$(( 1 )) 
  fi
else
  tsts=$(( 1 ))     
fi

echo >> $out

### get january tests

if [ $tsts -eq 0 ]
then
  echo -e "  get_january_data(\"GOOG\", 1980) == List()" | tee -a $out
  echo -e "  get_january_data(\"GOOG\", 2010).head == \"2010-01-04,312.204773\"" | tee -a $out

  if (scala_assert "drumb.scala" "drumb_test1.scala")
  then
      echo -e "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      echo -e "  --> TEST FAILED\n" | tee -a $out
  fi
fi

### get first price tests

if [ $tsts -eq 0 ]
then
  echo -e "  get_first_price(\"GOOG\", 1980) == None" | tee -a $out
  echo -e "  get_first_price(\"GOOG\", 2010) == Some(312.204773)" | tee -a $out

  if (scala_assert "drumb.scala" "drumb_test2.scala")
  then
      echo -e "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      echo -e "  --> TEST FAILED\n" | tee -a $out
  fi
fi

### get prices tests

if [ $tsts -eq 0 ]
then
  echo -e "  get_prices(List(\"BIDU\"), 2004 to 2008) ==" | tee -a $out
  echo -e "       List(List(None), List(None), List(Some(6.35)), " | tee -a $out
  echo -e "            List(Some(12.241)), List(Some(38.188)))" | tee -a $out
  echo -e " " | tee -a $out  
  echo -e "  get_prices(List(\"GOOG\", \"AAPL\"), 2010 to 2012) ==" | tee -a $out
  echo -e "       List(List(Some(312.204773), Some(26.782711))," | tee -a $out
  echo -e "            List(Some(301.0466),   Some(41.244694))," | tee -a $out
  echo -e "            List(Some(331.462585), Some(51.464207)))" | tee -a $out

  if (scala_assert "drumb.scala" "drumb_test3.scala")
  then
      echo -e "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      echo -e "  --> TEST FAILED\n" | tee -a $out
  fi
fi

### get_delta test

if [ $tsts -eq 0 ]
then
  echo -e "  get_delta(None, None) == None" | tee -a $out
  echo -e "  get_delta(Some(50.0), None) == None" | tee -a $out
  echo -e "  get_delta(None, Some(100.0)) == None" | tee -a $out
  echo -e "  get_delta(Some(50.0), Some(100.0)) == Some(1.0)" | tee -a $out

  if (scala_assert "drumb.scala" "drumb_test4.scala")
  then
      echo -e "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      echo -e "  --> TEST FAILED\n" | tee -a $out
  fi
fi


### get_deltas_test

if [ $tsts -eq 0 ]
then
  echo -e "  get_deltas(get_prices(List(\"GOOG\", \"AAPL\"), 2010 to 2012)) == " | tee -a $out
  echo -e "    List(List(Some(-0.03573991804411003), Some(0.539974575389325)), " | tee -a $out
  echo -e "         List(Some(0.10103414222249969), Some(0.24777764141006836)))" | tee -a $out
  echo -e "" | tee -a $out
  echo -e "  get_deltas(get_prices(List(\"BIDU\"), 2004 to 2008)) == " | tee -a $out
  echo -e "    List(List(None), List(None),                          " | tee -a $out
  echo -e "         List(Some(0.9277165354330709)), List(Some(2.119679764725104)))" | tee -a $out
  
  if (scala_assert "drumb.scala" "drumb_test5.scala") 
  then
     echo -e "  --> success" | tee -a $out
     marks=$(( marks + 1 ))
  else
     echo -e "  --> TEST FAILED\n" | tee -a $out
  fi
fi


### yield_tests

if [ $tsts -eq 0 ]
then
  echo -e "  val ds = get_deltas(get_prices(List(\"GOOG\", \"AAPL\"), 2010 to 2012))" | tee -a $out
  echo -e "  yearly_yield(ds, 100, 0) == 125" | tee -a $out
  echo -e "  yearly_yield(ds, 100, 1) == 117" | tee -a $out
  
  if (scala_assert "drumb.scala" "drumb_test6.scala") 
  then
      echo -e "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      echo -e "  --> TEST FAILED\n" | tee -a $out
  fi
fi


### investment_test

if [ $tsts -eq 0 ]
then
  echo -e "  All results need to be in the range of -/+ 1% of the given values."   | tee -a $out
  echo -e "   investment(List(\"GOOG\", \"AAPL\", \"BIDU\"), 2000 to 2000, 100) == 100"   | tee -a $out
  echo -e "   investment(List(\"GOOG\", \"AAPL\", \"BIDU\"), 2000 to 2001, 100) == 27 "   | tee -a $out
  echo -e "   investment(List(\"GOOG\", \"AAPL\", \"BIDU\"), 2000 to 2002, 100) == 42 "   | tee -a $out
  echo -e "   investment(List(\"GOOG\", \"AAPL\", \"BIDU\"), 2000 to 2003, 100) == 27 "   | tee -a $out
  echo -e "   investment(List(\"GOOG\", \"AAPL\", \"BIDU\"), 2000 to 2004, 100) == 38 "   | tee -a $out
  echo -e "   investment(List(\"GOOG\", \"AAPL\", \"BIDU\"), 2000 to 2005, 100) == 113"   | tee -a $out
  echo -e "   investment(List(\"GOOG\", \"AAPL\", \"BIDU\"), 2000 to 2006, 100) == 254"   | tee -a $out
  echo -e "   investment(List(\"GOOG\", \"AAPL\", \"BIDU\"), 2000 to 2007, 100) == 349"   | tee -a $out
  echo -e "   investment(List(\"GOOG\", \"AAPL\", \"BIDU\"), 1990 to 2017, 100) == 11504"   | tee -a $out
  
  
  if (scala_assert "drumb.scala" "drumb_test7.scala") 
  then
    echo -e "  --> success" | tee -a $out
    marks=$(( marks + 1 ))
  else
    echo -e "  --> TEST FAILED\n" | tee -a $out
  fi
fi

## final marks
echo -e "" >> $out
echo -e "Overall mark for CW 6, Core Part" | tee -a $out
echo -e "$marks" | tee -a $out
