#!/bin/bash

# to make the script fail safely
set -euo pipefail


out=${1:-output}

echo "" > $out

echo "Below is the feedback and provisional marks for your submission" >> $out
echo "for assignment 7 Part 2.  Please note all marks are provisional until" >> $out
echo "ratified by the assessment board -- this is not an official" >> $out
echo "results transcript." >> $out
echo "" >> $out

# marks for CW7 part 2
marks=$(( 0 ))

# compilation tests

function scala_compile {
    (ulimit -t 360; JAVA_OPTS="-Xmx1g" scala "$1" 2> /dev/null 1> /dev/null)
}

# functional tests

function scala_assert {
    (ulimit -t 360; JAVA_OPTS="-Xmx4g -Xss200m" scala -i "$1" "$2" -e "" 2> /dev/null 1> /dev/null)
}


# purity test

function scala_vars {
   (egrep '\bvar\b|\breturn\b|\.par|ListBuffer|mutable|new Array' "$1" 2> /dev/null 1> /dev/null)
}


# knights3: purity test
#
echo "knight3.scala does not contain vars, returns, Arrays, ListBuffers etc?" | tee -a $out


if (scala_vars knight3.scala)
then
  echo "  --> test failed" | tee -a $out
  tsts0=$(( 1 ))
else
  echo "  --> success" | tee -a $out
  tsts0=$(( 0 )) 
fi


# compilation test
if  [ $tsts0 -eq 0 ]
then    
  echo "knight3.scala runs?" | tee -a $out

  if (scala_compile knight3.scala)
  then
    echo "  --> success" | tee -a $out
    tsts1=$(( 0 ))
  else
    echo "  --> scala knight3.scala did not run successfully" | tee -a $out
    tsts1=$(( 1 )) 
  fi
else
  tsts1=$(( 1 ))     
fi

# ordered move test

if [ $tsts1 -eq 0 ]
then
  echo " ordered_moves(8, List((3,4), (3,2)), (1,3)) == List((0,1), (0,5), (2,1), (2,5))" | tee -a $out
  echo " ordered_moves(8, List((4,0)), (0,0)) == List((2,1), (1,2))" | tee -a $out
  echo " ordered_moves(8, List((0,4)), (0,0)) == List((1,2), (2,1))" | tee -a $out
  
  if (scala_assert "knight3.scala" "knight3a_test.scala")
  then
      echo "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
    echo "  --> test failed" | tee -a $out
  fi
fi


# first-closed-tour test

if [ $tsts1 -eq 0 ]
then
  echo " first_closed_tour_heuristic(6, List((3,3))) found and correct?" | tee -a $out
  
  if (scala_assert "knight3.scala" "knight3b_test.scala")
  then
      echo "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      echo "  --> test failed" | tee -a $out
  fi
fi



if [ $tsts1 -eq 0 ]
then
  echo " first_tour_heuristic(8, List((0,0))) found and correct?" | tee -a $out
  echo " first_tour_heuristic(40, List((0,0))) found and correct?" | tee -a $out
  
  if (scala_assert "knight3.scala" "knight3c_test.scala")
  then
      echo "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
    echo "  --> test failed" | tee -a $out
  fi
fi


## final marks
echo "Overall mark for CW 7, Part 2" | tee -a $out
echo "$marks" | tee -a $out
