// Part 1 about Regular Expression Matching
//==========================================

abstract class Rexp
case object ZERO extends Rexp
case object ONE extends Rexp
case class CHAR(c: Char) extends Rexp
case class ALT(r1: Rexp, r2: Rexp) extends Rexp 
case class SEQ(r1: Rexp, r2: Rexp) extends Rexp 
case class STAR(r: Rexp) extends Rexp 

// some convenience for typing in regular expressions

import scala.language.implicitConversions    
import scala.language.reflectiveCalls 

def charlist2rexp(s: List[Char]): Rexp = s match {
  case Nil => ONE
  case c::Nil => CHAR(c)
  case c::s => SEQ(CHAR(c), charlist2rexp(s))
}
implicit def string2rexp(s: String): Rexp = charlist2rexp(s.toList)

implicit def RexpOps (r: Rexp) = new {
  def | (s: Rexp) = ALT(r, s)
  def % = STAR(r)
  def ~ (s: Rexp) = SEQ(r, s)
}

implicit def stringOps (s: String) = new {
  def | (r: Rexp) = ALT(s, r)
  def | (r: String) = ALT(s, r)
  def % = STAR(s)
  def ~ (r: Rexp) = SEQ(s, r)
  def ~ (r: String) = SEQ(s, r)
}

// (1a) Complete the function nullable according to
// the definition given in the coursework; this 
// function checks whether a regular expression
// can match the empty string

def nullable (r: Rexp) : Boolean = r match {
  case ZERO => false
  case ONE => true
  case CHAR(_) => false
  case ALT(r1, r2) => nullable(r1) || nullable(r2)
  case SEQ(r1, r2) => nullable(r1) && nullable(r2)
  case STAR(_) => true
}

// (1b) Complete the function der according to
// the definition given in the coursework; this
// function calculates the derivative of a 
// regular expression w.r.t. a character

def der (c: Char, r: Rexp) : Rexp = r match {
  case ZERO => ZERO
  case ONE => ZERO
  case CHAR(d) => if (c == d) ONE else ZERO
  case ALT(r1, r2) => ALT(der(c, r1), der(c, r2))
  case SEQ(r1, r2) => 
    if (nullable(r1)) ALT(SEQ(der(c, r1), r2), der(c, r2))
    else SEQ(der(c, r1), r2)
  case STAR(r1) => SEQ(der(c, r1), STAR(r1))
}

// (1c) Complete the function der according to
// the specification given in the coursework; this
// function simplifies a regular expression;
// however it does not simplify inside STAR-regular
// expressions

def simp(r: Rexp) : Rexp = r match {
  case ALT(r1, r2) => (simp(r1), simp(r2)) match {
    case (ZERO, r2s) => r2s
    case (r1s, ZERO) => r1s
    case (r1s, r2s) => if (r1s == r2s) r1s else ALT (r1s, r2s)
  }
  case SEQ(r1, r2) =>  (simp(r1), simp(r2)) match {
    case (ZERO, _) => ZERO
    case (_, ZERO) => ZERO
    case (ONE, r2s) => r2s
    case (r1s, ONE) => r1s
    case (r1s, r2s) => SEQ(r1s, r2s)
  }
  case r => r
}

// (1d) Complete the two functions below; the first 
// calculates the derivative w.r.t. a string; the second
// is the regular expression matcher taking a regular
// expression and a string and checks whether the
// string matches the regular expression

def ders (s: List[Char], r: Rexp) : Rexp = s match {
  case Nil => r
  case c::s => ders(s, simp(der(c, r)))
}

// main matcher function
def matcher(r: Rexp, s: String): Boolean = nullable(ders(s.toList, r))


// (1e) Complete the function below: it searches (from the left to 
// right) in string s1 all the non-empty substrings that match the 
// regular expression -- these substrings are assumed to be
// the longest substrings matched by the regular expression and
// assumed to be non-overlapping. All these substrings in s1 are replaced
// by s2.



def splits(s: String): List[(String, String)] =
  (for (i <- (1 to s.length).toList) yield s.splitAt(i)).reverse
  
splits("abcde")
splits("")

def first(r: Rexp, lst: List[(String, String)]): Option[String] = lst match {
  case Nil => None
  case (s1, s2)::xs => if (matcher(r, s1)) Some(s2) else first(r, xs)
}
 
"abcd".head

def replace(r: Rexp, s1: String, s2: String): String = first(r, splits(s1)) match {
  case None if (s1 == "") => ""
  case None => s1.head.toString ++ replace(r, s1.tail, s2)
  case Some(s) => s2 ++ replace(r, s, s2) 
}
 
val s1 =  "aabbbaaaaaaabaaaaabbaaaabb"
val r: Rexp = "aa".% | "bb"
splits(s1)
first(r, splits(s1))

replace(r, s1, "c")

splits("bb")
first(r, splits("bb"))
replace(r, "abb", "c")


// PART 2
//========


// (2a)

import scala.annotation.tailrec

@tailrec
def iterT[A](n: Int, f: A => A, x: A): A = 
  if (n == 0) x else iterT(n - 1, f, f(x)) 


//non-tail recursive iter

//def iter[A](n: Int, f: A => A)(x: A): A = 
//  if (n == 0) x else f(iter(n - 1,f, x)) 



// (2b)

def size(r: Rexp): Int = r match {
  case ZERO => 1
  case ONE => 1
  case CHAR(_) => 1
  case ALT(r1, r2) => 1 + size(r1) + size (r2)
  case SEQ(r1, r2) => 1 + size(r1) + size (r2)
  case STAR(r1) => 1 + size(r1)
}


val EVIL = SEQ(STAR(STAR(CHAR('a'))), CHAR('b'))
size(iterT(20, (r: Rexp) => der('a', r), EVIL))        // should produce 7340068        
size(iterT(20, (r: Rexp) => simp(der('a', r)), EVIL))  // should produce 8


// (2c)

@tailrec
def fixpT[A](f: A => A, x: A): A = {
  val fx = f(x)
  if (fx == x) x else fixpT(f, fx) 
}

def ctest(n: Long): Long =
  if (n == 1) 1 else
    if (n % 2 == 0) n / 2 else 3 * n + 1

fixpT(ctest, 97L)
fixpT(ctest, 871L)
fixpT(ctest, 77031L)
fixpT(ctest, 837799L)

def foo(s: String): String = {
  if (matcher("a", s)) "a" else
  if (matcher("aa" ~ STAR("aa"), s)) s.take(s.length / 2) 
  else "a" ++ s * 3
}

fixpT(foo, "a" * 97)
fixpT(foo, "a" * 871)


