/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.parallel.mutable;

import java.io.Serializable;
import scala.Function1;
import scala.collection.DebugUtils$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.SeqOps;
import scala.collection.generic.Signalling;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.FlatHashTable;
import scala.collection.parallel.IterableSplitter;
import scala.collection.parallel.mutable.SizeMapUtils;
import scala.runtime.function.JProcedure1;

public interface ParFlatHashTable<T>
extends FlatHashTable<T> {
    public static boolean alwaysInitSizeMap$(ParFlatHashTable $this) {
        return $this.alwaysInitSizeMap();
    }

    @Override
    default public boolean alwaysInitSizeMap() {
        return true;
    }

    public abstract class ParFlatHashTableIterator
    implements IterableSplitter<T>,
    SizeMapUtils {
        private Signalling signalDelegate;
        private int idx;
        private final int until;
        private final int totalsize;
        private int traversed;
        private final Object[] itertable;
        private final /* synthetic */ ParFlatHashTable $outer;

        public ParFlatHashTableIterator(ParFlatHashTable $outer, int idx, int until, int totalsize) {
            this.idx = idx;
            this.until = until;
            this.totalsize = totalsize;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            IterableOnce.$init$((IterableOnce)this);
            IterableOnceOps.$init$((IterableOnceOps)this);
            Iterator.$init$((Iterator)this);
            IterableSplitter.$init$(this);
            this.traversed = 0;
            this.itertable = $outer.table();
            if (this.hasNext()) {
                this.scan();
            }
        }

        @Override
        public Signalling signalDelegate() {
            return this.signalDelegate;
        }

        @Override
        public void signalDelegate_$eq(Signalling x$1) {
            this.signalDelegate = x$1;
        }

        public int idx() {
            return this.idx;
        }

        public void idx_$eq(int x$1) {
            this.idx = x$1;
        }

        public int until() {
            return this.until;
        }

        public int totalsize() {
            return this.totalsize;
        }

        private void scan() {
            while (this.itertable[this.idx()] == null) {
                this.idx_$eq(this.idx() + 1);
            }
        }

        public abstract IterableSplitter<T> newIterator(int var1, int var2, int var3);

        @Override
        public int remaining() {
            return this.totalsize() - this.traversed;
        }

        public boolean hasNext() {
            return this.traversed < this.totalsize();
        }

        public T next() {
            if (this.hasNext()) {
                Object r = this.$outer.entryToElem(this.itertable[this.idx()]);
                ++this.traversed;
                this.idx_$eq(this.idx() + 1);
                if (this.hasNext()) {
                    this.scan();
                }
                return r;
            }
            return Iterator$.MODULE$.empty().next();
        }

        @Override
        public IterableSplitter<T> dup() {
            return this.newIterator(this.idx(), this.until(), this.totalsize());
        }

        @Override
        public Seq<IterableSplitter<T>> split() {
            if (this.remaining() > 1) {
                int divpt = (this.until() + this.idx()) / 2;
                int fstidx = this.idx();
                int fstuntil = divpt;
                int fsttotal = this.calcNumElems(this.idx(), divpt, this.itertable.length, this.$outer.sizeMapBucketSize());
                IterableSplitter fstit = this.newIterator(fstidx, fstuntil, fsttotal);
                int sndidx = divpt;
                int snduntil = this.until();
                int sndtotal = this.remaining() - fsttotal;
                IterableSplitter sndit = this.newIterator(sndidx, snduntil, sndtotal);
                return (Seq)((SeqOps)new .colon.colon(fstit, (List)new .colon.colon(sndit, (List)Nil$.MODULE$)));
            }
            return (Seq)((SeqOps)new .colon.colon((Object)this, (List)Nil$.MODULE$));
        }

        @Override
        public String debugInformation() {
            return this.buildString((Function1)(JProcedure1 & Serializable)append -> {
                append.apply((Object)"Parallel flat hash table iterator");
                append.apply((Object)"---------------------------------");
                append.apply((Object)new StringBuilder(20).append("Traversed/total: ").append(this.traversed).append(" / ").append(this.totalsize()).toString());
                append.apply((Object)new StringBuilder(20).append("Table idx/until: ").append(this.idx()).append(" / ").append(this.until()).toString());
                append.apply((Object)new StringBuilder(14).append("Table length: ").append(this.itertable.length).toString());
                append.apply((Object)"Table: ");
                append.apply((Object)DebugUtils$.MODULE$.arrayString(this.itertable, 0, this.itertable.length));
                append.apply((Object)"Sizemap: ");
                append.apply((Object)DebugUtils$.MODULE$.arrayString(this.$outer.sizemap(), 0, this.$outer.sizemap().length));
            });
        }

        @Override
        public int countElems(int from, int until) {
            int count = 0;
            for (int i = from; i < until; ++i) {
                if (this.itertable[i] == null) continue;
                ++count;
            }
            return count;
        }

        @Override
        public int countBucketSizes(int frombucket, int untilbucket) {
            int count = 0;
            for (int i = frombucket; i < untilbucket; ++i) {
                count += this.$outer.sizemap()[i];
            }
            return count;
        }

        public final /* synthetic */ ParFlatHashTable scala$collection$parallel$mutable$ParFlatHashTable$ParFlatHashTableIterator$$$outer() {
            return this.$outer;
        }
    }
}

