// Main Part 3 about Evil Wordle
//===============================


object M2 { 

import io.Source
import scala.util._

// ADD YOUR CODE BELOW
//======================


//(1)
def get_wordle_list(url: String) : List[String] = {
    Try(Source.fromURL(url).getLines.toList).getOrElse(List())
}

// val secrets = get_wordle_list("https://nms.kcl.ac.uk/christian.urban/wordle.txt")
// secrets.length // => 12972
// secrets.filter(_.length != 5) // => Nil

//(2) 
def removeN[A](xs: List[A], elem: A, n: Int) : List[A] = xs match {
    case Nil => Nil
    case x :: tail if x == elem && n > 0 => removeN(tail, elem, n - 1)
    case x :: tail => x :: removeN(tail, elem, n)
}


// removeN(List(1,2,3,2,1), 3, 1)  // => List(1, 2, 2, 1)
// removeN(List(1,2,3,2,1), 2, 1)  // => List(1, 3, 2, 1)
// removeN(List(1,2,3,2,1), 1, 1)  // => List(2, 3, 2, 1)
// removeN(List(1,2,3,2,1), 0, 2)  // => List(1, 2, 3, 2, 1)

// (3)
abstract class Tip
case object Absent extends Tip
case object Present extends Tip
case object Correct extends Tip


def pool(secret: String, word: String) : List[Char] = {
    (for(index <- (0 to word.length-1); if (word(index) != secret(index))) yield secret(index).toChar).toList
}
// t
def aux(secret: List[Char], word: List[Char], pool: List[Char]) : List[Tip] = {
    if (secret.isEmpty) List()
    else {
        if (secret.head == word.head) Correct :: aux(secret.tail, word.tail, pool)
        else if (pool.contains(word.head)) Present :: aux(secret.tail, word.tail, pool.filterNot(_ == word.head))
        else Absent :: aux(secret.tail, word.tail, pool)
    }
}

def score(secret: String, word: String) : List[Tip] = aux(secret.toList, word.toList, pool(secret, word))


// score("chess", "caves") // => List(Correct, Absent, Absent, Present, Correct)
// score("doses", "slide") // => List(Present, Absent, Absent, Present, Present)
// score("chess", "swiss") // => List(Absent, Absent, Absent, Correct, Correct)
// score("chess", "eexss") // => List(Present, Absent, Absent, Correct, Correct)

// (4)
def eval(t: Tip) : Int = t match {
    case Correct => 10
    case Present => 1
    case Absent => 0 
}

def iscore(secret: String, word: String) : Int =  (for(current <- score(secret, word)) yield eval(current)).sum
    

//iscore("chess", "caves") // => 21
//iscore("chess", "swiss") // => 20

// (5) t
def lowest(secrets: List[String], word: String, current: Int, acc: List[String]) : List[String] = {
    if (secrets.isEmpty) acc
    else {
        val score = iscore(secrets.head, word)
        
        if (score == current) lowest(secrets.tail, word, current, secrets.head :: acc)
        else if (score < current) lowest(secrets.tail, word, score, List(secrets.head))
        else lowest(secrets.tail, word, current, acc)
    }
}

def evil(secrets: List[String], word: String) = lowest(secrets, word, Int.MaxValue ,List())


//evil(secrets, "stent").length
//evil(secrets, "hexes").length
//evil(secrets, "horse").length
//evil(secrets, "hoise").length
//evil(secrets, "house").length

// (6) t
def frequencies(secrets: List[String]) : Map[Char, Double] = {
    val occurrences = secrets.mkString.groupBy(identity).mapValues(_.length)
    val all_letters = secrets.mkString.length.toDouble
    occurrences.map{ case (c, n) => c -> (1 - n/all_letters) }.toMap
}

// (7) 
def rank(frqs: Map[Char, Double], s: String) : Double = s.map(c => frqs(c)).sum


def ranked_evil(secrets: List[String], word: String): List[String] = {
    val frqs = frequencies(secrets)
    val ranked_secrets = evil(secrets, word).map(s => (s, rank(frqs, s)))
    List((ranked_secrets.sortWith(_._2 > _._2)).map(_._1).head )
}
    
}






// This template code is subject to copyright 
// by King's College London, 2022. Do not 
// make the template code public in any shape 
// or form, and do not exchange it with other 
// students under any circumstance.
