/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.parallel.mutable;

import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.DebugUtils$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.generic.Signalling;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashEntry;
import scala.collection.mutable.HashTable;
import scala.collection.parallel.BufferSplitter;
import scala.collection.parallel.IterableSplitter;
import scala.collection.parallel.mutable.SizeMapUtils;
import scala.collection.parallel.mutable.WithContents;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public interface ParHashTable<K, V, Entry extends HashEntry<K, Entry>>
extends HashTable<K, V, Entry>,
WithContents<K, V, Entry> {
    public static boolean alwaysInitSizeMap$(ParHashTable $this) {
        return $this.alwaysInitSizeMap();
    }

    default public boolean alwaysInitSizeMap() {
        return true;
    }

    public static /* synthetic */ String scala$collection$parallel$mutable$ParHashTable$EntryIterator$$_$debugInformation$$anonfun$1$$anonfun$1(HashEntry x) {
        return x != null ? x.toString() : "n/a";
    }

    public static class Contents<A, Entry extends HashEntry<A, Entry>> {
        private final int loadFactor;
        private final HashEntry[] table;
        private final int tableSize;
        private final int threshold;
        private final int seedvalue;
        private final int[] sizemap;

        public Contents(int loadFactor, HashEntry<A, Entry>[] table, int tableSize, int threshold, int seedvalue, int[] sizemap) {
            this.loadFactor = loadFactor;
            this.table = table;
            this.tableSize = tableSize;
            this.threshold = threshold;
            this.seedvalue = seedvalue;
            this.sizemap = sizemap;
        }

        public int loadFactor() {
            return this.loadFactor;
        }

        public HashEntry<A, Entry>[] table() {
            return this.table;
        }

        public int tableSize() {
            return this.tableSize;
        }

        public int threshold() {
            return this.threshold;
        }

        public int seedvalue() {
            return this.seedvalue;
        }

        public int[] sizemap() {
            return this.sizemap;
        }

        public String debugInformation() {
            return DebugUtils$.MODULE$.buildString((Function1<Function1<Object, BoxedUnit>, BoxedUnit>)(JProcedure1 & Serializable)append -> {
                append.apply((Object)"Hash table contents");
                append.apply((Object)"-------------------");
                append.apply((Object)("Table: [" + DebugUtils$.MODULE$.arrayString(this.table(), 0, this.table().length) + "]"));
                append.apply((Object)("Table size: " + this.tableSize()));
                append.apply((Object)("Load factor: " + this.loadFactor()));
                append.apply((Object)("Seedvalue: " + this.seedvalue()));
                append.apply((Object)("Threshold: " + this.threshold()));
                append.apply((Object)("Sizemap: [" + DebugUtils$.MODULE$.arrayString(this.sizemap(), 0, this.sizemap().length) + "]"));
            });
        }
    }

    public abstract class EntryIterator<T, IterRepr extends IterableSplitter<T>>
    implements IterableSplitter<T>,
    SizeMapUtils {
        private Signalling signalDelegate;
        private int idx;
        private final int until;
        private final int totalsize;
        private HashEntry es;
        private final HashEntry<K, Entry>[] itertable;
        private int traversed;
        private final ParHashTable<K, V, Entry> $outer;

        public EntryIterator(int idx, int until, int totalsize, Entry es) {
            this.idx = idx;
            this.until = until;
            this.totalsize = totalsize;
            this.es = es;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            IterableOnce.$init$((IterableOnce)this);
            IterableOnceOps.$init$((IterableOnceOps)this);
            Iterator.$init$((Iterator)this);
            IterableSplitter.$init$(this);
            this.itertable = $outer.table();
            this.traversed = 0;
            this.scan();
        }

        @Override
        public Signalling signalDelegate() {
            return this.signalDelegate;
        }

        @Override
        public void signalDelegate_$eq(Signalling x$1) {
            this.signalDelegate = x$1;
        }

        private int idx() {
            return this.idx;
        }

        private void idx_$eq(int x$0) {
            this.idx = x$0;
        }

        private int until() {
            return this.until;
        }

        private int totalsize() {
            return this.totalsize;
        }

        private Entry es() {
            return this.es;
        }

        private void es_$eq(Entry x$0) {
            this.es = x$0;
        }

        public abstract T entry2item(Entry var1);

        public abstract IterRepr newIterator(int var1, int var2, int var3, Entry var4);

        public boolean hasNext() {
            return this.es() != null;
        }

        public T next() {
            Object res = this.es();
            this.es_$eq(this.es().next());
            this.scan();
            ++this.traversed;
            return this.entry2item(res);
        }

        public void scan() {
            while (this.es() == null && this.idx() < this.until()) {
                this.es_$eq(this.itertable[this.idx()]);
                this.idx_$eq(this.idx() + 1);
            }
        }

        @Override
        public int remaining() {
            return this.totalsize() - this.traversed;
        }

        @Override
        public String debugInformation() {
            return this.buildString((Function1)(JProcedure1 & Serializable)append -> {
                append.apply((Object)"/--------------------\\");
                append.apply((Object)"Parallel hash table entry iterator");
                append.apply((Object)("total hash table elements: " + this.$outer.tableSize()));
                append.apply((Object)("pos: " + this.idx()));
                append.apply((Object)("until: " + this.until()));
                append.apply((Object)("traversed: " + this.traversed));
                append.apply((Object)("totalsize: " + this.totalsize()));
                append.apply((Object)("current entry: " + this.es()));
                append.apply((Object)("underlying from " + this.idx() + " until " + this.until()));
                Object object = Predef$.MODULE$.refArrayOps((Object[])this.itertable);
                Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.slice$extension(object, this.idx(), this.until()));
                append.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object2, ParHashTable::scala$collection$parallel$mutable$ParHashTable$EntryIterator$$_$debugInformation$$anonfun$1$$anonfun$1, ClassTag$.MODULE$.apply(String.class))).mkString(" | "));
                append.apply((Object)"\\--------------------/");
            });
        }

        @Override
        public IterableSplitter<T> dup() {
            return this.newIterator(this.idx(), this.until(), this.totalsize(), this.es());
        }

        @Override
        public Seq<IterableSplitter<T>> split() {
            Seq seq;
            if (this.remaining() > 1) {
                if (this.until() > this.idx()) {
                    int divsz = (this.until() - this.idx()) / 2;
                    int sidx = this.idx() + divsz + 1;
                    int suntil = this.until();
                    HashEntry ses = this.itertable[sidx - 1];
                    int stotal = this.calcNumElems(sidx - 1, suntil, this.$outer.table().length, this.$outer.sizeMapBucketSize());
                    int fidx = this.idx();
                    int funtil = this.idx() + divsz;
                    Object fes = this.es();
                    int ftotal = this.totalsize() - stotal;
                    seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IterableSplitter[]{this.newIterator(fidx, funtil, ftotal, fes), this.newIterator(sidx, suntil, stotal, ses)}));
                } else {
                    ArrayBuffer<T> arr = this.convertToArrayBuffer(this.es());
                    BufferSplitter<T> arrpit = new BufferSplitter<T>(arr, 0, arr.length(), this.signalDelegate());
                    seq = arrpit.split();
                }
            } else {
                seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IterableSplitter[]{this}));
            }
            return seq;
        }

        private ArrayBuffer<T> convertToArrayBuffer(Entry chainhead) {
            ArrayBuffer buff = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new HashEntry[0]));
            for (Object curr = chainhead; curr != null; curr = curr.next()) {
                buff.$plus$eq(curr);
            }
            return (ArrayBuffer)buff.map((Function1 & Serializable)e -> this.entry2item(e));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int countElems(int from, int until) {
            void var3_3;
            int c = 0;
            HashEntry es = null;
            for (int idx = from; idx < until; ++idx) {
                for (es = this.itertable[idx]; es != null; es = es.next()) {
                    ++c;
                }
            }
            return (int)var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int countBucketSizes(int fromBucket, int untilBucket) {
            void var3_3;
            int c = 0;
            for (int idx = fromBucket; idx < untilBucket; ++idx) {
                c += this.$outer.sizemap()[idx];
            }
            return (int)var3_3;
        }

        public final ParHashTable<K, V, Entry> scala$collection$parallel$mutable$ParHashTable$EntryIterator$$$outer() {
            return this.$outer;
        }
    }
}

