#!/bin/bash

# to make the script fail safely
set -euo pipefail


out=${1:-output}

echo -e "" > $out


echo -e "Below is the feedback and provisional marks for your submission" >> $out
echo -e "for assignment 10 Part 1.  Please note all marks are provisional until" >> $out
echo -e "ratified by the assessment board -- this is not an official" >> $out
echo -e "results transcript." >> $out
echo -e "" >> $out

# marks for CW10 part 1
marks=$(( 0 ))

# compilation tests

function scala_compile {
    (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala "$1" 2> /dev/null 1> /dev/null)
}

# functional tests

function scala_assert {
    (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -i "$1" -- "$2" 2> /dev/null 1> /dev/null)
}


# purity test

function scala_vars {
   (egrep '\bvar\b|\breturn\b|\.par|ListBuffer|mutable|new Array' "$1" 2> /dev/null 1> /dev/null)
}



# var, return, ListBuffer test
#
echo -e "bf.scala does not contain vars, returns, Arrays, ListBuffers etc?" | tee -a $out

if (scala_vars bf.scala)
then
  echo -e "  --> FAIL (make triple-sure your program conforms to the required format)" | tee -a $out
  tsts0=$(( 1 ))
else
  echo -e "  --> success" | tee -a $out
  tsts0=$(( 0 )) 
fi


# compilation test
if  [ $tsts0 -eq 0 ]
then    
  echo -e "bf.scala runs?" | tee -a $out

  if (scala_compile bf.scala)
  then
    echo -e "  --> success" | tee -a $out
    tsts1=$(( 0 ))
  else
    echo -e "  --> SCALA DID NOT RUN BF.SCALA\n" | tee -a $out
    tsts1=$(( 1 )) 
  fi
else
  tsts1=$(( 1 ))     
fi


### bf1 test

if [ $tsts1 -eq 0 ]
then
  echo -e " load_bff(\"benchmark.bf\").length == 188" | tee -a $out
  echo -e " load_bff(\"foobar.bf\") == \"\"" | tee -a $out  
   
  if (scala_assert "bf.scala" "bf_test1.scala")
  then
      echo -e "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      echo -e "  --> \n ONE TEST FAILED\n" | tee -a $out
  fi
fi


### bf2 test

if [ $tsts1 -eq 0 ]
then
  echo -e " sread(Map(), 2) == 0" | tee -a $out
  echo -e " sread(Map(2 -> 1), 2) == 1" | tee -a $out  
  echo -e " write(Map(), 1, 2) == Map(1 -> 2)" | tee -a $out
  echo -e " write(Map(1 -> 0), 1, 2) == Map(1 -> 2)" | tee -a $out
  
  if (scala_assert "bf.scala" "bf_test2.scala")
  then
      echo -e "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      echo -e "  --> \n ONE TEST FAILED\n" | tee -a $out
  fi
fi

### bf3 test

if [ $tsts1 -eq 0 ]
then
    echo -e " jumpRight(\"[xxxxxx]xxx\", 1, 0) == 8" | tee -a $out
    echo -e " jumpRight(\"[xx[x]x]xxx\", 1, 0) == 8" | tee -a $out
    echo -e " jumpRight(\"[xx[x]x]xxx\", 1, 0) == 8" | tee -a $out
    echo -e " jumpRight(\"[xx[xxx]xxx\", 1, 0) == 11" | tee -a $out
    echo -e " jumpRight(\"[x[][]x]xxx\", 1, 0) == 8" | tee -a $out
    echo -e " jumpLeft(\"[xxxxxx]xxx\", 6, 0) == 1" | tee -a $out
    echo -e " jumpLeft(\"[xxxxxx]xxx\", 7, 0) == -1" | tee -a $out
    echo -e " jumpLeft(\"[x[][]x]xxx\", 6, 0) == 1" | tee -a $out
  
  if (scala_assert "bf.scala" "bf_test3.scala")
  then
      echo -e "  --> success" | tee -a $out
      marks=$(( marks + 2 ))
  else
      echo -e "  --> \n ONE TEST FAILED\n" | tee -a $out
  fi
fi



if [ $tsts1 -eq 0 ]
then
  echo -e " run(\"[-]\", Map(0 -> 100)) == Map(0 -> 0)" | tee -a $out
  echo -e " run(\"[->+<]\", Map(0 -> 10)) == Map(0 -> 0, 1 -> 10)" | tee -a $out
  echo -e " run(\"[>>+>>+<<<<-]\", Map(0 -> 42)) == Map(0 -> 0, 2 -> 42, 4 -> 42)" | tee -a $out
  echo -e " run(\"\"\"+++++[->++++++++++<]>--<+++[->>++++++++++" | tee -a $out
  echo -e "        <<]>>++<<----------[+>.>.<+<]\"\"\") == Map(0 -> 0, 1 -> 58, 2 -> 32)" | tee -a $out
  echo -e " val hello = \"\"\"++++++++[>++++[>++>+++>+++>+<<<<-]>+>+>->>+[<]<-]>>.>---." | tee -a $out
  echo -e "               +++++++..+++.>>.<-.<.+++.------.--------.>>+.>++.\"\"\"" | tee -a $out
  echo -e " run(hello, Map()) == " | tee -a $out
  echo -e "       Map(0 -> 0, 5 -> 33, 1 -> 0, 6 -> 10, 2 -> 72, 3 -> 100, 4 -> 87)" | tee -a $out
  
  if (scala_assert "bf.scala" "bf_test4.scala")
  then
      echo -e "  --> success" | tee -a $out
      marks=$(( marks + 2 ))
  else
      echo -e "  --> \n ONE TEST FAILED\n" | tee -a $out
  fi
fi


## final marks
echo -e "Overall mark for CW 10, Part 1" | tee -a $out
echo -e "$marks" | tee -a $out

