import M2._


// first test 

val ls1_urban = List(("1", "a"), ("2", "a"), ("1", "c"), ("2", "a"), ("1", "c"))

val m_urban = groupById(ls1_urban, Map())

assert(m_urban.getOrElse("1", Nil).count(_ == "c") == 2)
assert(m_urban.getOrElse("1", Nil).count(_ == "a") == 1)
assert(m_urban.getOrElse("2", Nil) == List("a", "a"))

// second test

def urban_gb(ratings: List[(String, String)]) = 
  ratings.groupBy(_._1).view.mapValues(_.map(_._2).toSet).toMap 

def urban_gb2(ratings: List[(String, String)]) = 
  ratings.groupBy(_._1).view.mapValues(_.map(_._2)).toMap 

def urban_ck(ratings: List[(String, String)]) =
  urban_gb(ratings) == groupById(ratings, Map()).view.mapValues(_.toSet).toMap


val ls2_urban = List(("1", "a"), ("1", "b"), ("2", "x"), ("3", "a"), ("2", "y"), ("3", "c"))

assert(urban_ck(ls2_urban))

// thrird test

val ls3_urban = (1 to 1000).map(_.toString).toList
val ls4_urban = ls3_urban zip ls3_urban.tail
val ls5_urban = ls4_urban ::: ls4_urban.reverse

assert(urban_ck(ls5_urban))

// fourth test !!!

/*
 
val ls6_urban = (10 to 500 by 10).map(_.toString).toList
val ls7_urban = ls6_urban zip ls6_urban.tail
val ls8_urban = ls7_urban ::: ls7_urban.reverse

assert(urban_ck(ls8_urban)) 
*/
