// Main Part 3 about Evil Wordle
//===============================


object M2 { 

import io.Source
import scala.util._

// ADD YOUR CODE BELOW
//======================
// def main(args: Array[String]): Unit = {

//     val secrets = get_wordle_list("https://nms.kcl.ac.uk/christian.urban/wordle.txt")
//     println(ranked_evil(secrets, "beats")== List("fuzzy"))
//     println(ranked_evil(secrets, "vitae") == List("fuzzy"))
//     println(ranked_evil(secrets, "bento") == List("fuzzy"))
//     println(ranked_evil(secrets, "belts") == List("fuzzy"))
//     println(ranked_evil(secrets, "abbey") == List("whizz"))
//     println(ranked_evil(secrets, "afear") == List("buzzy"))
//     println(ranked_evil(secrets, "zincy") == List("jugum"))
//     println(ranked_evil(secrets, "zippy") == List("chuff"))
   
    
//    }

//(1)
def get_wordle_list(url: String) : List[String] = {
    try {
        Source.fromURL(url).getLines.toList;
    }
    catch {
        case _ : Throwable => List();
    }    
}
// val secrets = get_wordle_list("https://nms.kcl.ac.uk/christian.urban/wordle.txt")
// secrets.length // => 12972
// secrets.filter(_.length != 5) // => Nil

//(2)
def removeN[A](xs: List[A], elem: A, n: Int) : List[A] = {
    if (xs.isEmpty || n == 0 || !xs.contains(elem)){
        xs
    }
    else{
        val (newLst,newLst2) = xs.splitAt(xs.indexOf(elem))
        removeN(newLst ++ newLst2.tail,elem, n-1)
    }
}

// removeN(List(1,2,3,2,1), 3, 1)  // => List(1, 2, 2, 1)
// removeN(List(1,2,3,2,1), 2, 1)  // => List(1, 3, 2, 1)
// removeN(List(1,2,3,2,1), 1, 1)  // => List(2, 3, 2, 1)
// removeN(List(1,2,3,2,1), 0, 2)  // => List(1, 2, 3, 2, 1)

// (3)
abstract class Tip
case object Absent extends Tip
case object Present extends Tip
case object Correct extends Tip


def pool(secret: String, word: String) : List[Char] = {
    //print(secret.toList, word.toList)
    val lst= ((0 to 4).map(x => {
        if(!secret(x).equals(word(x))) Some(secret(x)) else None
        
        }).toList)
    lst.flatten
}


def aux(secret: List[Char], word: List[Char], pool: List[Char]) : List[Tip] = {
   
    if (secret.length == 1){
        if (secret.head == word.head){
            List(Correct)
        }
        else if (pool.contains(word.head)){
            List(Present) 
        }
        else {
            List(Absent) 
        }
    }
    else if (secret.head == word.head){
        List(Correct) ++ aux(secret.tail, word.tail, pool)
    }
    else if (pool.contains(word.head)){
        List(Present) ++ aux(secret.tail, word.tail, removeN(pool, word.head, 1))
    }
    else {
        List(Absent) ++ aux(secret.tail, word.tail, pool)
    }
}

def score(secret: String, word: String) : List[Tip] = {
    aux(secret.toList,word.toList,pool(secret,word))
}


// score("chess", "caves") // => List(Correct, Absent, Absent, Present, Correct)
// score("doses", "slide") // => List(Present, Absent, Absent, Present, Present)
// score("chess", "swiss") // => List(Absent, Absent, Absent, Correct, Correct)
// score("chess", "eexss") // => List(Present, Absent, Absent, Correct, Correct)

// (4)
def eval(t: Tip) : Int = {
    if (t == Correct) 10
    else if (t == Present) 1
    else 0
}

def iscore(secret: String, word: String) : Int = {
    val scoreList = score(secret,word)
    scoreList.map(x =>(eval(x))).toList.sum
}

//iscore("chess", "caves") // => 21
//iscore("chess", "swiss") // => 20

// (5)
def lowest(secrets: List[String], word: String, current: Int, acc: List[String]) : List[String] = {
    if(secrets.isEmpty) acc
    else if (iscore(secrets.head,word)<current){
        lowest(secrets.tail, word, iscore(secrets.head,word), List(secrets.head))
    }
    else if (iscore(secrets.head,word)==current){
        lowest(secrets.tail, word, current, acc :+ secrets.head)
    }
    else {
        lowest(secrets.tail, word, current, acc)
    }

}

def evil(secrets: List[String], word: String) = {
    lowest(secrets, word, 100, List())
}


//evil(secrets, "stent").length
//evil(secrets, "hexes").length
//evil(secrets, "horse").length
//evil(secrets, "hoise").length
//evil(secrets, "house").length

// (6)
def frequencies(secrets: List[String]) : Map[Char, Double] = {
    val totalChar = secrets.flatMap(_.toList).size.toDouble
    val freqMap = secrets.flatMap(_.toList).groupBy(identity)
    freqMap.map(x => (x._1, (1-(x._2.size.toDouble/ totalChar))))

}

// (7)
def rank(frqs: Map[Char, Double], s: String) = {
    s.map(x => (frqs(x))).toList.sum
}

def ranked_evil(secrets: List[String], word: String) : List[String]= {
    val evilWords = evil(secrets,word)
    val returnVal = evilWords.map(x => (x, rank(frequencies(secrets),x))).toMap.maxBy(_._2)._1
    List(returnVal)
}


}






// This template code is subject to copyright 
// by King's College London, 2022. Do not 
// make the template code public in any shape 
// or form, and do not exchange it with other 
// students under any circumstance.
