#!/bin/bash
set -euo pipefail


out=${1:-output}

echo -e "" > $out

echo -e "Below is the feedback for your submission of re.scala." >> $out
echo -e "" >> $out


# compilation tests

function scala_compile {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -Xprint:parser "$1" 2> c$out 1> c$out)
}

# functional tests

function scala_assert {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -i "$1" -- "$2" -e "" 2> /dev/null 1> /dev/null)
}

# purity test

function scala_vars {
   (egrep '\bvar\b|\breturn\b|\.par\.|\.par |ListBuffer|mutable|util.control|new Array' c$out 2> /dev/null 1> /dev/null)
}



# compilation test

echo -e "re.scala runs?" >> $out

if (scala_compile re.scala)
then
    echo -e "  --> yes" >> $out
    tsts=$(( 0 ))
else
    echo -e "  --> SCALA DID NOT RUN RE.SCALA\n" >> $out
    tsts=$(( 1 )) 
fi

# var, return, ListBuffer test
#

if [ $tsts -eq 0 ]
then
    echo -e "re.scala does not contain vars, returns etc?" >> $out

    if (scala_vars re.scala)
    then
	echo -e "   --> FAIL (make triple-sure your program conforms to the required format)" >> $out 
	tsts=$(( 1 ))
    else
	echo -e "  --> success" >> $out
	tsts=$(( 0 )) 
    fi
fi



### re tests

if [ $tsts -eq 0 ]
then
  echo -e " nullable(ZERO) == false" >> $out
  echo -e " nullable(ONE) == true" >> $out
  echo -e " nullable(CHAR('a')) == false" >> $out
  echo -e " nullable(ZERO | ONE) == true" >> $out
  echo -e " nullable(ZERO | CHAR('a')) == false" >> $out
  echo -e " nullable(ONE ~  ONE) == true" >> $out
  echo -e " nullable(ONE ~ CHAR('a')) == false" >> $out
  echo -e " nullable(STAR(ZERO)) == true" >> $out
  
  if (scala_assert "re.scala" "re_test1.scala")
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> \n ONE TEST FAILED\n" >> $out
  fi
fi



if [ $tsts -eq 0 ]
then
  echo -e " der('a', ZERO | ONE) == (ZERO | ZERO)" >> $out
  echo -e " der('a', (CHAR('a') | ONE) ~ CHAR('a')) ==" >> $out
  echo -e "                 ALT((ONE | ZERO) ~ CHAR('a'), ONE)" >> $out
  echo -e " der('a', STAR(CHAR('a'))) == (ONE ~ STAR(CHAR('a')))" >> $out
  echo -e " der('b', STAR(CHAR('a'))) == (ZERO ~ STAR(CHAR('a')))" >> $out
  
  if (scala_assert "re.scala" "re_test2.scala")
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> \n ONE TEST FAILED\n" >> $out
  fi
fi



if [ $tsts -eq 0 ]
then
  echo -e " simp(ZERO | ONE) == ONE" >> $out
  echo -e " simp(STAR(ZERO | ONE)) == STAR(ZERO | ONE)" >> $out
  echo -e " simp(ONE ~ (ONE ~ (ONE ~ CHAR('a')))) == CHAR('a')" >> $out
  echo -e " simp(((ONE ~ ONE) ~ ONE) ~ CHAR('a')) == CHAR('a'))" >> $out
  echo -e " simp(((ONE | ONE) ~ ONE) ~ CHAR('a')) == CHAR('a'))" >> $out
  echo -e " simp(ONE ~ (ONE ~ (ONE ~ ZERO))) == ZERO" >> $out
  echo -e " simp(ALT(ONE ~ (ONE ~ (ONE ~ ZERO)), CHAR('a'))) == CHAR('a')" >> $out
  echo -e " simp(CHAR('a') | CHAR('a')) == CHAR('a')" >> $out
  echo -e " simp(CHAR('a') ~ CHAR('a')) == CHAR('a') ~ CHAR('a')" >> $out
  echo -e " simp(ONE | CHAR('a')) == (ONE | CHAR('a'))" >> $out
  echo -e " simp(ALT((CHAR('a') | ZERO) ~ ONE," >> $out
  echo -e "          ((ONE | CHAR('b')) | CHAR('c')) ~ (CHAR('d') ~ ZERO))) == CHAR('a')" >> $out
  echo -e " simp((ZERO | ((ZERO | ZERO) | (ZERO | ZERO))) ~ ((ONE | ZERO) | ONE ) ~ (CHAR('a'))) == ZERO" >> $out
  echo -e " simp(ALT(ONE | ONE, ONE | ONE)) == ONE" >> $out
  echo -e " simp(ALT(ZERO | CHAR('a'), CHAR('a') | ZERO)) == CHAR('a')" >> $out
  echo -e " simp(ALT(ONE | CHAR('a'), CHAR('a') | ONE)) == ALT(ONE | CHAR('a'), CHAR('a') | ONE)" >> $out
  if (scala_assert "re.scala" "re_test3.scala")
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> \n ONE TEST FAILED\n" >> $out
  fi
fi


if [ $tsts -eq 0 ]
then
  echo -e " val EVIL = SEQ(STAR(STAR(CHAR('a'))), CHAR('b'))" >> $out
  echo -e " ders(\"aaaaa\".toList, EVIL) == SEQ(SEQ(STAR(CHAR('a')),STAR(STAR(CHAR('a')))),CHAR('b'))" >> $out
  echo -e " ders(List('b'), EVIL) == ONE" >> $out
  echo -e " ders(\"bb\".toList, EVIL) == ZERO" >> $out
  echo -e " matcher(EVIL, \"a\" * 5 ++ \"b\") == true" >> $out
  echo -e " matcher(EVIL, \"b\") == true" >> $out
  echo -e " matcher(EVIL, \"bb\") == false" >> $out
  echo -e " matcher(\"abc\", \"abc\") == true" >> $out
  echo -e " matcher((\"ab\" | \"a\") ~ (ONE | \"bc\"), \"abc\") == true" >> $out
  echo -e " matcher(ONE, \"\") == true" >> $out
  echo -e " matcher(ZERO, \"\") == false" >> $out
  echo -e " matcher(ONE | CHAR('a'), \"\") == true" >> $out
  echo -e " matcher(ONE | CHAR('a'), \"a\") == true" >> $out
  
  if (scala_assert "re.scala" "re_test4.scala")
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> \n ONE TEST FAILED\n" >> $out  
  fi
fi


if [ $tsts -eq 0 ]
then
  echo -e " val EVIL = SEQ(STAR(STAR(CHAR('a'))), CHAR('b'))" >> $out  
  echo -e " size(der('a', der('a', EVIL))) == 28" >> $out
  echo -e " size(der('a', der('a', der('a', EVIL)))) == 58" >> $out
  echo -e " size(ders(\"aaaaaa\".toList, EVIL)) == 8" >> $out
  
  if (scala_assert "re.scala" "re_test5.scala")
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> \n ONE TEST FAILED\n" >> $out   
  fi
fi


