#!/bin/bash
set -e

out=${1:-output}

echo "" > $out

echo "Below is the feedback for your submission of CW 7, Part 3." >> $out
echo "" >> $out

function scala_vars {
   (egrep '\bvar\b|\breturn\b|ListBuffer|mutable' "$1" 2> /dev/null 1> /dev/null)
}

# compilation tests

function scala_compile {
  (ulimit -t 30 -m 1024000 ; scala "$1" 2>> $out 1>> $out) 
}

# functional tests

function scala_assert {
    (ulimit -t 300 -m 1024000 ; scala -i "$1" "$2" -e "" 2> /dev/null 1> /dev/null)
}

# purity test

function scala_vars {
   (egrep '\bvar\b|\breturn\b|\.par|ListBuffer|mutable' "$1" 2> /dev/null 1> /dev/null)
}


# knights3: purity test
#
echo "knight3.scala does not contain vars, returns etc?" >> $out

if (scala_vars knight3.scala)
then
  echo "  --> fail" >> $out
  tsts0=$(( 1 ))
else
  echo "  --> success" >> $out
  tsts0=$(( 0 )) 
fi


# compilation test
if  [ $tsts0 -eq 0 ]
then    
  echo "knight3.scala runs?" >> $out

  if (scala_compile knight3.scala)
  then
    echo "  --> success" >> $out
    tsts1=$(( 0 ))
  else
    echo "  --> scala knight3.scala did not run successfully" >> $out
    tsts1=$(( 1 )) 
  fi
else
  tsts1=$(( 1 ))     
fi

# ordered move test

if [ $tsts1 -eq 0 ]
then
  echo " ordered_moves(8, List((3,4), (3,2)), (1, 3)) == List((0,1), (0,5), (2,1), (2,5))" >> $out
  echo " ordered_moves(8, List((4,0)), (0,0)) == List((2,1), (1,2))" >> $out
  echo " ordered_moves(8, List((0,4)), (0,0)) == List((1,2), (2,1))" >> $out
  
  if (scala_assert "knight3.scala" "knight3a_test.scala")
  then
    echo "  --> success" >> $out
  else
    echo "  --> test failed" >> $out
  fi
fi


# first-closed-tour test

if [ $tsts1 -eq 0 ]
then
  echo " first_closed_tour_heuristic(6, List((3, 3))) found and ok?" >> $out
  
  if (scala_assert "knight3.scala" "knight3b_test.scala")
  then
    echo "  --> success" >> $out
  else
    echo "  --> test failed" >> $out
  fi
fi



if [ $tsts1 -eq 0 ]
then
  echo " first_tour_heuristic(8, List((0,0))) found and ok?" >> $out
  echo " first_tour_heuristic(40, List((0,0))) found and ok?" >> $out
  
  if (scala_assert "knight3.scala" "knight3c_test.scala")
  then
    echo "  --> success" >> $out
  else
    echo "  --> test failed" >> $out
  fi
fi


## final marks
##echo "Overall mark for CW 7, Part 2" | tee -a $out
##echo "$marks" | tee -a $out
