// Advanced Part 3 about a really dumb investment strategy
//==========================================================

object CW6c {


//two test portfolios

val blchip_portfolio = List("GOOG", "AAPL", "MSFT", "IBM", "FB", "AMZN", "BIDU")
val rstate_portfolio = List("PLD", "PSA", "AMT", "AIV", "AVB", "BXP", "CCI","DLR", "EQIX", "EQR", "ESS", "EXR", "FRT", "GGP", "HCP") 

// (1.a) The function below takes a stock symbol and a year as arguments.
//       It should read the corresponding CSV-file and read the January 
//       data from the given year. The data should be collected in a list of
//       strings for each line in the CSV-file.

import io.Source
import scala.util._

def get_january_data(symbol: String, year: Int) : List[String] = {
	val file = symbol + ".csv"
	val list = scala.io.Source.fromFile(file).mkString.split("\n").toList
	val rx = (year.toString + ".*")
	(for(n <- 1 to list.length -1 if(list(n) matches rx)) yield list(n)).toList
}


// (1.b) From the output of the get_january_data function, the next function 
//       should extract the first line (if it exists) and the corresponding
//       first trading price in that year as Option[Double]. If no line is 
//       generated by get_january_data then the result is None


def get_first_price(symbol: String, year: Int) : Option[Double] = {
	val first_line = get_january_data(symbol, year)

	if(first_line.length == 0 ){
		None
	} else {
	Option((first_line(0).split(",")(1)).toDouble)
	}
}


// (1.c) Complete the function below that obtains all first prices
//       for the stock symbols from a portfolio (list of strings) and 
//       for the given range of years. The inner lists are for the
//       stock symbols and the outer list for the years.


def get_prices(portfolio: List[String], years: Range) : List[List[Option[Double]]] ={
	(for(y <- years) yield (for(n <- 0 to portfolio.length-1) yield get_first_price(portfolio(n), y)).toList).toList
}



// (2) The first function below calculates the change factor (dta) between
//     a price in year n and a price in year n + 1. The second function calculates
//     all change factors for all prices (from a portfolio). The input to this
//     function are the nested lists created by get_prices above.

def get_delta(price_old: Option[Double], price_new: Option[Double]) : Option[Double] = {
	for( x <- price_old; y <- price_new) yield (y-x)/x
}

def get_deltas(data: List[List[Option[Double]]]) :  List[List[Option[Double]]] = {
	(for( n <- 1 to data.length-1) yield (for(i <- 0 to data(n).length-1) yield  get_delta(data(n-1)(i), data(n)(i))).toList).toList
}



// (3) Write a function that given change factors, a starting balance and a year
//     calculates the yearly yield, i.e. new balance, according to our dump investment 
//     strategy. Another function calculates given the same data calculates the
//     compound yield up to a given year. Finally a function combines all 
//     calculations by taking a portfolio, a range of years and a start balance
//     as arguments.


def yearly_yield(data: List[List[Option[Double]]], balance: Long, year: Int) : Long = {
	val increments = (for(n <- 0 to data(year).length-1 if(!(data(year)(n) == None))) yield (data(year)(n).getOrElse(0.0))).toList
	val sumi = (increments.sum).toDouble
	if(increments.length == 0){
		balance
	}else{
		val il = (increments.length).toDouble
		val averag = sumi/il
		val i = (balance + (balance*averag))
		i.toLong
	}
}

def compound_yield(data: List[List[Option[Double]]], balance: Long, ye: Int) : Long = {//if(year == 0) yearly_yield(data, balance, 0) else compound_yield(data, yearly_yield(data, balance, year), year-1)
	val increments_py = (for(year <- 0 to ye) yield {
		val increments = (for(n <- 0 to data(year).length-1 if(!(data(year)(n) == None))) yield (data(year)(n).getOrElse(0.0))).toList
		val sum_of = (increments.sum).toDouble
		val number_of = (increments.length).toDouble
		sum_of/number_of + 1.0
	}).toList
	val mul_factor = increments_py.reduceLeft(_*_)
	(balance*mul_factor).toLong
}
def investment(portfolio: List[String], years: Range, start_balance: Long) : Long = {
	val p = get_prices(portfolio, years)
	val d = get_deltas(p)
	compound_yield(d, start_balance, d.length-1)
}



//test cases for the two portfolios given above

investment(rstate_portfolio, 1978 to 2017, 100)
investment(blchip_portfolio, 1978 to 2017, 100)

}
