// Scala Lecture 2
//=================


// Option type
//=============
val lst = List(None, Some(1), Some(2), None, Some(3))

lst.flatten
Some(1).get

val ps = List((3, 0), (3, 2), (4, 2), (2, 0), (1, 0), (1, 1))

for ((x, y) <- ps) yield {
  if (y == 0) None else Some(x / y)
}

// sudoku
// some none
// pattern matching

//type abbreviations
type Pos = (int, Int)

//sorting, higher-order functions
//lexicographic ordering


// Implicits
//===========
//
// for example adding your own methods to Strings:
// imagine you want to increment strings, like
//
//     "HAL".increment
//
// you can avoid ugly fudges, like a MyString, by
// using implicit conversions


implicit class MyString(s: String) {
  def increment = for (c <- s) yield (c + 1).toChar 
}

"HAL".increment
