// Part 1


//(1)
def collatz(n: Long): List[Long] =
  if (n == 1) List(1) else
    if (n % 2 == 0) (n::collatz(n / 2)) else 
      (n::collatz(3 * n + 1))

// an alternative that calculates the steps directly
def collatz1(n: Long): Int =
  if (n == 1) 1 else
    if (n % 2 == 0) (1 + collatz1(n / 2)) else 
      (1 + collatz1(3 * n + 1))


//(2)
def collatz_max(bnd: Int): Int = {
  (for (i <- 1 to bnd) yield collatz(i).length).max
}


val bnds = List(10, 100, 1000, 10000, 100000, 1000000, 10000000)

for (bnd <- bnds) {
  val max = collatz_max(bnd)
  println(s"In the range of 1 - ${bnd} the maximum steps are ${max}")
}

