#!/bin/bash

# to make the script fail safely
set -euo pipefail


out=${1:-output}

echo -e "" > $out

echo -e "Below is the feedback for your submission collatz.scala" >> $out
echo -e "" >> $out


# compilation tests

function scala_compile {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -Xprint:parser "$1" 2> c$out 1> c$out)
}

# functional tests

function scala_assert {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -i "$1" -- "$2" -e "" 2> /dev/null 1> /dev/null)
}

# purity test

function scala_vars {
   (egrep '\bvar\b|\breturn\b|\.par\.|\.par |ListBuffer|mutable|util.control|new Array' c$out 2> /dev/null 1> /dev/null)
}


### compilation test

echo -e "collatz.scala runs?" >> $out

if (scala_compile collatz.scala)
then
    echo -e "  --> passed" >> $out
    tsts=$(( 0 ))
else
    echo -e "  --> SCALA DID NOT RUN collatz.scala\n" >> $out
    tsts=$(( 1 )) 
fi



# var, .par return, ListBuffer test
#
echo -e "collatz.scala does not contain VARS, RETURNS etc?" >> $out

if  [ $tsts -eq 0 ]
then 
   if (scala_vars collatz.scala)
   then
      echo -e "  --> FAIL (make triple-sure your program conforms to the required format)\n" >> $out
      tsts=$(( 1 ))
   else
      echo -e "  --> passed" >> $out
      tsts=$(( 0 )) 
   fi
fi    


### collatz tests

if [ $tsts -eq 0 ]
then
  echo -e "collatz.scala tests:" >> $out
  echo -e "  collatz(1) == 0" >> $out
  echo -e "  collatz(6) == 8" >> $out
  echo -e "  collatz(9) == 19" >> $out

  if (scala_assert "collatz.scala" "collatz_test1.scala")
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> ONE OF THE TESTS FAILED\n" >> $out
  fi
fi

### collatz-max tests

if [ $tsts -eq 0 ]
then
  echo -e "  collatz_max(10) == (19, 9)" >> $out
  echo -e "  collatz_max(100) == (118, 97)" >> $out
  echo -e "  collatz_max(1000) == (178, 871)" >> $out
  echo -e "  collatz_max(10000) == (261, 6171)" >> $out
  echo -e "  collatz_max(100000) == (350, 77031)" >> $out
  echo -e "  collatz_max(1000000) == (524, 837799)" >> $out

  if (scala_assert "collatz.scala" "collatz_test2.scala") 
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> ONE OF THE TESTS FAILED\n" >> $out
  fi
fi


### last-odd tests

if [ $tsts -eq 0 ]
then
  echo -e "  last_odd(113) == 85" >> $out
  echo -e "  last_odd(84) == 21" >> $out
  echo -e "  last_odd(605) == 341" >> $out

  if (scala_assert "collatz.scala" "collatz_test3.scala") 
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> ONE OF THE TESTS FAILED\n" >> $out
  fi
fi
