
// webpages


//**Assignments (values)**
//(variable names should be lower case)
//=====================================
val x = 42
val y = 3 + 4


//**Collections**
//===============
List(1,2,3,1)
Set(1,2,3,1)

1 to 10
(1 to 10).toList

(1 until 10).toList

// an element in a list
List(1,2,3,1)(0)
List(1,2,3,1)(3)


//**Printing/Strings**
//====================

println("test")


val tst = "This is a " + "test" 
println(tst)

val lst = List(1,2,3,1)

println(lst.toString)
println(lst.mkString("\n"))

// some methods take more than one argument
println(lst.mkString("[",",","]"))

//**Conversion methods**
//======================

List(1,2,3,1).toString
List(1,2,3,1).toSet
"hello".toList
1.toDouble

//**Types**
//=========

// Int, Long, BigInt
// String, Char
// List[Int], Set[Double]
// Pairs: (Int, String)        
// List[(BigInt, String)]


//**Smart Strings**
//=================
""" """

//**Pairs/Tuples**
//================

val p = (1, "one")
p._1
p._2

val t = (4,1,2,3)
t._4

//**Function Definitions**
//========================

def square(x: Int): Int = x * x

//**Ifs control structures**
//==========================

def fact(n: Int): Int = 
  if (n == 0) 1 else n * fact(n - 1)





def fact2(n: BigInt): BigInt = 
  if (n == 0) 1 else n * fact2(n - 1)

def fib(n: Int): Int =
  if (n == 0) 1 else
    if (n == 1) 1 else fib(n - 1) + f(n - 2)


//a recursive function
def gcd(x: Int, y: Int): Int = 2 //??? 

//**String Interpolations**
//=========================


//**Assert/Testing**
====================

//**For-Maps (not For-Loops)**
//============================

for (n <- (1 to 10).toList) yield square(n)

for (n <- (1 to 10).toList; m <- (1 to 10).toList) yield m * n

val mtable = for (n <- (1 to 10).toList; m <- (1 to 10).toList) yield m * n

mtable.sliding(10,10).toList.mkString(
