// Advanvced Part 3 about Mr T. Drumb investing into stocks
//==========================================================

//two test portfolios

val blchip_portfolio = List("GOOG", "AAPL", "MSFT", "IBM", "FB", "YHOO", "AMZN", "BIDU")
val rstate_portfolio = List("PLD", "PSA", "AMT", "AIV", "AVB", "BXP", "CBG", "CCI", 
                            "DLR", "EQIX", "EQR", "ESS", "EXR", "FRT", "GGP", "HCP") 


import io.Source
import scala.util._

def get_yahoo_page(url: String): Option[List[String]] = {
  Try(Some(Source.fromURL(url)("ISO-8859-1").getLines.toList)).
    getOrElse { None }
}

def get_first_price(symbol: String, year: Int): Option[Double] = {
  //println(s"download..${symbol} at ${year}")
  val year_string = year.toString
  val date_string = s"&a=0&b=1&c=${year_string}&d=1&e=1&f=${year_string}"
  val url = """http://ichart.yahoo.com/table.csv?s=""" + symbol + date_string
  val data = get_yahoo_page(url)
  data.map(_.last.split(",").toList(6).toDouble)
}

def get_prices(portfolio: List[String], years: Range): List[List[Option[Double]]] = 
  for (year <- years.toList) yield
    for (symbol <- portfolio) yield get_first_price(symbol, year)

get_prices(List("GOOG", "AAPL"), 2010 to 2012)


def get_delta(price_old: Option[Double], price_new: Option[Double]): Option[Double] = {
  (price_old, price_new) match {
    case (Some(x), Some(y)) => Some((y - x) / x)
    case _ => None
  }
}

def get_deltas(data: List[List[Option[Double]]]):  List[List[Option[Double]]] =
  for (i <- (0 until (data.length - 1)).toList) yield 
    for (j <- (0 until (data(0).length)).toList) yield get_delta(data(i)(j), data(i + 1)(j))

def yearly_yield(data: List[List[Option[Double]]], balance: Long, year: Int): Long = {
  val somes = data(year).flatten
  val somes_length = somes.length
  if (somes_length == 0) balance
  else {
    val portion: Double = balance / somes_length
    balance + (for (x <- somes) yield (x * portion)).sum.toLong
  }
}

def compound_yield(data: List[List[Option[Double]]], balance: Long, year: Int): Long = {
  if (year >= data.length) balance else {
    val new_balance = yearly_yield(data, balance, year)
    compound_yield(data, new_balance, year + 1)
  }
}

val p = get_prices(List("GOOG", "AAPL"), 2010 to 2012)
val d = get_deltas(p)
yearly_yield(d, 100, 0)

def investment(portfolio: List[String], years: Range, start_balance: Long): Long = {
  compound_yield(get_deltas(get_prices(portfolio, years)), start_balance, 0)
}


println("Real data: " + investment(rstate_portfolio, 1978 to 2016, 100))
println("Blue data: " + investment(blchip_portfolio, 1978 to 2016, 100))

