// Part 1 about the 3n+1 conjecture
//==================================

object CW6a {

def collatz(n: Long): Long =
  if (n == 1) 1 else
    if (n % 2 == 0) 1 + collatz(n / 2) else 
      1 + collatz(3 * n + 1)


def collatz_max(bnd: Long): (Long, Long) = {
  val all = for (i <- (1 to bnd.toInt).toList) yield collatz(i)
  val max = all.max
  (max, all.indexOf(max) + 1)
}


// some testing harness...5 Mio pushes the envelope

val bnds = List(2, 10, 100, 1000, 10000, 100000, 
		77000, 90000, 1000000, 5000000)

for (bnd <- bnds) {
  val (steps, max) = collatz_max(bnd)
  println(s"In the range of 1 - ${bnd} the number ${max} needs the maximum steps of ${steps}")
}


}

