#!/bin/bash
set -e

out=${1:-output}

echo -e "" > $out

echo -e "Below is the feedback for your submission of CW 10, Part 1." >> $out
echo -e "" >> $out


# compilation tests

function scala_compile {
   (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala "$1" 2>> $out 1>> $out)
}

# functional tests

function scala_assert {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -nc -i "$1" "$2" -e "" 2> /dev/null 1> /dev/null)   
}

# purity test

function scala_vars {
   (egrep '\bvar\b|\breturn\b|\.par|ListBuffer|mutable|new Array' "$1" 2> /dev/null 1> /dev/null)
}


# var, return, ListBuffer test
#
echo -e "bf.scala does not contain vars, returns etc?" >> $out

if (scala_vars bf.scala)
then
  echo -e "   --> fail (make triple-sure your program conforms to the required format)" >> $out  
  tsts0=$(( 0 ))
else
  echo -e "  --> success" >> $out
  tsts0=$(( 0 )) 
fi


# compilation test
if  [ $tsts0 -eq 0 ]
then    
  echo -e "bf.scala runs?" >> $out

  if (scala_compile bf.scala)
  then
    echo -e "  --> success" >> $out
    tsts1=$(( 0 ))
  else
    echo -e "  -->   --> SCALA DID NOT RUN BF.SCALA\nx" >> $out
    tsts1=$(( 1 )) 
  fi
else
  tsts1=$(( 1 ))     
fi


### bf tests

if [ $tsts1 -eq 0 ]
then
  echo -e " load_bff(\"benchmark.bf\").length == 188" >> $out
  echo -e " load_bff(\"foobar.bf\") == \"\"" >> $out  
  
  if (scala_assert "bf.scala" "bf_test1.scala")
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> \n ONE TEST FAILED\n" >> $out
  fi
fi

if [ $tsts1 -eq 0 ]
then
  echo -e " sread(Map(), 2) == 0" >> $out
  echo -e " sread(Map(2 -> 1), 2) == 1" >> $out  
  echo -e " write(Map(), 1, 2) == Map(1 -> 2)" >> $out
  echo -e " write(Map(1 -> 0), 1, 2) == Map(1 -> 2)" >> $out
  
  if (scala_assert "bf.scala" "bf_test2.scala")
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> \n ONE TEST FAILED\n" >> $out
  fi
fi



if [ $tsts1 -eq 0 ]
then
    echo -e " jumpRight(\"[******]***\", 1, 0) == 8" >> $out
    echo -e " jumpRight(\"[**[*]*]***\", 1, 0) == 8" >> $out
    echo -e " jumpRight(\"[**[*]*]***\", 1, 0) == 8" >> $out
    echo -e " jumpRight(\"[**[***]***\", 1, 0) == 11" >> $out
    echo -e " jumpRight(\"[*[][]*]***\", 1, 0) == 8" >> $out
    echo -e " jumpLeft(\"[******]***\", 6, 0) == 1" >> $out
    echo -e " jumpLeft(\"[******]***\", 7, 0) == -1" >> $out
    echo -e " jumpLeft(\"[*[][]*]***\", 6, 0) == 1" >> $out
  
  if (scala_assert "bf.scala" "bf_test3.scala")
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> \n ONE TEST FAILED\n" >> $out   
  fi
fi



if [ $tsts1 -eq 0 ]
then
  echo -e " run(\"[-]\", Map(0 -> 100)) == Map(0 -> 0)" >> $out
  echo -e " run(\"[->+<]\", Map(0 -> 10)) == Map(0 -> 0, 1 -> 10)" >> $out
  echo -e " run(\"[>>+>>+<<<<-]\", Map(0 -> 42)) == Map(0 -> 0, 2 -> 42, 4 -> 42)" >> $out
  echo -e " run(\"\"\"+++++[->++++++++++<]>--<+++[->>++++++++++" >> $out
  echo -e "        <<]>>++<<----------[+>.>.<+<]\"\"\") == Map(0 -> 0, 1 -> 58, 2 -> 32)" >> $out

  if (scala_assert "bf.scala" "bf_test4.scala")
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> \n ONE TEST FAILED\n" >> $out 
  fi
fi




