#!/bin/bash

# to make the script fail safely
set -euo pipefail


out=${1:-output}

echo "" > $out

echo `date` >> $out
echo >> $out
echo "Below is the feedback and provisional marks for your submission" >> $out
echo "for the Preliminary Part of Part 1 (Scala).  Please note all marks are provisional until" >> $out
echo "ratified by the assessment board -- this is not an official" >> $out
echo "results transcript." >> $out
echo "" >> $out

echo "The feedback for your submission for collatz.scala" >> $out
echo "" >> $out

# marks for CW6 basic part 
marks=$(( 0 ))

# compilation tests

function scala_compile {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -Xprint:parser "$1" 2> c$out 1> c$out)
}

# functional tests

function scala_assert {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -nc -i "$1" -- "$2" -e "" 2> /dev/null 1> /dev/null)
}

# purity test

function scala_vars {
   (egrep '\bvar\b|\breturn\b|\.par\.|\.par |ListBuffer|mutable|util.control|new Array' c$out 2> /dev/null 1> /dev/null)
}


### compilation test

echo -e "collatz.scala runs?" >> $out

if (scala_compile collatz.scala)
then
    echo -e "  --> success" >> $out
    tsts0=$(( 0 ))
else
    echo -e "  --> SCALA DID NOT RUN collatz.scala\n" >> $out
    tsts0=$(( 1 )) 
fi

# var, .par return, ListBuffer test
#

if  [ $tsts0 -eq 0 ]
then
   echo -e "collatz.scala does not contain VARS, RETURNS etc?" >> $out
    
   if (scala_vars collatz.scala)
   then
      echo -e "  --> test failed\n" >> $out
      tsts=$(( 1 ))
   else
      echo -e "  --> success" >> $out
      tsts=$(( 0 )) 
   fi
fi    


echo >> $out

### collatz tests

if [ $tsts -eq 0 ]
then
  echo "collatz.scala tests:" | tee -a $out
  echo "  collatz(1) == 0" | tee -a $out
  echo "  collatz(6) == 8" | tee -a $out
  echo "  collatz(9) == 19" | tee -a $out
  echo "  collatz(9000) == 47" | tee -a $out

  if (scala_assert "collatz.scala" "collatz_test1.scala")
  then
      echo "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
    echo "  --> one of the tests failed" | tee -a $out
  fi
fi

### collatz-max tests

if [ $tsts -eq 0 ]
then
  echo "  collatz_max(10) == (19, 9)" | tee -a $out
  echo "  collatz_max(100) == (118, 97)" | tee -a $out
  echo "  collatz_max(1000) == (178, 871)" | tee -a $out
  echo "  collatz_max(10000) == (261, 6171)" | tee -a $out
  echo "  collatz_max(100000) == (350, 77031)" | tee -a $out
  echo "  collatz_max(1000000) == (524, 837799)" | tee -a $out
  #  echo "  collatz_max(2) == (1, 2) || collatz_max(2) == (0, 1)" | tee -a $out
  echo "  collatz_max(2) == (1, 2)" | tee -a $out
  echo "  collatz_max(77000) == (339, 52527)" | tee -a $out

  if (scala_assert "collatz.scala" "collatz_test2.scala") 
  then
      echo "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
    echo "  --> one of the tests failed" | tee -a $out
  fi
fi

### last-odd tests

if [ $tsts -eq 0 ]
then
  echo "  last_odd(113) == 85" | tee -a $out
  echo "  last_odd(84) == 21" | tee -a $out
  echo "  last_odd(605) == 341" | tee -a $out

  if (scala_assert "collatz.scala" "collatz_test3.scala") 
  then
      echo "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
    echo "  --> one of the tests failed" | tee -a $out
  fi
fi



## final marks
echo >> $out
echo "Overall mark for the Preliminary Part 1 (Scala)" | tee -a $out
echo " $marks" | tee -a $out


