// Advanvced Part 3 about really dumb investing strategy
//=======================================================

//two test portfolios

val blchip_portfolio = List("GOOG", "AAPL", "MSFT", "IBM", "FB", "YHOO", "AMZN", "BIDU")
val rstate_portfolio = List("PLD", "PSA", "AMT", "AIV", "AVB", "BXP", "CBG", "CCI", 
                            "DLR", "EQIX", "EQR", "ESS", "EXR", "FRT", "GGP", "HCP") 

// (1) The function below should obtain the first trading price
// for a stock symbol by using the query
//
//    http://ichart.yahoo.com/table.csv?s=<<symbol>>&a=0&b=1&c=<<year>>&d=1&e=1&f=<<year>> 
// 
// and extracting the first January Adjusted Close price in a year.

import io.Source
import scala.util._

def get_yahoo_page(url: String): Option[List[String]] = {
  Try(Some(Source.fromURL(url)("ISO-8859-1").getLines.toList)).
    getOrElse { None }
}

def get_first_price(symbol: String, year: Int): Option[Double] = {
  //println(s"download..${symbol} at ${year}")
  val year_string = year.toString
  val date_string = s"&a=0&b=1&c=${year_string}&d=1&e=1&f=${year_string}"
  val url = """http://ichart.yahoo.com/table.csv?s=""" + symbol + date_string
  val data = get_yahoo_page(url)
  data.map(_.last.split(",").toList(6).toDouble)
}


// Complete the function below that obtains all first prices
// for the stock symbols from a portfolio for the given
// range of years

def get_prices(portfolio: List[String], years: Range): List[List[Option[Double]]] = 
  for (year <- years.toList) yield
    for (symbol <- portfolio) yield get_first_price(symbol, year)


// test case
val p_fb = get_prices(List("FB"), 2012 to 2014)
val p = get_prices(List("GOOG", "AAPL"), 2005 to 2012)

val tt = get_prices(List("IBM", "BIDU"), 2004 to 2008)

// (2) The first function below calculates the change factor (delta) between
// a price in year n and a price in year n+1. The second function calculates
// all change factors for all prices (from a portfolio).

def get_delta(price_old: Option[Double], price_new: Option[Double]): Option[Double] = {
  (price_old, price_new) match {
    case (Some(x), Some(y)) => Some((y - x) / x)
    case _ => None
  }
}

def get_deltas(data: List[List[Option[Double]]]):  List[List[Option[Double]]] =
  for (i <- (0 until (data.length - 1)).toList) yield 
    for (j <- (0 until (data(0).length)).toList) yield get_delta(data(i)(j), data(i + 1)(j))


// test case using the prices calculated above
val d = get_deltas(p)
val ttd = get_deltas(tt)

// (3) Write a function that given change factors, a starting balance and a year
// calculates the yearly yield, i.e. new balanace, according to our dump investment 
// strategy. Another function calculates given the same data calculates the
// compound yield up to a given year. Finally a function combines all 
// calculations by taking a portfolio, a range of years and a start balance
// as arguments.


def yearly_yield(data: List[List[Option[Double]]], balance: Long, year: Int): Long = {
  val somes = data(year).flatten
  val somes_length = somes.length
  if (somes_length == 0) balance
  else {
    val portion: Double = balance.toDouble / somes_length.toDouble
    balance + (for (x <- somes) yield (x * portion)).sum.toLong
  }
}

yearly_yield(ttd, 100, 0)
yearly_yield(ttd, 100, 1)
yearly_yield(ttd, 100, 2)
yearly_yield(ttd, 100, 3) assert((yearly_yield(ttd, 100, 0) - 107).abs <= 2)
  assert((yearly_yield(ttd, 100, 1) - 85).abs <= 2)
  assert((yearly_yield(ttd, 100, 2) - 156).abs <= 2)
  assert((yearly_yield(ttd, 100, 3) - 210).abs <= 2)



//test case
yearly_yield(d, 100, 0)
yearly_yield(d, 225, 1)
yearly_yield(d, 246, 2)
yearly_yield(d, 466, 3)
yearly_yield(d, 218, 4)
yearly_yield(d, 469, 5)
yearly_yield(d, 587, 6)
//yearly_yield(d, 100, 0)
//yearly_yield(d, 125, 1)

def compound_yield(data: List[List[Option[Double]]], balance: Long, year: Int): Long = {
  if (year >= data.length) balance else {
    val new_balance = yearly_yield(data, balance, year)
    compound_yield(data, new_balance, year + 1)
  }
}

compound_yield(d.take(6), 100, 0)

def investment(portfolio: List[String], years: Range, start_balance: Long): Long = {
  compound_yield(get_deltas(get_prices(portfolio, years)), start_balance, 0)
}

investment(List("GOOG", "AAPL"), 2005 to 2009, 100)

//test cases for the two portfolios given above

println("Real data: " + investment(rstate_portfolio, 1978 to 2016, 100))
println("Blue data: " + investment(blchip_portfolio, 1978 to 2016, 100))


investment(List("IBM", "BIDU"), 2004 to 2008, 100)

val p_fb = get_prices(List("FB"), 2011 to 2016)

// prices 2011 - 2016
//    
List(List(None), List(None), List(Some(28.0)), 
     List(Some(54.709999)), List(Some(78.449997)), 
     List(Some(102.220001)))

// deltas 2011 - 2016
val d_fb = get_deltas(p_fb)

List(List(None), List(None), List(Some(0.9539285357142858)), 
     List(Some(0.4339242996513305)), List(Some(0.30299560113431234)))

yearly_yield(d_fb, 100, 0)   //2011  => 100
yearly_yield(d_fb, 100, 1)   //2012  => 100
yearly_yield(d_fb, 100, 2)   //2013  => 195
yearly_yield(d_fb, 195, 3)   //2014  => 279   
yearly_yield(d_fb, 279, 4)   //2015  => 363

investment(List("FB"), 2011 to 2012, 100)  // => 100
investment(List("FB"), 2011 to 2013, 100)  // => 100
investment(List("FB"), 2011 to 2014, 100)  // => 195
investment(List("FB"), 2011 to 2015, 100)  // => 279
investment(List("FB"), 2011 to 2016, 100)  // => 363


val rs_p = get_prices(rstate_portfolio, 1978 to 2016)
val bl_p = get_prices(blchip_portfolio, 1978 to 2016)

val rs_d = get_deltas(rs_p)
val bl_d = get_deltas(bl_p)

rs_p(0)
    <-
rs_p(1)
    <- 
rs_p(2)
    <- 
rs_p(3)

rs_d(0)
rs_d(1)
rs_d(2)

yearly_yield(rs_d, 100, 0)
yearly_yield(rs_d, 96, 1)
yearly_yield(rs_d, 95, 2)
yearly_yield(rs_d, 134, 3)
yearly_yield(rs_d, 126, 4)
yearly_yield(rs_d, 169, 5)

