theory SingleLet
imports "../NewParser"
begin

atom_decl name

declare [[STEPS = 100]]

nominal_datatype single_let: trm  =
  Var "name"
| App "trm" "trm"
| Lam x::"name" t::"trm"  bind x in t
| Let a::"assg" t::"trm"  bind (set) "bn a" in t
| Foo x::"name" y::"name" t::"trm" t1::"trm" t2::"trm" bind (set) x in y t t1 t2
| Bar x::"name" y::"name" t::"trm" bind y x in t x y
| Baz x::"name" t1::"trm" t2::"trm" bind x in t1, bind x in t2 
and assg =
  As "name" x::"name" t::"trm" bind x in t
binder
  bn::"assg \<Rightarrow> atom set"
where
  "bn (As x y t) = {atom x}"

thm single_let.distinct
thm single_let.induct
thm single_let.exhaust
thm single_let.fv_defs
thm single_let.bn_defs
thm single_let.perm_simps
thm single_let.eq_iff
thm single_let.fv_bn_eqvt
thm single_let.size_eqvt


(*


lemma supp_fv:
  "supp t = fv_trm t"
  "supp b = fv_bn b"
apply(induct t and b rule: i1)
apply(simp_all add: f1)
apply(simp_all add: supp_def)
apply(simp_all add: b1)
sorry

consts perm_bn_trm :: "perm \<Rightarrow> trm \<Rightarrow> trm"
consts perm_bn_assg :: "perm \<Rightarrow> assg \<Rightarrow> assg"

lemma y:
  "perm_bn_trm p (Var x) = (Var x)"
  "perm_bn_trm p (App t1 t2) = (App t1 t2)"
  "perm_bn_trm p ("



typ trm
typ assg

thm trm_assg.fv
thm trm_assg.supp
thm trm_assg.eq_iff
thm trm_assg.bn
thm trm_assg.perm
thm trm_assg.induct
thm trm_assg.inducts
thm trm_assg.distinct
ML {* Sign.of_sort @{theory} (@{typ trm}, @{sort fs}) *}
*)



end



