theory NewParser
imports "../Nominal-General/Nominal2_Base" 
        "../Nominal-General/Nominal2_Eqvt" 
        "../Nominal-General/Nominal2_Supp" 
        "Perm" "Tacs" "Lift" "Equivp"
begin

(* TODO

  we need to also export a cases-rule for nominal datatypes
  size function
*)

section{* Interface for nominal_datatype *}


ML {* 
(* nominal datatype parser *)
local
  structure P = Parse;
  structure S = Scan

  fun triple1 ((x, y), z) = (x, y, z)
  fun triple2 (x, (y, z)) = (x, y, z)
  fun tuple ((x, y, z), u) = (x, y, z, u)
  fun tswap (((x, y), z), u) = (x, y, u, z)
in

val _ = Keyword.keyword "bind"
val _ = Keyword.keyword "bind_set"
val _ = Keyword.keyword "bind_res"

val anno_typ = S.option (P.name --| P.$$$ "::") -- P.typ

val bind_mode = P.$$$ "bind" || P.$$$ "bind_set" || P.$$$ "bind_res"

val bind_clauses = 
  P.enum "," (bind_mode -- S.repeat1 P.term -- (P.$$$ "in" |-- S.repeat1 P.name) >> triple1)

val cnstr_parser =
  P.binding -- S.repeat anno_typ -- bind_clauses -- P.opt_mixfix >> tswap

(* datatype parser *)
val dt_parser =
  (P.type_args -- P.binding -- P.opt_mixfix >> triple1) -- 
    (P.$$$ "=" |-- P.enum1 "|" cnstr_parser) >> tuple

(* binding function parser *)
val bnfun_parser = 
  S.optional (P.$$$ "binder" |-- P.fixes -- Parse_Spec.where_alt_specs) ([], [])

(* main parser *)
val main_parser =
  P.and_list1 dt_parser -- bnfun_parser >> triple2

end
*}

ML {*
fun get_cnstrs dts =
  map (fn (_, _, _, constrs) => constrs) dts

fun get_typed_cnstrs dts =
  flat (map (fn (_, bn, _, constrs) => 
   (map (fn (bn', _, _) => (Binding.name_of bn, Binding.name_of bn')) constrs)) dts)

fun get_cnstr_strs dts =
  map (fn (bn, _, _) => Binding.name_of bn) (flat (get_cnstrs dts))

fun get_bn_fun_strs bn_funs =
  map (fn (bn_fun, _, _) => Binding.name_of bn_fun) bn_funs
*}


ML {*
fun add_datatype_wrapper dt_names dts =
let
  val conf = Datatype.default_config
in
  Local_Theory.theory_result (Datatype.add_datatype conf dt_names dts)
end
*}


text {* Infrastructure for adding "_raw" to types and terms *}

ML {*
fun add_raw s = s ^ "_raw"
fun add_raws ss = map add_raw ss
fun raw_bind bn = Binding.suffix_name "_raw" bn

fun replace_str ss s = 
  case (AList.lookup (op=) ss s) of 
     SOME s' => s'
   | NONE => s

fun replace_typ ty_ss (Type (a, Ts)) = Type (replace_str ty_ss a, map (replace_typ ty_ss) Ts)
  | replace_typ ty_ss T = T  

fun raw_dts ty_ss dts =
let
  fun raw_dts_aux1 (bind, tys, mx) =
    (raw_bind bind, map (replace_typ ty_ss) tys, mx)

  fun raw_dts_aux2 (ty_args, bind, mx, constrs) =
    (ty_args, raw_bind bind, mx, map raw_dts_aux1 constrs)
in
  map raw_dts_aux2 dts
end

fun replace_aterm trm_ss (Const (a, T)) = Const (replace_str trm_ss a, T)
  | replace_aterm trm_ss (Free (a, T)) = Free (replace_str trm_ss a, T)
  | replace_aterm trm_ss trm = trm

fun replace_term trm_ss ty_ss trm =
  trm |> Term.map_aterms (replace_aterm trm_ss) |> map_types (replace_typ ty_ss) 
*}

ML {*
fun rawify_dts dt_names dts dts_env =
let
  val raw_dts = raw_dts dts_env dts
  val raw_dt_names = add_raws dt_names
in
  (raw_dt_names, raw_dts)
end 
*}

ML {*
fun rawify_bn_funs dts_env cnstrs_env bn_fun_env bn_funs bn_eqs =
let
  val bn_funs' = map (fn (bn, ty, mx) => 
    (raw_bind bn, SOME (replace_typ dts_env ty), mx)) bn_funs
  
  val bn_eqs' = map (fn (attr, trm) => 
    (attr, replace_term (cnstrs_env @ bn_fun_env) dts_env trm)) bn_eqs
in
  (bn_funs', bn_eqs') 
end 
*}

ML {* 
fun rawify_bclauses dts_env cnstrs_env bn_fun_env bclauses =
let
  fun rawify_bnds bnds = 
    map (apfst (Option.map (replace_term (cnstrs_env @ bn_fun_env) dts_env))) bnds

  fun rawify_bclause (BC (mode, bnds, bdys)) = BC (mode, rawify_bnds bnds, bdys)
in
  map (map (map rawify_bclause)) bclauses
end
*}

(* strip_bn_fun takes a rhs of a bn function: this can only contain unions or
   appends of elements; in case of recursive calls it retruns also the applied
   bn function *)
ML {*
fun strip_bn_fun lthy args t =
let 
  fun aux t =
    case t of
      Const (@{const_name sup}, _) $ l $ r => aux l @ aux r
    | Const (@{const_name append}, _) $ l $ r => aux l @ aux r
    | Const (@{const_name insert}, _) $ (Const (@{const_name atom}, _) $ (x as Var _)) $ y =>
        (find_index (equal x) args, NONE) :: aux y
    | Const (@{const_name Cons}, _) $ (Const (@{const_name atom}, _) $ (x as Var _)) $ y =>
        (find_index (equal x) args, NONE) :: aux y
    | Const (@{const_name bot}, _) => []
    | Const (@{const_name Nil}, _) => []
    | (f as Const _) $ (x as Var _) => [(find_index (equal x) args, SOME f)]
    | _ => error ("Unsupported binding function: " ^ (Syntax.string_of_term lthy t))
in
  aux t
end  
*}

ML {*
fun find [] _ = error ("cannot find element")
  | find ((x, z)::xs) y = if (Long_Name.base_name x) = y then z else find xs y
*}

ML {*
fun prep_bn_info lthy dt_names dts eqs = 
let
  fun aux eq = 
  let
    val (lhs, rhs) = eq
      |> HOLogic.dest_Trueprop
      |> HOLogic.dest_eq
    val (bn_fun, [cnstr]) = strip_comb lhs
    val (_, ty) = dest_Const bn_fun
    val (ty_name, _) = dest_Type (domain_type ty)
    val dt_index = find_index (fn x => x = ty_name) dt_names
    val (cnstr_head, cnstr_args) = strip_comb cnstr    
    val rhs_elements = strip_bn_fun lthy cnstr_args rhs
  in
    (dt_index, (bn_fun, (cnstr_head, rhs_elements)))
  end
  fun order dts i ts = 
  let
    val dt = nth dts i
    val cts = map (fn (x, _, _) => Binding.name_of x) ((fn (_, _, _, x) => x) dt)
    val ts' = map (fn (x, y) => (fst (dest_Const x), y)) ts
  in
    map (find ts') cts
  end

  val unordered = AList.group (op=) (map aux eqs)
  val unordered' = map (fn (x, y) =>  (x, AList.group (op=) y)) unordered
  val ordered = map (fn (x, y) => (x, map (fn (v, z) => (v, order dts x z)) y)) unordered' 
  val ordered' = flat (map (fn (ith, l) => map (fn (bn, data) => (bn, ith, data)) l) ordered)

  (*val _ = tracing ("eqs\n" ^ cat_lines (map (Syntax.string_of_term lthy) eqs))*)
  (*val _ = tracing ("map eqs\n" ^ @{make_string} (map aux2 eqs))*)
  (*val _ = tracing ("ordered'\n" ^ @{make_string} ordered')*)
in
  ordered'
end
*}

ML {*
fun raw_nominal_decls dts bn_funs bn_eqs binds lthy =
let
  val thy = ProofContext.theory_of lthy
  val thy_name = Context.theory_name thy

  val dt_names = map (fn (_, s, _, _) => Binding.name_of s) dts
  val dt_full_names = map (Long_Name.qualify thy_name) dt_names 
  val dt_full_names' = add_raws dt_full_names
  val dts_env = dt_full_names ~~ dt_full_names'

  val cnstrs = get_cnstr_strs dts
  val cnstrs_ty = get_typed_cnstrs dts
  val cnstrs_full_names = map (Long_Name.qualify thy_name) cnstrs
  val cnstrs_full_names' = map (fn (x, y) => Long_Name.qualify thy_name 
    (Long_Name.qualify (add_raw x) (add_raw y))) cnstrs_ty
  val cnstrs_env = cnstrs_full_names ~~ cnstrs_full_names'

  val bn_fun_strs = get_bn_fun_strs bn_funs
  val bn_fun_strs' = add_raws bn_fun_strs
  val bn_fun_env = bn_fun_strs ~~ bn_fun_strs'
  val bn_fun_full_env = map (pairself (Long_Name.qualify thy_name)) 
    (bn_fun_strs ~~ bn_fun_strs')
  
  val (raw_dt_names, raw_dts) = rawify_dts dt_names dts dts_env
  val (raw_bn_funs, raw_bn_eqs) = rawify_bn_funs dts_env cnstrs_env bn_fun_env bn_funs bn_eqs 
  val raw_bclauses = rawify_bclauses dts_env cnstrs_env bn_fun_full_env binds 

  val (raw_dt_full_names, lthy1) = 
    add_datatype_wrapper raw_dt_names raw_dts lthy
in
  (raw_dt_full_names, raw_dts, raw_bclauses, raw_bn_funs, raw_bn_eqs, lthy1)
end
*}

ML {*
fun raw_bn_decls dt_names dts raw_bn_funs raw_bn_eqs constr_thms lthy =
  if null raw_bn_funs 
  then ([], [], [], [], lthy)
  else 
    let
      val (_, lthy1) = Function.add_function raw_bn_funs raw_bn_eqs
        Function_Common.default_config (pat_completeness_simp constr_thms) lthy

      val (info, lthy2) = prove_termination (Local_Theory.restore lthy1)
      val {fs, simps, inducts, ...} = info;

      val raw_bn_induct = (the inducts)
      val raw_bn_eqs = the simps

      val raw_bn_info = 
        prep_bn_info lthy dt_names dts (map prop_of raw_bn_eqs)
    in
      (fs, raw_bn_eqs, raw_bn_info, raw_bn_induct, lthy2)
    end
*}



ML {* val cheat_fv_rsp = Unsynchronized.ref false *}
ML {* val cheat_alpha_bn_rsp = Unsynchronized.ref false *}
ML {* val cheat_supp_eq = Unsynchronized.ref false *}


ML {*
(* for testing porposes - to exit the procedure early *)
exception TEST of Proof.context

val (STEPS, STEPS_setup) = Attrib.config_int "STEPS" (K 10);

fun get_STEPS ctxt = Config.get ctxt STEPS
*}

setup STEPS_setup

ML {*
fun nominal_datatype2 dts bn_funs bn_eqs bclauses lthy =
let
  (* definition of the raw datatypes *)
  val _ = warning "Definition of raw datatypes";
  val (raw_dt_names, raw_dts, raw_bclauses, raw_bn_funs, raw_bn_eqs, lthy0) =
    if get_STEPS lthy > 0 
    then raw_nominal_decls dts bn_funs bn_eqs bclauses lthy
    else raise TEST lthy

  val dtinfo = Datatype.the_info (ProofContext.theory_of lthy0) (hd raw_dt_names)
  val {descr, sorts, ...} = dtinfo
  val all_raw_tys = all_dtyps descr sorts
  val all_raw_ty_names = map (fn (_, (n, _, _)) => n) descr
  val all_raw_constrs = 
    flat (map (map (fn (c, _, _, _) => c)) (all_dtyp_constrs_types descr sorts))

  val dtinfos = map (Datatype.the_info (ProofContext.theory_of lthy0)) all_raw_ty_names  
  val inject_thms = flat (map #inject dtinfos);
  val distinct_thms = flat (map #distinct dtinfos);
  val constr_thms = inject_thms @ distinct_thms
  val rel_dtinfos = List.take (dtinfos, (length dts)); 
  val raw_constrs_distinct = (map #distinct rel_dtinfos); 
  val raw_induct_thm = #induct dtinfo;
  val raw_induct_thms = #inducts dtinfo;
  val exhaust_thms = map #exhaust dtinfos;
  val raw_size_trms = map (fn ty => Const (@{const_name size}, ty --> @{typ nat})) all_raw_tys
  val raw_size_thms = Size.size_thms (ProofContext.theory_of lthy0) (hd raw_dt_names)
    |> `(fn thms => (length thms) div 2)
    |> uncurry drop
  

  (* definitions of raw permutations *)
  val _ = warning "Definition of raw permutations";
  val ((raw_perm_funs, raw_perm_simps, raw_perm_laws), lthy2) =
    if get_STEPS lthy0 > 1 
    then Local_Theory.theory_result (define_raw_perms descr sorts raw_induct_thm (length dts)) lthy0
    else raise TEST lthy0
 
  (* noting the raw permutations as eqvt theorems *)
  val eqvt_attrib = Attrib.internal (K Nominal_ThmDecls.eqvt_add)
  val (_, lthy2a) = Local_Theory.note ((Binding.empty, [eqvt_attrib]), raw_perm_simps) lthy2

  val thy = Local_Theory.exit_global lthy2a;
  val thy_name = Context.theory_name thy

  (* definition of raw fv_functions *)
  val _ = warning "Definition of raw fv-functions";
  val lthy3 = Named_Target.init NONE thy;

  val (raw_bns, raw_bn_eqs, raw_bn_info, raw_bn_induct, lthy3a) =
    if get_STEPS lthy3 > 2 
    then raw_bn_decls all_raw_ty_names raw_dts raw_bn_funs raw_bn_eqs constr_thms lthy3
    else raise TEST lthy3

  val (raw_fvs, raw_fv_bns, raw_fv_defs, raw_fv_bns_induct, lthy3b) = 
    if get_STEPS lthy3a > 3 
    then define_raw_fvs descr sorts raw_bn_info raw_bclauses constr_thms lthy3a
    else raise TEST lthy3a

  (* definition of raw alphas *)
  val _ = warning "Definition of alphas";
  val (alpha_trms, alpha_bn_trms, alpha_intros, alpha_cases, alpha_induct, lthy4) =
    if get_STEPS lthy3b > 4 
    then define_raw_alpha descr sorts raw_bn_info raw_bclauses raw_fvs lthy3b
    else raise TEST lthy3b
  val alpha_tys = map (domain_type o fastype_of) alpha_trms  

  (* definition of alpha-distinct lemmas *)
  val _ = warning "Distinct theorems";
  val (alpha_distincts, alpha_bn_distincts) = 
    mk_alpha_distincts lthy4 alpha_cases raw_constrs_distinct alpha_trms alpha_bn_trms raw_bn_info

  (* definition of alpha_eq_iff  lemmas *)
  (* they have a funny shape for the simplifier *)
  val _ = warning "Eq-iff theorems";
  val (alpha_eq_iff_simps, alpha_eq_iff) = 
    if get_STEPS lthy > 5
    then mk_alpha_eq_iff lthy4 alpha_intros distinct_thms inject_thms alpha_cases
    else raise TEST lthy4

  (* proving equivariance lemmas for bns, fvs, size and alpha *)
  val _ = warning "Proving equivariance";
  val bn_eqvt = 
    if get_STEPS lthy > 6
    then raw_prove_eqvt raw_bns raw_bn_induct (raw_bn_eqs @ raw_perm_simps) lthy4
    else raise TEST lthy4

  (* noting the bn_eqvt lemmas in a temprorary theory *)
  val add_eqvt = Attrib.internal (K Nominal_ThmDecls.eqvt_add)
  val lthy_tmp = snd (Local_Theory.note ((Binding.empty, [add_eqvt]), bn_eqvt) lthy4)

  val fv_eqvt = 
    if get_STEPS lthy > 7
    then raw_prove_eqvt (raw_fvs @ raw_fv_bns) raw_fv_bns_induct (raw_fv_defs @ raw_perm_simps) 
      (Local_Theory.restore lthy_tmp)
    else raise TEST lthy4

  val raw_size_eqvt = 
    if get_STEPS lthy > 8
    then raw_prove_eqvt raw_size_trms raw_induct_thms (raw_size_thms @ raw_perm_simps) 
      (Local_Theory.restore lthy_tmp)
      |> map (rewrite_rule @{thms permute_nat_def[THEN eq_reflection]})
      |> map (fn thm => thm RS @{thm sym})
    else raise TEST lthy4
 
  val lthy5 = snd (Local_Theory.note ((Binding.empty, [add_eqvt]), fv_eqvt) lthy_tmp)

  val (alpha_eqvt, lthy6) =
    if get_STEPS lthy > 9
    then Nominal_Eqvt.equivariance true (alpha_trms @ alpha_bn_trms) alpha_induct alpha_intros lthy5
    else raise TEST lthy4

  (* proving alpha equivalence *)
  val _ = warning "Proving equivalence"

  val alpha_refl_thms = 
    if get_STEPS lthy > 10
    then raw_prove_refl alpha_trms alpha_bn_trms alpha_intros raw_induct_thm lthy6 
    else raise TEST lthy6

  val alpha_sym_thms = 
    if get_STEPS lthy > 11
    then raw_prove_sym (alpha_trms @ alpha_bn_trms) alpha_intros alpha_induct lthy6 
    else raise TEST lthy6

  val alpha_trans_thms = 
    if get_STEPS lthy > 12
    then raw_prove_trans (alpha_trms @ alpha_bn_trms) (distinct_thms @ inject_thms) 
           alpha_intros alpha_induct alpha_cases lthy6
    else raise TEST lthy6

  val alpha_equivp_thms = 
    if get_STEPS lthy > 13
    then raw_prove_equivp alpha_trms alpha_refl_thms alpha_sym_thms alpha_trans_thms lthy6
    else raise TEST lthy6

  (* proving alpha implies alpha_bn *)
  val _ = warning "Proving alpha implies bn"

  val alpha_bn_imp_thms = 
    if get_STEPS lthy > 14
    then raw_prove_bn_imp alpha_trms alpha_bn_trms alpha_intros alpha_induct lthy6 
    else raise TEST lthy6
  
  (* auxiliary lemmas for respectfulness proofs *)
  val raw_funs_rsp = raw_fv_bn_rsp_aux alpha_trms alpha_bn_trms raw_fvs 
    raw_bns raw_fv_bns alpha_induct (raw_bn_eqs @ raw_fv_defs) lthy6

  val raw_size_rsp = raw_size_rsp_aux (alpha_trms @ alpha_bn_trms) alpha_induct 
    (raw_size_thms @ raw_size_eqvt) lthy6

  val raw_constrs_rsp = raw_constrs_rsp all_raw_constrs alpha_trms alpha_intros
    (alpha_bn_imp_thms @ raw_funs_rsp) lthy6 

  (* defining the quotient type *)
  val _ = warning "Declaring the quotient types"
  val qty_descr = map (fn (vs, bind, mx, _) => (vs, bind, mx)) dts
  val qty_binds = map (fn (_, bind, _, _) => bind) dts        
  val qty_names = map Name.of_binding qty_binds;              
  val qty_full_names = map (Long_Name.qualify thy_name) qty_names (* not used *)
  
  val (qty_infos, lthy7) = 
    if get_STEPS lthy > 15
    then qtype_defs qty_descr alpha_tys alpha_trms alpha_equivp_thms lthy6
    else raise TEST lthy6

  val qtys = map #qtyp qty_infos
  
  (* defining of quotient term-constructors, binding functions, free vars functions *)
  val _ = warning "Defining the quotient constants"
  val qconstrs_descr = 
    flat (map (fn (_, _, _, cs) => map (fn (b, _, mx) => (Name.of_binding b, mx)) cs) dts)
    |> map2 (fn t => fn (b, mx) => (b, t, mx)) all_raw_constrs

  val qbns_descr =
    map2 (fn (b, _, mx) => fn t => (Name.of_binding b, t, mx)) bn_funs raw_bns

  val qfvs_descr = 
    map2 (fn n => fn t => ("fv_" ^ n, t, NoSyn)) qty_names raw_fvs

  val qfv_bns_descr = 
    map2 (fn (b, _, _) => fn t => ("fv_" ^ Name.of_binding b, t, NoSyn)) bn_funs  raw_fv_bns

  val qalpha_bns_descr = 
    map2 (fn (b, _, _) => fn t => ("alpha_" ^ Name.of_binding b, t, NoSyn)) bn_funs  alpha_bn_trms

  val (((((qconstrs_info, qbns_info), qfvs_info), qfv_bns_info), qalpha_bns_info), lthy8) = 
    if get_STEPS lthy > 16
    then 
      lthy7
      |> qconst_defs qtys qconstrs_descr 
      ||>> qconst_defs qtys qbns_descr 
      ||>> qconst_defs qtys qfvs_descr
      ||>> qconst_defs qtys qfv_bns_descr
      ||>> qconst_defs qtys qalpha_bns_descr
    else raise TEST lthy7

  val qconstrs = map #qconst qconstrs_info
  val qbns = map #qconst qbns_info
  val qfvs = map #qconst qfvs_info
  val qfv_bns = map #qconst qfv_bns_info
  val qalpha_bns = map #qconst qalpha_bns_info

  (* temporary theorem bindings *)

  val (_, lthy8') = lthy8
     |> Local_Theory.note ((@{binding "distinct"}, []), alpha_distincts) 
     ||>> Local_Theory.note ((@{binding "eq_iff"}, []), alpha_eq_iff)
     ||>> Local_Theory.note ((@{binding "eq_iff_simps"}, []), alpha_eq_iff_simps) 
     ||>> Local_Theory.note ((@{binding "fv_defs"}, []), raw_fv_defs) 
     ||>> Local_Theory.note ((@{binding "perm_simps"}, []), raw_perm_simps) 
     ||>> Local_Theory.note ((@{binding "perm_laws"}, []), raw_perm_laws) 
     ||>> Local_Theory.note ((@{binding "alpha_bn_imps"}, []), alpha_bn_imp_thms)
     ||>> Local_Theory.note ((@{binding "funs_rsp"}, []), raw_funs_rsp)
     ||>> Local_Theory.note ((@{binding "size_eqvt"}, []), raw_size_eqvt)
     ||>> Local_Theory.note ((@{binding "size_simps"}, []), raw_size_thms)
     ||>> Local_Theory.note ((@{binding "size_rsp"}, []), raw_size_rsp)
     ||>> Local_Theory.note ((@{binding "constrs_rsp"}, []), raw_constrs_rsp)
     ||>> Local_Theory.note ((@{binding "alpha_sym_thms"}, []), alpha_sym_thms)
     ||>> Local_Theory.note ((@{binding "alpha_trans_thms"}, []), alpha_trans_thms)
  
  val _ = 
    if get_STEPS lthy > 17
    then true else raise TEST lthy8'
  
  (* old stuff *)

  val _ = warning "Proving respects";

  val bn_nos = map (fn (_, i, _) => i) raw_bn_info;
  val bns = raw_bns ~~ bn_nos;

  val bns_rsp_pre' = build_fvbv_rsps alpha_trms alpha_induct raw_bn_eqs (map fst bns) lthy8;
  val (bns_rsp_pre, lthy9) = fold_map (
    fn (bn_t, _) => prove_const_rsp qtys Binding.empty [bn_t] (fn _ =>
       resolve_tac bns_rsp_pre' 1)) bns lthy8;
  val bns_rsp = flat (map snd bns_rsp_pre);

  fun fv_rsp_tac _ = if !cheat_fv_rsp then Skip_Proof.cheat_tac thy
    else fvbv_rsp_tac alpha_induct raw_fv_defs lthy8 1;

  val fv_alpha_all = combine_fv_alpha_bns (raw_fvs, raw_fv_bns) (alpha_trms, alpha_bn_trms) bn_nos

  val fv_rsps = prove_fv_rsp fv_alpha_all alpha_trms fv_rsp_tac lthy9;
  val (fv_rsp_pre, lthy10) = fold_map
    (fn fv => fn ctxt => prove_const_rsp qtys Binding.empty [fv]
    (fn _ => asm_simp_tac (HOL_ss addsimps fv_rsps) 1) ctxt) (raw_fvs @ raw_fv_bns) lthy9;
  val fv_rsp = flat (map snd fv_rsp_pre);
  val (perms_rsp, lthy11) = prove_const_rsp qtys Binding.empty raw_perm_funs
    (fn _ => asm_simp_tac (HOL_ss addsimps alpha_eqvt) 1) lthy10;
  fun alpha_bn_rsp_tac _ = if !cheat_alpha_bn_rsp then Skip_Proof.cheat_tac thy
    else
      let val alpha_bn_rsp_pre = prove_alpha_bn_rsp alpha_trms alpha_induct (alpha_eq_iff @ alpha_distincts @ alpha_bn_distincts) alpha_equivp_thms exhaust_thms alpha_bn_trms lthy11 in asm_simp_tac (HOL_ss addsimps alpha_bn_rsp_pre) 1 end;
  val (alpha_bn_rsps, lthy11a) = fold_map (fn cnst => prove_const_rsp qtys Binding.empty [cnst]
    alpha_bn_rsp_tac) alpha_bn_trms lthy11
  fun const_rsp_tac _ =
    let val alpha_alphabn = prove_alpha_alphabn alpha_trms alpha_induct alpha_eq_iff alpha_bn_trms lthy11a
      in constr_rsp_tac alpha_eq_iff (fv_rsp @ bns_rsp @ alpha_refl_thms @ alpha_alphabn) 1 end
  val (const_rsps, lthy12) = fold_map (fn cnst => prove_const_rsp qtys Binding.empty [cnst]
    const_rsp_tac) all_raw_constrs lthy11a
  val qfv_names = map (unsuffix "_raw" o Long_Name.base_name o fst o dest_Const) (raw_fvs @ raw_fv_bns)
  val dd = map2 (fn x => fn y => (x, y, NoSyn)) qfv_names (raw_fvs @ raw_fv_bns)
  val (qfv_info, lthy12a) = qconst_defs qtys dd lthy12;
  val qfv_ts = map #qconst qfv_info
  val qfv_defs = map #def qfv_info
  val (qfv_ts_nobn, qfv_ts_bn) = chop (length raw_perm_funs) qfv_ts;
  val qbn_names = map (fn (b, _ , _) => Name.of_binding b) bn_funs
  val dd = map2 (fn x => fn y => (x, y, NoSyn)) qbn_names raw_bns
  val (qbn_info, lthy12b) = qconst_defs qtys dd lthy12a;
  val qbn_ts = map #qconst qbn_info
  val qbn_defs = map #def qbn_info
  val qalpha_bn_names = map (unsuffix "_raw" o Long_Name.base_name o fst o dest_Const) alpha_bn_trms
  val dd = map2 (fn x => fn y => (x, y, NoSyn)) qalpha_bn_names alpha_bn_trms
  val (qalpha_info, lthy12c) = qconst_defs qtys dd lthy12b;
  val qalpha_bn_trms = map #qconst qalpha_info
  val qalphabn_defs = map #def qalpha_info
  
  val _ = warning "Lifting permutations";
  val thy = Local_Theory.exit_global lthy12c;
  val perm_names = map (fn x => "permute_" ^ x) qty_names
  val dd = map2 (fn x => fn y => (x, y, NoSyn)) perm_names raw_perm_funs
  (* use Local_Theory.theory_result *)
  val thy' = qperm_defs qtys qty_full_names dd raw_perm_laws thy;
  val lthy13 = Named_Target.init NONE thy';
  
  val q_name = space_implode "_" qty_names;
  fun suffix_bind s = Binding.qualify true q_name (Binding.name s);
  val _ = warning "Lifting induction";
  val constr_names = map (Long_Name.base_name o fst o dest_Const) qconstrs;
  val q_induct = Rule_Cases.name constr_names (lift_thm qtys lthy13 raw_induct_thm);
  fun note_suffix s th ctxt =
    snd (Local_Theory.note ((suffix_bind s, []), th) ctxt);
  fun note_simp_suffix s th ctxt =
    snd (Local_Theory.note ((suffix_bind s, [Attrib.internal (K Simplifier.simp_add)]), th) ctxt);
  val (_, lthy14) = Local_Theory.note ((suffix_bind "induct",
    [Attrib.internal (K (Rule_Cases.case_names constr_names))]), 
    [Rule_Cases.name constr_names q_induct]) lthy13;
  val q_inducts = Project_Rule.projects lthy13 (1 upto (length raw_fvs)) q_induct
  val (_, lthy14a) = Local_Theory.note ((suffix_bind "inducts", []), q_inducts) lthy14;
  val q_perm = map (lift_thm qtys lthy14) raw_perm_simps;
  val lthy15 = note_simp_suffix "perm" q_perm lthy14a;
  val q_fv = map (lift_thm qtys lthy15) raw_fv_defs;
  val lthy16 = note_simp_suffix "fv" q_fv lthy15;
  val q_bn = map (lift_thm qtys lthy16) raw_bn_eqs;
  val lthy17 = note_simp_suffix "bn" q_bn lthy16;
  val _ = warning "Lifting eq-iff";
  (*val _ = map tracing (map PolyML.makestring alpha_eq_iff);*)
  val eq_iff_unfolded0 = map (Local_Defs.unfold lthy17 @{thms alphas}) alpha_eq_iff
  val eq_iff_unfolded1 = map (Local_Defs.unfold lthy17 @{thms Pair_eqvt}) eq_iff_unfolded0
  val q_eq_iff_pre0 = map (lift_thm qtys lthy17) eq_iff_unfolded1;
  val q_eq_iff_pre1 = map (Local_Defs.fold lthy17 @{thms Pair_eqvt}) q_eq_iff_pre0
  val q_eq_iff_pre2 = map (Local_Defs.fold lthy17 @{thms alphas}) q_eq_iff_pre1
  val q_eq_iff = map (Local_Defs.unfold lthy17 (Quotient_Info.id_simps_get lthy17)) q_eq_iff_pre2
  val (_, lthy18) = Local_Theory.note ((suffix_bind "eq_iff", []), q_eq_iff) lthy17;
  val q_dis = map (lift_thm qtys lthy18) alpha_distincts;
  val lthy19 = note_simp_suffix "distinct" q_dis lthy18;
  val q_eqvt = map (lift_thm qtys lthy19) (bn_eqvt @ fv_eqvt);
  val (_, lthy20) = Local_Theory.note ((Binding.empty,
    [Attrib.internal (fn _ => Nominal_ThmDecls.eqvt_add)]), q_eqvt) lthy19;
  val _ = warning "Supports";
  val supports = map (prove_supports lthy20 q_perm) qconstrs;
  val fin_supp = HOLogic.conj_elims (prove_fs lthy20 q_induct supports qtys);
  val thy3 = Local_Theory.exit_global lthy20;
  val _ = warning "Instantiating FS";
  val lthy21 = Class.instantiation (qty_full_names, [], @{sort fs}) thy3;
  fun tac _ = Class.intro_classes_tac [] THEN (ALLGOALS (resolve_tac fin_supp))
  val lthy22 = Class.prove_instantiation_instance tac lthy21
  val fv_alpha_all = combine_fv_alpha_bns (qfv_ts_nobn, qfv_ts_bn) (alpha_trms, qalpha_bn_trms) bn_nos;
  val (names, supp_eq_t) = supp_eq fv_alpha_all;
  val _ = warning "Support Equations";
  fun supp_eq_tac' _ = if !cheat_supp_eq then Skip_Proof.cheat_tac thy else
    supp_eq_tac q_induct q_fv q_perm q_eq_iff lthy22 1;
  val q_supp = HOLogic.conj_elims (Goal.prove lthy22 names [] supp_eq_t supp_eq_tac') handle e =>
    let val _ = warning ("Support eqs failed") in [] end;
  val lthy23 = note_suffix "supp" q_supp lthy22;
in
  (0, lthy23)
end handle TEST ctxt => (0, ctxt)
*}

section {* Preparing and parsing of the specification *}

ML {* 
(* parsing the datatypes and declaring *)
(* constructors in the local theory    *)
fun prepare_dts dt_strs lthy = 
let
  val thy = ProofContext.theory_of lthy
  
  fun mk_type full_tname tvrs =
    Type (full_tname, map (fn a => TVar ((a, 0), [])) tvrs)

  fun prep_cnstr full_tname tvs (cname, anno_tys, mx, _) =
  let
    val tys = map (Syntax.read_typ lthy o snd) anno_tys
    val ty = mk_type full_tname tvs
  in
    ((cname, tys ---> ty, mx), (cname, tys, mx))
  end
  
  fun prep_dt (tvs, tname, mx, cnstrs) = 
  let
    val full_tname = Sign.full_name thy tname
    val (cnstrs', cnstrs'') = 
      split_list (map (prep_cnstr full_tname tvs) cnstrs)
  in
    (cnstrs', (tvs, tname, mx, cnstrs''))
  end 

  val (cnstrs, dts) = split_list (map prep_dt dt_strs)
in
  lthy
  |> Local_Theory.theory (Sign.add_consts_i (flat cnstrs))
  |> pair dts
end
*}

ML {*
(* parsing the binding function specification and *)
(* declaring the functions in the local theory    *)
fun prepare_bn_funs bn_fun_strs bn_eq_strs lthy =
let
  val ((bn_funs, bn_eqs), _) = 
    Specification.read_spec bn_fun_strs bn_eq_strs lthy

  fun prep_bn_fun ((bn, T), mx) = (bn, T, mx) 
  
  val bn_funs' = map prep_bn_fun bn_funs
in
  lthy
  |> Local_Theory.theory (Sign.add_consts_i bn_funs')
  |> pair (bn_funs', bn_eqs) 
end 
*}

text {* associates every SOME with the index in the list; drops NONEs *}
ML {*
fun indexify xs =
let
  fun mapp _ [] = []
    | mapp i (NONE :: xs) = mapp (i + 1) xs
    | mapp i (SOME x :: xs) = (x, i) :: mapp (i + 1) xs
in 
  mapp 0 xs 
end

fun index_lookup xs x =
  case AList.lookup (op=) xs x of
    SOME x => x
  | NONE => error ("Cannot find " ^ x ^ " as argument annotation.");
*}

ML {*
fun prepare_bclauses dt_strs lthy = 
let
  val annos_bclauses =
    get_cnstrs dt_strs
    |> map (map (fn (_, antys, _, bns) => (map fst antys, bns)))

  fun prep_binder env bn_str =
    case (Syntax.read_term lthy bn_str) of
      Free (x, _) => (NONE, index_lookup env x)
    | Const (a, T) $ Free (x, _) => (SOME (Const (a, T)), index_lookup env x)
    | _ => error ("The term " ^ bn_str ^ " is not allowed as binding function.")
 
  fun prep_body env bn_str = index_lookup env bn_str

  fun prep_mode "bind"     = Lst 
    | prep_mode "bind_set" = Set 
    | prep_mode "bind_res" = Res 

  fun prep_bclause env (mode, binders, bodies) = 
  let
    val binders' = map (prep_binder env) binders
    val bodies' = map (prep_body env) bodies
  in  
    BC (prep_mode mode, binders', bodies')
  end

  fun prep_bclauses (annos, bclause_strs) = 
  let
    val env = indexify annos (* for every label, associate the index *)
  in
    map (prep_bclause env) bclause_strs
  end
in
  map (map prep_bclauses) annos_bclauses
end
*}

text {* 
  adds an empty binding clause for every argument
  that is not already part of a binding clause
*}

ML {*
fun included i bcs = 
let
  fun incl (BC (_, bns, bds)) = (member (op =) (map snd bns) i) orelse (member (op =) bds i)
in
  exists incl bcs 
end
*}

ML {* 
fun complete dt_strs bclauses = 
let
  val args = 
    get_cnstrs dt_strs
    |> map (map (fn (_, antys, _, _) => length antys))

  fun complt n bcs = 
  let
    fun add bcs i = (if included i bcs then [] else [BC (Lst, [], [i])]) 
  in
    bcs @ (flat (map_range (add bcs) n))
  end
in
  map2 (map2 complt) args bclauses
end
*}

ML {*
fun nominal_datatype2_cmd (dt_strs, bn_fun_strs, bn_eq_strs) lthy = 
let
  fun prep_typ (tvs, tname, mx, _) = (tname, length tvs, mx)
  val lthy0 = 
    Local_Theory.theory (Sign.add_types (map prep_typ dt_strs)) lthy
  val (dts, lthy1) = prepare_dts dt_strs lthy0
  val ((bn_funs, bn_eqs), lthy2) = prepare_bn_funs bn_fun_strs bn_eq_strs lthy1
  val bclauses = prepare_bclauses dt_strs lthy2
  val bclauses' = complete dt_strs bclauses 
in
  nominal_datatype2 dts bn_funs bn_eqs bclauses' lthy |> snd
end


(* Command Keyword *)

val _ = Outer_Syntax.local_theory "nominal_datatype" "test" Keyword.thy_decl
  (main_parser >> nominal_datatype2_cmd)
*}


text {* 
  nominal_datatype2 does the following things in order:

Parser.thy/raw_nominal_decls
  1) define the raw datatype
  2) define the raw binding functions 

Perm.thy/define_raw_perms
  3) define permutations of the raw datatype and show that the raw type is 
     in the pt typeclass
      
Lift.thy/define_fv_alpha_export, Fv.thy/define_fv & define_alpha
  4) define fv and fv_bn
  5) define alpha and alpha_bn

Perm.thy/distinct_rel
  6) prove alpha_distincts (C1 x \<notsimeq> C2 y ...)             (Proof by cases; simp)

Tacs.thy/build_rel_inj
  6) prove alpha_eq_iff    (C1 x = C2 y \<leftrightarrow> P x y ...)
     (left-to-right by intro rule, right-to-left by cases; simp)
Equivp.thy/prove_eqvt
  7) prove bn_eqvt (common induction on the raw datatype)
  8) prove fv_eqvt (common induction on the raw datatype with help of above)
Rsp.thy/build_alpha_eqvts
  9) prove alpha_eqvt and alpha_bn_eqvt
     (common alpha-induction, unfolding alpha_gen, permute of #* and =)
Equivp.thy/build_alpha_refl & Equivp.thy/build_equivps
 10) prove that alpha and alpha_bn are equivalence relations
     (common induction and application of 'compose' lemmas)
Lift.thy/define_quotient_types
 11) define quotient types
Rsp.thy/build_fvbv_rsps
 12) prove bn respects     (common induction and simp with alpha_gen)
Rsp.thy/prove_const_rsp
 13) prove fv respects     (common induction and simp with alpha_gen)
 14) prove permute respects    (unfolds to alpha_eqvt)
Rsp.thy/prove_alpha_bn_rsp
 15) prove alpha_bn respects
     (alpha_induct then cases then sym and trans of the relations)
Rsp.thy/prove_alpha_alphabn
 16) show that alpha implies alpha_bn (by unduction, needed in following step)
Rsp.thy/prove_const_rsp
 17) prove respects for all datatype constructors
     (unfold eq_iff and alpha_gen; introduce zero permutations; simp)
Perm.thy/quotient_lift_consts_export
 18) define lifted constructors, fv, bn, alpha_bn, permutations
Perm.thy/define_lifted_perms
 19) lift permutation zero and add properties to show that quotient type is in the pt typeclass
Lift.thy/lift_thm
 20) lift permutation simplifications
 21) lift induction
 22) lift fv
 23) lift bn
 24) lift eq_iff
 25) lift alpha_distincts
 26) lift fv and bn eqvts
Equivp.thy/prove_supports
 27) prove that union of arguments supports constructors
Equivp.thy/prove_fs
 28) show that the lifted type is in fs typeclass     (* by q_induct, supports *)
Equivp.thy/supp_eq
 29) prove supp = fv
*}



end



