theory QuotList
imports QuotMain List
begin

fun
  list_rel
where
  "list_rel R [] [] = True"
| "list_rel R (x#xs) [] = False"
| "list_rel R [] (x#xs) = False"
| "list_rel R (x#xs) (y#ys) = (R x y \<and> list_rel R xs ys)"

declare [[map list = (map, list_rel)]]

lemma list_equivp[quotient_equiv]:
  assumes a: "equivp R"
  shows "equivp (list_rel R)"
  unfolding equivp_def
  apply(rule allI)+
  apply(induct_tac x y rule: list_induct2')
  apply(simp_all add: expand_fun_eq)
  apply(metis list_rel.simps(1) list_rel.simps(2))
  apply(metis list_rel.simps(1) list_rel.simps(2))
  apply(rule iffI)
  apply(rule allI)
  apply(case_tac x)
  apply(simp_all)
  using a
  apply(unfold equivp_def)
  apply(auto)[1]
  apply(metis list_rel.simps(4))
  done

lemma list_rel_rel:
  assumes q: "Quotient R Abs Rep"
  shows "list_rel R r s = (list_rel R r r \<and> list_rel R s s \<and> (map Abs r = map Abs s))"
  apply(induct r s rule: list_induct2')
  apply(simp_all)
  using Quotient_rel[OF q]
  apply(metis)
  done

lemma list_quotient[quotient_thm]:
  assumes q: "Quotient R Abs Rep"
  shows "Quotient (list_rel R) (map Abs) (map Rep)"
  unfolding Quotient_def
  apply(rule conjI)
  apply(rule allI)
  apply(induct_tac a)
  apply(simp)
  apply(simp add: Quotient_abs_rep[OF q])
  apply(rule conjI)
  apply(rule allI)
  apply(induct_tac a)
  apply(simp)
  apply(simp)
  apply(simp add: Quotient_rep_reflp[OF q])
  apply(rule allI)+
  apply(rule list_rel_rel[OF q])
  done

lemma map_id: "map id \<equiv> id"
  apply (rule eq_reflection)
  apply (rule ext)
  apply (rule_tac list="x" in list.induct)
  apply (simp_all)
  done


lemma cons_prs:
  assumes q: "Quotient R Abs Rep"
  shows "(map Abs) ((Rep h) # (map Rep t)) = h # t"
by (induct t) (simp_all add: Quotient_abs_rep[OF q])

lemma cons_rsp[quotient_rsp]:
  assumes q: "Quotient R Abs Rep"
  shows "(R ===> list_rel R ===> list_rel R) op # op #"
by (auto)

lemma nil_prs:
  assumes q: "Quotient R Abs Rep"
  shows "map Abs [] \<equiv> []"
by (simp)

lemma nil_rsp[quotient_rsp]:
  assumes q: "Quotient R Abs Rep"
  shows "list_rel R [] []"
by simp

lemma map_prs:
  assumes a: "Quotient R1 abs1 rep1"
  and     b: "Quotient R2 abs2 rep2"
  shows "(map abs2) (map ((abs1 ---> rep2) f) (map rep1 l)) = map f l"
by (induct l) (simp_all add: Quotient_abs_rep[OF a] Quotient_abs_rep[OF b])

lemma map_rsp[quotient_rsp]:
  assumes q1: "Quotient R1 Abs1 Rep1"
  and     q2: "Quotient R2 Abs2 Rep2"
  shows "((R1 ===> R2) ===> (list_rel R1) ===> list_rel R2) map map"
apply(simp)
apply(rule allI)+
apply(rule impI)
apply(rule allI)+
apply (induct_tac xa ya rule: list_induct2')
apply simp_all
done

lemma foldr_prs:
  assumes a: "Quotient R1 abs1 rep1"
  and     b: "Quotient R2 abs2 rep2"
  shows "abs2 (foldr ((abs1 ---> abs2 ---> rep2) f) (map rep1 l) (rep2 e)) = foldr f l e"
by (induct l) (simp_all add: Quotient_abs_rep[OF a] Quotient_abs_rep[OF b])

lemma foldl_prs:
  assumes a: "Quotient R1 abs1 rep1"
  and     b: "Quotient R2 abs2 rep2"
  shows "abs1 (foldl ((abs1 ---> abs2 ---> rep1) f) (rep1 e) (map rep2 l)) = foldl f e l"
by (induct l arbitrary:e) (simp_all add: Quotient_abs_rep[OF a] Quotient_abs_rep[OF b])

lemma list_rel_empty: "list_rel R [] b \<Longrightarrow> length b = 0"
by (induct b) (simp_all)

lemma list_rel_len: "list_rel R a b \<Longrightarrow> length a = length b"
apply (induct a arbitrary: b)
apply (simp add: list_rel_empty)
apply (case_tac b)
apply simp_all
done

(* TODO: induct_tac doesn't accept 'arbitrary'.
         induct     doesn't accept 'rule'.
   that's why the proof uses manual generalisation and needs assumptions
   both in conclusion for induction and in assumptions. *)
lemma foldl_rsp[quotient_rsp]:
  assumes q1: "Quotient R1 Abs1 Rep1"
  and     q2: "Quotient R2 Abs2 Rep2"
  shows "((R1 ===> R2 ===> R1) ===> R1 ===> list_rel R2 ===> R1) foldl foldl"
apply auto
apply (subgoal_tac "R1 xa ya \<longrightarrow> list_rel R2 xb yb \<longrightarrow> R1 (foldl x xa xb) (foldl y ya yb)")
apply simp
apply (rule_tac x="xa" in spec)
apply (rule_tac x="ya" in spec)
apply (rule_tac xs="xb" and ys="yb" in list_induct2)
apply (rule list_rel_len)
apply (simp_all)
done

(* TODO: foldr_rsp should be similar *)




(* TODO: Rest are unused *)

lemma list_rel_eq:
  shows "list_rel (op =) \<equiv> (op =)"
apply(rule eq_reflection)
unfolding expand_fun_eq
apply(rule allI)+
apply(induct_tac x xa rule: list_induct2')
apply(simp_all)
done

lemma list_rel_refl:
  assumes a: "\<And>x y. R x y = (R x = R y)"
  shows "list_rel R x x"
by (induct x) (auto simp add: a)

end
