theory Let
imports "../Nominal2" 
begin


lemma Abs_lst_fcb2:
  fixes as bs :: "atom list"
    and x y :: "'b :: fs"
    and c::"'c::fs"
  assumes eq: "[as]lst. x = [bs]lst. y"
  and fcb1: "(set as) \<sharp>* c \<Longrightarrow> (set as) \<sharp>* f as x c"
  and fresh1: "set as \<sharp>* c"
  and fresh2: "set bs \<sharp>* c"
  and perm1: "\<And>p. supp p \<sharp>* c \<Longrightarrow> p \<bullet> (f as x c) = f (p \<bullet> as) (p \<bullet> x) c"
  and perm2: "\<And>p. supp p \<sharp>* c \<Longrightarrow> p \<bullet> (f bs y c) = f (p \<bullet> bs) (p \<bullet> y) c"
  shows "f as x c = f bs y c"
proof -
  have "supp (as, x, c) supports (f as x c)"
    unfolding  supports_def fresh_def[symmetric]
    by (simp add: fresh_Pair perm1 fresh_star_def supp_swap swap_fresh_fresh)
  then have fin1: "finite (supp (f as x c))"
    by (auto intro: supports_finite simp add: finite_supp)
  have "supp (bs, y, c) supports (f bs y c)"
    unfolding  supports_def fresh_def[symmetric]
    by (simp add: fresh_Pair perm2 fresh_star_def supp_swap swap_fresh_fresh)
  then have fin2: "finite (supp (f bs y c))"
    by (auto intro: supports_finite simp add: finite_supp)
  obtain q::"perm" where 
    fr1: "(q \<bullet> (set as)) \<sharp>* (x, c, f as x c, f bs y c)" and 
    fr2: "supp q \<sharp>* Abs_lst as x" and 
    inc: "supp q \<subseteq> (set as) \<union> q \<bullet> (set as)"
    using at_set_avoiding3[where xs="set as" and c="(x, c, f as x c, f bs y c)" and x="[as]lst. x"]  
      fin1 fin2
    by (auto simp add: supp_Pair finite_supp Abs_fresh_star dest: fresh_star_supp_conv)
  have "Abs_lst (q \<bullet> as) (q \<bullet> x) = q \<bullet> Abs_lst as x" by simp
  also have "\<dots> = Abs_lst as x"
    by (simp only: fr2 perm_supp_eq)
  finally have "Abs_lst (q \<bullet> as) (q \<bullet> x) = Abs_lst bs y" using eq by simp
  then obtain r::perm where 
    qq1: "q \<bullet> x = r \<bullet> y" and 
    qq2: "q \<bullet> as = r \<bullet> bs" and 
    qq3: "supp r \<subseteq> (q \<bullet> (set as)) \<union> set bs"
    apply(drule_tac sym)
    apply(simp only: Abs_eq_iff2 alphas)
    apply(erule exE)
    apply(erule conjE)+
    apply(drule_tac x="p" in meta_spec)
    apply(simp add: set_eqvt)
    apply(blast)
    done
  have "(set as) \<sharp>* f as x c" 
    apply(rule fcb1)
    apply(rule fresh1)
    done
  then have "q \<bullet> ((set as) \<sharp>* f as x c)"
    by (simp add: permute_bool_def)
  then have "set (q \<bullet> as) \<sharp>* f (q \<bullet> as) (q \<bullet> x) c"
    apply(simp add: fresh_star_eqvt set_eqvt)
    apply(subst (asm) perm1)
    using inc fresh1 fr1
    apply(auto simp add: fresh_star_def fresh_Pair)
    done
  then have "set (r \<bullet> bs) \<sharp>* f (r \<bullet> bs) (r \<bullet> y) c" using qq1 qq2 by simp
  then have "r \<bullet> ((set bs) \<sharp>* f bs y c)"
    apply(simp add: fresh_star_eqvt set_eqvt)
    apply(subst (asm) perm2[symmetric])
    using qq3 fresh2 fr1
    apply(auto simp add: set_eqvt fresh_star_def fresh_Pair)
    done
  then have fcb2: "(set bs) \<sharp>* f bs y c" by (simp add: permute_bool_def)
  have "f as x c = q \<bullet> (f as x c)"
    apply(rule perm_supp_eq[symmetric])
    using inc fcb1[OF fresh1] fr1 by (auto simp add: fresh_star_def)
  also have "\<dots> = f (q \<bullet> as) (q \<bullet> x) c" 
    apply(rule perm1)
    using inc fresh1 fr1 by (auto simp add: fresh_star_def)
  also have "\<dots> = f (r \<bullet> bs) (r \<bullet> y) c" using qq1 qq2 by simp
  also have "\<dots> = r \<bullet> (f bs y c)"
    apply(rule perm2[symmetric])
    using qq3 fresh2 fr1 by (auto simp add: fresh_star_def)
  also have "... = f bs y c"
    apply(rule perm_supp_eq)
    using qq3 fr1 fcb2 by (auto simp add: fresh_star_def)
  finally show ?thesis by simp
qed

lemma Abs_lst1_fcb2:
  fixes a b :: "atom"
    and x y :: "'b :: fs"
    and c::"'c :: fs"
  assumes e: "(Abs_lst [a] x) = (Abs_lst [b] y)"
  and fcb1: "a \<sharp> c \<Longrightarrow> a \<sharp> f a x c"
  and fresh: "{a, b} \<sharp>* c"
  and perm1: "\<And>p. supp p \<sharp>* c \<Longrightarrow> p \<bullet> (f a x c) = f (p \<bullet> a) (p \<bullet> x) c"
  and perm2: "\<And>p. supp p \<sharp>* c \<Longrightarrow> p \<bullet> (f b y c) = f (p \<bullet> b) (p \<bullet> y) c"
  shows "f a x c = f b y c"
using e
apply(drule_tac Abs_lst_fcb2[where c="c" and f="\<lambda>(as::atom list) . f (hd as)"])
apply(simp_all)
using fcb1 fresh perm1 perm2
apply(simp_all add: fresh_star_def)
done

atom_decl name

nominal_datatype trm =
  Var "name"
| App "trm" "trm"
| Let as::"assn" t::"trm"   bind "bn as" in t
and assn =
  Assn "name" "trm"
binder
  bn
where
 "bn (Assn x t) = [atom x]"

print_theorems



thm bn_raw.simps
thm permute_bn_raw.simps
thm trm_assn.perm_bn_alpha
thm trm_assn.permute_bn

thm trm_assn.fv_defs
thm trm_assn.eq_iff 
thm trm_assn.bn_defs
thm trm_assn.bn_inducts
thm trm_assn.perm_simps
thm trm_assn.induct
thm trm_assn.inducts
thm trm_assn.distinct
thm trm_assn.supp
thm trm_assn.fresh
thm trm_assn.exhaust
thm trm_assn.strong_exhaust
thm trm_assn.perm_bn_simps

thm alpha_bn_raw.cases


lemmas alpha_bn_cases[consumes 1] = alpha_bn_raw.cases[quot_lifted]

lemma alpha_bn_refl: "alpha_bn x x"
  by (induct x rule: trm_assn.inducts(2))
     (rule TrueI, auto simp add: trm_assn.eq_iff)
lemma alpha_bn_sym: "alpha_bn x y \<Longrightarrow> alpha_bn y x"
  apply(erule alpha_bn_cases)
  apply(auto)
  done

lemma alpha_bn_trans: "alpha_bn x y \<Longrightarrow> alpha_bn y z \<Longrightarrow> alpha_bn x z"
  sorry

lemma k: "A \<Longrightarrow> A \<and> A" by blast

lemma max_eqvt[eqvt]: "p \<bullet> (max (a :: _ :: pure) b) = max (p \<bullet> a) (p \<bullet> b)"
  by (simp add: permute_pure)


section {* definition with helper functions *}

function 
  apply_assn
where
  "apply_assn f (Assn x t) = (f t)"
apply(case_tac x)
apply(simp)
apply(case_tac b rule: trm_assn.exhaust(2))
apply(blast)
apply(simp)
done

termination
  by lexicographic_order

function 
  apply_assn2
where
  "apply_assn2 f (Assn x t) = Assn x (f t)"
apply(case_tac x)
apply(simp)
apply(case_tac b rule: trm_assn.exhaust(2))
apply(blast)
apply(simp)
done

termination
  by lexicographic_order

lemma [eqvt]:
  shows "p \<bullet> (apply_assn f as) = apply_assn (p \<bullet> f) (p \<bullet> as)"
apply(induct f as rule: apply_assn.induct)
apply(simp)
apply(perm_simp)
apply(rule)
done

lemma [eqvt]:
  shows "p \<bullet> (apply_assn2 f as) = apply_assn2 (p \<bullet> f) (p \<bullet> as)"
apply(induct f as rule: apply_assn.induct)
apply(simp)
apply(perm_simp)
apply(rule)
done


nominal_primrec
    height_trm :: "trm \<Rightarrow> nat"
where
  "height_trm (Var x) = 1"
| "height_trm (App l r) = max (height_trm l) (height_trm r)"
| "height_trm (Let as b) = max (apply_assn height_trm as) (height_trm b)"
  apply (simp only: eqvt_def height_trm_graph_def)
  apply (rule, perm_simp)
  apply(rule)
  apply(rule TrueI)
  apply (case_tac x rule: trm_assn.exhaust(1))
  apply (auto simp add: alpha_bn_refl)[3]
  apply (drule_tac x="assn" in meta_spec)
  apply (drule_tac x="trm" in meta_spec)
  apply(simp add: alpha_bn_refl)
  apply(simp_all)[5]
  apply(simp)
  apply(erule conjE)+
  thm alpha_bn_cases
  apply(erule alpha_bn_cases)
  apply(simp)
  apply (subgoal_tac "height_trm_sumC b = height_trm_sumC ba")
  apply simp
  apply(simp add: trm_assn.bn_defs)
  apply(erule_tac c="()" in Abs_lst_fcb2)
  apply(simp_all add: pure_fresh fresh_star_def)[3]
  apply(simp_all add: eqvt_at_def)
  done


nominal_primrec 
  subst_trm :: "trm \<Rightarrow> name \<Rightarrow> trm \<Rightarrow> trm"  ("_ [_ ::= _]" [90, 90, 90] 90) 
where
  "(Var x)[y ::= s] = (if x = y then s else (Var x))"
| "(App t1 t2)[y ::= s] = App (t1[y ::= s]) (t2[y ::= s])"
| "(set (bn as)) \<sharp>* (y, s) \<Longrightarrow> 
      (Let as t)[y ::= s] = Let (apply_assn2 (\<lambda>t. t[y ::=s]) as) (t[y ::= s])"
  apply (simp only: eqvt_def subst_trm_graph_def)
  apply (rule, perm_simp)
  apply(rule)
  apply(rule TrueI)
  apply(case_tac x)
  apply(simp)
  apply (rule_tac y="a" and c="(b,c)" in trm_assn.strong_exhaust(1))
  apply (auto simp add: alpha_bn_refl)[3]
  apply(simp_all)[5]
  apply(simp)
  apply(erule conjE)+
  thm alpha_bn_cases
  apply(erule alpha_bn_cases)
  apply(simp)
  apply(simp add: trm_assn.bn_defs)
  apply(erule_tac c="(ya,sa)" in Abs_lst1_fcb2)
  apply(simp add: Abs_fresh_iff fresh_star_def)
  apply(simp add: fresh_star_def)
  apply(simp_all add: eqvt_at_def perm_supp_eq fresh_star_Pair)[2]
  done


section {* direct definitions --- problems *}


nominal_primrec
    height_trm :: "trm \<Rightarrow> nat"
and height_assn :: "assn \<Rightarrow> nat"
where
  "height_trm (Var x) = 1"
| "height_trm (App l r) = max (height_trm l) (height_trm r)"
| "height_trm (Let as b) = max (height_assn as) (height_trm b)"
| "height_assn (Assn x t) = (height_trm t)"
  apply (simp only: eqvt_def height_trm_height_assn_graph_def)
  apply (rule, perm_simp, rule, rule TrueI)
  apply (case_tac x)
  apply(simp)
  apply (case_tac a rule: trm_assn.exhaust(1))
  apply (auto simp add: alpha_bn_refl)[3]
  apply (drule_tac x="assn" in meta_spec)
  apply (drule_tac x="trm" in meta_spec)
  apply(simp add: alpha_bn_refl)
  apply(simp)
  apply (case_tac b rule: trm_assn.exhaust(2))
  apply (auto)[1]
  apply(simp_all)[7]
  prefer 2
  apply(simp)
  --"let case"
  apply (simp only: meta_eq_to_obj_eq[OF height_trm_def, symmetric, unfolded fun_eq_iff])
  apply (simp only: meta_eq_to_obj_eq[OF height_assn_def, symmetric, unfolded fun_eq_iff])
  apply (subgoal_tac "eqvt_at height_assn as")
  apply (subgoal_tac "eqvt_at height_assn asa")
  apply (subgoal_tac "eqvt_at height_trm b")
  apply (subgoal_tac "eqvt_at height_trm ba")
  apply (thin_tac "eqvt_at height_trm_height_assn_sumC (Inr as)")
  apply (thin_tac "eqvt_at height_trm_height_assn_sumC (Inr asa)")
  apply (thin_tac "eqvt_at height_trm_height_assn_sumC (Inl b)")
  apply (thin_tac "eqvt_at height_trm_height_assn_sumC (Inl ba)")
  defer
  apply (simp add: eqvt_at_def height_trm_def)
  apply (simp add: eqvt_at_def height_trm_def)
  apply (simp add: eqvt_at_def height_assn_def)
  apply (simp add: eqvt_at_def height_assn_def)
  prefer 2
  apply (subgoal_tac "height_assn as = height_assn asa")
  apply (subgoal_tac "height_trm b = height_trm ba")
  apply simp
  apply(simp)
  apply(erule conjE)+
  apply(erule alpha_bn_cases)
  apply(simp)
  apply(simp add: trm_assn.bn_defs)
  thm Abs_lst_fcb2
  apply(erule_tac c="()" in Abs_lst_fcb2)
  apply(simp_all add: fresh_star_def pure_fresh)[3]
  apply(simp add: eqvt_at_def)
  apply(simp add: eqvt_at_def)
  defer
  apply(simp)
  apply(frule Inl_inject)
  apply(subst (asm) trm_assn.eq_iff)
  apply(drule Inl_inject)
  apply(clarify)
  apply(erule alpha_bn_cases)
  apply(simp del: trm_assn.eq_iff)
  apply(rename_tac as s as' s' t' t x x')
  apply(simp only: trm_assn.bn_defs)
  (* HERE *)
  oops


lemma ww1:
  shows "finite (fv_trm t)"
  and "finite (fv_bn as)"
apply(induct t and as rule: trm_assn.inducts)
apply(simp_all add: trm_assn.fv_defs supp_at_base)
done

text {* works, but only because no recursion in as *}

nominal_primrec (invariant "\<lambda>x (y::atom set). finite y")
  frees_set :: "trm \<Rightarrow> atom set"
where
  "frees_set (Var x) = {atom x}"
| "frees_set (App t1 t2) = frees_set t1 \<union> frees_set t2"
| "frees_set (Let as t) = (frees_set t) - (set (bn as)) \<union> (fv_bn as)"
  apply(simp add: eqvt_def frees_set_graph_def)
  apply(rule, perm_simp, rule)
  apply(erule frees_set_graph.induct)
  apply(auto simp add: ww1)[3]
  apply(rule_tac y="x" in trm_assn.exhaust(1))
  apply(auto simp add: alpha_bn_refl)[3]
  apply(drule_tac x="assn" in meta_spec)
  apply(drule_tac x="trm" in meta_spec)
  apply(simp add: alpha_bn_refl)
  apply(simp_all)[5]
  apply(simp)
  apply(erule conjE)
  apply(erule alpha_bn_cases)
  apply(simp add: trm_assn.bn_defs)
  apply(simp add: trm_assn.fv_defs)
  (* apply(erule_tac c="(trm_rawa)" in Abs_lst1_fcb2) *)
  apply(subgoal_tac " frees_set_sumC t - {atom name} = frees_set_sumC ta - {atom namea}")
  apply(simp)
  apply(erule_tac c="()" in Abs_lst1_fcb2)
  apply(simp add: fresh_minus_atom_set)
  apply(simp add: fresh_star_def fresh_Unit)
  apply(simp add: Diff_eqvt eqvt_at_def, perm_simp, rule refl)
  apply(simp add: Diff_eqvt eqvt_at_def, perm_simp, rule refl)
  done

termination
  by lexicographic_order

lemma test:
  assumes a: "\<exists>y. f x = Inl y"
  shows "(p \<bullet> (Sum_Type.Projl (f x))) = Sum_Type.Projl ((p \<bullet> f) (p \<bullet> x))"
using a
apply clarify
apply(frule_tac p="p" in permute_boolI)
apply(simp (no_asm_use) only: eqvts)
apply(subst (asm) permute_fun_app_eq)
back
apply(simp)
done


nominal_primrec (default "sum_case (\<lambda>x. Inl undefined) (\<lambda>x. Inr undefined)")
  subst_trm :: "trm \<Rightarrow> name \<Rightarrow> trm \<Rightarrow> trm"  ("_ [_ ::trm= _]" [90, 90, 90] 90) and
  subst_assn :: "assn \<Rightarrow> name \<Rightarrow> trm \<Rightarrow> assn"  ("_ [_ ::assn= _]" [90, 90, 90] 90)
where
  "(Var x)[y ::trm= s] = (if x = y then s else (Var x))"
| "(App t1 t2)[y ::trm= s] = App (t1[y ::trm= s]) (t2[y ::trm= s])"
| "(set (bn as)) \<sharp>* (y, s) \<Longrightarrow> (Let as t)[y ::trm= s] = Let (ast[y ::assn= s]) (t[y ::trm= s])"
| "(Assn x t)[y ::assn= s] = Assn x (t[y ::trm= s])"
apply(subgoal_tac "\<And>p x r. subst_trm_subst_assn_graph x r \<Longrightarrow> subst_trm_subst_assn_graph (p \<bullet> x) (p \<bullet> r)")
apply(simp add: eqvt_def)
apply(rule allI)
apply(simp add: permute_fun_def permute_bool_def)
apply(rule ext)
apply(rule ext)
apply(rule iffI)
apply(drule_tac x="p" in meta_spec)
apply(drule_tac x="- p \<bullet> x" in meta_spec)
apply(drule_tac x="- p \<bullet> xa" in meta_spec)
apply(simp)
apply(drule_tac x="-p" in meta_spec)
apply(drule_tac x="x" in meta_spec)
apply(drule_tac x="xa" in meta_spec)
apply(simp)
--"Eqvt One way"
defer
  apply(rule TrueI)
  apply(case_tac x)
  apply(simp)
  apply(case_tac a)
  apply(simp)
  apply(rule_tac y="aa" and c="(b, c)" in trm_assn.strong_exhaust(1))
  apply(blast)+
  apply(simp)
  apply(case_tac b)
  apply(simp)
  apply(rule_tac y="a" in trm_assn.exhaust(2))
  apply(simp)
  apply(blast)
  apply(simp_all)[7]
  prefer 2
  apply(simp)
  prefer 2
  apply(simp)
  apply(simp)
  apply (simp only: meta_eq_to_obj_eq[OF subst_trm_def, symmetric, unfolded fun_eq_iff])
  apply (simp only: meta_eq_to_obj_eq[OF subst_assn_def, symmetric, unfolded fun_eq_iff])
  apply (subgoal_tac "eqvt_at (\<lambda>ast. subst_assn ast ya sa) ast")
  apply (subgoal_tac "eqvt_at (\<lambda>asta. subst_assn asta ya sa) asta")
  apply (subgoal_tac "eqvt_at (\<lambda>t. subst_trm t ya sa) t")
  apply (subgoal_tac "eqvt_at (\<lambda>ta. subst_trm ta ya sa) ta")
  apply (thin_tac "eqvt_at subst_trm_subst_assn_sumC (Inr (ast, ya, sa))")
  apply (thin_tac "eqvt_at subst_trm_subst_assn_sumC (Inr (asta, ya, sa))")
  apply (thin_tac "eqvt_at subst_trm_subst_assn_sumC (Inl (t, ya, sa))")
  apply (thin_tac "eqvt_at subst_trm_subst_assn_sumC (Inl (ta, ya, sa))")
  defer
  defer
  defer
  defer
  defer
  defer
  apply(rule conjI)
  apply (subgoal_tac "subst_assn ast ya sa= subst_assn asta ya sa")
  apply (subgoal_tac "subst_trm t ya sa = subst_trm ta ya sa")
  apply(simp)
  apply(erule_tac conjE)+
  apply(erule alpha_bn_cases)
  apply(simp add: trm_assn.bn_defs)
  apply(rotate_tac 7)
  apply(drule k)
  apply(erule conjE)
  apply(subst (asm) Abs1_eq_iff)
  apply(rule sort_of_atom_eq)
  apply(rule sort_of_atom_eq)
  apply(erule disjE)
  apply(simp)
  apply(rotate_tac 12)
  apply(drule sym)
  apply(rule sym)
  apply (erule_tac c="(ya,sa)" in Abs_lst1_fcb2)
  apply(erule fresh_eqvt_at)
  
  thm fresh_eqvt_at
  apply(simp add: Abs_fresh_iff)
  apply(simp add: fresh_star_def fresh_Pair)
  apply(simp add: eqvt_at_def atom_eqvt fresh_star_Pair perm_supp_eq)
  apply(simp add: eqvt_at_def atom_eqvt fresh_star_Pair perm_supp_eq)



  apply(simp_all add: fresh_star_def fresh_Pair_elim)[1]
  apply(blast)
  apply(simp_all)[5]
  apply(simp (no_asm_use))
  apply(simp)
  apply(erule conjE)+
  apply (erule_tac c="(ya,sa)" in Abs_lst1_fcb2)
  apply(simp add: Abs_fresh_iff)
  apply(simp add: fresh_star_def fresh_Pair)
  apply(simp add: eqvt_at_def atom_eqvt fresh_star_Pair perm_supp_eq)
  apply(simp add: eqvt_at_def atom_eqvt fresh_star_Pair perm_supp_eq)
done


end