theory SingleLet
imports "../NewParser"
begin

atom_decl name

declare [[STEPS = 100]]

nominal_datatype single_let: trm  =
  Var "name"
| App "trm" "trm"
| Lam x::"name" t::"trm"  bind x in t
| Let a::"assg" t::"trm"  bind (set) "bn a" in t
| Foo x::"name" y::"name" t::"trm" t1::"trm" t2::"trm" bind (set) x in y t t1 t2
| Bar x::"name" y::"name" t::"trm" bind y x in t x y
| Baz x::"name" t1::"trm" t2::"trm" bind x in t1, bind x in t2 
and assg =
  As "name" x::"name" t::"trm" bind x in t
binder
  bn::"assg \<Rightarrow> atom set"
where
  "bn (As x y t) = {atom x}"

thm Ball_def Bex_def mem_def

thm single_let.distinct
thm single_let.induct
thm single_let.exhaust
thm single_let.fv_defs
thm single_let.bn_defs
thm single_let.perm_simps
thm single_let.eq_iff
thm single_let.fv_bn_eqvt
thm single_let.size_eqvt
thm single_let.supports
thm single_let.fsupp





lemma test: 
  "(\<exists>p. (bs, x) \<approx>lst (op=) f p (cs, y)) \<longleftrightarrow> (\<exists>p. (bs, x) \<approx>lst (op=) supp p (cs, y))"
oops

lemma Abs_eq_iff:
  shows "Abs bs x = Abs cs y \<longleftrightarrow> (\<exists>p. (bs, x) \<approx>gen (op =) supp p (cs, y))"
  and   "Abs_res bs x = Abs_res cs y \<longleftrightarrow> (\<exists>p. (bs, x) \<approx>res (op =) supp p (cs, y))"
  and   "Abs_lst bsl x = Abs_lst csl y \<longleftrightarrow> (\<exists>p. (bsl, x) \<approx>lst (op =) supp p (csl, y))"
  by (lifting alphas_abs)

(*
lemma supp_fv:
  "supp t = fv_trm t \<and> supp b = fv_bn b"
apply(rule single_let.induct)
apply(simp_all only: single_let.fv_defs)[2]
apply(simp_all only: supp_def)[2]
apply(simp_all only: single_let.perm_simps)[2]
apply(simp_all only: single_let.eq_iff)[2]
apply(simp_all only: de_Morgan_conj)[2]
apply(simp_all only: Collect_disj_eq)[2]
apply(simp_all only: finite_Un)[2]
apply(simp_all only: de_Morgan_conj)[2]
apply(simp_all only: Collect_disj_eq)[2]
apply(subgoal_tac "supp (Lam name trm) = supp (Abs_lst [atom name] trm)")
apply(simp only: single_let.fv_defs)
apply(simp only: supp_abs)
apply(simp (no_asm) only: supp_def)
apply(simp only: single_let.perm_simps)
apply(simp only: single_let.eq_iff)
apply(subst test)
apply(simp only: Abs_eq_iff[symmetric])
apply(simp only: alphas_abs[symmetric])
apply(simp only: eqvts)
thm Abs_eq_iff
apply(simp only: alphas)
sorry
*)
(*

consts perm_bn_trm :: "perm \<Rightarrow> trm \<Rightarrow> trm"
consts perm_bn_assg :: "perm \<Rightarrow> assg \<Rightarrow> assg"

lemma y:
  "perm_bn_trm p (Var x) = (Var x)"
  "perm_bn_trm p (App t1 t2) = (App t1 t2)"
  "perm_bn_trm p ("



typ trm
typ assg

thm trm_assg.fv
thm trm_assg.supp
thm trm_assg.eq_iff
thm trm_assg.bn
thm trm_assg.perm
thm trm_assg.induct
thm trm_assg.inducts
thm trm_assg.distinct
ML {* Sign.of_sort @{theory} (@{typ trm}, @{sort fs}) *}
*)



end



