theory QuotProd
imports QuotMain
begin

fun
  prod_rel
where
  "prod_rel r1 r2 = (\<lambda>(a,b) (c,d). r1 a c \<and> r2 b d)"

(* prod_fun is a good mapping function *)

lemma prod_equivp:
  assumes a: "equivp R1"
  assumes b: "equivp R2"
  shows "equivp (prod_rel R1 R2)"
unfolding equivp_reflp_symp_transp reflp_def symp_def transp_def
apply(auto simp add: equivp_reflp[OF a] equivp_reflp[OF b])
apply(simp only: equivp_symp[OF a])
apply(simp only: equivp_symp[OF b])
using equivp_transp[OF a] apply blast
using equivp_transp[OF b] apply blast
done

lemma prod_quotient:
  assumes q1: "Quotient R1 Abs1 Rep1"
  assumes q2: "Quotient R2 Abs2 Rep2"
  shows "Quotient (prod_rel R1 R2) (prod_fun Abs1 Abs2) (prod_fun Rep1 Rep2)"
unfolding Quotient_def
using q1 q2
apply (simp add: Quotient_abs_rep Quotient_abs_rep Quotient_rel_rep Quotient_rel_rep)
using Quotient_rel[OF q1] Quotient_rel[OF q2] by blast

lemma pair_rsp:
  assumes q1: "Quotient R1 Abs1 Rep1"
  assumes q2: "Quotient R2 Abs2 Rep2"
  shows "(R1 ===> R2 ===> prod_rel R1 R2) Pair Pair"
by auto

lemma pair_prs_aux:
  assumes q1: "Quotient R1 Abs1 Rep1"
  assumes q2: "Quotient R2 Abs2 Rep2"
  shows "(prod_fun Abs1 Abs2) (Rep1 l, Rep2 r) \<equiv> (l, r)"
  by (simp add: Quotient_abs_rep[OF q1] Quotient_abs_rep[OF q2])

lemma pair_prs[quot_preserve]:
  assumes q1: "Quotient R1 Abs1 Rep1"
  assumes q2: "Quotient R2 Abs2 Rep2"
  shows "(Rep1 ---> Rep2 ---> (prod_fun Abs1 Abs2)) Pair = Pair"
apply(simp only: expand_fun_eq fun_map.simps pair_prs_aux[OF q1 q2])
apply(simp)
done




lemma fst_rsp:
  assumes q1: "Quotient R1 Abs1 Rep1"
  assumes q2: "Quotient R2 Abs2 Rep2"
  assumes a: "(prod_rel R1 R2) p1 p2"
  shows "R1 (fst p1) (fst p2)"
  using a
  apply(case_tac p1)
  apply(case_tac p2)
  apply(auto)
  done

lemma snd_rsp:
  assumes q1: "Quotient R1 Abs1 Rep1"
  assumes q2: "Quotient R2 Abs2 Rep2"
  assumes a: "(prod_rel R1 R2) p1 p2"
  shows "R2 (snd p1) (snd p2)"
  using a
  apply(case_tac p1)
  apply(case_tac p2)
  apply(auto)
  done

lemma fst_prs:
  assumes q1: "Quotient R1 Abs1 Rep1"
  assumes q2: "Quotient R2 Abs2 Rep2"
  shows "Abs1 (fst ((prod_fun Rep1 Rep2) p)) = fst p"
by (case_tac p) (auto simp add: Quotient_abs_rep[OF q1])

lemma snd_prs:
  assumes q1: "Quotient R1 Abs1 Rep1"
  assumes q2: "Quotient R2 Abs2 Rep2"
  shows "Abs2 (snd ((prod_fun Rep1 Rep2) p)) = snd p"
by (case_tac p) (auto simp add: Quotient_abs_rep[OF q2])

lemma prod_fun_id[id_simps]: "prod_fun id id \<equiv> id"
  by (rule eq_reflection) (simp add: prod_fun_def)

lemma prod_rel_eq[id_simps]: "prod_rel op = op = \<equiv> op ="
  apply (rule eq_reflection)
  apply (rule ext)+
  apply auto
  done

section {* general setup for products *}

declare [[map * = (prod_fun, prod_rel)]]

lemmas [quot_thm] = prod_quotient
lemmas [quot_respect] = pair_rsp
lemmas [quot_equiv] = prod_equivp

end
