theory Nominal2
imports 
  "../Nominal-General/Nominal2_Base" 
  "../Nominal-General/Nominal2_Eqvt" 
  "Nominal2_FSet"
  "Abs"
uses ("nominal_dt_rawperm.ML")
     ("nominal_dt_rawfuns.ML")
     ("nominal_dt_alpha.ML")
     ("nominal_dt_quot.ML")
     ("nominal_dt_supp.ML")
begin

use "nominal_dt_rawperm.ML"
ML {* open Nominal_Dt_RawPerm *}

use "nominal_dt_rawfuns.ML"
ML {* open Nominal_Dt_RawFuns *}

use "nominal_dt_alpha.ML"
ML {* open Nominal_Dt_Alpha *}

use "nominal_dt_quot.ML"
ML {* open Nominal_Dt_Quot *}

use "nominal_dt_supp.ML"
ML {* open Nominal_Dt_Supp *}

section{* Interface for nominal_datatype *}

ML {*
(* attributes *)
val eqvt_attr = Attrib.internal (K Nominal_ThmDecls.eqvt_add)
val rsp_attr = Attrib.internal (K Quotient_Info.rsp_rules_add)
val simp_attr = Attrib.internal (K Simplifier.simp_add)

*}

ML {* print_depth 50 *}

ML {*
fun get_cnstrs dts =
  map (fn (_, _, _, constrs) => constrs) dts

fun get_typed_cnstrs dts =
  flat (map (fn (_, bn, _, constrs) => 
   (map (fn (bn', _, _) => (Binding.name_of bn, Binding.name_of bn')) constrs)) dts)

fun get_cnstr_strs dts =
  map (fn (bn, _, _) => Binding.name_of bn) (flat (get_cnstrs dts))

fun get_bn_fun_strs bn_funs =
  map (fn (bn_fun, _, _) => Binding.name_of bn_fun) bn_funs
*}


text {* Infrastructure for adding "_raw" to types and terms *}

ML {*
fun add_raw s = s ^ "_raw"
fun add_raws ss = map add_raw ss
fun raw_bind bn = Binding.suffix_name "_raw" bn

fun replace_str ss s = 
  case (AList.lookup (op=) ss s) of 
     SOME s' => s'
   | NONE => s

fun replace_typ ty_ss (Type (a, Ts)) = Type (replace_str ty_ss a, map (replace_typ ty_ss) Ts)
  | replace_typ ty_ss T = T  

fun raw_dts ty_ss dts =
let
  fun raw_dts_aux1 (bind, tys, mx) =
    (raw_bind bind, map (replace_typ ty_ss) tys, mx)

  fun raw_dts_aux2 (ty_args, bind, mx, constrs) =
    (ty_args, raw_bind bind, mx, map raw_dts_aux1 constrs)
in
  map raw_dts_aux2 dts
end

fun replace_aterm trm_ss (Const (a, T)) = Const (replace_str trm_ss a, T)
  | replace_aterm trm_ss (Free (a, T)) = Free (replace_str trm_ss a, T)
  | replace_aterm trm_ss trm = trm

fun replace_term trm_ss ty_ss trm =
  trm |> Term.map_aterms (replace_aterm trm_ss) |> map_types (replace_typ ty_ss) 
*}

ML {*
fun rawify_dts dt_names dts dts_env =
let
  val raw_dts = raw_dts dts_env dts
  val raw_dt_names = add_raws dt_names
in
  (raw_dt_names, raw_dts)
end 
*}

ML {*
fun rawify_bn_funs dts_env cnstrs_env bn_fun_env bn_funs bn_eqs =
let
  val bn_funs' = map (fn (bn, ty, mx) => 
    (raw_bind bn, SOME (replace_typ dts_env ty), mx)) bn_funs
  
  val bn_eqs' = map (fn (attr, trm) => 
    (attr, replace_term (cnstrs_env @ bn_fun_env) dts_env trm)) bn_eqs
in
  (bn_funs', bn_eqs') 
end 
*}

ML {* 
fun rawify_bclauses dts_env cnstrs_env bn_fun_env bclauses =
let
  fun rawify_bnds bnds = 
    map (apfst (Option.map (replace_term (cnstrs_env @ bn_fun_env) dts_env))) bnds

  fun rawify_bclause (BC (mode, bnds, bdys)) = BC (mode, rawify_bnds bnds, bdys)
in
  map (map (map rawify_bclause)) bclauses
end
*}

(* strip_bn_fun takes a rhs of a bn function: this can only contain unions or
   appends of elements; in case of recursive calls it retruns also the applied
   bn function *)
ML {*
fun strip_bn_fun lthy args t =
let 
  fun aux t =
    case t of
      Const (@{const_name sup}, _) $ l $ r => aux l @ aux r
    | Const (@{const_name append}, _) $ l $ r => aux l @ aux r
    | Const (@{const_name insert}, _) $ (Const (@{const_name atom}, _) $ (x as Var _)) $ y =>
        (find_index (equal x) args, NONE) :: aux y
    | Const (@{const_name Cons}, _) $ (Const (@{const_name atom}, _) $ (x as Var _)) $ y =>
        (find_index (equal x) args, NONE) :: aux y
    | Const (@{const_name bot}, _) => []
    | Const (@{const_name Nil}, _) => []
    | (f as Const _) $ (x as Var _) => [(find_index (equal x) args, SOME f)]
    | _ => error ("Unsupported binding function: " ^ (Syntax.string_of_term lthy t))
in
  aux t
end  
*}

ML {*
(** definition of the raw binding functions **)

(* TODO: needs cleaning *)
fun find [] _ = error ("cannot find element")
  | find ((x, z)::xs) y = if (Long_Name.base_name x) = y then z else find xs y

fun prep_bn_info lthy dt_names dts eqs = 
let
  fun aux eq = 
  let
    val (lhs, rhs) = eq
      |> HOLogic.dest_Trueprop
      |> HOLogic.dest_eq
    val (bn_fun, [cnstr]) = strip_comb lhs
    val (_, ty) = dest_Const bn_fun
    val (ty_name, _) = dest_Type (domain_type ty)
    val dt_index = find_index (fn x => x = ty_name) dt_names
    val (cnstr_head, cnstr_args) = strip_comb cnstr    
    val rhs_elements = strip_bn_fun lthy cnstr_args rhs
  in
    (dt_index, (bn_fun, (cnstr_head, rhs_elements)))
  end
  fun order dts i ts = 
  let
    val dt = nth dts i
    val cts = map (fn (x, _, _) => Binding.name_of x) ((fn (_, _, _, x) => x) dt)
    val ts' = map (fn (x, y) => (fst (dest_Const x), y)) ts
  in
    map (find ts') cts
  end

  val unordered = AList.group (op=) (map aux eqs)
  val unordered' = map (fn (x, y) =>  (x, AList.group (op=) y)) unordered
  val ordered = map (fn (x, y) => (x, map (fn (v, z) => (v, order dts x z)) y)) unordered' 
  val ordered' = flat (map (fn (ith, l) => map (fn (bn, data) => (bn, ith, data)) l) ordered)

  (*val _ = tracing ("eqs\n" ^ cat_lines (map (Syntax.string_of_term lthy) eqs))*)
  (*val _ = tracing ("map eqs\n" ^ @{make_string} (map aux2 eqs))*)
  (*val _ = tracing ("ordered'\n" ^ @{make_string} ordered')*)
in
  ordered'
end


fun define_raw_bns dt_names dts raw_bn_funs raw_bn_eqs constr_thms size_thms lthy =
  if null raw_bn_funs 
  then ([], [], [], [], lthy)
  else 
    let
      val (_, lthy1) = Function.add_function raw_bn_funs raw_bn_eqs
        Function_Common.default_config (pat_completeness_simp constr_thms) lthy

      val (info, lthy2) = prove_termination size_thms (Local_Theory.restore lthy1)
      val {fs, simps, inducts, ...} = info

      val raw_bn_induct = (the inducts)
      val raw_bn_eqs = the simps

      val raw_bn_info = 
        prep_bn_info lthy dt_names dts (map prop_of raw_bn_eqs)
    in
      (fs, raw_bn_eqs, raw_bn_info, raw_bn_induct, lthy2)
    end
*}

ML {*
fun define_raw_dts dts bn_funs bn_eqs binds lthy =
let
  val thy = Local_Theory.exit_global lthy
  val thy_name = Context.theory_name thy

  val dt_names = map (fn (_, s, _, _) => Binding.name_of s) dts
  val dt_full_names = map (Long_Name.qualify thy_name) dt_names 
  val dt_full_names' = add_raws dt_full_names
  val dts_env = dt_full_names ~~ dt_full_names'

  val cnstrs = get_cnstr_strs dts
  val cnstrs_ty = get_typed_cnstrs dts
  val cnstrs_full_names = map (Long_Name.qualify thy_name) cnstrs
  val cnstrs_full_names' = map (fn (x, y) => Long_Name.qualify thy_name 
    (Long_Name.qualify (add_raw x) (add_raw y))) cnstrs_ty
  val cnstrs_env = cnstrs_full_names ~~ cnstrs_full_names'

  val bn_fun_strs = get_bn_fun_strs bn_funs
  val bn_fun_strs' = add_raws bn_fun_strs
  val bn_fun_env = bn_fun_strs ~~ bn_fun_strs'
  val bn_fun_full_env = map (pairself (Long_Name.qualify thy_name)) 
    (bn_fun_strs ~~ bn_fun_strs')
  
  val (raw_dt_names, raw_dts) = rawify_dts dt_names dts dts_env
  val (raw_bn_funs, raw_bn_eqs) = rawify_bn_funs dts_env cnstrs_env bn_fun_env bn_funs bn_eqs 
  val raw_bclauses = rawify_bclauses dts_env cnstrs_env bn_fun_full_env binds 

  val (raw_dt_full_names, thy1) = 
    Datatype.add_datatype Datatype.default_config raw_dt_names raw_dts thy

  val lthy1 = Named_Target.theory_init thy1
in
  (raw_dt_full_names, raw_dts, raw_bclauses, raw_bn_funs, raw_bn_eqs, lthy1)
end
*}


ML {*
(* for testing porposes - to exit the procedure early *)
exception TEST of Proof.context

val (STEPS, STEPS_setup) = Attrib.config_int "STEPS" (K 100);

fun get_STEPS ctxt = Config.get ctxt STEPS
*}

setup STEPS_setup

ML {*
fun nominal_datatype2 opt_thms_name dts bn_funs bn_eqs bclauses lthy =
let
  (* definition of the raw datatypes *)
  val _ = warning "Definition of raw datatypes";
  val (raw_dt_names, raw_dts, raw_bclauses, raw_bn_funs, raw_bn_eqs, lthy0) =
    if get_STEPS lthy > 0 
    then define_raw_dts dts bn_funs bn_eqs bclauses lthy
    else raise TEST lthy

  val dtinfo = Datatype.the_info (ProofContext.theory_of lthy0) (hd raw_dt_names)
  val {descr, sorts, ...} = dtinfo

  val raw_tys = all_dtyps descr sorts
  val raw_full_ty_names = map (fst o dest_Type) raw_tys
  val tvs = hd raw_tys
    |> snd o dest_Type
    |> map dest_TFree  

  val dtinfos = map (Datatype.the_info (ProofContext.theory_of lthy0)) raw_full_ty_names  
 
  val raw_cns_info = all_dtyp_constrs_types descr sorts
  val raw_constrs = flat (map (map (fn (c, _, _, _) => c)) raw_cns_info)

  val raw_inject_thms = flat (map #inject dtinfos)
  val raw_distinct_thms = flat (map #distinct dtinfos)
  val raw_induct_thm = #induct dtinfo
  val raw_induct_thms = #inducts dtinfo
  val raw_exhaust_thms = map #exhaust dtinfos
  val raw_size_trms = map size_const raw_tys
  val raw_size_thms = Size.size_thms (ProofContext.theory_of lthy0) (hd raw_dt_names)
    |> `(fn thms => (length thms) div 2)
    |> uncurry drop
  
  (* definitions of raw permutations by primitive recursion *)
  val _ = warning "Definition of raw permutations";
  val ((raw_perm_funs, raw_perm_simps, raw_perm_laws), lthy2a) =
    if get_STEPS lthy0 > 1 
    then define_raw_perms raw_full_ty_names raw_tys tvs raw_constrs raw_induct_thm lthy0
    else raise TEST lthy0
 
  (* noting the raw permutations as eqvt theorems *)
  val (_, lthy3) = Local_Theory.note ((Binding.empty, [eqvt_attr]), raw_perm_simps) lthy2a

  (* definition of raw fv_functions *)
  val _ = warning "Definition of raw fv-functions";
  val (raw_bns, raw_bn_defs, raw_bn_info, raw_bn_induct, lthy3a) =
    if get_STEPS lthy3 > 2 
    then define_raw_bns raw_full_ty_names raw_dts raw_bn_funs raw_bn_eqs 
      (raw_inject_thms @ raw_distinct_thms) raw_size_thms lthy3
    else raise TEST lthy3

  val (raw_fvs, raw_fv_bns, raw_fv_defs, raw_fv_bns_induct, lthy3b) = 
    if get_STEPS lthy3a > 3 
    then define_raw_fvs raw_full_ty_names raw_tys raw_cns_info raw_bn_info raw_bclauses 
      (raw_inject_thms @ raw_distinct_thms) raw_size_thms lthy3a
    else raise TEST lthy3a

  (* definition of raw alphas *)
  val _ = warning "Definition of alphas";
  val (alpha_trms, alpha_bn_trms, alpha_intros, alpha_cases, alpha_induct, lthy4) =
    if get_STEPS lthy3b > 4 
    then define_raw_alpha raw_full_ty_names raw_tys raw_cns_info raw_bn_info raw_bclauses raw_fvs lthy3b
    else raise TEST lthy3b
  val alpha_tys = map (domain_type o fastype_of) alpha_trms  

  (* definition of alpha-distinct lemmas *)
  val _ = warning "Distinct theorems";
  val alpha_distincts = 
    mk_alpha_distincts lthy4 alpha_cases raw_distinct_thms alpha_trms raw_tys

  (* definition of alpha_eq_iff  lemmas *)
  (* they have a funny shape for the simplifier ---- CHECK WHETHER NEEDED*)
  val _ = warning "Eq-iff theorems";
  val (alpha_eq_iff_simps, alpha_eq_iff) = 
    if get_STEPS lthy > 5
    then mk_alpha_eq_iff lthy4 alpha_intros raw_distinct_thms raw_inject_thms alpha_cases
    else raise TEST lthy4

  (* proving equivariance lemmas for bns, fvs, size and alpha *)
  val _ = warning "Proving equivariance";
  val raw_bn_eqvt = 
    if get_STEPS lthy > 6
    then raw_prove_eqvt raw_bns raw_bn_induct (raw_bn_defs @ raw_perm_simps) lthy4
    else raise TEST lthy4

  (* noting the raw_bn_eqvt lemmas in a temprorary theory *)
  val lthy_tmp = snd (Local_Theory.note ((Binding.empty, [eqvt_attr]), raw_bn_eqvt) lthy4)

  val raw_fv_eqvt = 
    if get_STEPS lthy > 7
    then raw_prove_eqvt (raw_fvs @ raw_fv_bns) raw_fv_bns_induct (raw_fv_defs @ raw_perm_simps) 
      (Local_Theory.restore lthy_tmp)
    else raise TEST lthy4

  val raw_size_eqvt = 
    if get_STEPS lthy > 8
    then raw_prove_eqvt raw_size_trms raw_induct_thms (raw_size_thms @ raw_perm_simps) 
      (Local_Theory.restore lthy_tmp)
      |> map (rewrite_rule @{thms permute_nat_def[THEN eq_reflection]})
      |> map (fn thm => thm RS @{thm sym})
    else raise TEST lthy4
 
  val lthy5 = snd (Local_Theory.note ((Binding.empty, [eqvt_attr]), raw_fv_eqvt) lthy_tmp)

  val (alpha_eqvt, lthy6) =
    if get_STEPS lthy > 9
    then Nominal_Eqvt.equivariance true (alpha_trms @ alpha_bn_trms) alpha_induct alpha_intros lthy5
    else raise TEST lthy4

  (* proving alpha equivalence *)
  val _ = warning "Proving equivalence"

  val alpha_refl_thms = 
    if get_STEPS lthy > 10
    then raw_prove_refl alpha_trms alpha_bn_trms alpha_intros raw_induct_thm lthy6 
    else raise TEST lthy6

  val alpha_sym_thms = 
    if get_STEPS lthy > 11
    then raw_prove_sym (alpha_trms @ alpha_bn_trms) alpha_intros alpha_induct lthy6 
    else raise TEST lthy6

  val alpha_trans_thms = 
    if get_STEPS lthy > 12
    then raw_prove_trans (alpha_trms @ alpha_bn_trms) (raw_distinct_thms @ raw_inject_thms) 
           alpha_intros alpha_induct alpha_cases lthy6
    else raise TEST lthy6

  val (alpha_equivp_thms, alpha_bn_equivp_thms) = 
    if get_STEPS lthy > 13
    then raw_prove_equivp alpha_trms alpha_bn_trms alpha_refl_thms alpha_sym_thms 
       alpha_trans_thms lthy6
    else raise TEST lthy6

  (* proving alpha implies alpha_bn *)
  val _ = warning "Proving alpha implies bn"

  val alpha_bn_imp_thms = 
    if get_STEPS lthy > 14
    then raw_prove_bn_imp alpha_trms alpha_bn_trms alpha_intros alpha_induct lthy6 
    else raise TEST lthy6
  
  (* respectfulness proofs *)
  val raw_funs_rsp_aux = 
    if get_STEPS lthy > 15
    then raw_fv_bn_rsp_aux alpha_trms alpha_bn_trms raw_fvs 
      raw_bns raw_fv_bns alpha_induct (raw_bn_defs @ raw_fv_defs) lthy6
    else raise TEST lthy6 
  
  val raw_funs_rsp = 
    if get_STEPS lthy > 16
    then map mk_funs_rsp raw_funs_rsp_aux
    else raise TEST lthy6 

  val raw_size_rsp = 
    if get_STEPS lthy > 17
    then
      raw_size_rsp_aux (alpha_trms @ alpha_bn_trms) alpha_induct 
      (raw_size_thms @ raw_size_eqvt) lthy6
      |> map mk_funs_rsp
    else raise TEST lthy6 

  val raw_constrs_rsp = 
    if get_STEPS lthy > 18
    then raw_constrs_rsp raw_constrs alpha_trms alpha_intros
      (alpha_bn_imp_thms @ raw_funs_rsp_aux) lthy6 
    else raise TEST lthy6 

  val alpha_permute_rsp = 
    if get_STEPS lthy > 19
    then map mk_alpha_permute_rsp alpha_eqvt
    else raise TEST lthy6 

  val alpha_bn_rsp = 
    if get_STEPS lthy > 20
    then raw_alpha_bn_rsp alpha_bn_trms alpha_bn_equivp_thms alpha_bn_imp_thms
    else raise TEST lthy6 

  (* noting the quot_respects lemmas *)
  val (_, lthy6a) = 
    if get_STEPS lthy > 21
    then Local_Theory.note ((Binding.empty, [rsp_attr]),
      raw_constrs_rsp @ raw_funs_rsp @ raw_size_rsp @ alpha_permute_rsp @ alpha_bn_rsp) lthy6
    else raise TEST lthy6

  (* defining the quotient type *)
  val _ = warning "Declaring the quotient types"
  val qty_descr = map (fn (vs, bind, mx, _) => (vs, bind, mx)) dts
     
  val (qty_infos, lthy7) = 
    if get_STEPS lthy > 22
    then define_qtypes qty_descr alpha_tys alpha_trms alpha_equivp_thms lthy6a
    else raise TEST lthy6a

  val qtys = map #qtyp qty_infos
  val qty_full_names = map (fst o dest_Type) qtys
  val qty_names = map Long_Name.base_name qty_full_names             

  (* defining of quotient term-constructors, binding functions, free vars functions *)
  val _ = warning "Defining the quotient constants"
  val qconstrs_descr = 
    flat (map (fn (_, _, _, cs) => map (fn (b, _, mx) => (Name.of_binding b, mx)) cs) dts)
    |> map2 (fn t => fn (b, mx) => (b, t, mx)) raw_constrs

  val qbns_descr =
    map2 (fn (b, _, mx) => fn t => (Name.of_binding b, t, mx)) bn_funs raw_bns

  val qfvs_descr = 
    map2 (fn n => fn t => ("fv_" ^ n, t, NoSyn)) qty_names raw_fvs

  val qfv_bns_descr = 
    map2 (fn (b, _, _) => fn t => ("fv_" ^ Name.of_binding b, t, NoSyn)) bn_funs raw_fv_bns

  val qalpha_bns_descr = 
    map2 (fn (b, _, _) => fn t => ("alpha_" ^ Name.of_binding b, t, NoSyn)) bn_funs  alpha_bn_trms

  val qperm_descr =
    map2 (fn n => fn t => ("permute_" ^ n, Type.legacy_freeze t, NoSyn)) qty_names raw_perm_funs

  val qsize_descr =
    map2 (fn n => fn t => ("size_" ^ n, t, NoSyn)) qty_names raw_size_trms

  val (((((qconstrs_info, qbns_info), qfvs_info), qfv_bns_info), qalpha_bns_info), lthy8) = 
    if get_STEPS lthy > 23
    then 
      lthy7
      |> define_qconsts qtys qconstrs_descr 
      ||>> define_qconsts qtys qbns_descr 
      ||>> define_qconsts qtys qfvs_descr
      ||>> define_qconsts qtys qfv_bns_descr
      ||>> define_qconsts qtys qalpha_bns_descr
    else raise TEST lthy7

  (* definition of the quotient permfunctions and pt-class *)
  val lthy9 = 
    if get_STEPS lthy > 24
    then define_qperms qtys qty_full_names tvs qperm_descr raw_perm_laws lthy8 
    else raise TEST lthy8
  
  val lthy9a = 
    if get_STEPS lthy > 25
    then define_qsizes qtys qty_full_names tvs qsize_descr lthy9
    else raise TEST lthy9

  val qtrms = map #qconst qconstrs_info
  val qbns = map #qconst qbns_info
  val qfvs = map #qconst qfvs_info
  val qfv_bns = map #qconst qfv_bns_info
  val qalpha_bns = map #qconst qalpha_bns_info

  (* lifting of the theorems *)
  val _ = warning "Lifting of Theorems"
  
  val eq_iff_simps = @{thms alphas permute_prod.simps prod_fv.simps prod_alpha_def prod_rel.simps
    prod.cases} 

  val ((((((qdistincts, qeq_iffs), qfv_defs), qbn_defs), qperm_simps), qfv_qbn_eqvts), lthyA) = 
    if get_STEPS lthy > 26
    then 
      lthy9a    
      |> lift_thms qtys [] alpha_distincts  
      ||>> lift_thms qtys eq_iff_simps alpha_eq_iff       
      ||>> lift_thms qtys [] raw_fv_defs
      ||>> lift_thms qtys [] raw_bn_defs
      ||>> lift_thms qtys [] raw_perm_simps
      ||>> lift_thms qtys [] (raw_fv_eqvt @ raw_bn_eqvt)
    else raise TEST lthy9a

  val (((qsize_eqvt, [qinduct]), qexhausts), lthyB) = 
    if get_STEPS lthy > 27
    then
      lthyA 
      |> lift_thms qtys [] raw_size_eqvt
      ||>> lift_thms qtys [] [raw_induct_thm]
      ||>> lift_thms qtys [] raw_exhaust_thms
    else raise TEST lthyA

  (* supports lemmas *) 
  val qsupports_thms =
    if get_STEPS lthy > 28
    then prove_supports lthyB qperm_simps qtrms
    else raise TEST lthyB

  (* finite supp lemmas *)
  val qfsupp_thms =
    if get_STEPS lthy > 29
    then prove_fsupp lthyB qtys qinduct qsupports_thms
    else raise TEST lthyB

  (* fs instances *)
  val lthyC =
    if get_STEPS lthy > 30
    then fs_instance qtys qty_full_names tvs qfsupp_thms lthyB
    else raise TEST lthyB

  (* noting the theorems *)  

  (* generating the prefix for the theorem names *)
  val thms_name = 
    the_default (Binding.name (space_implode "_" qty_names)) opt_thms_name 
  fun thms_suffix s = Binding.qualified true s thms_name 

  val (_, lthy9') = lthyC
     |> Local_Theory.note ((thms_suffix "distinct", []), qdistincts) 
     ||>> Local_Theory.note ((thms_suffix "eq_iff", []), qeq_iffs)
     ||>> Local_Theory.note ((thms_suffix "fv_defs", []), qfv_defs) 
     ||>> Local_Theory.note ((thms_suffix "bn_defs", []), qbn_defs) 
     ||>> Local_Theory.note ((thms_suffix "perm_simps", [eqvt_attr, simp_attr]), qperm_simps) 
     ||>> Local_Theory.note ((thms_suffix "fv_bn_eqvt", []), qfv_qbn_eqvts) 
     ||>> Local_Theory.note ((thms_suffix "size_eqvt", []), qsize_eqvt)
     ||>> Local_Theory.note ((thms_suffix "induct", []), [qinduct]) 
     ||>> Local_Theory.note ((thms_suffix "exhaust", []), qexhausts)
     ||>> Local_Theory.note ((thms_suffix "supports", []), qsupports_thms)
     ||>> Local_Theory.note ((thms_suffix "fsupp", []), qfsupp_thms)
in
  (0, lthy9')
end handle TEST ctxt => (0, ctxt)
*}

section {* Preparing and parsing of the specification *}

ML {* 
(* generates the parsed datatypes and 
   declares the constructors 
*)
fun prepare_dts dt_strs thy = 
let
  fun inter_fs_sort thy (a, S) = 
    (a, Type.inter_sort (Sign.tsig_of thy) (@{sort fs}, S)) 

  fun mk_type tname sorts (cname, cargs, mx) =
  let
    val full_tname = Sign.full_name thy tname
    val ty = Type (full_tname, map (TFree o inter_fs_sort thy) sorts)
  in
    (cname, cargs ---> ty, mx)
  end

  fun prep_constr (cname, cargs, mx, _) (constrs, sorts) =
  let 
    val (cargs', sorts') = 
      fold_map (Datatype.read_typ thy) (map snd cargs) sorts
      |>> map (map_type_tfree (TFree o inter_fs_sort thy)) 
  in 
    (constrs @ [(cname, cargs', mx)], sorts') 
  end
  
  fun prep_dts (tvs, tname, mx, constrs) (constr_trms, dts, sorts) =
  let 
    val (constrs', sorts') = 
      fold prep_constr constrs ([], sorts)

    val constr_trms' = 
      map (mk_type tname (rev sorts')) constrs'
  in 
    (constr_trms @ constr_trms', dts @ [(tvs, tname, mx, constrs')], sorts') 
  end

  val (constr_trms, dts, sorts) = fold prep_dts dt_strs ([], [], []);
in
  thy
  |> Sign.add_consts_i constr_trms
  |> pair dts
end
*}

ML {*
(* parsing the binding function specification and *)
(* declaring the functions in the local theory    *)
fun prepare_bn_funs bn_fun_strs bn_eq_strs thy =
let
  val lthy = Named_Target.theory_init thy

  val ((bn_funs, bn_eqs), lthy') = 
    Specification.read_spec bn_fun_strs bn_eq_strs lthy

  fun prep_bn_fun ((bn, T), mx) = (bn, T, mx) 
  
  val bn_funs' = map prep_bn_fun bn_funs
in
  (Local_Theory.exit_global lthy')
  |> Sign.add_consts_i bn_funs'
  |> pair (bn_funs', bn_eqs) 
end 
*}

text {* associates every SOME with the index in the list; drops NONEs *}
ML {*
fun indexify xs =
let
  fun mapp _ [] = []
    | mapp i (NONE :: xs) = mapp (i + 1) xs
    | mapp i (SOME x :: xs) = (x, i) :: mapp (i + 1) xs
in 
  mapp 0 xs 
end

fun index_lookup xs x =
  case AList.lookup (op=) xs x of
    SOME x => x
  | NONE => error ("Cannot find " ^ x ^ " as argument annotation.");
*}

ML {*
fun prepare_bclauses dt_strs thy = 
let
  val annos_bclauses =
    get_cnstrs dt_strs
    |> map (map (fn (_, antys, _, bns) => (map fst antys, bns)))

  fun prep_binder env bn_str =
    case (Syntax.read_term_global thy bn_str) of
      Free (x, _) => (NONE, index_lookup env x)
    | Const (a, T) $ Free (x, _) => (SOME (Const (a, T)), index_lookup env x)
    | _ => error ("The term " ^ bn_str ^ " is not allowed as binding function.")
 
  fun prep_body env bn_str = index_lookup env bn_str

  fun prep_bclause env (mode, binders, bodies) = 
  let
    val binders' = map (prep_binder env) binders
    val bodies' = map (prep_body env) bodies
  in  
    BC (mode, binders', bodies')
  end

  fun prep_bclauses (annos, bclause_strs) = 
  let
    val env = indexify annos (* for every label, associate the index *)
  in
    map (prep_bclause env) bclause_strs
  end
in
  (map (map prep_bclauses) annos_bclauses, thy)
end
*}

text {* 
  adds an empty binding clause for every argument
  that is not already part of a binding clause
*}

ML {*
fun included i bcs = 
let
  fun incl (BC (_, bns, bds)) = 
    member (op =) (map snd bns) i orelse member (op =) bds i
in
  exists incl bcs 
end
*}

ML {* 
fun complete dt_strs bclauses = 
let
  val args = 
    get_cnstrs dt_strs
    |> map (map (fn (_, antys, _, _) => length antys))

  fun complt n bcs = 
  let
    fun add bcs i = (if included i bcs then [] else [BC (Lst, [], [i])]) 
  in
    bcs @ (flat (map_range (add bcs) n))
  end
in
  map2 (map2 complt) args bclauses
end
*}

ML {*
fun nominal_datatype2_cmd (opt_thms_name, dt_strs, bn_fun_strs, bn_eq_strs) lthy = 
let
  val pre_typs = 
    map (fn (tvs, tname, mx, _) => (tname, length tvs, mx)) dt_strs

  (* this theory is used just for parsing *)
  val thy = ProofContext.theory_of lthy  
  val tmp_thy = Theory.copy thy 

  val (((dts, (bn_funs, bn_eqs)), bclauses), tmp_thy') = 
    tmp_thy
    |> Sign.add_types pre_typs
    |> prepare_dts dt_strs 
    ||>> prepare_bn_funs bn_fun_strs bn_eq_strs 
    ||>> prepare_bclauses dt_strs 

  val bclauses' = complete dt_strs bclauses
in
  timeit (fn () => nominal_datatype2 opt_thms_name dts bn_funs bn_eqs bclauses' lthy |> snd)
end
*}

ML {* 
(* nominal datatype parser *)
local
  structure P = Parse;
  structure S = Scan

  fun triple ((x, y), z) = (x, y, z)
  fun tuple1 ((x, y, z), u) = (x, y, z, u)
  fun tuple2 (((x, y), z), u) = (x, y, u, z)
  fun tuple3 ((x, y), (z, u)) = (x, y, z, u)
in

val _ = Keyword.keyword "bind"

val opt_name = Scan.option (P.binding --| Args.colon)

val anno_typ = S.option (P.name --| P.$$$ "::") -- P.typ

val bind_mode = P.$$$ "bind" |--
  S.optional (Args.parens 
    (Args.$$$ "list" >> K Lst || Args.$$$ "set" >> K Set || Args.$$$ "res" >> K Res)) Lst

val bind_clauses = 
  P.enum "," (bind_mode -- S.repeat1 P.term -- (P.$$$ "in" |-- S.repeat1 P.name) >> triple)

val cnstr_parser =
  P.binding -- S.repeat anno_typ -- bind_clauses -- P.opt_mixfix >> tuple2

(* datatype parser *)
val dt_parser =
  (P.type_args -- P.binding -- P.opt_mixfix >> triple) -- 
    (P.$$$ "=" |-- P.enum1 "|" cnstr_parser) >> tuple1

(* binding function parser *)
val bnfun_parser = 
  S.optional (P.$$$ "binder" |-- P.fixes -- Parse_Spec.where_alt_specs) ([], [])

(* main parser *)
val main_parser =
  opt_name -- P.and_list1 dt_parser -- bnfun_parser >> tuple3

end

(* Command Keyword *)
val _ = Outer_Syntax.local_theory "nominal_datatype" "test" Keyword.thy_decl
  (main_parser >> nominal_datatype2_cmd)
*}


end



