theory SingleLet
imports "../Nominal2"
begin

atom_decl name

declare [[STEPS = 100]]

nominal_datatype single_let: trm  =
  Var "name"
| App "trm" "trm"
| Lam x::"name" t::"trm"  bind x in t
| Let a::"assg" t::"trm"  bind "bn a" in t
| Foo x::"name" y::"name" t::"trm" t1::"trm" t2::"trm" bind (set) x in y t t1 t2
| Bar x::"name" y::"name" t::"trm" bind y x in t x y
| Baz x::"name" t1::"trm" t2::"trm" bind x in t1, bind x in t2 
and assg =
  As "name" x::"name" t::"trm" bind x in t
binder
  bn::"assg \<Rightarrow> atom list"
where
  "bn (As x y t) = [atom x]"


thm single_let.distinct
thm single_let.induct
thm single_let.exhaust
thm single_let.fv_defs
thm single_let.bn_defs
thm single_let.perm_simps
thm single_let.eq_iff
thm single_let.fv_bn_eqvt
thm single_let.size_eqvt
thm single_let.supports
thm single_let.fsupp

lemma test2:
  assumes "fv_trm t = supp t" 
  shows "\<forall>p. fv_trm (p \<bullet> t) = supp (p \<bullet> t)"
apply(rule allI)
apply(rule_tac p="-p" in permute_boolE)
apply(perm_simp add: single_let.fv_bn_eqvt permute_minus_cancel)
apply(rule assms)
done


lemma supp_fv:
  "fv_trm t = supp t \<and> fv_assg as = supp as \<and> fv_bn as = {a. infinite {b. \<not>alpha_bn ((a \<rightleftharpoons> b) \<bullet> as) as}}"
apply(rule single_let.induct)
apply(simp_all (no_asm_use) only: single_let.fv_defs)[2]
apply(simp_all (no_asm_use) only: supp_def)[2]
apply(simp_all (no_asm_use) only: single_let.perm_simps)[2]
apply(simp_all (no_asm_use) only: single_let.eq_iff)[2]
apply(simp_all (no_asm_use) only: de_Morgan_conj)[2]
apply(simp_all (no_asm_use) only: Collect_disj_eq)[2]
apply(simp_all (no_asm_use) only: finite_Un)[2]
apply(simp_all (no_asm_use) only: de_Morgan_conj)[2]
apply(simp_all (no_asm_use) only: Collect_disj_eq)[2]
apply(simp)
--" 1 "
apply(simp only: single_let.fv_defs supp_Pair[symmetric])
apply(simp only: supp_abs(3)[symmetric])
apply(simp (no_asm) only: supp_def)
apply(perm_simp add: single_let.perm_simps single_let.fv_bn_eqvt)
apply(simp (no_asm) only: single_let.eq_iff Abs_eq_iff)
apply(simp only: alphas prod_alpha_def prod_fv.simps prod_rel.simps permute_prod_def prod.recs prod.cases prod.inject)
apply(drule test2)
apply(simp only:)
-- " 2 "
apply(erule conjE)+
apply(simp only: single_let.fv_defs supp_Pair[symmetric])
apply(simp only: supp_abs(3)[symmetric])
apply(simp (no_asm) only: supp_def)
apply(perm_simp add: single_let.perm_simps single_let.fv_bn_eqvt)
apply(simp (no_asm) only: single_let.eq_iff Abs_eq_iff)
apply(simp only: de_Morgan_conj Collect_disj_eq finite_Un)
apply(simp only: alphas prod_alpha_def prod_fv.simps prod_rel.simps permute_prod_def prod.recs prod.cases prod.inject)
apply(drule test2)
apply(simp only:)
-- " 3 "
apply(simp only: single_let.fv_defs supp_Pair[symmetric])
apply(simp only: supp_abs(1)[symmetric])
apply(simp (no_asm) only: supp_def)
apply(perm_simp add: single_let.perm_simps single_let.fv_bn_eqvt)
apply(simp (no_asm) only: single_let.eq_iff Abs_eq_iff)
apply(simp only: alphas prod_alpha_def prod_fv.simps prod_rel.simps permute_prod_def prod.recs prod.cases prod.inject)
apply(drule test2)+
apply(simp only: supp_Pair Un_assoc conj_assoc)
-- " Bar "
apply(simp only: single_let.fv_defs supp_Pair[symmetric])
apply(simp only: supp_abs(3)[symmetric])
apply(simp (no_asm) only: supp_def)
apply(perm_simp add: single_let.perm_simps single_let.fv_bn_eqvt)
apply(simp (no_asm) only: single_let.eq_iff Abs_eq_iff)
apply(simp only: alphas prod_alpha_def prod_fv.simps prod_rel.simps permute_prod_def prod.recs prod.cases prod.inject)
apply(drule test2)+
apply(simp only: supp_Pair Un_assoc conj_assoc)
-- " Baz "
apply(simp only: single_let.fv_defs supp_Pair[symmetric])
apply(simp only: supp_abs(3)[symmetric])
apply(simp (no_asm) only: supp_def)
apply(perm_simp add: single_let.perm_simps single_let.fv_bn_eqvt)
apply(simp (no_asm) only: single_let.eq_iff Abs_eq_iff)
apply(simp only: alphas prod_alpha_def prod_fv.simps prod_rel.simps permute_prod_def prod.recs prod.cases prod.inject)
apply(simp only: de_Morgan_conj Collect_disj_eq finite_Un)
apply(drule test2)+
apply(simp only: supp_Pair Un_assoc conj_assoc)
-- "last"
apply(rule conjI)
apply(simp only: single_let.fv_defs supp_Pair[symmetric])
apply(simp only: supp_abs(3)[symmetric])
apply(simp (no_asm) only: supp_def)
apply(perm_simp add: single_let.perm_simps single_let.fv_bn_eqvt)
apply(simp (no_asm) only: single_let.eq_iff Abs_eq_iff)
apply(simp only: alphas prod_alpha_def prod_fv.simps prod_rel.simps permute_prod_def prod.recs prod.cases prod.inject)
apply(simp only: de_Morgan_conj Collect_disj_eq finite_Un)
apply(drule test2)+
apply(simp only: supp_Pair Un_assoc conj_assoc)
-- "other case"
apply(simp only: single_let.fv_defs supp_Pair[symmetric])
apply(simp only: supp_abs(3)[symmetric])
apply(simp (no_asm) only: supp_def)
apply(perm_simp add: single_let.perm_simps single_let.fv_bn_eqvt)
apply(simp (no_asm) only: single_let.eq_iff Abs_eq_iff)
apply(simp only: alphas prod_alpha_def prod_fv.simps prod_rel.simps permute_prod_def prod.recs prod.cases prod.inject)
apply(simp only: de_Morgan_conj Collect_disj_eq finite_Un)?
apply(drule test2)+
apply(simp only: supp_Pair Un_assoc conj_assoc)
done





text {* *}

(*
consts perm_bn_trm :: "perm \<Rightarrow> trm \<Rightarrow> trm"
consts perm_bn_assg :: "perm \<Rightarrow> assg \<Rightarrow> assg"

lemma y:
  "perm_bn_trm p (Var x) = (Var x)"
  "perm_bn_trm p (App t1 t2) = (App t1 t2)"
  "perm_bn_trm p ("



typ trm
typ assg

thm trm_assg.fv
thm trm_assg.supp
thm trm_assg.eq_iff
thm trm_assg.bn
thm trm_assg.perm
thm trm_assg.induct
thm trm_assg.inducts
thm trm_assg.distinct
ML {* Sign.of_sort @{theory} (@{typ trm}, @{sort fs}) *}
*)



end



