theory LamEx
imports Nominal "../QuotMain" "../QuotList"
begin

atom_decl name

datatype rlam =
  rVar "name"
| rApp "rlam" "rlam"
| rLam "name" "rlam"

fun
  rfv :: "rlam \<Rightarrow> name set"
where
  rfv_var: "rfv (rVar a) = {a}"
| rfv_app: "rfv (rApp t1 t2) = (rfv t1) \<union> (rfv t2)"
| rfv_lam: "rfv (rLam a t) = (rfv t) - {a}"

overloading
  perm_rlam \<equiv> "perm :: 'x prm \<Rightarrow> rlam \<Rightarrow> rlam"   (unchecked)
begin

fun
  perm_rlam
where
  "perm_rlam pi (rVar a) = rVar (pi \<bullet> a)"
| "perm_rlam pi (rApp t1 t2) = rApp (perm_rlam pi t1) (perm_rlam pi t2)"
| "perm_rlam pi (rLam a t) = rLam (pi \<bullet> a) (perm_rlam pi t)"

end

inductive
  alpha :: "rlam \<Rightarrow> rlam \<Rightarrow> bool" ("_ \<approx> _" [100, 100] 100)
where
  a1: "a = b \<Longrightarrow> (rVar a) \<approx> (rVar b)"
| a2: "\<lbrakk>t1 \<approx> t2; s1 \<approx> s2\<rbrakk> \<Longrightarrow> rApp t1 s1 \<approx> rApp t2 s2"
| a3: "\<lbrakk>t \<approx> ([(a,b)] \<bullet> s); a \<notin> rfv (rLam b t)\<rbrakk> \<Longrightarrow> rLam a t \<approx> rLam b s"

lemma helper:
  fixes t::"rlam"
  and   a::"name"
  shows "[(a, a)] \<bullet> t = t"
by (induct t)
   (auto simp add: calc_atm)

lemma alpha_refl:
  fixes t::"rlam"
  shows "t \<approx> t"
  apply(induct t rule: rlam.induct)
  apply(simp add: a1)
  apply(simp add: a2)
  apply(rule a3)
  apply(simp add: helper)
  apply(simp)
  done

lemma alpha_equivp:
  shows "equivp alpha"
sorry

quotient_type lam = rlam / alpha
  by (rule alpha_equivp)


quotient_definition
  "Var :: name \<Rightarrow> lam"
as
  "rVar"

quotient_definition
   "App :: lam \<Rightarrow> lam \<Rightarrow> lam"
as
  "rApp"

quotient_definition
  "Lam :: name \<Rightarrow> lam \<Rightarrow> lam"
as
  "rLam"

quotient_definition
  "fv :: lam \<Rightarrow> name set"
as
  "rfv"

thm Var_def
thm App_def
thm Lam_def
thm fv_def

(* definition of overloaded permutation function *)
(* for the lifted type lam                       *)
overloading
  perm_lam \<equiv> "perm :: 'x prm \<Rightarrow> lam \<Rightarrow> lam"   (unchecked)
begin

quotient_definition
   "perm_lam :: 'x prm \<Rightarrow> lam \<Rightarrow> lam"
as
  "perm::'x prm \<Rightarrow> rlam \<Rightarrow> rlam"

end

thm perm_lam_def

(* lemmas that need to be lifted *)
lemma pi_var_eqvt1:
  fixes pi::"'x prm"
  shows "(pi \<bullet> rVar a) \<approx> rVar (pi \<bullet> a)"
  by (simp add: alpha_refl)

lemma pi_var_eqvt2:
  fixes pi::"'x prm"
  shows "(pi \<bullet> rVar a) = rVar (pi \<bullet> a)"
  by (simp)

lemma pi_app_eqvt1:
  fixes pi::"'x prm"
  shows "(pi \<bullet> rApp t1 t2) \<approx> rApp (pi \<bullet> t1) (pi \<bullet> t2)"
  by (simp add: alpha_refl)

lemma pi_app_eqvt2:
  fixes pi::"'x prm"
  shows "(pi \<bullet> rApp t1 t2) = rApp (pi \<bullet> t1) (pi \<bullet> t2)"
  by (simp)

lemma pi_lam_eqvt1:
  fixes pi::"'x prm"
  shows "(pi \<bullet> rLam a t) \<approx> rLam (pi \<bullet> a) (pi \<bullet> t)"
  by (simp add: alpha_refl)

lemma pi_lam_eqvt2:
  fixes pi::"'x prm"
  shows "(pi \<bullet> rLam a t) = rLam (pi \<bullet> a) (pi \<bullet> t)"
  by (simp add: alpha)


lemma real_alpha:
  assumes a: "t = [(a,b)]\<bullet>s" "a\<sharp>[b].s"
  shows "Lam a t = Lam b s"
using a
unfolding fresh_def supp_def
sorry

lemma perm_rsp[quot_respect]:
  "(op = ===> alpha ===> alpha) op \<bullet> op \<bullet>"
  apply(auto)
  (* this is propably true if some type conditions are imposed ;o) *)
  sorry

lemma fresh_rsp:
  "(op = ===> alpha ===> op =) fresh fresh"
  apply(auto)
  (* this is probably only true if some type conditions are imposed *)
  sorry

lemma rVar_rsp[quot_respect]:
  "(op = ===> alpha) rVar rVar"
  by (auto intro: a1)

lemma rApp_rsp[quot_respect]: "(alpha ===> alpha ===> alpha) rApp rApp"
  by (auto intro: a2)

lemma rLam_rsp[quot_respect]: "(op = ===> alpha ===> alpha) rLam rLam"
  apply(auto)
  apply(rule a3)
  apply(simp add: helper)
  apply(simp)
  done

lemma rfv_rsp[quot_respect]: 
  "(alpha ===> op =) rfv rfv"
  sorry

lemma rvar_inject: "rVar a \<approx> rVar b = (a = b)"
  apply (auto)
  apply (erule alpha.cases)
  apply (simp_all add: rlam.inject alpha_refl)
  done

lemma pi_var1:
  fixes pi::"'x prm"
  shows "pi \<bullet> Var a = Var (pi \<bullet> a)"
  by (lifting pi_var_eqvt1)

lemma pi_var2:
  fixes pi::"'x prm"
  shows "pi \<bullet> Var a = Var (pi \<bullet> a)"
  by (lifting pi_var_eqvt2)


lemma pi_app: 
  fixes pi::"'x prm"
  shows "pi \<bullet> App t1 t2 = App (pi \<bullet> t1) (pi \<bullet> t2)"
  by (lifting pi_app_eqvt2)

lemma pi_lam: 
  fixes pi::"'x prm"
  shows "pi \<bullet> Lam a t = Lam (pi \<bullet> a) (pi \<bullet> t)"
  by (lifting pi_lam_eqvt2)

lemma fv_var: 
  shows "fv (Var a) = {a}"
  by  (lifting rfv_var)

lemma fv_app: 
  shows "fv (App t1 t2) = fv t1 \<union> fv t2"
  by (lifting rfv_app)

lemma fv_lam: 
  shows "fv (Lam a t) = fv t - {a}"
  by (lifting rfv_lam)

lemma a1: 
  "a = b \<Longrightarrow> Var a = Var b"
  by  (lifting a1)

lemma a2: 
  "\<lbrakk>x = xa; xb = xc\<rbrakk> \<Longrightarrow> App x xb = App xa xc"
  by  (lifting a2)

lemma a3: 
  "\<lbrakk>x = [(a, b)] \<bullet> xa; a \<notin> fv (Lam b x)\<rbrakk> \<Longrightarrow> Lam a x = Lam b xa"
  by  (lifting a3)

lemma alpha_cases: 
  "\<lbrakk>a1 = a2; \<And>a b. \<lbrakk>a1 = Var a; a2 = Var b; a = b\<rbrakk> \<Longrightarrow> P;
    \<And>x xa xb xc. \<lbrakk>a1 = App x xb; a2 = App xa xc; x = xa; xb = xc\<rbrakk> \<Longrightarrow> P;
    \<And>x a b xa. \<lbrakk>a1 = Lam a x; a2 = Lam b xa; x = [(a, b)] \<bullet> xa; a \<notin> fv (Lam b x)\<rbrakk> \<Longrightarrow> P\<rbrakk>
    \<Longrightarrow> P"
  by (lifting alpha.cases)

lemma alpha_induct: 
  "\<lbrakk>qx = qxa; \<And>a b. a = b \<Longrightarrow> qxb (Var a) (Var b);
    \<And>x xa xb xc. \<lbrakk>x = xa; qxb x xa; xb = xc; qxb xb xc\<rbrakk> \<Longrightarrow> qxb (App x xb) (App xa xc);
     \<And>x a b xa.
        \<lbrakk>x = [(a, b)] \<bullet> xa; qxb x ([(a, b)] \<bullet> xa); a \<notin> fv (Lam b x)\<rbrakk> \<Longrightarrow> qxb (Lam a x) (Lam b xa)\<rbrakk>
    \<Longrightarrow> qxb qx qxa"
  by (lifting alpha.induct)

lemma var_inject: 
  "(Var a = Var b) = (a = b)"
  by (lifting rvar_inject)

lemma lam_induct:
  "\<lbrakk>\<And>name. P (Var name);
    \<And>lam1 lam2. \<lbrakk>P lam1; P lam2\<rbrakk> \<Longrightarrow> P (App lam1 lam2);
    \<And>name lam. P lam \<Longrightarrow> P (Lam name lam)\<rbrakk> 
    \<Longrightarrow> P lam"
  by (lifting rlam.induct)

instance lam::pt_name
apply(default)
sorry

instance lam::fs_name
apply(default)
sorry

lemma lam_induct_strong:
  fixes a::"'a::fs_name"
  assumes a1: "\<And>name b. P b (Var name)"
  and     a2: "\<And>lam1 lam2 b. \<lbrakk>\<And>c. P c lam1; \<And>c. P c lam2\<rbrakk> \<Longrightarrow> P b (App lam1 lam2)"
  and     a3: "\<And>name lam b. \<lbrakk>\<And>c. P c lam; name \<sharp> lam\<rbrakk> \<Longrightarrow> P b (Lam name lam)"
  shows "P a lam"
proof -
  have "\<And>(pi::name prm) a. P a (pi \<bullet> lam)" 
  proof (induct lam rule: lam_induct)
    case (1 name pi)
    show "P a (pi \<bullet> Var name)"
      apply (simp only: pi_var1)
      apply (rule a1)
      done
  next
    case (2 lam1 lam2 pi)
    have b1: "\<And>(pi::name prm) a. P a (pi \<bullet> lam1)" by fact
    have b2: "\<And>(pi::name prm) a. P a (pi \<bullet> lam2)" by fact
    show "P a (pi \<bullet> App lam1 lam2)"
      apply (simp only: pi_app)
      apply (rule a2)
      apply (rule b1)
      apply (rule b2)
      done
  next
    case (3 name lam pi)
    have b: "P a (pi \<bullet> lam)" by fact
    show "P a (pi \<bullet> Lam name lam)" 
      apply (simp add: pi_lam)
      using b
      sorry
  qed
  then have "P a (([]::name prm) \<bullet> lam)" by blast
  then show "P a lam" by simp 
qed


lemma var_supp:
  shows "supp (Var a) = ((supp a)::name set)"
  apply(simp add: supp_def)
  apply(simp add: pi_var2)
  apply(simp add: var_inject)
  done

lemma var_fresh:
  fixes a::"name"
  shows "(a \<sharp> (Var b)) = (a \<sharp> b)"
  apply(simp add: fresh_def)
  apply(simp add: var_supp)
  done

end
