theory SingleLet
imports "../NewParser"
begin

atom_decl name

ML {* print_depth 50 *}
declare [[STEPS = 8]]


nominal_datatype trm =
  Var "name"
| App "trm" "trm"
| Lam x::"name" t::"trm"  bind_set x in t
| Let a::"assg" t::"trm"  bind_set "bn a" in t
| Foo x::"name" y::"name" t::"trm" bind_set x in y t
| Bar x::"name" y::"name" t::"trm" bind y x in t x y
and assg =
  As "name" "trm"
binder
  bn::"assg \<Rightarrow> atom set"
where
  "bn (As x t) = {atom x}"


thm permute_trm_raw_permute_assg_raw.simps[no_vars]
thm fv_trm_raw.simps[no_vars] fv_assg_raw.simps[no_vars] fv_bn_raw.simps[no_vars] bn_raw.simps[no_vars]
thm alpha_trm_raw_alpha_assg_raw_alpha_bn_raw.intros[no_vars]

ML {* val {inducts, ... } = Function.get_info @{context} @{term "fv_trm_raw"}*}
ML {* Rule_Cases.strict_mutual_rule @{context} (the inducts) *}

(*
lemma empty_eqvt[eqvt]:
  shows "p \<bullet> {} = {}"
  unfolding empty_def
  by (perm_simp) (rule refl)
*)
lemma 
  "(p \<bullet> {}) = {}"
thm eqvts_raw
thm eqvts
apply(perm_strict_simp)


lemma
 shows "p1 \<bullet> fv_trm_raw trm_raw = fv_trm_raw (p1 \<bullet> trm_raw)"
 and "p1 \<bullet> fv_assg_raw assg_raw = fv_assg_raw (p1 \<bullet> assg_raw)"
 and "p1 \<bullet> fv_bn_raw assg_raw = fv_bn_raw (p1 \<bullet> assg_raw)"
apply(induct trm_raw and assg_raw and assg_raw rule: fv_trm_raw_fv_assg_raw_fv_bn_raw.induct)
apply(simp_all)
apply(perm_simp)
apply(rule refl)
apply(perm_simp)
apply(rule refl)
apply(perm_simp)
apply(rule refl)
apply(simp add: fv_trm_raw.simps)



ML {* Inductive.the_inductive *}
thm trm_assg.fv
thm trm_assg.supp
thm trm_assg.eq_iff
thm trm_assg.bn
thm trm_assg.perm
thm trm_assg.induct
thm trm_assg.inducts
thm trm_assg.distinct
ML {* Sign.of_sort @{theory} (@{typ trm}, @{sort fs}) *}

(* TEMPORARY
thm trm_assg.fv[simplified trm_assg.supp(1-2)]
*)



end



