theory SingleLet
imports "../NewParser"
begin

atom_decl name

declare [[STEPS = 17]]

nominal_datatype trm  =
  Var "name"
| App "trm" "trm"
| Lam x::"name" t::"trm"  bind_set x in t
| Let a::"assg" t::"trm"  bind_set "bn a" in t
| Foo x::"name" y::"name" t::"trm" t1::"trm" t2::"trm" bind_set x in y t t1 t2
| Bar x::"name" y::"name" t::"trm" bind y x in t x y
| Baz x::"name" t1::"trm" t2::"trm" bind x in t1, bind x in t2 
and assg =
  As "name" x::"name" t::"trm" bind x in t
binder
  bn::"assg \<Rightarrow> atom set"
where
  "bn (As x y t) = {atom x}"

(* can lift *)
thm distinct
thm trm_raw_assg_raw.inducts
thm fv_defs


(* cannot lift yet *)
thm eq_iff
thm eq_iff_simps
thm perm_simps
thm perm_laws
thm trm_raw_assg_raw.size(9 - 16)

(* rsp lemmas *)
thm size_rsp
thm funs_rsp
thm constrs_rsp
thm permute_rsp

declare constrs_rsp[quot_respect]
declare funs_rsp[quot_respect] 
declare size_rsp[quot_respect]
declare permute_rsp[quot_respect]

ML {*
  val thms_d = map (lift_thm [@{typ trm}, @{typ assg}] @{context}) @{thms distinct}
*}

ML {* 
  val thms_i = map (lift_thm [@{typ trm}, @{typ assg}] @{context}) @{thms trm_raw_assg_raw.inducts}
*}

ML {*
  val thms_f = map (lift_thm [@{typ trm}, @{typ assg}] @{context}) @{thms fv_defs}
*}

instantiation trm and assg :: size 
begin

quotient_definition 
  "size_trm :: trm \<Rightarrow> nat"
is "size :: trm_raw \<Rightarrow> nat"

quotient_definition 
  "size_assg :: assg \<Rightarrow> nat"
is "size :: assg_raw \<Rightarrow> nat"

instance .. 

end 

ML {* 
  val thms_i = map (lift_thm [@{typ trm}, @{typ assg}] @{context}) @{thms trm_raw_assg_raw.size(9 - 16)}
*}



instantiation trm and assg :: pt
begin

quotient_definition 
  "permute_trm :: perm => trm => trm" 
  is "permute :: perm \<Rightarrow> trm_raw \<Rightarrow> trm_raw"

quotient_definition 
  "permute_assg :: perm => assg => assg" 
  is "permute :: perm \<Rightarrow> assg_raw \<Rightarrow> assg_raw"

lemma qperm_laws:
  fixes t::trm and a::assg
  shows "permute 0 t = t"
  and   "permute 0 a = a" 
sorry
  
instance
apply(default)
sorry

end


(*
lemma [quot_respect]:
  "(alpha_assg_raw ===> alpha_assg_raw ===> op =) alpha_bn_raw alpha_bn_raw"
apply(simp)
sorry
*)

ML {*
  val thms_e = map (lift_thm [@{typ trm}, @{typ assg}] @{context}) @{thms eq_iff[unfolded alphas prod_fv.simps prod_rel.simps prod_alpha_def]}
*}

ML {*
  val thms_e = map (lift_thm [@{typ trm}, @{typ assg}] @{context}) @{thms eq_iff[unfolding alphas]}
*}


(*
instance trm :: size ..
instance assg :: size ..

lemma "(size (Var x)) = 0"
apply(descending)
apply(rule trm_raw_assg_raw.size(9 - 16))
apply(simp)
*)

ML {*
  val thms_e = map (lift_thm [@{typ trm}, @{typ assg}] @{context}) @{thms eq_iff[unfolding alphas]}
*}

section {* NOT *}


ML {* 
  val thms_i = map (lift_thm [@{typ trm}, @{typ assg}] @{context}) @{thms trm_raw_assg_raw.size(9 - 16)}
*}


ML {*
  val thms_p = map (lift_thm [@{typ trm}, @{typ assg}] @{context}) @{thms perm_simps(1)}
*}

ML {*
  val thms_f = map (lift_thm [@{typ trm}, @{typ assg}] @{context}) @{thms perm_laws}
*}


ML {*
  val thms_p = map (lift_thm [@{typ trm}, @{typ assg}] @{context}) @{thms perm_simps(1)}
*}

instance trm :: pt sorry
instance assg :: pt sorry










thm eq_iff[no_vars]

ML {*
  val q1 = lift_thm [@{typ trm}, @{typ assg}] @{context} @{thm "eq_iff"(1)}
*}

local_setup {* Local_Theory.note ((@{binding d1}, []), thms_d) #> snd *}
local_setup {* Local_Theory.note ((@{binding i1}, []), thms_i) #> snd *}
local_setup {* Local_Theory.note ((@{binding f1}, []), thms_f) #> snd *}
local_setup {* Local_Theory.note ((@{binding q1}, []), [q1]) #> snd *}


thm perm_defs
thm perm_simps

lemma supp_fv:
  "supp t = fv_trm t"
  "supp b = fv_bn b"
apply(induct t and b rule: i1)
apply(simp_all add: f1)
apply(simp_all add: supp_def)
apply(simp_all add: b1)
sorry

consts perm_bn_trm :: "perm \<Rightarrow> trm \<Rightarrow> trm"
consts perm_bn_assg :: "perm \<Rightarrow> assg \<Rightarrow> assg"

lemma y:
  "perm_bn_trm p (Var x) = (Var x)"
  "perm_bn_trm p (App t1 t2) = (App t1 t2)"
  "perm_bn_trm p ("



ML {*
  map (lift_thm [@{typ trm}, @{typ assg}] @{context}) @{thms eq_iff}
*}





lemma "Var x \<noteq> App y1 y2"
apply(descending)
apply(simp add: trm_raw.distinct)



ML {*
  map (lift_thm [@{typ trm}, @{typ assg}] @{context}) @{thms trm_raw.distinct(1)}
*}




typ trm
typ assg

thm trm_assg.fv
thm trm_assg.supp
thm trm_assg.eq_iff
thm trm_assg.bn
thm trm_assg.perm
thm trm_assg.induct
thm trm_assg.inducts
thm trm_assg.distinct
ML {* Sign.of_sort @{theory} (@{typ trm}, @{sort fs}) *}

(* TEMPORARY
thm trm_assg.fv[simplified trm_assg.supp(1-2)]
*)

end



