theory Abs
imports "Nominal2_Atoms" "Nominal2_Eqvt" "Nominal2_Supp" "../QuotMain" "../QuotProd"
begin

(* lemmas that should be in Nominal \<dots>\<dots>must be cleaned *)
lemma in_permute_iff:
  shows "(p \<bullet> x) \<in> (p \<bullet> X) \<longleftrightarrow> x \<in> X"
apply(unfold mem_def permute_fun_def)[1]
apply(simp add: permute_bool_def) 
done

lemma fresh_plus:
  fixes p q::perm
  shows "\<lbrakk>a \<sharp> p;  a \<sharp> q\<rbrakk> \<Longrightarrow> a \<sharp> (p + q)"
  unfolding fresh_def
  using supp_plus_perm
  by(auto)

lemma fresh_star_plus:
  fixes p q::perm
  shows "\<lbrakk>a \<sharp>* p;  a \<sharp>* q\<rbrakk> \<Longrightarrow> a \<sharp>* (p + q)"
  unfolding fresh_star_def
  by (simp add: fresh_plus)


lemma fresh_star_permute_iff:
  shows "(p \<bullet> a) \<sharp>* (p \<bullet> x) \<longleftrightarrow> a \<sharp>* x"
apply(simp add: fresh_star_def)
apply(auto)
apply(drule_tac x="p \<bullet> xa" in bspec)
apply(unfold mem_def permute_fun_def)[1] 
apply(simp add: eqvts)
apply(simp add: fresh_permute_iff)
apply(rule_tac ?p1="- p" in fresh_permute_iff[THEN iffD1])
apply(simp)
apply(drule_tac x="- p \<bullet> xa" in bspec)
apply(rule_tac ?p1="p" in in_permute_iff[THEN iffD1])
apply(simp)
apply(simp)
done

lemma fresh_minus_perm:
  fixes p::perm
  shows "a \<sharp> (- p) \<longleftrightarrow> a \<sharp> p"
  apply(simp add: fresh_def)
  apply(simp only: supp_minus_perm)
  done

fun
  alpha_gen 
where
  alpha_gen[simp del]:
  "(alpha_gen (bs, x) R f pi (cs, y)) \<longleftrightarrow> (f x - bs = f y - cs) \<and> ((f x - bs) \<sharp>* pi) \<and> (R (pi \<bullet> x) y)"

notation
  alpha_gen ("_ \<approx>gen _ _ _ _")

lemma [mono]: "R1 \<le> R2 \<Longrightarrow> alpha_gen x R1 \<le> alpha_gen x R2"
  by (cases x) (auto simp add: le_fun_def le_bool_def alpha_gen.simps)

lemma alpha_gen_refl:
  assumes a: "R x x"
  shows "(bs, x) \<approx>gen R f 0 (bs, x)"
  using a by (simp add: alpha_gen fresh_star_def fresh_zero_perm)

lemma alpha_gen_sym:
  assumes a: "(bs, x) \<approx>gen R f p (cs, y)"
  and     b: "R (p \<bullet> x) y \<Longrightarrow> R (- p \<bullet> y) x"
  shows "(cs, y) \<approx>gen R f (- p) (bs, x)"
  using a b by (simp add: alpha_gen fresh_star_def fresh_def supp_minus_perm)

lemma alpha_gen_atom_sym:
  assumes a: "\<And>pi t s. (R t s \<Longrightarrow> R (pi \<bullet> t) (pi \<bullet> s))"
  shows "\<exists>pi. ({atom a}, t) \<approx>gen \<lambda>x1 x2. R x1 x2 \<and> R x2 x1 f pi ({atom b}, s) \<Longrightarrow>
        \<exists>pi. ({atom b}, s) \<approx>gen R f pi ({atom a}, t)"
  apply(erule exE)
  apply(rule_tac x="- pi" in exI)
  apply(simp add: alpha_gen.simps)
  apply(erule conjE)+
  apply(rule conjI)
  apply(simp add: fresh_star_def fresh_minus_perm)
  apply(subgoal_tac "R (- pi \<bullet> s) ((- pi) \<bullet> (pi \<bullet> t))")
  apply simp
  apply(rule a)
  apply assumption
  done

lemma alpha_gen_trans:
  assumes a: "(bs, x) \<approx>gen R f p1 (cs, y)"
  and     b: "(cs, y) \<approx>gen R f p2 (ds, z)"
  and     c: "\<lbrakk>R (p1 \<bullet> x) y; R (p2 \<bullet> y) z\<rbrakk> \<Longrightarrow> R ((p2 + p1) \<bullet> x) z"
  shows "(bs, x) \<approx>gen R f (p2 + p1) (ds, z)"
  using a b c using supp_plus_perm
  apply(simp add: alpha_gen fresh_star_def fresh_def)
  apply(blast)
  done

lemma alpha_gen_atom_trans:
  assumes a: "\<And>pi t s. (R t s \<Longrightarrow> R (pi \<bullet> t) (pi \<bullet> s))"
  shows "\<lbrakk>\<exists>pi\<Colon>perm. ({atom a}, t) \<approx>gen \<lambda>x1 x2. R x1 x2 \<and> (\<forall>x. R x2 x \<longrightarrow> R x1 x) f pi ({atom aa}, ta);
        \<exists>pi\<Colon>perm. ({atom aa}, ta) \<approx>gen R f pi ({atom ba}, sa)\<rbrakk>
    \<Longrightarrow> \<exists>pi\<Colon>perm. ({atom a}, t) \<approx>gen R f pi ({atom ba}, sa)"
  apply(simp add: alpha_gen.simps)
  apply(erule conjE)+
  apply(erule exE)+
  apply(erule conjE)+
  apply(rule_tac x="pia + pi" in exI)
  apply(simp add: fresh_star_plus)
  apply(drule_tac x="- pia \<bullet> sa" in spec)
  apply(drule mp)
  apply(rotate_tac 4)
  apply(drule_tac pi="- pia" in a)
  apply(simp)
  apply(rotate_tac 6)
  apply(drule_tac pi="pia" in a)
  apply(simp)
  done

lemma alpha_gen_eqvt:
  assumes a: "(bs, x) \<approx>gen R f q (cs, y)"
  and     b: "R (q \<bullet> x) y \<Longrightarrow> R (p \<bullet> (q \<bullet> x)) (p \<bullet> y)"
  and     c: "p \<bullet> (f x) = f (p \<bullet> x)"
  and     d: "p \<bullet> (f y) = f (p \<bullet> y)"
  shows "(p \<bullet> bs, p \<bullet> x) \<approx>gen R f (p \<bullet> q) (p \<bullet> cs, p \<bullet> y)"
  using a b
  apply(simp add: alpha_gen c[symmetric] d[symmetric] Diff_eqvt[symmetric])
  apply(simp add: permute_eqvt[symmetric])
  apply(simp add: fresh_star_permute_iff)
  apply(clarsimp)
  done

lemma alpha_gen_atom_eqvt:
  assumes a: "\<And>x. pi \<bullet> (f x) = f (pi \<bullet> x)"
  and     b: "\<exists>pia. ({atom a}, t) \<approx>gen \<lambda>x1 x2. R x1 x2 \<and> R (pi \<bullet> x1) (pi \<bullet> x2) f pia ({atom b}, s)"
  shows  "\<exists>pia. ({atom (pi \<bullet> a)}, pi \<bullet> t) \<approx>gen R f pia ({atom (pi \<bullet> b)}, pi \<bullet> s)"
  using b apply -
  apply(erule exE)
  apply(rule_tac x="pi \<bullet> pia" in exI)
  apply(simp add: alpha_gen.simps)
  apply(erule conjE)+
  apply(rule conjI)+
  apply(rule_tac ?p1="- pi" in permute_eq_iff[THEN iffD1])
  apply(simp add: a[symmetric] atom_eqvt eqvts)
  apply(rule conjI)
  apply(rule_tac ?p1="- pi" in fresh_star_permute_iff[THEN iffD1])
  apply(simp add: a[symmetric] eqvts atom_eqvt)
  apply(subst permute_eqvt[symmetric])
  apply(simp)
  done


fun
  alpha_abs 
where
  "alpha_abs (bs, x) (cs, y) = (\<exists>p. (bs, x) \<approx>gen (op=) supp p (cs, y))"

notation
  alpha_abs ("_ \<approx>abs _")

lemma alpha_abs_swap:
  assumes a1: "a \<notin> (supp x) - bs"
  and     a2: "b \<notin> (supp x) - bs"
  shows "(bs, x) \<approx>abs ((a \<rightleftharpoons> b) \<bullet> bs, (a \<rightleftharpoons> b) \<bullet> x)"
  apply(simp)
  apply(rule_tac x="(a \<rightleftharpoons> b)" in exI)
  apply(simp add: alpha_gen)
  apply(simp add: supp_eqvt[symmetric] Diff_eqvt[symmetric])
  apply(simp add: swap_set_not_in[OF a1 a2])
  apply(subgoal_tac "supp (a \<rightleftharpoons> b) \<subseteq> {a, b}")
  using a1 a2
  apply(simp add: fresh_star_def fresh_def)
  apply(blast)
  apply(simp add: supp_swap)
  done

fun
  supp_abs_fun
where
  "supp_abs_fun (bs, x) = (supp x) - bs"

lemma supp_abs_fun_lemma:
  assumes a: "x \<approx>abs y" 
  shows "supp_abs_fun x = supp_abs_fun y"
  using a
  apply(induct rule: alpha_abs.induct)
  apply(simp add: alpha_gen)
  done
  
quotient_type 'a abs = "(atom set \<times> 'a::pt)" / "alpha_abs"
  apply(rule equivpI)
  unfolding reflp_def symp_def transp_def
  apply(simp_all)
  apply(clarify)
  apply(rule exI)
  apply(rule alpha_gen_refl)
  apply(simp)
  apply(clarify)
  apply(rule exI)
  apply(rule alpha_gen_sym)
  apply(assumption)
  apply(clarsimp)
  apply(clarify)
  apply(rule exI)
  apply(rule alpha_gen_trans)
  apply(assumption)
  apply(assumption)
  apply(simp)
  done

quotient_definition
   "Abs::atom set \<Rightarrow> ('a::pt) \<Rightarrow> 'a abs"
as
   "Pair::atom set \<Rightarrow> ('a::pt) \<Rightarrow> (atom set \<times> 'a)"

lemma [quot_respect]:
  shows "((op =) ===> (op =) ===> alpha_abs) Pair Pair"
  apply(clarsimp)
  apply(rule exI)
  apply(rule alpha_gen_refl)
  apply(simp)
  done

lemma [quot_respect]:
  shows "((op =) ===> alpha_abs ===> alpha_abs) permute permute"
  apply(clarsimp)
  apply(rule exI)
  apply(rule alpha_gen_eqvt)
  apply(assumption)
  apply(simp_all add: supp_eqvt)
  done

lemma [quot_respect]:
  shows "(alpha_abs ===> (op =)) supp_abs_fun supp_abs_fun"
  apply(simp add: supp_abs_fun_lemma)
  done

lemma abs_induct:
  "\<lbrakk>\<And>as (x::'a::pt). P (Abs as x)\<rbrakk> \<Longrightarrow> P t"
  apply(lifting prod.induct[where 'a="atom set" and 'b="'a"])
  done

instantiation abs :: (pt) pt
begin

quotient_definition
  "permute_abs::perm \<Rightarrow> ('a::pt abs) \<Rightarrow> 'a abs"
as
  "permute:: perm \<Rightarrow> (atom set \<times> 'a::pt) \<Rightarrow> (atom set \<times> 'a::pt)"

lemma permute_ABS [simp]:
  fixes x::"'a::pt"  (* ??? has to be 'a \<dots> 'b does not work *)
  shows "(p \<bullet> (Abs as x)) = Abs (p \<bullet> as) (p \<bullet> x)"
  by (lifting permute_prod.simps(1)[where 'a="atom set" and 'b="'a"])

instance
  apply(default)
  apply(induct_tac [!] x rule: abs_induct)
  apply(simp_all)
  done

end

quotient_definition
  "supp_Abs_fun :: ('a::pt) abs \<Rightarrow> atom \<Rightarrow> bool"
as
  "supp_abs_fun"

lemma supp_Abs_fun_simp:
  shows "supp_Abs_fun (Abs bs x) = (supp x) - bs"
  by (lifting supp_abs_fun.simps(1))

lemma supp_Abs_fun_eqvt:
  shows "(p \<bullet> supp_Abs_fun) = supp_Abs_fun"
  apply(subst permute_fun_def)
  apply(subst expand_fun_eq)
  apply(rule allI)
  apply(induct_tac x rule: abs_induct)
  apply(simp add: supp_Abs_fun_simp supp_eqvt Diff_eqvt)
  done

lemma supp_Abs_fun_fresh:
  shows "a \<sharp> Abs bs x \<Longrightarrow> a \<sharp> supp_Abs_fun (Abs bs x)"
  apply(rule fresh_fun_eqvt_app)
  apply(simp add: supp_Abs_fun_eqvt)
  apply(simp)
  done

lemma Abs_swap:
  assumes a1: "a \<notin> (supp x) - bs"
  and     a2: "b \<notin> (supp x) - bs"
  shows "(Abs bs x) = (Abs ((a \<rightleftharpoons> b) \<bullet> bs) ((a \<rightleftharpoons> b) \<bullet> x))"
  using a1 a2 by (lifting alpha_abs_swap)

lemma Abs_supports:
  shows "((supp x) - as) supports (Abs as x)"
  unfolding supports_def
  apply(clarify)
  apply(simp (no_asm))
  apply(subst Abs_swap[symmetric])
  apply(simp_all)
  done

lemma supp_Abs_subset1:
  fixes x::"'a::fs"
  shows "(supp x) - as \<subseteq> supp (Abs as x)"
  apply(simp add: supp_conv_fresh)
  apply(auto)
  apply(drule_tac supp_Abs_fun_fresh)
  apply(simp only: supp_Abs_fun_simp)
  apply(simp add: fresh_def)
  apply(simp add: supp_finite_atom_set finite_supp)
  done

lemma supp_Abs_subset2:
  fixes x::"'a::fs"
  shows "supp (Abs as x) \<subseteq> (supp x) - as"
  apply(rule supp_is_subset)
  apply(rule Abs_supports)
  apply(simp add: finite_supp)
  done

lemma supp_Abs:
  fixes x::"'a::fs"
  shows "supp (Abs as x) = (supp x) - as"
  apply(rule_tac subset_antisym)
  apply(rule supp_Abs_subset2)
  apply(rule supp_Abs_subset1)
  done

instance abs :: (fs) fs
  apply(default)
  apply(induct_tac x rule: abs_induct)
  apply(simp add: supp_Abs)
  apply(simp add: finite_supp)
  done

lemma Abs_fresh_iff:
  fixes x::"'a::fs"
  shows "a \<sharp> Abs bs x = (a \<in> bs \<or> (a \<notin> bs \<and> a \<sharp> x))"
  apply(simp add: fresh_def)
  apply(simp add: supp_Abs)
  apply(auto)
  done

lemma Abs_eq_iff:
  shows "(Abs bs x) = (Abs cs y) \<longleftrightarrow> (\<exists>p. (bs, x) \<approx>gen (op =) supp p (cs, y))"
  by (lifting alpha_abs.simps(1))



(* 
  below is a construction site for showing that in the
  single-binder case, the old and new alpha equivalence 
  coincide
*)

fun
  alpha1
where
  "alpha1 (a, x) (b, y) \<longleftrightarrow> ((a = b \<and> x = y) \<or> (a \<noteq> b \<and> x = (a \<rightleftharpoons> b) \<bullet> y \<and> a \<sharp> y))"

notation 
  alpha1 ("_ \<approx>abs1 _")

lemma
  assumes a: "(a, x) \<approx>abs1 (b, y)" "sort_of a = sort_of b"
  shows "({a}, x) \<approx>abs ({b}, y)"
using a
apply(simp)
apply(erule disjE)
apply(simp)
apply(rule exI)
apply(rule alpha_gen_refl)
apply(simp)
apply(rule_tac x="(a \<rightleftharpoons> b)" in  exI)
apply(simp add: alpha_gen)
apply(simp add: fresh_def)
apply(rule conjI)
apply(rule_tac ?p1="(a \<rightleftharpoons> b)" in  permute_eq_iff[THEN iffD1])
apply(rule trans)
apply(simp add: Diff_eqvt supp_eqvt)
apply(subst swap_set_not_in)
back
apply(simp)
apply(simp)
apply(simp add: permute_set_eq)
apply(rule_tac ?p1="(a \<rightleftharpoons> b)" in fresh_star_permute_iff[THEN iffD1])
apply(simp add: permute_self)
apply(simp add: Diff_eqvt supp_eqvt)
apply(simp add: permute_set_eq)
apply(subgoal_tac "supp (a \<rightleftharpoons> b) \<subseteq> {a, b}")
apply(simp add: fresh_star_def fresh_def)
apply(blast)
apply(simp add: supp_swap)
done


end

