(*<*)
theory Slides3
imports "LaTeXsugar" "Nominal"
begin

notation (latex output)
  set ("_") and
  Cons  ("_::/_" [66,65] 65) 

(*>*)

text_raw {*
  \renewcommand{\slidecaption}{UNIF, Edinburgh, 14.~July 2010}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>[c]
  \frametitle{Quiz}
  
  Assuming that \smath{a} and \smath{b} are distinct variables,\\
  is it possible to find $\lambda$-terms \smath{M_1} to \smath{M_7} 
  that make the following pairs \alert{$\alpha$-equivalent}?

  \begin{tabular}{@ {\hspace{14mm}}p{12cm}}
  \begin{itemize}
  \item \smath{\lambda a.\lambda b. (M_1\,b)\;} and 
        \smath{\lambda b.\lambda a. (a\,M_1)\;}

  \item \smath{\lambda a.\lambda b. (M_2\,b)\;} and 
        \smath{\lambda b.\lambda a. (a\,M_3)\;}

  \item \smath{\lambda a.\lambda b. (b\,M_4)\;} and 
        \smath{\lambda b.\lambda a. (a\,M_5)\;}

  \item \smath{\lambda a.\lambda b. (b\,M_6)\;} and 
        \smath{\lambda a.\lambda a. (a\,M_7)\;}
  \end{itemize}
  \end{tabular}

  If there is one solution for a pair, can you describe all its solutions?

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>[t]
  \frametitle{%
  \begin{tabular}{@ {\hspace{-3mm}}c@ {}}
  \\
  \huge Nominal Unification\\[-2mm] 
  \Large Hitting a Sweet Spot\\[5mm]
  \end{tabular}}
  \begin{center}
  Christian Urban
  \end{center}
  \begin{center}
  \small initial work with Andy Pitts and Jamie Gabbay\\[0mm] 
  \end{center}
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     

*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-2>
  \frametitle{\begin{tabular}{c}Binding in Old Nominal\end{tabular}}
  \mbox{}\\[-6mm]

  \begin{itemize}
  \item old Nominal provided a reasoning infrastructure for single binders\medskip
  
  \begin{center}
  Lam [a].(Var a)
  \end{center}\bigskip

  \item<2-> but representing 

  \begin{center}
  $\forall\{a_1,\ldots,a_n\}.\; T$ 
  \end{center}\medskip

  with single binders and reasoning about it is a \alert{\bf major} pain; 
  take my word for it!
  \end{itemize}

  \only<1>{
  \begin{textblock}{6}(1.5,11)
  \small
  for example\\
  \begin{tabular}{l@ {\hspace{2mm}}l}
   & a $\fresh$ Lam [a]. t\\
   & Lam [a]. (Var a) \alert{$=$} Lam [b]. (Var b)\\
   & Barendregt style reasoning about bound variables\\
  \end{tabular}
  \end{textblock}}
  
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-4>
  \frametitle{\begin{tabular}{c}Binding Sets of Names\end{tabular}}
  \mbox{}\\[-3mm]

  \begin{itemize}
  \item binding sets of names has some interesting properties:\medskip
  
  \begin{center}
  \begin{tabular}{l}
  $\forall\{x, y\}.\, x \rightarrow y \;\;\approx_\alpha\;\; \forall\{y, x\}.\, y \rightarrow x$
  \bigskip\smallskip\\

  \onslide<2->{%
  $\forall\{x, y\}.\, x \rightarrow y \;\;\not\approx_\alpha\;\; \forall\{z\}.\, z \rightarrow z$
  }\bigskip\smallskip\\

  \onslide<3->{%
  $\forall\{x\}.\, x \rightarrow y \;\;\approx_\alpha\;\; \forall\{x, \alert{z}\}.\, x \rightarrow y$
  }\medskip\\
  \onslide<3->{\hspace{4cm}\small provided $z$ is fresh for the type}
  \end{tabular}
  \end{center}
  \end{itemize}
  
  \begin{textblock}{8}(2,14.5)
  \footnotesize $^*$ $x$, $y$, $z$ are assumed to be distinct
  \end{textblock}

  \only<4>{
  \begin{textblock}{6}(2.5,4)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=3mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\normalsize\color{darkgray}
  \begin{minipage}{8cm}\raggedright
  For type-schemes the order of bound names does not matter, and
  alpha-equivalence is preserved under \alert{vacuous} binders.
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-3>
  \frametitle{\begin{tabular}{c}Other Binding Modes\end{tabular}}
  \mbox{}\\[-3mm]

  \begin{itemize}
  \item alpha-equivalence being preserved under vacuous binders is \underline{not} always
  wanted:\bigskip\bigskip\normalsize
  
  \begin{tabular}{@ {\hspace{-8mm}}l}
  $\text{let}\;x = 3\;\text{and}\;y = 2\;\text{in}\;x - y\;\text{end}$\medskip\\
  \onslide<2->{$\;\;\;\only<2>{\approx_\alpha}\only<3>{\alert{\not\approx_\alpha}}
   \text{let}\;y = 2\;\text{and}\;x = 3\only<3->{\alert{\;\text{and}
    \;z = \text{loop}}}\;\text{in}\;x - y\;\text{end}$}
  \end{tabular}
  

  \end{itemize}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>
  \frametitle{\begin{tabular}{c}\LARGE{}Even Another Binding Mode\end{tabular}}
  \mbox{}\\[-3mm]

  \begin{itemize}
  \item sometimes one wants to abstract more than one name, but the order \underline{does} matter\bigskip
  
  \begin{center}
  \begin{tabular}{@ {\hspace{-8mm}}l}
  $\text{let}\;(x, y) = (3, 2)\;\text{in}\;x - y\;\text{end}$\medskip\\
  $\;\;\;\not\approx_\alpha
   \text{let}\;(y, x) = (3, 2)\;\text{in}\;x - y\;\text{end}$
  \end{tabular}
  \end{center}
  

  \end{itemize}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-2>
  \frametitle{\begin{tabular}{c}\LARGE{}Three Binding Modes\end{tabular}}
  \mbox{}\\[-3mm]

  \begin{itemize}
  \item the order does not matter and alpha-equivelence is preserved under
  vacuous binders \textcolor{gray}{(restriction)}\medskip
  
  \item the order does not matter, but the cardinality of the binders 
  must be the same \textcolor{gray}{(abstraction)}\medskip

  \item the order does matter
  \end{itemize}

  \onslide<2->{
  \begin{center}
  \isacommand{bind\_res}\hspace{6mm}
  \isacommand{bind\_set}\hspace{6mm}
  \isacommand{bind}
  \end{center}}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-3>
  \frametitle{\begin{tabular}{c}Specification of Binding\end{tabular}}
  \mbox{}\\[-6mm]

  \mbox{}\hspace{10mm}
  \begin{tabular}{ll}
  \multicolumn{2}{l}{\isacommand{nominal\_datatype} trm $=$}\\
  \hspace{5mm}\phantom{$|$} Var name\\
  \hspace{5mm}$|$ App trm trm\\
  \hspace{5mm}$|$ Lam \only<2->{x::}name \only<2->{t::}trm
  & \onslide<2->{\isacommand{bind} x \isacommand{in} t}\\
  \hspace{5mm}$|$ Let \only<2->{as::}assn \only<2->{t::}trm
  & \onslide<2->{\isacommand{bind} bn(as) \isacommand{in} t}\\
  \multicolumn{2}{l}{\isacommand{and} assn $=$}\\
  \multicolumn{2}{l}{\hspace{5mm}\phantom{$|$} ANil}\\
  \multicolumn{2}{l}{\hspace{5mm}$|$ ACons name trm assn}\\
  \multicolumn{2}{l}{\onslide<3->{\isacommand{binder} bn \isacommand{where}}}\\
  \multicolumn{2}{l}{\onslide<3->{\hspace{5mm}\phantom{$|$} bn(ANil) $=$ []}}\\
  \multicolumn{2}{l}{\onslide<3->{\hspace{5mm}$|$ bn(ACons a t as) $=$ [a] @ bn(as)}}\\
  \end{tabular}



  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-5>
  \frametitle{\begin{tabular}{c}Inspiration from Ott\end{tabular}}
  \mbox{}\\[-3mm]

  \begin{itemize}
  \item this way of specifying binding is inspired by 
  Ott\onslide<2->{, \alert{\bf but} we made adjustments:}\medskip
  

  \only<2>{
  \begin{itemize}
  \item Ott allows specifications like\smallskip
  \begin{center}
  $t ::= t\;t\; |\;\lambda x.t$
  \end{center}
  \end{itemize}}

  \only<3-4>{
  \begin{itemize}
  \item whether something is bound can depend in Ott on other bound things\smallskip
  \begin{center}
  \begin{tikzpicture}
  \node (A) at (-0.5,1) {Foo $(\lambda y. \lambda x. t)$};
  \node (B) at ( 1.1,1) {$s$};
  \onslide<4>{\node (C) at (0.5,0) {$\{y, x\}$};}
  \onslide<4>{\draw[->,red,line width=1mm] (A) -- (C);}
  \onslide<4>{\draw[->,red,line width=1mm] (C) -- (B);}
  \end{tikzpicture}
  \end{center}
  \onslide<4>{this might make sense for ``raw'' terms, but not at all 
  for $\alpha$-equated terms}
  \end{itemize}}

  \only<5>{
  \begin{itemize}
  \item we allow multiple binders and bodies\smallskip
  \begin{center}
  \isacommand{bind} a b c \isacommand{in} x y z
  \end{center}\bigskip\medskip
  the reason is that in general
  \begin{center}
  \begin{tabular}{rcl}
  \isacommand{bind\_res} as \isacommand{in} x y & $\not\Leftrightarrow$ &
  \begin{tabular}{@ {}l}
  \isacommand{bind\_res} as \isacommand{in} x,\\
  \isacommand{bind\_res} as \isacommand{in} y
  \end{tabular}
  \end{tabular}
  \end{center}\smallskip

  same with \isacommand{bind\_set}
  \end{itemize}}
  \end{itemize}


  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>
  \frametitle{\begin{tabular}{c}Alpha-Equivalence\end{tabular}}
  \mbox{}\\[-3mm]

  \begin{itemize}
  \item in old Nominal, we represented single binders as partial functions:\bigskip
  
  \begin{center}
  \begin{tabular}{l}
  Lam [$a$].\,$t$ $\;{^\text{``}}\!\dn{}\!^{\text{''}}$\\[2mm]
  \;\;\;\;$\lambda b.$\;$\text{if}\;a = b\;\text{then}\;t\;\text{else}$\\
  \phantom{\;\;\;\;$\lambda b.$\;\;\;\;\;\;}$\text{if}\;b \fresh t\;
  \text{then}\;(a\;b)\act t\;\text{else}\;\text{error}$ 
  \end{tabular}
  \end{center}
  \end{itemize}

  \begin{textblock}{10}(2,14)
  \footnotesize $^*$ alpha-equality coincides with equality on functions
  \end{textblock}
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->
  \frametitle{\begin{tabular}{c}New Design\end{tabular}}
  \mbox{}\\[4mm]

  \begin{center}
  \begin{tikzpicture}
  \alt<2>
  {\draw (0,0) node[inner sep=3mm, ultra thick, draw=red, rounded corners=2mm]
  (A) {\textcolor{red}{\begin{minipage}{1.1cm}bind.\\spec.\end{minipage}}};}
  {\draw (0,0) node[inner sep=3mm, ultra thick, draw=white, rounded corners=2mm]
  (A) {\begin{minipage}{1.1cm}bind.\\spec.\end{minipage}};}
  
  \alt<3>
  {\draw (3,0) node[inner sep=3mm, ultra thick, draw=red, rounded corners=2mm]
  (B) {\textcolor{red}{\begin{minipage}{1.1cm}raw\\terms\end{minipage}}};}
  {\draw (3,0) node[inner sep=3mm, ultra thick, draw=white, rounded corners=2mm]
  (B) {\begin{minipage}{1.1cm}raw\\terms\end{minipage}};}

  \alt<4>
  {\draw (6,0) node[inner sep=3mm, ultra thick, draw=red, rounded corners=2mm]
  (C) {\textcolor{red}{\begin{minipage}{1.1cm}$\alpha$-\\equiv.\end{minipage}}};}
  {\draw (6,0) node[inner sep=3mm, ultra thick, draw=white, rounded corners=2mm]
  (C) {\begin{minipage}{1.1cm}$\alpha$-\\equiv.\end{minipage}};}
  
  \alt<5>
  {\draw (0,-3) node[inner sep=3mm, ultra thick, draw=red, rounded corners=2mm]
  (D) {\textcolor{red}{\begin{minipage}{1.1cm}quot.\\type\end{minipage}}};}
  {\draw (0,-3) node[inner sep=3mm, ultra thick, draw=white, rounded corners=2mm]
  (D) {\begin{minipage}{1.1cm}quot.\\type\end{minipage}};}

  \alt<6>
  {\draw (3,-3) node[inner sep=3mm, ultra thick, draw=red, rounded corners=2mm]
  (E) {\textcolor{red}{\begin{minipage}{1.1cm}lift\\thms\end{minipage}}};}
  {\draw (3,-3) node[inner sep=3mm, ultra thick, draw=white, rounded corners=2mm]
  (E) {\begin{minipage}{1.1cm}lift\\thms\end{minipage}};}

  \alt<7>
  {\draw (6,-3) node[inner sep=3mm, ultra thick, draw=red, rounded corners=2mm]
  (F) {\textcolor{red}{\begin{minipage}{1.1cm}add.\\thms\end{minipage}}};}
  {\draw (6,-3) node[inner sep=3mm, ultra thick, draw=white, rounded corners=2mm]
  (F) {\begin{minipage}{1.1cm}add.\\thms\end{minipage}};}
  
  \draw[->,white!50,line width=1mm] (A) -- (B);
  \draw[->,white!50,line width=1mm] (B) -- (C);
  \draw[->,white!50,line width=1mm, line join=round, rounded corners=2mm] 
  (C) -- (8,0) -- (8,-1.5) -- (-2,-1.5) -- (-2,-3) -- (D);
  \draw[->,white!50,line width=1mm] (D) -- (E);
  \draw[->,white!50,line width=1mm] (E) -- (F);
  \end{tikzpicture}
  \end{center}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}



text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-9>
  \frametitle{\begin{tabular}{c}Alpha-Equivalence\end{tabular}}
  \mbox{}\\[-3mm]

  \begin{itemize}
  \item lets first look at pairs\bigskip\medskip

  \begin{tabular}{@ {\hspace{1cm}}l}
  $(as, x) \onslide<2->{\approx\!}\makebox[0mm][l]{\only<2-7>{${}_{\text{set}}$}%
           \only<8>{${}_{\text{\alert{list}}}$}%
           \only<9>{${}_{\text{\alert{res}}}$}}%
           \onslide<3->{^{R,\text{fv}}}\,\onslide<2->{(bs,y)}$
  \end{tabular}\bigskip
  \end{itemize}

  \only<1>{
  \begin{textblock}{8}(3,8.5)
  \begin{tabular}{l@ {\hspace{2mm}}p{8cm}}
   & $as$ is a set of atoms\ldots the binders\\
   & $x$ is the body\\
   & $\approx_{\text{set}}$ is where the cardinality 
  of the binders has to be the same\\
  \end{tabular}
  \end{textblock}}

  \only<4->{
  \begin{textblock}{12}(5,8)
  \begin{tabular}{ll@ {\hspace{1mm}}l}
  $\dn$ & \onslide<5->{$\exists \pi.\,$} & $\text{fv}(x) - as = \text{fv}(y) - bs$\\[1mm]
        & \onslide<5->{$\;\;\;\wedge$} & \onslide<5->{$\text{fv}(x) - as \fresh^* \pi$}\\[1mm]
        & \onslide<6->{$\;\;\;\wedge$} & \onslide<6->{$(\pi \act x)\;R\;y$}\\[1mm]
        & \onslide<7-8>{$\;\;\;\wedge$} & \onslide<7-8>{$\pi \act as = bs$}\\
  \end{tabular}
  \end{textblock}}
  
  \only<8>{
  \begin{textblock}{8}(3,13.8)
  \footnotesize $^*$ $as$ and $bs$ are \alert{lists} of atoms 
  \end{textblock}}
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-2>
  \frametitle{\begin{tabular}{c}Examples\end{tabular}}
  \mbox{}\\[-3mm]

  \begin{itemize}
  \item lets look at ``type-schemes'':\medskip\medskip

  \begin{center}
  $(as, x) \approx\!\makebox[0mm][l]{${}_{\text{set}}$}\only<1>{{}^{R,\text{fv}}}\only<2->{{}^{\alert{=},\alert{\text{fv}}}} (bs, y)$
  \end{center}\medskip

  \onslide<2->{
  \begin{center}
  \begin{tabular}{l}
  $\text{fv}(x) = \{x\}$\\[1mm]
  $\text{fv}(T_1 \rightarrow T_2) = \text{fv}(T_1) \cup \text{fv}(T_2)$\\
  \end{tabular}
  \end{center}}
  \end{itemize}

  
  \only<2->{
  \begin{textblock}{4}(0.3,12)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=1mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\tiny\color{darkgray}
  \begin{minipage}{3.4cm}\raggedright
  \begin{tabular}{r@ {\hspace{1mm}}l}
  \multicolumn{2}{@ {}l}{res:}\\
  $\exists\pi.$ & $\text{fv}(x) - as = \text{fv}(y) - bs$\\
  $\wedge$ & $\text{fv}(x) - as \fresh^* \pi$\\
  $\wedge$ & $\pi \cdot x = y$\\
  \\
  \end{tabular}
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}
  \only<2->{
  \begin{textblock}{4}(5.2,12)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=1mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\tiny\color{darkgray}
  \begin{minipage}{3.4cm}\raggedright
  \begin{tabular}{r@ {\hspace{1mm}}l}
  \multicolumn{2}{@ {}l}{set:}\\
  $\exists\pi.$ & $\text{fv}(x) - as = \text{fv}(y) - bs$\\
  $\wedge$ & $\text{fv}(x) - as \fresh^* \pi$\\
  $\wedge$ & $\pi \cdot x = y$\\
  $\wedge$ & $\pi \cdot as = bs$\\
  \end{tabular}
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}
  \only<2->{
  \begin{textblock}{4}(10.2,12)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=1mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\tiny\color{darkgray}
  \begin{minipage}{3.4cm}\raggedright
  \begin{tabular}{r@ {\hspace{1mm}}l}
  \multicolumn{2}{@ {}l}{list:}\\
  $\exists\pi.$ & $\text{fv}(x) - as = \text{fv}(y) - bs$\\
  $\wedge$ & $\text{fv}(x) - as \fresh^* \pi$\\
  $\wedge$ & $\pi \cdot x = y$\\
  $\wedge$ & $\pi \cdot as = bs$\\
  \end{tabular}
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-2>
  \frametitle{\begin{tabular}{c}Examples\end{tabular}}
  \mbox{}\\[-3mm]

  \begin{center}
  \only<1>{$(\{x, y\}, x \rightarrow y) \approx_? (\{x, y\}, y \rightarrow x)$}
  \only<2>{$([x, y], x \rightarrow y) \approx_? ([x, y], y \rightarrow x)$}
  \end{center}

  \begin{itemize}
  \item $\approx_{\text{res}}$, $\approx_{\text{set}}$% 
  \only<2>{, \alert{$\not\approx_{\text{list}}$}}
  \end{itemize}

  
  \only<1->{
  \begin{textblock}{4}(0.3,12)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=1mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\tiny\color{darkgray}
  \begin{minipage}{3.4cm}\raggedright
  \begin{tabular}{r@ {\hspace{1mm}}l}
  \multicolumn{2}{@ {}l}{res:}\\
  $\exists\pi.$ & $\text{fv}(x) - as = \text{fv}(y) - bs$\\
  $\wedge$ & $\text{fv}(x) - as \fresh^* \pi$\\
  $\wedge$ & $\pi \cdot x = y$\\
  \\
  \end{tabular}
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}
  \only<1->{
  \begin{textblock}{4}(5.2,12)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=1mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\tiny\color{darkgray}
  \begin{minipage}{3.4cm}\raggedright
  \begin{tabular}{r@ {\hspace{1mm}}l}
  \multicolumn{2}{@ {}l}{set:}\\
  $\exists\pi.$ & $\text{fv}(x) - as = \text{fv}(y) - bs$\\
  $\wedge$ & $\text{fv}(x) - as \fresh^* \pi$\\
  $\wedge$ & $\pi \cdot x = y$\\
  $\wedge$ & $\pi \cdot as = bs$\\
  \end{tabular}
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}
  \only<1->{
  \begin{textblock}{4}(10.2,12)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=1mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\tiny\color{darkgray}
  \begin{minipage}{3.4cm}\raggedright
  \begin{tabular}{r@ {\hspace{1mm}}l}
  \multicolumn{2}{@ {}l}{list:}\\
  $\exists\pi.$ & $\text{fv}(x) - as = \text{fv}(y) - bs$\\
  $\wedge$ & $\text{fv}(x) - as \fresh^* \pi$\\
  $\wedge$ & $\pi \cdot x = y$\\
  $\wedge$ & $\pi \cdot as = bs$\\
  \end{tabular}
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>
  \frametitle{\begin{tabular}{c}Examples\end{tabular}}
  \mbox{}\\[-3mm]

  \begin{center}
  \only<1>{$(\{x\}, x) \approx_? (\{x, y\}, x)$}
  \end{center}

  \begin{itemize}
  \item $\approx_{\text{res}}$, $\not\approx_{\text{set}}$,
        $\not\approx_{\text{list}}$
  \end{itemize}

  
  \only<1->{
  \begin{textblock}{4}(0.3,12)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=1mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\tiny\color{darkgray}
  \begin{minipage}{3.4cm}\raggedright
  \begin{tabular}{r@ {\hspace{1mm}}l}
  \multicolumn{2}{@ {}l}{res:}\\
  $\exists\pi.$ & $\text{fv}(x) - as = \text{fv}(y) - bs$\\
  $\wedge$ & $\text{fv}(x) - as \fresh^* \pi$\\
  $\wedge$ & $\pi \cdot x = y$\\
  \\
  \end{tabular}
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}
  \only<1->{
  \begin{textblock}{4}(5.2,12)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=1mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\tiny\color{darkgray}
  \begin{minipage}{3.4cm}\raggedright
  \begin{tabular}{r@ {\hspace{1mm}}l}
  \multicolumn{2}{@ {}l}{set:}\\
  $\exists\pi.$ & $\text{fv}(x) - as = \text{fv}(y) - bs$\\
  $\wedge$ & $\text{fv}(x) - as \fresh^* \pi$\\
  $\wedge$ & $\pi \cdot x = y$\\
  $\wedge$ & $\pi \cdot as = bs$\\
  \end{tabular}
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}
  \only<1->{
  \begin{textblock}{4}(10.2,12)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=1mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\tiny\color{darkgray}
  \begin{minipage}{3.4cm}\raggedright
  \begin{tabular}{r@ {\hspace{1mm}}l}
  \multicolumn{2}{@ {}l}{list:}\\
  $\exists\pi.$ & $\text{fv}(x) - as = \text{fv}(y) - bs$\\
  $\wedge$ & $\text{fv}(x) - as \fresh^* \pi$\\
  $\wedge$ & $\pi \cdot x = y$\\
  $\wedge$ & $\pi \cdot as = bs$\\
  \end{tabular}
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-3>
  \frametitle{\begin{tabular}{c}General Abstractions\end{tabular}}
  \mbox{}\\[-7mm]

  \begin{itemize}
  \item we take $(as, x) \approx\!\makebox[0mm][l]{${}_{\star}$}^{=,\text{supp}} (bs, y)$\medskip
  \item they are equivalence relations\medskip
  \item we can therefore use the quotient package to introduce the 
  types $\beta\;\text{abs}_\star$\bigskip
  \begin{center}
  \only<1>{$[as].\,x$}
  \only<2>{$\text{supp}([as].x) = \text{supp}(x) - as$}
  \only<3>{%
  \begin{tabular}{r@ {\hspace{1mm}}l}
  \multicolumn{2}{@ {\hspace{-7mm}}l}{$[as]. x \alert{=}  [bs].y\;\;\;\text{if\!f}$}\\[2mm]
  $\exists \pi.$ & $\text{supp}(x) - as = \text{supp}(y) - bs$\\
  $\wedge$       & $\text{supp}(x) - as \fresh^* \pi$\\
  $\wedge$       & $\pi \act x = y $\\
  $(\wedge$       & $\pi \act as = bs)\;^\star$\\
  \end{tabular}}
  \end{center}
  \end{itemize}

  
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>
  \frametitle{\begin{tabular}{c}One Problem\end{tabular}}
  \mbox{}\\[-3mm]

  \begin{center}
  $\text{let}\;x_1=t_1 \ldots x_n=t_n\;\text{in}\;s$
  \end{center}

  \begin{itemize}
  \item we cannot represent this as\medskip
  \begin{center}
  $\text{let}\;[x_1,\ldots,x_n]\alert{.}s\;\;[t_1,\ldots,t_n]$
  \end{center}\bigskip

  because\medskip
  \begin{center}
  $\text{let}\;[x].s\;\;[t_1,t_2]$
  \end{center}
  \end{itemize}

  
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->
  \frametitle{\begin{tabular}{c}Our Specifications\end{tabular}}
  \mbox{}\\[-6mm]

  \mbox{}\hspace{10mm}
  \begin{tabular}{ll}
  \multicolumn{2}{l}{\isacommand{nominal\_datatype} trm $=$}\\
  \hspace{5mm}\phantom{$|$} Var name\\
  \hspace{5mm}$|$ App trm trm\\
  \hspace{5mm}$|$ Lam x::name t::trm
  & \isacommand{bind} x \isacommand{in} t\\
  \hspace{5mm}$|$ Let as::assn t::trm
  & \isacommand{bind} bn(as) \isacommand{in} t\\
  \multicolumn{2}{l}{\isacommand{and} assn $=$}\\
  \multicolumn{2}{l}{\hspace{5mm}\phantom{$|$} ANil}\\
  \multicolumn{2}{l}{\hspace{5mm}$|$ ACons name trm assn}\\
  \multicolumn{2}{l}{\isacommand{binder} bn \isacommand{where}}\\
  \multicolumn{2}{l}{\hspace{5mm}\phantom{$|$} bn(ANil) $=$ $[]$}\\
  \multicolumn{2}{l}{\hspace{5mm}$|$ bn(ACons a t as) $=$ $[$a$]$ @ bn(as)}\\
  \end{tabular}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-2>
  \frametitle{\begin{tabular}{c}``Raw'' Definitions\end{tabular}}
  \mbox{}\\[-6mm]

  \mbox{}\hspace{10mm}
  \begin{tabular}{ll}
  \multicolumn{2}{l}{\isacommand{datatype} trm $=$}\\
  \hspace{5mm}\phantom{$|$} Var name\\
  \hspace{5mm}$|$ App trm trm\\
  \hspace{5mm}$|$ Lam name trm\\
  \hspace{5mm}$|$ Let assn trm\\
  \multicolumn{2}{l}{\isacommand{and} assn $=$}\\
  \multicolumn{2}{l}{\hspace{5mm}\phantom{$|$} ANil}\\
  \multicolumn{2}{l}{\hspace{5mm}$|$ ACons name trm assn}\\[5mm]
  \multicolumn{2}{l}{\isacommand{function} bn \isacommand{where}}\\
  \multicolumn{2}{l}{\hspace{5mm}\phantom{$|$} bn(ANil) $=$ $[]$}\\
  \multicolumn{2}{l}{\hspace{5mm}$|$ bn(ACons a t as) $=$ $[$a$]$ @ bn(as)}\\
  \end{tabular}

  \only<2>{
  \begin{textblock}{5}(10,5)
  $+$ \begin{tabular}{l}automatically\\ 
  generate fv's\end{tabular}
  \end{textblock}}
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>
  \frametitle{\begin{tabular}{c}\LARGE``Raw'' Alpha-Equivalence\end{tabular}}
  \mbox{}\\[6mm]

  \begin{center}
  Lam x::name t::trm \hspace{10mm}\isacommand{bind} x \isacommand{in} t\\
  \end{center}


  \[
  \infer[\text{Lam-}\!\approx_\alpha]
  {\text{Lam}\;x\;t \approx_\alpha \text{Lam}\;x'\;t'}
  {([x], t) \approx\!\makebox[0mm][l]{${}_{\text{list}}$}
    ^{\approx_\alpha,\text{fv}} ([x'], t')}
  \]


  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>
  \frametitle{\begin{tabular}{c}\LARGE``Raw'' Alpha-Equivalence\end{tabular}}
  \mbox{}\\[6mm]

  \begin{center}
  Lam x::name y::name t::trm s::trm \hspace{5mm}\isacommand{bind} x y \isacommand{in} t s\\
  \end{center}


  \[
  \infer[\text{Lam-}\!\approx_\alpha]
  {\text{Lam}\;x\;y\;t\;s \approx_\alpha \text{Lam}\;x'\;y'\;t'\;s'}
  {([x, y], (t, s)) \approx\!\makebox[0mm][l]{${}_{\text{list}}$}
    ^{R, fv} ([x', y'], (t', s'))}
  \]

  \footnotesize
  where $R =\;\approx_\alpha\times\approx_\alpha$ and $fv = \text{fv}\cup\text{fv}$

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-2>
  \frametitle{\begin{tabular}{c}\LARGE``Raw'' Alpha-Equivalence\end{tabular}}
  \mbox{}\\[6mm]

  \begin{center}
  Let as::assn t::trm \hspace{10mm}\isacommand{bind} bn(as) \isacommand{in} t\\
  \end{center}


  \[
  \infer[\text{Let-}\!\approx_\alpha]
  {\text{Let}\;as\;t \approx_\alpha \text{Let}\;as'\;t'}
  {(\text{bn}(as), t) \approx\!\makebox[0mm][l]{${}_{\text{list}}$}
    ^{\approx_\alpha,\text{fv}} (\text{bn}(as'), t') &
   \onslide<2>{as \approx_\alpha^{\text{bn}} as'}}
  \]


  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->
  \frametitle{\begin{tabular}{c}\LARGE{}$\alpha$ for Binding Functions\end{tabular}}
  \mbox{}\\[-6mm]

  \mbox{}\hspace{10mm}
  \begin{tabular}{l}
  \ldots\\
  \isacommand{binder} bn \isacommand{where}\\
  \phantom{$|$} bn(ANil) $=$ $[]$\\
  $|$ bn(ACons a t as) $=$ $[$a$]$ @ bn(as)\\
  \end{tabular}\bigskip

  \begin{center}
  \mbox{\infer{\text{ANil} \approx_\alpha^{\text{bn}} \text{ANil}}{}}\bigskip

  \mbox{\infer{\text{ACons}\;a\;t\;as \approx_\alpha^{\text{bn}} \text{ACons}\;a'\;t'\;as'}
  {t \approx_\alpha t' & as \approx_\alpha^{bn} as'}}
  \end{center}


  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->
  \frametitle{\begin{tabular}{c}Automatic Proofs\end{tabular}}
  \mbox{}\\[-6mm]

  \begin{itemize}
  \item we can show that $\alpha$'s are equivalence relations\medskip
  \item as a result we can use the quotient package to introduce the type(s)
  of $\alpha$-equated terms

  \[
  \infer
  {\text{Lam}\;x\;t \alert{=} \text{Lam}\;x'\;t'}
  {\only<1>{([x], t) \approx\!\makebox[0mm][l]{${}_{\text{list}}$}
    ^{=,\text{supp}} ([x'], t')}%
   \only<2>{[x].t = [x'].t'}}
  \]


  \item the properties for support are implied by the properties of $[\_].\_$
  \item we can derive strong induction principles (almost automatic---just a matter of
  another week or two)
  \end{itemize}


  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>[t]
  \frametitle{\begin{tabular}{c}Runtime is Acceptable\end{tabular}}
  \mbox{}\\[-7mm]\mbox{}

  \footnotesize
  \begin{center}
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=2mm, ultra thick, draw=white, rounded corners=2mm]
  (A) {\begin{minipage}{0.8cm}bind.\\spec.\end{minipage}};
  
  \draw (2,0) node[inner sep=2mm, ultra thick, draw=white, rounded corners=2mm]
  (B) {\begin{minipage}{0.8cm}raw\\terms\end{minipage}};

  \draw (4,0) node[inner sep=2mm, ultra thick, draw=white, rounded corners=2mm]
  (C) {\begin{minipage}{0.8cm}$\alpha$-\\equiv.\end{minipage}};
  
  \draw (0,-2) node[inner sep=2mm, ultra thick, draw=white, rounded corners=2mm]
  (D) {\begin{minipage}{0.8cm}quot.\\type\end{minipage}};

  \draw (2,-2) node[inner sep=2mm, ultra thick, draw=white, rounded corners=2mm]
  (E) {\begin{minipage}{0.8cm}lift\\thms\end{minipage}};

  \draw (4,-2) node[inner sep=2mm, ultra thick, draw=white, rounded corners=2mm]
  (F) {\begin{minipage}{0.8cm}add.\\thms\end{minipage}};
  
  \draw[->,white!50,line width=1mm] (A) -- (B);
  \draw[->,white!50,line width=1mm] (B) -- (C);
  \draw[->,white!50,line width=1mm, line join=round, rounded corners=2mm] 
  (C) -- (5,0) -- (5,-1) -- (-1,-1) -- (-1,-2) -- (D);
  \draw[->,white!50,line width=1mm] (D) -- (E);
  \draw[->,white!50,line width=1mm] (E) -- (F);
  \end{tikzpicture}
  \end{center}

  \begin{itemize}
  \item Core Haskell: 11 types, 49 term-constructors, 
  \end{itemize}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}


text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->
  \frametitle{\begin{tabular}{c}Interesting Phenomenon\end{tabular}}
  \mbox{}\\[-6mm]

  \small
  \mbox{}\hspace{10mm}
  \begin{tabular}{ll}
  \multicolumn{2}{l}{\isacommand{nominal\_datatype} trm $=$}\\
  \hspace{5mm}\phantom{$|$} Var name\\
  \hspace{5mm}$|$ App trm trm\\
  \hspace{5mm}$|$ Lam x::name t::trm
  & \isacommand{bind} x \isacommand{in} t\\
  \hspace{5mm}$|$ Let as::assn t::trm
  & \isacommand{bind} bn(as) \isacommand{in} t\\
  \multicolumn{2}{l}{\isacommand{and} assn $=$}\\
  \multicolumn{2}{l}{\hspace{5mm}\phantom{$|$} ANil}\\
  \multicolumn{2}{l}{\hspace{5mm}$|$ ACons name trm assn}\\
  \multicolumn{2}{l}{\isacommand{binder} bn \isacommand{where}}\\
  \multicolumn{2}{l}{\hspace{5mm}\phantom{$|$} bn(ANil) $=$ $[]$}\\
  \multicolumn{2}{l}{\hspace{5mm}$|$ bn(ACons a t as) $=$ $[$a$]$ @ bn(as)}\\
  \end{tabular}\bigskip\medskip

  we cannot quotient assn: ACons a \ldots $\not\approx_\alpha$ ACons b \ldots

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->
  \frametitle{\begin{tabular}{c}Conclusion\end{tabular}}
  \mbox{}\\[-6mm]

  \begin{itemize}
  \item the user does not see anything of the raw level\medskip
  \only<1>{\begin{center}
  Lam a (Var a) \alert{$=$} Lam b (Var b)
  \end{center}\bigskip}

  \item<2-> we have not yet done function definitions (will come soon and
  we hope to make improvements over the old way there too)\medskip
  \item<3-> it took quite some time to get here, but it seems worthwhile 
  (Barendregt's variable convention is unsound in general, 
  found bugs in two paper proofs, quotient package, POPL 2011 tutorial)\medskip
  \end{itemize}


  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

(*<*)
end
(*>*)