theory ExCoreHaskell
imports "Parser"
begin

(* core haskell *)

ML {* val _ = recursive := false *}
ML {* val _ = cheat_bn_eqvt := true *}
ML {* val _ = cheat_bn_rsp := true *}
ML {* val _ = cheat_const_rsp := true *}
ML {* val _ = cheat_alpha_bn_rsp := true *}
atom_decl var
atom_decl tvar

(* there are types, coercion types and regular types list-data-structure *)

nominal_datatype tkind =
  KStar
| KFun "tkind" "tkind"
and ckind =
  CKEq "ty" "ty"
and ty =
  TVar "tvar"
| TC "char"
| TApp "ty" "ty"
| TFun "char" "ty_lst"
| TAll tv::"tvar" "tkind" T::"ty"  bind tv in T
| TEq "ty" "ty" "ty"
and ty_lst =
  TsNil
| TsCons "ty" "ty_lst"
and co =
  CC "char"
| CApp "co" "co"
| CFun "char" "co_lst"
| CAll tv::"tvar" "ckind" C::"co"  bind tv in C
| CEq "co" "co" "co"
| CSym "co"
| CCir "co" "co"
| CLeft "co"
| CRight "co"
| CSim "co"
| CRightc "co"
| CLeftc "co"
| CCoe "co" "co"
and co_lst =
  CsNil
| CsCons "co" "co_lst"
and trm =
  Var "var"
| C "char"
| LAMT tv::"tvar" "tkind" t::"trm" bind tv in t
| LAMC tv::"tvar" "ckind" t::"trm" bind tv in t
| APP "trm" "ty"
| Lam v::"var" "ty" t::"trm"       bind v in t
| App "trm" "trm"
| Let x::"var" "ty" "trm" t::"trm" bind x in t
| Case "trm" "assoc_lst"
| Cast "trm" "ty"                  --"ty is supposed to be a coercion type only"
and assoc_lst =
  ANil
| ACons p::"pat" t::"trm" "assoc_lst" bind "bv p" in t
and pat =
  K "char" "tvtk_lst" "tvck_lst" "vt_lst"
and vt_lst =
  VTNil
| VTCons "var" "ty" "vt_lst"
and tvtk_lst =
  TVTKNil
| TVTKCons "tvar" "tkind" "tvtk_lst"
and tvck_lst =
  TVCKNil
| TVCKCons "tvar" "ckind" "tvck_lst"
binder
    bv :: "pat \<Rightarrow> atom set"
and bv_vt :: "vt_lst \<Rightarrow> atom set"
and bv_tvtk :: "tvtk_lst \<Rightarrow> atom set"
and bv_tvck :: "tvck_lst \<Rightarrow> atom set"
where
  "bv (K s tvts tvcs vs) = (bv_tvtk tvts) \<union> (bv_tvck tvcs) \<union> (bv_vt vs)"
| "bv_vt VTNil = {}"
| "bv_vt (VTCons v k t) = {atom v} \<union> bv_vt t"
| "bv_tvtk TVTKNil = {}"
| "bv_tvtk (TVTKCons v k t) = {atom v} \<union> bv_tvtk t"
| "bv_tvck TVCKNil = {}"
| "bv_tvck (TVCKCons v k t) = {atom v} \<union> bv_tvck t"

lemmas fv_supp=tkind_ckind_ty_ty_lst_co_co_lst_trm_assoc_lst_pat_vt_lst_tvtk_lst_tvck_lst.supp(1-9,11,13,15)
lemmas supp=tkind_ckind_ty_ty_lst_co_co_lst_trm_assoc_lst_pat_vt_lst_tvtk_lst_tvck_lst.fv[simplified fv_supp]

lemma 
  assumes a01: "P1 KStar"
  and a02: "\<And>tkind1 tkind2. \<lbrakk>P1 tkind1; P1 tkind2\<rbrakk> \<Longrightarrow> P1 (KFun tkind1 tkind2)"
  and a03: "\<And>ty1 ty2. \<lbrakk>P3 ty1; P3 ty2\<rbrakk> \<Longrightarrow> P2 (CKEq ty1 ty2)"
  and a04: "\<And>tvar. P3 (TVar tvar)"
  and a05: "\<And>char. P3 (TC char)"
  and a06: "\<And>ty1 ty2. \<lbrakk>P3 ty1; P3 ty2\<rbrakk> \<Longrightarrow> P3 (TApp ty1 ty2)"
  and a07: "\<And>char ty_lst. P4 ty_lst \<Longrightarrow> P3 (TFun char ty_lst)"
  and a08: "\<And>tvar tkind ty. \<lbrakk>P1 tkind; P3 ty\<rbrakk> \<Longrightarrow> P3 (TAll tvar tkind ty)"
  and a09: "\<And>ty1 ty2 ty3. \<lbrakk>P3 ty1; P3 ty2; P3 ty3\<rbrakk> \<Longrightarrow> P3 (TEq ty1 ty2 ty3)"
  and a10: "P4 TsNil"
  and a11: "\<And>ty ty_lst. \<lbrakk>P3 ty; P4 ty_lst\<rbrakk> \<Longrightarrow> P4 (TsCons ty ty_lst)"
  and a12: "\<And>char. P5 (CC char)"
  and a13: "\<And>co1 co2. \<lbrakk>P5 co1; P5 co2\<rbrakk> \<Longrightarrow> P5 (CApp co1 co2)"
  and a14: "\<And>char co_lst. P6 co_lst \<Longrightarrow> P5 (CFun char co_lst)"
  and a15: "\<And>tvar ckind co. \<lbrakk>P2 ckind; P5 co\<rbrakk> \<Longrightarrow> P5 (CAll tvar ckind co)"
  and a16: "\<And>co1 co2 co3. \<lbrakk>P5 co1; P5 co2; P5 co3\<rbrakk> \<Longrightarrow> P5 (CEq co1 co2 co3)"
  and a17: "\<And>co. P5 co \<Longrightarrow> P5 (CSym co)"
  and a18: "\<And>co1 co2. \<lbrakk>P5 co1; P5 co2\<rbrakk> \<Longrightarrow> P5 (CCir co1 co2)"
  and a19: "\<And>co. P5 co \<Longrightarrow> P5 (CLeft co)"
  and a20: "\<And>co. P5 co \<Longrightarrow> P5 (CRight co)"
  and a21: "\<And>co. P5 co \<Longrightarrow> P5 (CSim co)"
  and a22: "\<And>co. P5 co \<Longrightarrow> P5 (CRightc co)"
  and a23: "\<And>co. P5 co \<Longrightarrow> P5 (CLeftc co)"
  and a24: "\<And>co1 co2. \<lbrakk>P5 co1; P5 co2\<rbrakk> \<Longrightarrow> P5 (CCoe co1 co2)"
  and a25: "P6 CsNil"
  and a26: "\<And>co co_lst. \<lbrakk>P5 co; P6 co_lst\<rbrakk> \<Longrightarrow> P6 (CsCons co co_lst)"
  and a27: "\<And>var. P7 (Var var)"
  and a28: "\<And>char. P7 (C char)"
  and a29: "\<And>tvar tkind trm. \<lbrakk>P1 tkind; P7 trm\<rbrakk> \<Longrightarrow> P7 (LAMT tvar tkind trm)"
  and a30: "\<And>tvar ckind trm. \<lbrakk>P2 ckind; P7 trm\<rbrakk> \<Longrightarrow> P7 (LAMC tvar ckind trm)"
  and a31: "\<And>trm ty. \<lbrakk>P7 trm; P3 ty\<rbrakk> \<Longrightarrow> P7 (APP trm ty)"
  and a32: "\<And>var ty trm. \<lbrakk>P3 ty; P7 trm\<rbrakk> \<Longrightarrow> P7 (Lam var ty trm)"
  and a33: "\<And>trm1 trm2. \<lbrakk>P7 trm1; P7 trm2\<rbrakk> \<Longrightarrow> P7 (App trm1 trm2)"
  and a34: "\<And>var ty trm1 trm2. \<lbrakk>P3 ty; P7 trm1; P7 trm2\<rbrakk> \<Longrightarrow> P7 (ExCoreHaskell.Let var ty trm1 trm2)"
  and a35: "\<And>trm assoc_lst. \<lbrakk>P7 trm; P8 assoc_lst\<rbrakk> \<Longrightarrow> P7 (Case trm assoc_lst)"
  and a36: "\<And>trm ty. \<lbrakk>P7 trm; P3 ty\<rbrakk> \<Longrightarrow> P7 (Cast trm ty)"
  and a37: "P8 ANil"
  and a38: "\<And>pat trm assoc_lst. \<lbrakk>P9 pat; P7 trm; P8 assoc_lst\<rbrakk> \<Longrightarrow> P8 (ACons pat trm assoc_lst)"
  and a39: "\<And>char tvtk_lst tvck_lst vt_lst. \<lbrakk>P11 tvtk_lst; P12 tvck_lst; P10 vt_lst\<rbrakk>
    \<Longrightarrow> P9 (K char tvtk_lst tvck_lst vt_lst)"
  and a40: "P10 VTNil"
  and a41: "\<And>var ty vt_lst. \<lbrakk>P3 ty; P10 vt_lst\<rbrakk> \<Longrightarrow> P10 (VTCons var ty vt_lst)"
  and a42: "P11 TVTKNil"
  and a43: "\<And>tvar tkind tvtk_lst. \<lbrakk>P1 tkind; P11 tvtk_lst\<rbrakk> \<Longrightarrow> P11 (TVTKCons tvar tkind tvtk_lst)"
  and a44: "P12 TVCKNil"
  and a45: "\<And>tvar ckind tvck_lst. \<lbrakk>P2 ckind; P12 tvck_lst\<rbrakk> \<Longrightarrow> P12 (TVCKCons tvar ckind tvck_lst)"
  shows "P1 tkind \<and> P2 ckind \<and> P3 ty \<and> P4 ty_lst \<and> P5 co \<and> P6 co_lst \<and>
         P7 trm \<and> P8 assoc_lst \<and> P9 pat \<and> P10 vt_lst \<and> P11 tvtk_lst \<and> P12 tvck_lst"

end



