theory SingleLet
imports "../Nominal2" 
begin

atom_decl name

declare [[STEPS = 100]]

nominal_datatype single_let: trm =
  Var "name"
| App "trm" "trm"
| Lam x::"name" t::"trm"  bind x in t
| Let a::"assg" t::"trm"  bind "bn a" in t
| Foo x::"name" y::"name" t::"trm" t1::"trm" t2::"trm" bind (set) x in y t t1 t2
| Bar x::"name" y::"name" t::"trm" bind y x in t x y
| Baz x::"name" t1::"trm" t2::"trm" bind (set) x in t1, bind (set) x in t2 
and assg =
  As "name" x::"name" t::"trm" bind x in t
binder
  bn::"assg \<Rightarrow> atom list"
where
  "bn (As x y t) = [atom x]"


thm single_let.distinct
thm single_let.induct
thm single_let.inducts
thm single_let.exhaust
thm single_let.fv_defs
thm single_let.bn_defs
thm single_let.perm_simps
thm single_let.eq_iff
thm single_let.fv_bn_eqvt
thm single_let.size_eqvt
thm single_let.supports
thm single_let.fsupp
thm single_let.supp

lemma test2:
  assumes "fv_trm t = supp t" 
  shows "\<forall>p. fv_trm (p \<bullet> t) = supp (p \<bullet> t)"
apply(rule allI)
apply(rule_tac p="-p" in permute_boolE)
apply(perm_simp add: single_let.fv_bn_eqvt permute_minus_cancel)
apply(rule assms)
done

lemma supp_fv:
  "fv_trm x = supp x" 
  "fv_assg xa = supp xa"
  "fv_bn xa = supp_rel alpha_bn xa"
apply(induct rule: single_let.inducts)
-- " 0A "
apply(simp only: single_let.fv_defs supp_Pair[symmetric])
apply(simp (no_asm) only: supp_def)
apply(perm_simp add: single_let.perm_simps single_let.fv_bn_eqvt)
apply(simp (no_asm) only: single_let.eq_iff Abs_eq_iff)
-- " 0B"
apply(simp only: single_let.fv_defs supp_Pair[symmetric])
apply(simp (no_asm) only: supp_def)
apply(perm_simp add: single_let.perm_simps single_let.fv_bn_eqvt)
apply(simp (no_asm) only: single_let.eq_iff Abs_eq_iff)
apply(simp only: alphas prod_alpha_def prod_fv.simps prod_rel.simps permute_prod_def prod.recs prod.cases prod.inject)
--" 1 "
apply(simp only: single_let.fv_defs supp_Pair[symmetric])
apply(tactic {* EqSubst.eqsubst_tac @{context} [1] @{thms supp_abs(3)[symmetric]} 1 *})
apply(simp (no_asm) only: supp_def)
apply(perm_simp add: single_let.perm_simps single_let.fv_bn_eqvt)
apply(simp (no_asm) only: single_let.eq_iff Abs_eq_iff)
apply(simp only: alphas prod_alpha_def prod_fv.simps prod_rel.simps permute_prod_def prod.recs prod.cases prod.inject)
apply(drule test2)
apply(simp only:)
-- " 2 "
apply(simp only: single_let.fv_defs supp_Pair[symmetric])
apply(subst supp_abs(3)[symmetric])
apply(simp (no_asm) only: supp_def supp_rel_def)
apply(perm_simp add: single_let.perm_simps single_let.fv_bn_eqvt)
apply(simp (no_asm) only: single_let.eq_iff Abs_eq_iff)
apply(simp only: de_Morgan_conj Collect_disj_eq finite_Un)
apply(simp only: alphas prod_alpha_def prod_fv.simps prod_rel.simps permute_prod_def prod.recs prod.cases prod.inject)
apply(drule test2)
apply(simp only:)
-- " 3 "
apply(simp only: single_let.fv_defs supp_Pair[symmetric])
apply(subst supp_abs(1)[symmetric])
apply(simp (no_asm) only: supp_def supp_rel_def)
apply(perm_simp add: single_let.perm_simps single_let.fv_bn_eqvt)
apply(simp (no_asm) only: single_let.eq_iff Abs_eq_iff)
apply(simp only: alphas prod_alpha_def prod_fv.simps prod_rel.simps permute_prod_def prod.recs prod.cases prod.inject)
apply(drule test2)+
apply(simp only: supp_Pair Un_assoc conj_assoc)
-- " Bar "
apply(simp only: single_let.fv_defs supp_Pair[symmetric])
apply(subst supp_abs(3)[symmetric])
apply(simp (no_asm) only: supp_def)
apply(perm_simp add: single_let.perm_simps single_let.fv_bn_eqvt)
apply(simp (no_asm) only: single_let.eq_iff Abs_eq_iff)
apply(simp only: alphas prod_alpha_def prod_fv.simps prod_rel.simps permute_prod_def prod.recs prod.cases prod.inject)
apply(drule test2)+
apply(simp only: supp_Pair Un_assoc conj_assoc)
-- " Baz "
apply(simp only: single_let.fv_defs supp_Pair[symmetric])
apply(subst supp_abs(1)[symmetric])
apply(subst supp_abs(1)[symmetric])
apply(simp (no_asm) only: supp_def)
apply(perm_simp add: single_let.perm_simps single_let.fv_bn_eqvt)
apply(simp (no_asm) only: single_let.eq_iff Abs_eq_iff)
apply(simp only: alphas prod_alpha_def prod_fv.simps prod_rel.simps permute_prod_def prod.recs prod.cases prod.inject)
apply(simp only: de_Morgan_conj Collect_disj_eq finite_Un)
apply(drule test2)+
apply(simp only: supp_Pair Un_assoc conj_assoc)
-- "last"
apply(simp only: single_let.fv_defs supp_Pair[symmetric])
apply(tactic {* EqSubst.eqsubst_tac @{context} [1] @{thms supp_abs(3)[symmetric]} 1 *})
apply(simp (no_asm) only: supp_def supp_rel_def)
apply(perm_simp add: single_let.perm_simps single_let.fv_bn_eqvt)
apply(simp (no_asm) only: single_let.eq_iff Abs_eq_iff)
apply(simp only: alphas prod_alpha_def prod_fv.simps prod_rel.simps permute_prod_def prod.recs prod.cases prod.inject)
apply(simp only: de_Morgan_conj Collect_disj_eq finite_Un)
apply(drule test2)+
apply(simp only: supp_Pair Un_assoc conj_assoc)
-- "other case"
apply(simp only: single_let.fv_defs supp_Pair[symmetric])
apply(simp only: supp_abs(3)[symmetric])
apply(simp (no_asm) only: supp_def supp_rel_def)
apply(perm_simp add: single_let.perm_simps single_let.fv_bn_eqvt)
apply(simp (no_asm) only: single_let.eq_iff Abs_eq_iff)
apply(simp only: alphas prod_alpha_def prod_fv.simps prod_rel.simps permute_prod_def prod.recs prod.cases prod.inject)
apply(simp only: de_Morgan_conj Collect_disj_eq finite_Un)?
apply(drule test2)+
apply(simp only: supp_Pair Un_assoc conj_assoc)
done





text {* *}

(*
consts perm_bn_trm :: "perm \<Rightarrow> trm \<Rightarrow> trm"
consts perm_bn_assg :: "perm \<Rightarrow> assg \<Rightarrow> assg"

lemma y:
  "perm_bn_trm p (Var x) = (Var x)"
  "perm_bn_trm p (App t1 t2) = (App t1 t2)"
  "perm_bn_trm p ("



typ trm
typ assg

thm trm_assg.fv
thm trm_assg.supp
thm trm_assg.eq_iff
thm trm_assg.bn
thm trm_assg.perm
thm trm_assg.induct
thm trm_assg.inducts
thm trm_assg.distinct
ML {* Sign.of_sort @{theory} (@{typ trm}, @{sort fs}) *}
*)



end



