(*<*)
theory Slides4
imports "LaTeXsugar" "Nominal"
begin

notation (latex output)
  set ("_") and
  Cons  ("_::/_" [66,65] 65) 

(*>*)

text_raw {*
  \renewcommand{\slidecaption}{Nanjing, 31.~August 2010}

  \newcommand{\abst}[2]{#1.#2}% atom-abstraction
  \newcommand{\pair}[2]{\langle #1,#2\rangle} % pairing
  \newcommand{\susp}{{\boldsymbol{\cdot}}}% for suspensions
  \newcommand{\unit}{\langle\rangle}% unit
  \newcommand{\app}[2]{#1\,#2}% application
  \newcommand{\eqprob}{\mathrel{{\approx}?}}
  \newcommand{\freshprob}{\mathrel{\#?}}
  \newcommand{\redu}[1]{\stackrel{#1}{\Longrightarrow}}% reduction
  \newcommand{\id}{\varepsilon}% identity substitution
  
  \newcommand{\bl}[1]{\textcolor{blue}{#1}}
  \newcommand{\gr}[1]{\textcolor{gray}{#1}}
  \newcommand{\rd}[1]{\textcolor{red}{#1}}

  \newcommand{\ok}{\includegraphics[scale=0.07]{ok.png}}
  \newcommand{\notok}{\includegraphics[scale=0.07]{notok.png}}
  \newcommand{\largenotok}{\includegraphics[scale=1]{notok.png}}

  \renewcommand{\Huge}{\fontsize{61.92}{77}\selectfont}
  \newcommand{\veryHuge}{\fontsize{74.3}{93}\selectfont}
  \newcommand{\VeryHuge}{\fontsize{89.16}{112}\selectfont}
  \newcommand{\VERYHuge}{\fontsize{107}{134}\selectfont}

  \newcommand{\LL}{$\mathbb{L}\,$}


  \pgfdeclareradialshading{smallbluesphere}{\pgfpoint{0.5mm}{0.5mm}}%
  {rgb(0mm)=(0,0,0.9);
  rgb(0.9mm)=(0,0,0.7);
  rgb(1.3mm)=(0,0,0.5);
  rgb(1.4mm)=(1,1,1)}

  \def\myitemi{\begin{pgfpicture}{-1ex}{-0.55ex}{1ex}{1ex}
    \usebeamercolor[fg]{subitem projected}
    {\pgftransformscale{0.8}\pgftext{\normalsize\pgfuseshading{bigsphere}}}
    \pgftext{%
      \usebeamerfont*{subitem projected}}
  \end{pgfpicture}}

  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>[t]
  \frametitle{%
  \begin{tabular}{@ {\hspace{-3mm}}c@ {}}
  \\
  \huge Error-Free Programming\\[-1mm] 
  \huge with Theorem Provers\\[5mm]
  \end{tabular}}
  \begin{center}
  Christian Urban
  \end{center}
  \begin{center}
  \small Technical University of Munich, Germany\\[7mm]

  \small in Nanjing on the kind invitation of\\ Professor Xingyuan Zhang
  and his group
  \end{center}
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     

*}
text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->[c]
  \frametitle{My Background}

  \begin{itemize}
  \item researcher in Theoretical Computer Science\medskip

  \item programmer on a \alert<2->{software system} with 800 kloc (though I am 
  responsible only for 35 kloc)
  \end{itemize}

  \only<2->{
  \begin{textblock}{6}(2,11)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=2mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\color{darkgray}
  \begin{minipage}{4cm}\raggedright
  A theorem prover called {\bf Isabelle}.
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}

  
  \only<3>{
  \begin{textblock}{6}(9,11)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=2mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\color{darkgray}
  \begin{minipage}{4cm}\raggedright
  Like every other code, this code is very hard to 
  get correct.
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->[t]
  \frametitle{Regular Expressions}

  An example many (should) know about:\\ 
  \rd{\bf Regular Expressions:} 

  \only<2>{
  \begin{center}
  \bl{[] $\;\;\;|\;\;\;$ c $\;\;\;|\;\;\;$  r$_1$$|$r$_2$  $\;\;\;|\;\;\;$  
   r$_1$$\cdot$r$_2$ $\;\;\;|\;\;\;$ r$^*$}
  \end{center}}
  \only<3->{
  \begin{center}
  \begin{tabular}{@ {}rrll@ {}}
  \bl{r} & \bl{$::=$}  & \bl{NULL}            & \gr{(matches no string)}\\ 
         & \bl{$\mid$} & \bl{EMPTY}           & \gr{(matches the empty string, [])}\\ 
         & \bl{$\mid$} & \bl{CHR c}           & \gr{(matches the character c)}\\ 
         & \bl{$\mid$} & \bl{ALT r$_1$ r$_2$} & \gr{(alternative, r$_1 |\,$r$_2$)}\\ 
         & \bl{$\mid$} & \bl{SEQ r$_1$ r$_2$} & \gr{(sequential, r$_1\cdot\,$r$_2$)}\\ 
         & \bl{$\mid$} & \bl{STAR r}          & \gr{(repeat, r$^*$)}\\
  \end{tabular}
  \end{center}\medskip}

  \small
  \begin{textblock}{14.5}(1,12.5)
  \only<2->{\gr{(a$\cdot$b)$^*$ \hspace{3mm}$\mapsto$\hspace{3mm} \{[], ab, abab, ababab, \ldots\}}\\}
  \only<2->{\gr{x$\cdot$(0 $|$ 1 $|$ 2  \ldots  8 $|$ 9)$^*$ \hspace{3mm}$\mapsto$\hspace{3mm} 
  \{x, x0, x1, \ldots, x00, \ldots, x123, \ldots\}}}
  \end{textblock}
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>[c]
  \frametitle{RegExp Matcher}

  Let's implement a regular expression matcher:\bigskip

  \begin{center}
  \begin{tikzpicture}
  %%\draw[help lines, black] (-3,0) grid (6,3);
  
  \draw[line width=1mm, red] (0.0,0.0) rectangle (4,2.3);
  \node[anchor=base] at (2,1) 
     {\small\begin{tabular}{@ {}c@ {}}\Large\bf Regular\\ 
                                      \Large\bf Expression \\ 
                                      \Large\bf Matcher\end{tabular}};
  
  \coordinate (m1) at (0,1.5);
  \draw (-2,2) node (m2) {\small\begin{tabular}{c}\bl{regular}\\[-1mm] \bl{expression}\end{tabular}};
  \path[overlay, ->, line width = 1mm, shorten <=-3mm] (m2) edge (m1);
  
  \coordinate (s1) at (0,0.5);
  \draw (-1.8,-0) node (s2) {\small\begin{tabular}{c}\bl{string}\end{tabular}};
  \path[overlay, ->, line width = 1mm, shorten <=-3mm] (s2) edge (s1);

  \coordinate (r1) at (4,1.2);
  \draw (6,1.2) node (r2) {\small\begin{tabular}{c}\bl{true}, \bl{false}\end{tabular}};
  \path[overlay, ->, line width = 1mm, shorten >=-3mm] (r1) edge (r2);

  \end{tikzpicture}
  \end{center}


  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->[t]
  \frametitle{RegExp Matcher}
  \small

  {\bf input:} a \underline{list} of RegExps and a string \hspace{6mm}{\bf output:} true or false

  \only<2->{
  \begin{center}
  \begin{tabular}{@ {}l@ {\hspace{2mm}}c@ {\hspace{2mm}}l@ {}}
  \bl{match [] []}                   & \bl{$=$} & \bl{true}\\
  \bl{match [] \_}                   & \bl{$=$} & \bl{false}\\
  \bl{match (NULL::rs) s}            & \bl{$=$} & \bl{false}\\
  \bl{match (EMPTY::rs) s}           & \bl{$=$} & \bl{match rs s}\\
  \bl{match (CHR c::rs) (c::s)}      & \bl{$=$} & \bl{match rs s}\\         
  \bl{match (CHR c::rs) \_}          & \bl{$=$} & \bl{false}\\    
  \bl{match (ALT r$_1$ r$_2$::rs) s} & \bl{$=$} & \bl{match (r$_1$::rs) s}\\
                                     &          & \bl{\;\;\;\;orelse match (r$_2$::rs) s}\\ 
  \bl{match (SEQ r$_1$ r$_2$::rs) s} & \bl{$=$} & \bl{match (r$_1$::r$_2$::rs) s}\\
  \bl{match (STAR r::rs) s}          & \bl{$=$} & \bl{match rs s}\\
                                     &          & \bl{\;\;\;\;orelse match (r::STAR r::rs) s}\\
  \end{tabular}
  \end{center}}

  \onslide<3->{we start the program with\\
  \hspace{6mm}\bl{matches r s $=$ match [r] s}}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}


text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>[c]
  \frametitle{Program in Scala}

  \bl{\footnotesize
  \begin{tabular}{l}
  sealed abstract class Rexp\\ 
  sealed case class Null extends Rexp\\
  sealed case class Empty extends Rexp\\
  sealed case class Chr(c: Char) extends Rexp\\
  sealed case class Alt(r1 : Rexp, r2 : Rexp) extends Rexp\\
  sealed case class Seq(r1 : Rexp, r2 : Rexp) extends Rexp\\
  sealed case class Star(r : Rexp) extends Rexp\medskip\\
  def match1 (rs : List[Rexp], s : List[Char]) : Boolean = rs match \{\\
  \hspace{3mm}case Nil @{text "\<Rightarrow>"} if (s == Nil) true else false\\
  \hspace{3mm}case (Null()::rs) @{text "\<Rightarrow>"} false\\
  \hspace{3mm}case (Empty()::rs) @{text "\<Rightarrow>"} match1 (rs, s)\\
  \hspace{3mm}case (Chr(c)::rs) @{text "\<Rightarrow>"} s match \\
  \hspace{6mm}\{ case Nil @{text "\<Rightarrow>"} false\\
  \hspace{8mm}case (d::s) @{text "\<Rightarrow>"} if (c==d) match1 (rs,s) else false \}\\
  \hspace{3mm}case (Alt (r1, r2)::rs) @{text "\<Rightarrow>"} match1 (r1::rs, s) || match1 (r2::rs, s)\\
  \hspace{3mm}case (Seq (r1, r2)::rs) @{text "\<Rightarrow>"} match1 (r1::r2::rs, s) \\
  \hspace{3mm}case (Star (r)::rs) @{text "\<Rightarrow>"} match1 (r::rs, s) || match1 (r::Star (r)::rs, s)\\
  \}
  \end{tabular}}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}


text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->[c]
  \frametitle{Testing}
  
  \small
  Every good programmer should do thourough tests: 


  \begin{center}
  \begin{tabular}{@ {\hspace{-20mm}}lcl}
  \bl{matches (a$\cdot$b)$^*\;$ []}     & \bl{$\mapsto$} & \bl{true}\\
  \bl{matches (a$\cdot$b)$^*\;$ ab}   & \bl{$\mapsto$} & \bl{true}\\ 
  \bl{matches (a$\cdot$b)$^*\;$ aba}  & \bl{$\mapsto$} & \bl{false}\\
  \bl{matches (a$\cdot$b)$^*\;$ abab} & \bl{$\mapsto$} & \bl{true}\\ 
  \bl{matches (a$\cdot$b)$^*\;$ abaa} & \bl{$\mapsto$} & \bl{false}\medskip\\
  \onslide<2->{\bl{matches x$\cdot$(0$|$1)$^*\;$ x}   & \bl{$\mapsto$} & \bl{true}}\\
  \onslide<2->{\bl{matches x$\cdot$(0$|$1)$^*\;$ x0}  & \bl{$\mapsto$} & \bl{true}}\\
  \onslide<2->{\bl{matches x$\cdot$(0$|$1)$^*\;$ x3}  & \bl{$\mapsto$} & \bl{false}}
  \end{tabular}
  \end{center}
 
  \onslide<3->
  {looks OK \ldots let's ship it to customers\hspace{5mm} 
   \raisebox{-5mm}{\includegraphics[scale=0.05]{sun.png}}}
  
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->[t]
  \frametitle{Testing}

  \begin{itemize}
  \item While testing is an important part in the process of programming development\pause

  \item we can only test a {\bf finite} amount of examples\bigskip\pause

  \begin{center}
  \colorbox{cream}
  {\gr{\begin{minipage}{10cm}
  ``Testing can only show the presence of errors, never their
  absence'' (Edsger W.~Dijkstra)
  \end{minipage}}}
  \end{center}\bigskip\pause

  \item In a theorem prover we can establish properties that apply to 
  {\bf all} input and {\bf all} output.\pause 

  \item For example we can establish that the matcher terminates 
  on all input.
  \end{itemize}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->[t]
  \frametitle{RegExp Matcher}

  \small
  We need to find a measure that gets smaller in each recursive call.\bigskip

  \onslide<1->{
  \begin{center}
  \begin{tabular}{@ {}l@ {\hspace{2mm}}c@ {\hspace{2mm}}l@ {\hspace{-9mm}}l@ {}}
  \bl{match [] []}                   & \bl{$=$} & \bl{true} & \onslide<2->{\ok}\\
  \bl{match [] \_}                   & \bl{$=$} & \bl{false} & \onslide<2->{\ok}\\
  \bl{match (NULL::rs) s}            & \bl{$=$} & \bl{false} & \onslide<2->{\ok}\\
  \bl{match (EMPTY::rs) s}           & \bl{$=$} & \bl{match rs s} & \onslide<3->{\ok}\\
  \bl{match (CHR c::rs) (c::s)}      & \bl{$=$} & \bl{match rs s} & \onslide<4->{\ok}\\         
  \bl{match (CHR c::rs) \_}          & \bl{$=$} & \bl{false} & \onslide<2->{\ok}\\    
  \bl{match (ALT r$_1$ r$_2$::rs) s} & \bl{$=$} & \bl{match (r$_1$::rs) s} & \onslide<5->{\ok}\\
                                     &          & \bl{\;\;\;\;orelse match (r$_2$::rs) s}\\ 
  \bl{match (SEQ r$_1$ r$_2$::rs) s} & \bl{$=$} & \bl{match (r$_1$::r$_2$::rs) s} & \onslide<6->{\ok}\\
  \bl{match (STAR r::rs) s}          & \bl{$=$} & \bl{match rs s} & \onslide<7->{\notok}\\
                                     &          & \bl{\;\;\;\;orelse match (r::STAR r::rs) s}\\
  \end{tabular}
  \end{center}}


  \begin{textblock}{5}(4,4)
  \begin{tikzpicture}
  %%\draw[help lines, black] (-3,0) grid (6,3);
  
  \coordinate (m1) at (-2,0);
  \coordinate (m2) at ( 2,0);
  \path[overlay, ->, line width = 0.6mm, color = red] (m1) edge (m2);
  \draw (0,0) node[above=-1mm] {\footnotesize\rd{needs to get smaller}};
  \end{tikzpicture}
  \end{textblock}


  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->[c]
  \frametitle{Bug Hunting}

  \only<1>{Several hours later\ldots}\pause


  \begin{center}
  \begin{tabular}{@ {\hspace{-20mm}}lcl}
  \bl{matches (STAR (EMPTY)) s}     & \bl{$\mapsto$} & loops\\
  \onslide<4->{\bl{matches (STAR (EMPTY $|$ \ldots)) s}   & \bl{$\mapsto$} & loops\\} 
  \end{tabular}
  \end{center}

  \small
  \onslide<3->{
  \begin{center}
  \begin{tabular}{@ {}l@ {\hspace{2mm}}c@ {\hspace{2mm}}l@ {}}
  \ldots\\
  \bl{match (EMPTY::rs) s}           & \bl{$=$} & \bl{match rs s}\\
  \ldots\\
  \bl{match (STAR r::rs) s}          & \bl{$=$} & \bl{match rs s}\\
                                     &          & \bl{\;\;\;\;orelse match (r::STAR r::rs) s}\\
  \end{tabular}
  \end{center}}
  

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->[c]
  \frametitle{RegExp Matcher}
  \small

  \begin{center}
  \begin{tabular}{@ {}l@ {\hspace{2mm}}c@ {\hspace{2mm}}l@ {}}
  \bl{match [] []}                   & \bl{$=$} & \bl{true}\\
  \bl{match [] \_}                   & \bl{$=$} & \bl{false}\\
  \bl{match (NULL::rs) s}            & \bl{$=$} & \bl{false}\\
  \bl{match (EMPTY::rs) s}           & \bl{$=$} & \bl{match rs s}\\
  \bl{match (CHR c::rs) (c::s)}      & \bl{$=$} & \bl{match rs s}\\         
  \bl{match (CHR c::rs) \_}          & \bl{$=$} & \bl{false}\\    
  \bl{match (ALT r$_1$ r$_2$::rs) s} & \bl{$=$} & \bl{match (r$_1$::rs) s}\\
                                     &          & \bl{\;\;\;\;orelse match (r$_2$::rs) s}\\ 
  \bl{match (SEQ r$_1$ r$_2$::rs) s} & \bl{$=$} & \bl{match (r$_1$::r$_2$::rs) s}\\
  \bl{match (STAR r::rs) s}          & \bl{$=$} & \bl{match rs s}\\
                                     &          & \bl{\;\;\;\;orelse match (r::STAR r::rs) s}\\
  \end{tabular}
  \end{center}

  \only<1>{
  \begin{textblock}{5}(4,4)
  \largenotok
  \end{textblock}}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}



text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->[t]
  \frametitle{Second Attempt}

  Can a regular expression match the empty string?

  \small
  \begin{center}
  \begin{tabular}{@ {}l@ {\hspace{2mm}}c@ {\hspace{2mm}}ll@ {}}
  \bl{nullable (NULL)}            & \bl{$=$} & \bl{false} & \onslide<2->{\ok}\\
  \bl{nullable (EMPTY)}           & \bl{$=$} & \bl{true}  & \onslide<2->{\ok}\\
  \bl{nullable (CHR c)}           & \bl{$=$} & \bl{false} & \onslide<2->{\ok}\\         
  \bl{nullable (ALT r$_1$ r$_2$)} & \bl{$=$} & \bl{(nullable r$_1$) orelse (nullable r$_2$)}
    & \onslide<2->{\ok}\\ 
  \bl{nullable (SEQ r$_1$ r$_2$)} & \bl{$=$} & \bl{(nullable r$_1$) andalso (nullable r$_2$)}
    & \onslide<2->{\ok}\\ 
  \bl{nullable (STAR r)}          & \bl{$=$} & \bl{true} & \onslide<2->{\ok}\\
  \end{tabular}
  \end{center}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}


text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->[t]
  \frametitle{RegExp Matcher 2}

  If \bl{r} matches \bl{c::s}, which regular expression can match the string \bl{s}?

  \small
  \begin{center}
  \begin{tabular}{@ {}l@ {\hspace{2mm}}c@ {\hspace{2mm}}l@ {\hspace{-10mm}}l@ {}}
  \bl{der c (NULL)}            & \bl{$=$} & \bl{NULL} & \onslide<3->{\ok}\\
  \bl{der c (EMPTY)}           & \bl{$=$} & \bl{NULL} & \onslide<3->{\ok}\\
  \bl{der c (CHR d)}           & \bl{$=$} & \bl{if c=d then EMPTY else NULL} & \onslide<3->{\ok}\\
  \bl{der c (ALT r$_1$ r$_2$)} & \bl{$=$} & \bl{ALT (der c r$_1$) (der c r$_2$)} & \onslide<3->{\ok}\\ 
  \bl{der c (SEQ r$_1$ r$_2$)} & \bl{$=$} & \bl{ALT (SEQ (der c r$_1$) r$_2$)} & \onslide<3->{\ok}\\
       &          & \bl{\phantom{ALT} (if nullable r$_1$ then der c r$_2$ else NULL)}\\
  \bl{der c (STAR r)}          & \bl{$=$} & \bl{SEQ (der c r) (STAR r)} & \onslide<3->{\ok}\medskip\\
  \pause

  \bl{derivative r []}     & \bl{$=$} & \bl{r} & \onslide<3->{\ok}\\
  \bl{derivative r (c::s)} & \bl{$=$} & \bl{derivative (der c r) s} & \onslide<3->{\ok}\\
  \end{tabular}
  \end{center}

  we call the program with\\
  \bl{matches r s $=$ nullable (derivative r s)}
  

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->[c]
  \frametitle{But Now What?}

  \begin{center}
  {\usefont{T1}{ptm}{b}{N}\VERYHuge{\rd{?}}}
  \end{center}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->[c]
  \frametitle{Testing}
  
  \small

  \begin{center}
  \begin{tabular}{@ {\hspace{-20mm}}lcl}
  \bl{matches []$^*$ []} & \bl{$\mapsto$} & \bl{true}\\
  \bl{matches ([]$|$a)$^*$ a}  & \bl{$\mapsto$} & \bl{true}\medskip\\

  \bl{matches (a$\cdot$b)$^*\;$ []}     & \bl{$\mapsto$} & \bl{true}\\
  \bl{matches (a$\cdot$b)$^*\;$ ab}   & \bl{$\mapsto$} & \bl{true}\\ 
  \bl{matches (a$\cdot$b)$^*\;$ aba}  & \bl{$\mapsto$} & \bl{false}\\
  \bl{matches (a$\cdot$b)$^*\;$ abab} & \bl{$\mapsto$} & \bl{true}\\ 
  \bl{matches (a$\cdot$b)$^*\;$ abaa} & \bl{$\mapsto$} & \bl{false}\medskip\\
  
  \bl{matches x$\cdot$(0$|$1)$^*\;$ x}   & \bl{$\mapsto$} & \bl{true}\\
  \bl{matches x$\cdot$(0$|$1)$^*\;$ x0}  & \bl{$\mapsto$} & \bl{true}\\
  \bl{matches x$\cdot$(0$|$1)$^*\;$ x3}  & \bl{$\mapsto$} & \bl{false}
  \end{tabular}
  \end{center}
 
  
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->[t]
  \frametitle{Specification}

  We have to specify what it means for a regular expression to match
  a string. 
  %
  \only<2>{
  \mbox{}\\[8mm]
  \bl{(a$\cdot$b)$^*$}\\ 
  \hspace{7mm}\bl{$\mapsto$\hspace{3mm}\{[], ab, abab, ababab, \ldots\}}\bigskip\\
  \bl{x$\cdot$(0 $|$ 1 $|$ 2  \ldots  8 $|$ 9 )$^*$}\\ 
  \hspace{7mm}\bl{$\mapsto$\hspace{3mm} 
  \{x, x0, x1, \ldots, x00, \ldots, x123, \ldots\}}}
  %
  \only<3->{
  \begin{center}
  \begin{tabular}{rcl}
  \bl{\LL (NULL)}            & \bl{$\dn$} & \bl{\{\}}\\
  \bl{\LL (EMPTY)}           & \bl{$\dn$} & \bl{\{[]\}}\\
  \bl{\LL (CHR c)}           & \bl{$\dn$} & \bl{\{c\}}\\
  \bl{\LL (ALT r$_1$ r$_2$)} & \bl{$\dn$} & \onslide<4->{\bl{\LL (r$_1$) $\cup$ \LL (r$_2$)}}\\
  \bl{\LL (SEQ r$_1$ r$_2$)} & \bl{$\dn$} & \onslide<6->{\bl{\LL (r$_1$) ; \LL (r$_2$)}}\\
  \bl{\LL (STAR r)}          & \bl{$\dn$} & \onslide<8->{\bl{(\LL (r))$^\star$}}\\
  \end{tabular}
  \end{center}}

  \only<5-6>{
  \begin{textblock}{6}(2.9,13.3)
  \colorbox{cream}{\bl{S$_1$ ; S$_2$ $\;\dn\;$ \{ s$_1$@s$_2$ $|$ s$_1$$\in$S$_1$ $\wedge$
                                                          s$_2$$\in$S$_2$ \}}}
  \end{textblock}}

  \only<7->{
  \begin{textblock}{9}(4,13)
  \colorbox{cream}{\bl{$\infer{\mbox{[]} \in \mbox{S}^\star}{}$}}\hspace{3mm}
  \colorbox{cream}{\bl{$\infer{\mbox{s}_1\mbox{@}\mbox{s}_2 \in \mbox{S}^\star}
                      {\mbox{s}_1 \in \mbox{S} & \mbox{s}_2 \in \mbox{S}^\star}$}}
  \end{textblock}}
  
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->[t]
  \frametitle{Is the Matcher Error-Free?}

  We expect that

  \begin{center}
  \begin{tabular}{lcl}
  \bl{matches r s = true}  & \only<1>{\rd{$\Longrightarrow\,\,$}}\only<2>{\rd{$\Longleftarrow\,\,$}}% 
  \only<3->{\rd{$\Longleftrightarrow$}} & \bl{s $\in$ \LL(r)}\\
  \bl{matches r s = false} & \only<1>{\rd{$\Longrightarrow\,\,$}}\only<2>{\rd{$\Longleftarrow\,\,$}}%
  \only<3->{\rd{$\Longleftrightarrow$}} & \bl{s $\notin$ \LL(r)}\\
  \end{tabular}
  \end{center}
  \pause\pause\bigskip
  By \alert<4->{induction}, we can {\bf prove} these properties.\bigskip

  \begin{tabular}{lrcl}
  Lemmas:  & \bl{nullable (r)}          & \bl{$\Longleftrightarrow$} & \bl{[] $\in$ \LL (r)}\\
           & \bl{s $\in$ \LL (der c r)} & \bl{$\Longleftrightarrow$} & \bl{(c::s) $\in$ \LL (r)}\\
  \end{tabular}
  
  \only<4->{
  \begin{textblock}{3}(0.9,4.5)
  \rd{\huge$\forall$\large{}r s.}
  \end{textblock}}
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->[t]

  \mbox{}\\[-2mm]

  \small
  \begin{tabular}{@ {}l@ {\hspace{2mm}}c@ {\hspace{2mm}}ll@ {}}
  \bl{nullable (NULL)}            & \bl{$=$} & \bl{false} &\\
  \bl{nullable (EMPTY)}           & \bl{$=$} & \bl{true}  &\\
  \bl{nullable (CHR c)}           & \bl{$=$} & \bl{false} &\\
  \bl{nullable (ALT r$_1$ r$_2$)} & \bl{$=$} & \bl{(nullable r$_1$) orelse (nullable r$_2$)} & \\ 
  \bl{nullable (SEQ r$_1$ r$_2$)} & \bl{$=$} & \bl{(nullable r$_1$) andalso (nullable r$_2$)} & \\
  \bl{nullable (STAR r)}          & \bl{$=$} & \bl{true} & \\
  \end{tabular}\medskip

  \begin{tabular}{@ {}l@ {\hspace{2mm}}c@ {\hspace{2mm}}l@ {\hspace{-10mm}}l@ {}}
  \bl{der c (NULL)}            & \bl{$=$} & \bl{NULL} & \\
  \bl{der c (EMPTY)}           & \bl{$=$} & \bl{NULL} & \\
  \bl{der c (CHR d)}           & \bl{$=$} & \bl{if c=d then EMPTY else NULL} & \\
  \bl{der c (ALT r$_1$ r$_2$)} & \bl{$=$} & \bl{ALT (der c r$_1$) (der c r$_2$)} & \\
  \bl{der c (SEQ r$_1$ r$_2$)} & \bl{$=$} & \bl{ALT (SEQ (der c r$_1$) r$_2$)} & \\
       &          & \bl{\phantom{ALT} (if nullable r$_1$ then der c r$_2$ else NULL)}\\
  \bl{der c (STAR r)}          & \bl{$=$} & \bl{SEQ (der c r) (STAR r)} &\smallskip\\

  \bl{derivative r []}     & \bl{$=$} & \bl{r} & \\
  \bl{derivative r (c::s)} & \bl{$=$} & \bl{derivative (der c r) s} & \\
  \end{tabular}\medskip

  \bl{matches r s $=$ nullable (derivative r s)}
  
  \only<2>{
  \begin{textblock}{8}(1.5,4)
  \includegraphics[scale=0.3]{approved.png}
  \end{textblock}}
  

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}


text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->[c]
  \frametitle{Interlude: TCB}

  \begin{itemize}
  \item The \alert{\bf Trusted Code Base} (TCB) is the code that can make your 
  program behave in unintended ways (i.e.~cause bugs).\medskip

  \item Typically the TCB includes: CPUs, operating systems, C-libraries,
  device drivers, (J)VMs\ldots\bigskip
  \pause

  \item It also includes the compiler.
  \end{itemize}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*

  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1-3>
  \frametitle{\LARGE\begin{tabular}{c}Hacking Compilers 
  \end{tabular}}
  
  %Why is it so paramount to have a small trusted code base (TCB)?
  \bigskip\bigskip

  \begin{columns}
  \begin{column}{2.7cm}
  \begin{minipage}{2.5cm}%
  \begin{tabular}{c@ {}}
  \includegraphics[scale=0.2]{ken-thompson.jpg}\\[-1.8mm]
  \footnotesize Ken Thompson\\[-1.8mm]
  \footnotesize Turing Award, 1983\\
  \end{tabular}
  \end{minipage}
  \end{column}
  \begin{column}{9cm}
  \begin{tabular}{l@ {\hspace{1mm}}p{8cm}}
  \myitemi
  & Ken Thompson showed how to hide a Trojan Horse in a 
  compiler \textcolor{red}{without} leaving any traces in the source code.\\[2mm]
  \myitemi
  & No amount of source level verification will protect 
  you from such Thompson-hacks.\\[2mm]

  \myitemi
  & Therefore in safety-critical systems it is important to rely 
  on only a very small TCB.
  \end{tabular}
  \end{column}
  \end{columns}

  \only<2>{
  \begin{textblock}{6}(4,2)
  \begin{tikzpicture}
  \draw (0,0) node[inner sep=3mm,fill=cream, ultra thick, draw=red, rounded corners=2mm] 
  {\normalsize
  \begin{minipage}{8cm}
  \begin{quote}
  \includegraphics[scale=0.05]{evil.png}
  \begin{enumerate}
  \item[1)] Assume you ship the compiler as binary and also with sources.
  \item[2)] Make the compiler aware when it compiles itself.
  \item[3)] Add the Trojan horse.
  \item[4)] Compile.
  \item[5)] Delete Trojan horse from the sources of the compiler.
  \item[6)] Go on holiday for the rest of your life. ;o)\\[-7mm]\mbox{}
  \end{enumerate}
  \end{quote}
  \end{minipage}};
  \end{tikzpicture}
  \end{textblock}}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     

*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}
  \frametitle{\LARGE\begin{tabular}{c}An Example: Small TCB for\\[-2mm] 
  A Critical Infrastructure\end{tabular}}
  \mbox{}\\[-14mm]\mbox{}

  \begin{columns}
  \begin{column}{0.2\textwidth}
  \begin{tabular}{@ {} c@ {}}
  \includegraphics[scale=0.3]{appel.jpg}\\[-2mm] 
  {\footnotesize Andrew Appel}\\[-2.5mm]
  {\footnotesize (Princeton)}
  \end{tabular}
  \end{column}
  
  \begin{column}{0.8\textwidth}
  \begin{textblock}{10}(4.5,3.95)
  \begin{block}{Proof-Carrying Code}
  \begin{center}
  \begin{tikzpicture}
  \draw[help lines,cream] (0,0.2) grid (8,4);
  
  \draw[line width=1mm, red] (5.5,0.6) rectangle (7.5,4);
  \node[anchor=base] at (6.5,2.8) 
     {\small\begin{tabular}{@ {}p{1.9cm}@ {}}\centering  user needs to run untrusted code\end{tabular}};

  \draw[line width=1mm, red] (0.5,0.6) rectangle (2.5,4);
  \node[anchor=base] at (1.5,2.3) 
     {\small\begin{tabular}{@ {}p{1.9cm}@ {}}\centering  code developer/ web server/ Apple 
  Store\end{tabular}};
  
  \onslide<4->{
  \draw[line width=1mm, red, fill=red] (5.5,0.6) rectangle (7.5,1.8);
  \node[anchor=base,white] at (6.5,1.1) 
     {\small\begin{tabular}{@ {}p{1.9cm}@ {}}\bf\centering proof- checker\end{tabular}};}

  \node at (3.8,3.0) [single arrow, fill=red,text=white, minimum height=3cm]{\bf code};
  \onslide<3->{
  \node at (3.8,1.3) [single arrow, fill=red,text=white, minimum height=3cm]{\bf LF proof};
  \node at (3.8,1.9) {\small certificate};
  }

  \onslide<2>{\node at (4.0,1.3) [text=red]{\begin{tabular}{c}\bf Highly\\\bf Dangerous!\end{tabular}};}
  % Code Developer
  % User (runs untrusted code)
  % transmits a proof that the code is safe
  % 
  \end{tikzpicture}
  \end{center}
  \end{block}
  \end{textblock}
  \end{column}
  \end{columns}
  
  \small\mbox{}\\[2.5cm]
  \begin{itemize}
  \item<4-> TCB of the checker is $\sim$2700 lines of code (1865 loc of\\ LF definitions; 
  803 loc in C including 2 library functions)\\[-3mm]
  \item<5-> 167 loc in C implement a type-checker
  \end{itemize}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     

*}



text {*
  \tikzstyle{every node}=[node distance=25mm,text height=1.5ex, text depth=.25ex]
  \tikzstyle{node1}=[rectangle, minimum size=10mm, rounded corners=3mm, very thick, 
                     draw=black!50, top color=white, bottom color=black!20]
  \tikzstyle{node2}=[rectangle, minimum size=12mm, rounded corners=3mm, very thick, 
                     draw=red!70, top color=white, bottom color=red!50!black!20]
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}[squeeze]
  \frametitle{Type-Checking in LF} 
  
  \begin{columns}
  \begin{column}{0.2\textwidth}
  \begin{tabular}{@ {\hspace{-4mm}}c@ {}}
  \\[-4mm]
  \includegraphics[scale=0.1]{harper.jpg}\\[-2mm] 
  {\footnotesize Bob Harper}\\[-2.5mm]
  {\footnotesize (CMU)}\\[2mm]

  \includegraphics[scale=0.3]{pfenning.jpg}\\[-2mm] 
  {\footnotesize Frank Pfenning}\\[-2.5mm]
  {\footnotesize (CMU)}\\[2mm]

  \onslide<-6>{
  {\footnotesize 31 pages in }\\[-2.5mm]
  {\footnotesize ACM Transact.~on}\\[-2.5mm]
  {\footnotesize Comp.~Logic.,~2005}\\}
  \end{tabular}
  \end{column}

  \begin{column}{0.8\textwidth}
  \begin{textblock}{0}(3.1,2)

  \begin{tikzpicture}
  \matrix[ampersand replacement=\&,column sep=7mm, row sep=5mm]
  { \&[-10mm] 
    \node (def1)   [node1] {\large\hspace{1mm}Spec\hspace{1mm}\mbox{}}; \&
    \node (proof1) [node1] {\large Proof}; \&
    \node (alg1)   [node1] {\large\hspace{1mm}Alg\hspace{1mm}\mbox{}}; \\
    
    \onslide<4->{\node {\begin{tabular}{c}\small 1st\\[-2.5mm] \footnotesize solution\end{tabular}};} \&
    \onslide<4->{\node (def2)   [node2] {\large Spec$^\text{+ex}$};} \&
    \onslide<4->{\node (proof2) [node1] {\large Proof};} \&
    \onslide<4->{\node (alg2)   [node1] {\large\hspace{1mm}Alg\hspace{1mm}\mbox{}};} \\
     
    \onslide<5->{\node {\begin{tabular}{c}\small 2nd\\[-2.5mm] \footnotesize solution\end{tabular}};} \&
    \onslide<5->{\node (def3)   [node1] {\large\hspace{1mm}Spec\hspace{1mm}\mbox{}};} \&
    \onslide<5->{\node (proof3) [node1] {\large Proof};} \&
    \onslide<5->{\node (alg3)   [node2] {\large Alg$^\text{-ex}$};} \\

    \onslide<6->{\node {\begin{tabular}{c}\small 3rd\\[-2.5mm] \footnotesize solution\end{tabular}};} \&
    \onslide<6->{\node (def4)   [node1] {\large\hspace{1mm}Spec\hspace{1mm}\mbox{}};} \&
    \onslide<6->{\node (proof4) [node2] {\large\hspace{1mm}Proof\hspace{1mm}};} \&
    \onslide<6->{\node (alg4)   [node1] {\large\hspace{1mm}Alg\hspace{1mm}\mbox{}};} \\
  };

  \draw[->,black!50,line width=2mm] (proof1) -- (def1);
  \draw[->,black!50,line width=2mm] (proof1) -- (alg1);
  
  \onslide<4->{\draw[->,black!50,line width=2mm] (proof2) -- (def2);}
  \onslide<4->{\draw[->,black!50,line width=2mm] (proof2) -- (alg2);}

  \onslide<5->{\draw[->,black!50,line width=2mm] (proof3) -- (def3);}
  \onslide<5->{\draw[->,black!50,line width=2mm] (proof3) -- (alg3);}
  
  \onslide<6->{\draw[->,black!50,line width=2mm] (proof4) -- (def4);}
  \onslide<6->{\draw[->,black!50,line width=2mm] (proof4) -- (alg4);}

  \onslide<3->{\draw[white,line width=1mm] (1.1,3.2) -- (0.9,2.85) -- (1.1,2.35) -- (0.9,2.0);} 
  \end{tikzpicture}

  \end{textblock}
  \end{column}
  \end{columns}

  \only<2>{%
  \begin{textblock}{2}(.1,12.85)
  \begin{tikzpicture}
  \draw[line width=1mm, red] (0,0) ellipse (1.5cm and 0.88cm);
  \end{tikzpicture}
  \end{textblock}
  }

  \begin{textblock}{3}(14,3.6)
  \onslide<4->{
  \begin{tikzpicture}
  \node at (0,0) [single arrow, shape border rotate=270, fill=red,text=white]{2h};
  \end{tikzpicture}}
  \end{textblock}

  \only<7->{
  \begin{textblock}{14}(0.6,12.8)
  \begin{block}{}
  \small Each time one needs to check $\sim$31pp~of informal paper proofs.
  You have to be able to keep definitions and proofs consistent.
  \end{block}
  \end{textblock}}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     

*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>[c]
  \frametitle{Theorem Provers}

  \begin{itemize}
  \item Theorem provers help with keeping large proofs consistent;
  make them modifiable.\medskip
  
  \item They can ensure that all cases are covered.\medskip

  \item Sometimes, tedious reasoning can be automated.
  \end{itemize}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>[c]
  \frametitle{Theorem Provers}

  \begin{itemize}
  \item You also pay a (sometimes heavy) price: reasoning can be much, much harder.\medskip

  \item Depending on your domain, suitable reasoning infrastructure
  might not yet be available.
  \end{itemize}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>[c]
  \frametitle{Theorem Provers}

  Recently impressive work has been accomplished proving the correctness

  \begin{itemize}
  \item of a compiler for C-light (compiled code has the same observable
  behaviour as the original source code),\medskip

  \item a mirco-kernel operating system (absence of certain 
  bugs\ldots no nil pointers, no buffer overflows).
  \end{itemize}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}


text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>[c]
  \frametitle{Trust in Theorem Provers}

  \begin{center}
  Why should we trust theorem provers? 
  \end{center}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*

  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}
  \frametitle{Theorem Provers}
  
   \begin{itemize}
  \item Theorem provers are a \textcolor{red}{special kind} of software.
  
  \item We do \textcolor{red}{\bf not} need to trust them; we only need to trust:
  \end{itemize}

  \begin{quote}
  \begin{itemize}
  \item The logic they are based on \textcolor{gray}{(e.g.~HOL)}, and\smallskip
  \item a proof checker that checks the proofs
  \textcolor{gray}{(this can be a very small program)}.\smallskip\pause
  \item To a little extend, we also need to trust our definitions
  \textcolor{gray}{(this can be mitigated)}.
  \end{itemize}
  \end{quote}
  
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     

*}

text_raw {*

  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}
  \frametitle{Isabelle}
  
  \begin{itemize}
  \item I am using the Isabelle theorem prover (development since 1990).\bigskip\bigskip\bigskip
  
  \item It follows the LCF-approach:
  
  \begin{itemize}
  \item Have a special abstract type \alert{\bf thm}.
  \item Make the constructors of this abstract type the inference rules 
  of your logic.
  \item Implement the theorem prover in a strongly-typed language (e.g.~ML).
  \end{itemize}

  $\Rightarrow$ everything of type {\bf thm} has been proved (even if we do not
  have to explicitly generate proofs).
  \end{itemize}
  
  \only<1>{
  \begin{textblock}{5}(11,2.3)
  \begin{center}
  \includegraphics[scale=0.18]{robin-milner.jpg}\\[-0.8mm]
  \footnotesize Robin Milner\\[-0.8mm]
  \footnotesize Turing Award, 1991\\
  \end{center}
  \end{textblock}}

  
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>[c]
  \frametitle{
  \begin{tabular}{c}
  \mbox{}\\[23mm]
  \LARGE Demo
  \end{tabular}}
  
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}


text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->[c]
  \frametitle{Future Research}
  
  \begin{itemize}
  \item Make theorem provers more like a programming environment.\medskip\pause 

  \item Use all the computational power we get from the hardware to
  automate reasoning (GPUs).\medskip\pause

  \item Provide a comprehensive reasoning infrastructure for many domains and 
  design automated decision procedures. 
  \end{itemize}\pause

  
  \begin{center}
  \colorbox{cream}{
  \begin{minipage}{10cm} 
  \color{gray}
  \small
  ``Formal methods will never have a significant impact until
   they can be used by people that don't understand them.''\smallskip\\
  \mbox{}\footnotesize\hfill attributed to Tom Melham
  \end{minipage}}
  \end{center}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->[c]
  \frametitle{Conclusion}
  
  \begin{itemize}
  \item The plan is to make this kind of programming the ``future''.\medskip\pause

  \item Though the technology is already there\\ (compiler + micro-kernel os).\medskip\pause

  \item Logic and reasoning (especially induction) are important skills for 
  Computer Scientists.
  \end{itemize}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}


text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>[c]
  \frametitle{
  \begin{tabular}{c}
  \mbox{}\\[23mm]
  \alert{\LARGE Thank you very much!}\\
  \alert{\Large Questions?}
  \end{tabular}}
  
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}



(*<*)
end
(*>*)