theory Parser
imports "Nominal2_Atoms" "Nominal2_Eqvt" "Nominal2_Supp" "Perm" "Fv" "Rsp"
begin

atom_decl name

section{* Interface for nominal_datatype *}

text {*

Nominal-Datatype-part:


1nd Arg: (string list * binding * mixfix * (binding * typ list * mixfix) list) list
         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
               type(s) to be defined             constructors list
               (ty args, name, syn)              (name, typs, syn)

Binder-Function-part:

2rd Arg: (binding * typ option * mixfix) list 
         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^    
            binding function(s)           
              to be defined               
            (name, type, syn)             

3th Arg:  term list 
          ^^^^^^^^^
          the equations of the binding functions
          (Trueprop equations)
*}

ML {*

*}

text {*****************************************************}
ML {* 
(* nominal datatype parser *)
local
  structure P = OuterParse

  fun tuple ((x, y, z), u) = (x, y, z, u)
  fun tswap (((x, y), z), u) = (x, y, u, z)
in

val _ = OuterKeyword.keyword "bind"
val anno_typ = Scan.option (P.name --| P.$$$ "::") -- P.typ

(* binding specification *)
(* maybe use and_list *)
val bind_parser = 
  P.enum "," ((P.$$$ "bind" |-- P.term) -- (P.$$$ "in" |-- P.name) >> swap)

val constr_parser =
  P.binding -- Scan.repeat anno_typ

(* datatype parser *)
val dt_parser =
  (P.type_args -- P.binding -- P.opt_mixfix >> P.triple1) -- 
    (P.$$$ "=" |-- P.enum1 "|" (constr_parser -- bind_parser -- P.opt_mixfix >> tswap)) >> tuple

(* function equation parser *)
val fun_parser = 
  Scan.optional (P.$$$ "binder" |-- P.fixes -- SpecParse.where_alt_specs) ([],[])

(* main parser *)
val main_parser =
  (P.and_list1 dt_parser) -- fun_parser >> P.triple2

end
*}

(* adds "_raw" to the end of constants and types *)
ML {*
fun add_raw s = s ^ "_raw"
fun add_raws ss = map add_raw ss
fun raw_bind bn = Binding.suffix_name "_raw" bn

fun replace_str ss s = 
  case (AList.lookup (op=) ss s) of 
     SOME s' => s'
   | NONE => s

fun replace_typ ty_ss (Type (a, Ts)) = Type (replace_str ty_ss a, map (replace_typ ty_ss) Ts)
  | replace_typ ty_ss T = T  

fun raw_dts ty_ss dts =
let

  fun raw_dts_aux1 (bind, tys, mx) =
    (raw_bind bind, map (replace_typ ty_ss) tys, mx)

  fun raw_dts_aux2 (ty_args, bind, mx, constrs) =
    (ty_args, raw_bind bind, mx, map raw_dts_aux1 constrs)
in
  map raw_dts_aux2 dts
end

fun replace_aterm trm_ss (Const (a, T)) = Const (replace_str trm_ss a, T)
  | replace_aterm trm_ss (Free (a, T)) = Free (replace_str trm_ss a, T)
  | replace_aterm trm_ss trm = trm

fun replace_term trm_ss ty_ss trm =
  trm |> Term.map_aterms (replace_aterm trm_ss) |> map_types (replace_typ ty_ss) 
*}

ML {*
fun get_cnstrs dts =
  map (fn (_, _, _, constrs) => constrs) dts

fun get_typed_cnstrs dts =
  flat (map (fn (_, bn, _, constrs) => 
   (map (fn (bn', _, _) => (Binding.name_of bn, Binding.name_of bn')) constrs)) dts)

fun get_cnstr_strs dts =
  map (fn (bn, _, _) => Binding.name_of bn) (flat (get_cnstrs dts))

fun get_bn_fun_strs bn_funs =
  map (fn (bn_fun, _, _) => Binding.name_of bn_fun) bn_funs
*}

ML {*
fun rawify_dts dt_names dts dts_env =
let
  val raw_dts = raw_dts dts_env dts
  val raw_dt_names = add_raws dt_names
in
  (raw_dt_names, raw_dts)
end 
*}

ML {*
fun rawify_bn_funs dts_env cnstrs_env bn_fun_env bn_funs bn_eqs =
let
  val bn_funs' = map (fn (bn, ty, mx) => 
    (raw_bind bn, replace_typ dts_env ty, mx)) bn_funs
  
  val bn_eqs' = map (fn (attr, trm) => 
    (attr, replace_term (cnstrs_env @ bn_fun_env) dts_env trm)) bn_eqs
in
  (bn_funs', bn_eqs') 
end 
*}

ML {* 
fun rawify_binds dts_env cnstrs_env bn_fun_env binds =
  map (map (map (map (fn (opt_trm, i, j) => 
    (Option.map (apfst (replace_term (cnstrs_env @ bn_fun_env) dts_env)) opt_trm, i, j))))) binds
*}

ML {*
fun find [] _ = error ("cannot find element")
  | find ((x, z)::xs) y = if (Long_Name.base_name x) = y then z else find xs y
*}

ML {*
fun prep_bn dt_names dts eqs = 
let
  fun aux eq = 
  let
    val (lhs, rhs) = eq
      |> strip_qnt_body "all" 
      |> HOLogic.dest_Trueprop
      |> HOLogic.dest_eq
    val (bn_fun, [cnstr]) = strip_comb lhs
    val (_, ty) = dest_Free bn_fun
    val (ty_name, _) = dest_Type (domain_type ty)
    val dt_index = find_index (fn x => x = ty_name) dt_names
    val (cnstr_head, cnstr_args) = strip_comb cnstr
    val included = map (fn i => length (cnstr_args) - i - 1) (loose_bnos rhs)
  in
    (dt_index, (bn_fun, (cnstr_head, included)))
  end 
 
  fun order dts i ts = 
  let
    val dt = nth dts i
    val cts = map (fn (x, _, _) => Binding.name_of x) ((fn (_, _, _, x) => x) dt)
    val ts' = map (fn (x, y) => (fst (dest_Const x), y)) ts
  in
    map (find ts') cts
  end

  val unordered = AList.group (op=) (map aux eqs)
  val unordered' = map (fn (x, y) =>  (x, AList.group (op=) y)) unordered
  val ordered = map (fn (x, y) => (x, map (fn (v, z) => (v, order dts x z)) y)) unordered' 
in
  ordered
end
*}

ML {* 
fun add_primrec_wrapper funs eqs lthy = 
  if null funs then (([], []), lthy)
  else 
   let 
     val eqs' = map (fn (_, eq) => (Attrib.empty_binding, eq)) eqs
     val funs' = map (fn (bn, ty, mx) => (bn, SOME ty, mx)) funs
   in 
     Primrec.add_primrec funs' eqs' lthy
   end
*}

ML {*
fun add_datatype_wrapper dt_names dts =
let
  val conf = Datatype.default_config
in
  Local_Theory.theory_result (Datatype.add_datatype conf dt_names dts)
end
*}

ML {* 
fun raw_nominal_decls dts bn_funs bn_eqs binds lthy =
let
  val thy = ProofContext.theory_of lthy
  val thy_name = Context.theory_name thy

  val dt_names = map (fn (_, s, _, _) => Binding.name_of s) dts
  val dt_full_names = map (Long_Name.qualify thy_name) dt_names 
  val dt_full_names' = add_raws dt_full_names
  val dts_env = dt_full_names ~~ dt_full_names'

  val cnstrs = get_cnstr_strs dts
  val cnstrs_ty = get_typed_cnstrs dts
  val cnstrs_full_names = map (Long_Name.qualify thy_name) cnstrs
  val cnstrs_full_names' = map (fn (x, y) => Long_Name.qualify thy_name 
    (Long_Name.qualify (add_raw x) (add_raw y))) cnstrs_ty
  val cnstrs_env = cnstrs_full_names ~~ cnstrs_full_names'

  val bn_fun_strs = get_bn_fun_strs bn_funs
  val bn_fun_strs' = add_raws bn_fun_strs
  val bn_fun_env = bn_fun_strs ~~ bn_fun_strs'
  val bn_fun_full_env = map (pairself (Long_Name.qualify thy_name)) 
    (bn_fun_strs ~~ bn_fun_strs')
  
  val (raw_dt_names, raw_dts) = rawify_dts dt_names dts dts_env

  val (raw_bn_funs, raw_bn_eqs) = rawify_bn_funs dts_env cnstrs_env bn_fun_env bn_funs bn_eqs 
  
  val raw_binds = rawify_binds dts_env cnstrs_env bn_fun_full_env binds 

  val raw_bns = prep_bn dt_full_names' raw_dts (map snd raw_bn_eqs)

  val _ = tracing (cat_lines (map PolyML.makestring raw_bns)) 
in
  lthy 
  |> add_datatype_wrapper raw_dt_names raw_dts 
  ||>> add_primrec_wrapper raw_bn_funs raw_bn_eqs
  ||>> pair raw_binds
  ||>> pair raw_bns
end
*}

ML {*
fun un_raw name = unprefix "_raw" name handle Fail _ => name
fun add_under names = hd names :: (map (prefix "_") (tl names))
fun un_raws name = implode (map un_raw (add_under (space_explode "_" name)))
val un_raw_names = rename_vars un_raws
fun lift_thm ctxt thm = un_raw_names (snd (Quotient_Tacs.lifted_attrib (Context.Proof ctxt, thm)))
*}

lemma equivp_hack: "equivp x"
sorry
ML {*
fun equivp_hack ctxt rel =
let
  val thy = ProofContext.theory_of ctxt
  val ty = domain_type (fastype_of rel)
  val cty = ctyp_of thy ty
  val ct = cterm_of thy rel
in
  Drule.instantiate' [SOME cty] [SOME ct] @{thm equivp_hack}
end
*}

(* These 2 are critical, we don't know how to do it in term5 *)
ML {* val cheat_fv_rsp = ref true *}
ML {* val cheat_const_rsp = ref true *} (* For alpha_bn 0 and alpha_bn_rsp *)

ML {* val cheat_equivp = ref true *}

(* Fixes for these 2 are known *)
ML {* val cheat_fv_eqvt = ref true *} (* The tactic works, building the goal needs fixing *)
ML {* val cheat_alpha_eqvt = ref true *} (* The tactic works, building the goal needs fixing *)


ML {*
fun nominal_datatype2 dts bn_funs bn_eqs binds lthy =
let
  val thy = ProofContext.theory_of lthy
  val thy_name = Context.theory_name thy
  val ((((raw_dt_names, (raw_bn_funs_loc, raw_bn_eqs_loc)), raw_binds), raw_bns), lthy2) =
    raw_nominal_decls dts bn_funs bn_eqs binds lthy
  val morphism_2_1 = ProofContext.export_morphism lthy2 lthy
  val raw_bns_exp = map (apsnd (map (apfst (Morphism.term morphism_2_1)))) raw_bns;
  val bn_funs_decls = flat (map (fn (ith, l) => map (fn (bn, data) => (bn, ith, data)) l) raw_bns_exp);

  val raw_bn_funs = map (Morphism.term morphism_2_1) raw_bn_funs_loc
  val raw_bn_eqs = ProofContext.export lthy2 lthy raw_bn_eqs_loc
  val dtinfo = Datatype.the_info (ProofContext.theory_of lthy2) (hd raw_dt_names);
  val descr = #descr dtinfo;
  val sorts = #sorts dtinfo;
  val all_typs = map (fn i => typ_of_dtyp descr sorts (DtRec i)) (map fst descr)
  val all_full_tnames = map (fn (_, (n, _, _)) => n) descr;
  val dtinfos = map (Datatype.the_info (ProofContext.theory_of lthy2)) all_full_tnames;
  val rel_dtinfos = List.take (dtinfos, (length dts));
  val inject = flat (map #inject dtinfos);
  val distincts = flat (map #distinct dtinfos);
  val rel_distinct = map #distinct rel_dtinfos;
  val induct = #induct dtinfo;
  val inducts = #inducts dtinfo;
  val ((raw_perm_def, raw_perm_simps, perms), lthy3) =
    Local_Theory.theory_result (define_raw_perms dtinfo (length dts)) lthy2;
  val raw_binds_flat = map (map flat) raw_binds;
  val (((fv_ts_loc, fv_def_loc), alpha), lthy4) = define_fv_alpha dtinfo raw_binds_flat bn_funs_decls lthy3;
  val alpha_ts_loc = #preds alpha
  val alpha_ts_loc_nobn = List.take (alpha_ts_loc, length perms)
  val morphism_4_3 = ProofContext.export_morphism lthy4 lthy3;
  val fv_ts = map (Morphism.term morphism_4_3) fv_ts_loc;
  val fv_ts_loc_nobn = List.take (fv_ts_loc, length perms)
  val fv_ts_nobn = List.take (fv_ts, length perms)
  val alpha_ts = map (Morphism.term morphism_4_3) alpha_ts_loc;
  val (alpha_ts_nobn, alpha_ts_bn) = chop (length perms) alpha_ts
  val alpha_induct_loc = #induct alpha
  val [alpha_induct] = ProofContext.export lthy4 lthy3 [alpha_induct_loc];
  val alpha_inducts = Project_Rule.projects lthy4 (1 upto (length dts)) alpha_induct
  val fv_def = ProofContext.export lthy4 lthy3 fv_def_loc;
  val dts_names = map (fn (i, (s, _, _)) => (s, i)) (#descr dtinfo);
  val bn_tys = map (domain_type o fastype_of) raw_bn_funs;
  val bn_nos = map (dtyp_no_of_typ dts_names) bn_tys;
  val bns = raw_bn_funs ~~ bn_nos;
  val alpha_intros = #intrs alpha;
  val alpha_cases_loc = #elims alpha
  val alpha_cases = ProofContext.export lthy4 lthy3 alpha_cases_loc
  val alpha_inj_loc = build_alpha_inj alpha_intros (inject @ distincts) alpha_cases_loc lthy4
  val alpha_inj = ProofContext.export lthy4 lthy3 alpha_inj_loc
  fun alpha_eqvt_tac' _ =
    if !cheat_alpha_eqvt then Skip_Proof.cheat_tac thy
    else alpha_eqvt_tac alpha_induct_loc (raw_perm_def @ alpha_inj_loc) lthy4 1
  val alpha_eqvt_loc = build_alpha_eqvts alpha_ts_loc alpha_eqvt_tac' lthy4;
  val alpha_eqvt = ProofContext.export lthy4 lthy2 alpha_eqvt_loc;
  val _ = map tracing (map PolyML.makestring alpha_eqvt)
  val (bv_eqvts, lthy5) = fold_map (build_bv_eqvt (raw_bn_eqs @ raw_perm_def) inducts) bns lthy4;
  val fv_eqvt_tac =
    if !cheat_fv_eqvt then (fn _ => fn _ => Skip_Proof.cheat_tac thy)
    else build_eqvts_tac induct ((flat (map snd bv_eqvts)) @ fv_def_loc @ raw_perm_def) lthy5
  val (fv_eqvts, lthy6) = build_eqvts Binding.empty fv_ts_loc fv_eqvt_tac lthy5;
  val raw_fv_bv_eqvt_loc = flat (map snd bv_eqvts) @ (snd fv_eqvts)
  val raw_fv_bv_eqvt = ProofContext.export lthy6 lthy3 raw_fv_bv_eqvt_loc;
  val alpha_equivp_loc = 
    if !cheat_equivp then map (equivp_hack lthy6) alpha_ts_loc_nobn
    else build_equivps alpha_ts_loc induct alpha_induct_loc
      inject alpha_inj_loc distincts alpha_cases_loc alpha_eqvt_loc lthy6;
  val alpha_equivp = ProofContext.export lthy6 lthy2 alpha_equivp_loc;
  val qty_binds = map (fn (_, b, _, _) => b) dts;
  val qty_names = map Name.of_binding qty_binds;
  val qty_full_names = map (Long_Name.qualify thy_name) qty_names
  val lthy7 = define_quotient_type
    (map (fn ((b, t), alpha) => (([], b, NoSyn), (t, alpha))) ((qty_binds ~~ all_typs) ~~ alpha_ts_nobn))
    (ALLGOALS (resolve_tac alpha_equivp)) lthy6;
  val const_names = map Name.of_binding (flat (map (fn (_, _, _, t) => map (fn (b, _, _) => b) t) dts));
  val raw_consts =
    flat (map (fn (i, (_, _, l)) =>
      map (fn (cname, dts) =>
        Const (cname, map (typ_of_dtyp descr sorts) dts --->
          typ_of_dtyp descr sorts (DtRec i))) l) descr);
  val (consts_defs, lthy8) = fold_map Quotient_Def.quotient_lift_const (const_names ~~ raw_consts) lthy7;
  val (consts_loc, const_defs) = split_list consts_defs;
  val morphism_8_7 = ProofContext.export_morphism lthy8 lthy7;
  val consts = map (Morphism.term morphism_8_7) consts_loc;
  (* Could be done nicer *)
  val q_tys = distinct (op =) (map (snd o strip_type o fastype_of) consts);
  val (bns_rsp_pre, lthy9) = fold_map (
    fn (bn_t, i) => prove_const_rsp Binding.empty [bn_t]
      (fn _ => fvbv_rsp_tac (nth alpha_inducts i) raw_bn_eqs 1)) bns lthy8;
  val bns_rsp = flat (map snd bns_rsp_pre);
  fun fv_rsp_tac _ = if !cheat_fv_rsp then Skip_Proof.cheat_tac thy
    else fvbv_rsp_tac alpha_induct fv_def 1;
  val ((_, fv_rsp), lthy10) = prove_const_rsp Binding.empty fv_ts fv_rsp_tac lthy9
  val (perms_rsp, lthy11) = prove_const_rsp Binding.empty perms
    (fn _ => asm_simp_tac (HOL_ss addsimps alpha_eqvt) 1) lthy10;
  fun const_rsp_tac _ = if !cheat_const_rsp then Skip_Proof.cheat_tac thy
    else constr_rsp_tac alpha_inj (fv_rsp @ bns_rsp) alpha_equivp 1
  val (const_rsps, lthy12) = fold_map (fn cnst => prove_const_rsp Binding.empty [cnst]
    const_rsp_tac) (raw_consts @ alpha_ts_bn) lthy11
  val qfv_names = map (unsuffix "_raw" o Long_Name.base_name o fst o dest_Const) fv_ts
  val (qfv_defs, lthy12a) = fold_map Quotient_Def.quotient_lift_const (qfv_names ~~ fv_ts) lthy12;
  val qbn_names = map (fn (b, _ , _) => Name.of_binding b) bn_funs
  val (qbn_defs, lthy12b) = fold_map Quotient_Def.quotient_lift_const (qbn_names ~~ raw_bn_funs) lthy12a;
  val qalpha_bn_names = map (unsuffix "_raw" o Long_Name.base_name o fst o dest_Const) alpha_ts_bn
  val (qbn_defs, lthy12c) = fold_map Quotient_Def.quotient_lift_const (qalpha_bn_names ~~ alpha_ts_bn) lthy12b;
  val thy = Local_Theory.exit_global lthy12c;
  val perm_names = map (fn x => "permute_" ^ x) qty_names
  val thy' = define_lifted_perms qty_full_names (perm_names ~~ perms) raw_perm_simps thy;
  val lthy13 = Theory_Target.init NONE thy';
  val q_name = space_implode "_" qty_names;
  val q_induct = lift_thm lthy13 induct;
  val (_, lthy14) = Local_Theory.note ((Binding.name (q_name ^ "_induct"), []), [q_induct]) lthy13;
  val q_perm = map (lift_thm lthy14) raw_perm_def;
  val (_, lthy15) = Local_Theory.note ((Binding.name (q_name ^ "_perm"), []), q_perm) lthy14;
  val q_fv = map (lift_thm lthy15) fv_def;
  val (_, lthy16) = Local_Theory.note ((Binding.name (q_name ^ "_fv"), []), q_fv) lthy15;
  val q_bn = map (lift_thm lthy16) raw_bn_eqs;
  val (_, lthy17) = Local_Theory.note ((Binding.name (q_name ^ "_bn"), []), q_bn) lthy16;
  val inj_unfolded = map (Local_Defs.unfold lthy17 @{thms alpha_gen}) alpha_inj
  val q_inj_pre = map (lift_thm lthy17) inj_unfolded;
  val q_inj = map (Local_Defs.fold lthy17 @{thms alpha_gen}) q_inj_pre
  val (_, lthy18) = Local_Theory.note ((Binding.name (q_name ^ "_inject"), []), q_inj) lthy17;
  val rel_dists = flat (map (distinct_rel lthy18 alpha_cases)
    (rel_distinct ~~ (List.take (alpha_ts, (length dts)))))
  val q_dis = map (lift_thm lthy18) rel_dists;
  val (_, lthy19) = Local_Theory.note ((Binding.name (q_name ^ "_distinct"), []), q_dis) lthy18;
  val q_eqvt = map (lift_thm lthy19) raw_fv_bv_eqvt;
  val (_, lthy20) = Local_Theory.note ((Binding.empty,
    [Attrib.internal (fn _ => Nominal_ThmDecls.eqvt_add)]), q_eqvt) lthy19;
  val supports = map (prove_supports lthy20 q_perm) consts
  val _ = map tracing (map PolyML.makestring supports);
  val fin_supp = HOLogic.conj_elims (prove_fs lthy20 q_induct supports q_tys) handle _ => []
  val thy3 = Local_Theory.exit_global lthy20;
  val lthy21 = Theory_Target.instantiation (qty_full_names, [], @{sort fs}) thy3;
  fun tac _ = Class.intro_classes_tac [] THEN (ALLGOALS (resolve_tac fin_supp))
  val lthy22 = Class.prove_instantiation_instance tac lthy21 handle _ => lthy20
in
  ((raw_dt_names, raw_bn_funs, raw_bn_eqs, raw_binds), lthy22)
end
*}


ML {* 
(* parsing the datatypes and declaring *)
(* constructors in the local theory    *)
fun prepare_dts dt_strs lthy = 
let
  val thy = ProofContext.theory_of lthy
  
  fun mk_type full_tname tvrs =
    Type (full_tname, map (fn a => TVar ((a, 0), [])) tvrs)

  fun prep_cnstr lthy full_tname tvs (cname, anno_tys, mx, _) =
  let
    val tys = map (Syntax.read_typ lthy o snd) anno_tys
    val ty = mk_type full_tname tvs
  in
    ((cname, tys ---> ty, mx), (cname, tys, mx))
  end
  
  fun prep_dt lthy (tvs, tname, mx, cnstrs) = 
  let
    val full_tname = Sign.full_name thy tname
    val (cnstrs', cnstrs'') = 
      split_list (map (prep_cnstr lthy full_tname tvs) cnstrs)
  in
    (cnstrs', (tvs, tname, mx, cnstrs''))
  end 

  val (cnstrs, dts) = 
    split_list (map (prep_dt lthy) dt_strs)
in
  lthy
  |> Local_Theory.theory (Sign.add_consts_i (flat cnstrs))
  |> pair dts
end
*}

ML {*
(* parsing the binding function specification and *)
(* declaring the functions in the local theory    *)
fun prepare_bn_funs bn_fun_strs bn_eq_strs lthy =
let
  val ((bn_funs, bn_eqs), _) = 
    Specification.read_spec bn_fun_strs bn_eq_strs lthy

  fun prep_bn_fun ((bn, T), mx) = (bn, T, mx) 
  val bn_funs' = map prep_bn_fun bn_funs
in
  lthy
  |> Local_Theory.theory (Sign.add_consts_i bn_funs')
  |> pair (bn_funs', bn_eqs) 
end 
*}

ML {*
fun find_all eq xs (k',i) = 
  maps (fn (k, (v1, v2)) => if eq (k, k') then [(v1, v2, i)] else []) xs
*}

ML {*
(* associates every SOME with the index in the list; drops NONEs *)
fun mk_env xs =
  let
    fun mapp (_: int) [] = []
      | mapp i (a :: xs) = 
         case a of
           NONE => mapp (i + 1) xs
         | SOME x => (x, i) :: mapp (i + 1) xs
  in mapp 0 xs end
*}

ML {*
fun env_lookup xs x =
  case AList.lookup (op =) xs x of
    SOME x => x
  | NONE => error ("cannot find " ^ x ^ " in the binding specification.");
*}

ML {*
val recursive = ref false
*}

ML {*
fun prepare_binds dt_strs lthy = 
let
  fun extract_annos_binds dt_strs =
    map (map (fn (_, antys, _, bns) => (map fst antys, bns))) dt_strs

  fun prep_bn env bn_str =
    case (Syntax.read_term lthy bn_str) of
       Free (x, _) => (NONE, env_lookup env x)
     | Const (a, T) $ Free (x, _) => (SOME (Const (a, T), !recursive), env_lookup env x)
     | _ => error (bn_str ^ " not allowed as binding specification.");  
 
  fun prep_typ env (i, opt_name) = 
    case opt_name of
      NONE => []
    | SOME x => find_all (op=) env (x,i);
        
  (* annos - list of annotation for each type (either NONE or SOME fo a type *)
  
  fun prep_binds (annos, bind_strs) = 
  let
    val env = mk_env annos (* for every label the index *)
    val binds = map (fn (x, y) => (x, prep_bn env y)) bind_strs  
  in
    map_index (prep_typ binds) annos
  end

in
  map (map prep_binds) (extract_annos_binds (get_cnstrs dt_strs))
end
*}

ML {*
fun nominal_datatype2_cmd (dt_strs, bn_fun_strs, bn_eq_strs) lthy =
let
  fun prep_typ (tvs, tname, mx, _) = (tname, length tvs, mx)

  val lthy0 = 
    Local_Theory.theory (Sign.add_types (map prep_typ dt_strs)) lthy
  val (dts, lthy1) = 
    prepare_dts dt_strs lthy0
  val ((bn_funs, bn_eqs), lthy2) = 
    prepare_bn_funs bn_fun_strs bn_eq_strs lthy1
  val binds = prepare_binds dt_strs lthy2
in
  nominal_datatype2 dts bn_funs bn_eqs binds lthy |> snd
end
*}


(* Command Keyword *)

ML {*
let
   val kind = OuterKeyword.thy_decl
in
   OuterSyntax.local_theory "nominal_datatype" "test" kind 
     (main_parser >> nominal_datatype2_cmd)
end
*}


end



