theory Abs
imports "Nominal2_Atoms" "Nominal2_Eqvt" "Nominal2_Supp" "../QuotMain" 
begin

(* lemmas that should be in Nominal \<dots>\<dots>must be cleaned *)
lemma in_permute_iff:
  shows "(p \<bullet> x) \<in> (p \<bullet> X) \<longleftrightarrow> x \<in> X"
apply(unfold mem_def permute_fun_def)[1]
apply(simp add: permute_bool_def) 
done

lemma fresh_star_permute_iff:
  shows "(p \<bullet> a) \<sharp>* (p \<bullet> x) \<longleftrightarrow> a \<sharp>* x"
apply(simp add: fresh_star_def)
apply(auto)
apply(drule_tac x="p \<bullet> xa" in bspec)
apply(unfold mem_def permute_fun_def)[1] 
apply(simp add: eqvts)
apply(simp add: fresh_permute_iff)
apply(rule_tac ?p1="- p" in fresh_permute_iff[THEN iffD1])
apply(simp)
apply(drule_tac x="- p \<bullet> xa" in bspec)
apply(rule_tac ?p1="p" in in_permute_iff[THEN iffD1])
apply(simp)
apply(simp)
done


datatype 'a rabst = 
  RAbst "atom set" "'a::pt"

fun map_fun 
where "map_fun f (RAbst bs x) = RAbst bs (f x)"

fun map_rel
where "map_rel R (RAbst bs x) (RAbst cs y) = R x y"

declare [[map "rabst" = (map_fun, map_rel)]]

instantiation rabst :: (pt) pt
begin

primrec
  permute_rabst
where
  "p \<bullet> (RAbst bs x) = RAbst (p \<bullet> bs) (p \<bullet> x)"

instance
apply(default)
apply(case_tac [!] x)
apply(simp_all)
done

end

fun
 alpha_gen 
where
 alpha_gen[simp del]:
   "(alpha_gen (bs, x) R f pi (cs, y)) \<longleftrightarrow> (f x - bs = f y - cs) \<and> ((f x - bs) \<sharp>* pi) \<and> (R (pi \<bullet> x) y)"

notation
  alpha_gen ("_ \<approx>gen _ _ _ _")

lemma [mono]: "R1 \<le> R2 \<Longrightarrow> alpha_gen x R1 \<le> alpha_gen x R2"
  by (cases x) (auto simp add: le_fun_def le_bool_def alpha_gen.simps)

lemma alpha_gen_refl:
  assumes a: "R x x"
  shows "(bs, x) \<approx>gen R f 0 (bs, x)"
  using a by (simp add: alpha_gen fresh_star_def fresh_zero_perm)

lemma alpha_gen_sym:
  assumes a: "(bs, x) \<approx>gen R f p (cs, y)"
  and     b: "R (p \<bullet> x) y \<Longrightarrow> R (- p \<bullet> y) x"
  shows "(cs, y) \<approx>gen R f (- p) (bs, x)"
  using a b by (simp add: alpha_gen fresh_star_def fresh_def supp_minus_perm)

lemma alpha_gen_trans:
  assumes a: "(bs, x) \<approx>gen R f p1 (cs, y)"
  and     b: "(cs, y) \<approx>gen R f p2 (ds, z)"
  and     c: "\<lbrakk>R (p1 \<bullet> x) y; R (p2 \<bullet> y) z\<rbrakk> \<Longrightarrow> R ((p2 + p1) \<bullet> x) z"
  shows "(bs, x) \<approx>gen R f (p2 + p1) (ds, z)"
  using a b c using supp_plus_perm
  apply(simp add: alpha_gen fresh_star_def fresh_def)
  apply(blast)
  done

lemma alpha_gen_eqvt:
  assumes a: "(bs, x) \<approx>gen R f q (cs, y)"
  and     b: "R (q \<bullet> x) y \<Longrightarrow> R (p \<bullet> (q \<bullet> x)) (p \<bullet> y)"
  and     c: "p \<bullet> (f x) = f (p \<bullet> x)"
  and     d: "p \<bullet> (f y) = f (p \<bullet> y)"
  shows "(p \<bullet> bs, p \<bullet> x) \<approx>gen R f (p \<bullet> q) (p \<bullet> cs, p \<bullet> y)"
  using a b
  apply(simp add: alpha_gen c[symmetric] d[symmetric] Diff_eqvt[symmetric])
  apply(simp add: permute_eqvt[symmetric])
  apply(simp add: fresh_star_permute_iff)
  apply(clarsimp)
  done

fun
  alpha_rabst :: "('a::pt) rabst \<Rightarrow> 'a rabst \<Rightarrow> bool" ("_ \<approx>raw _") 
where
  "(RAbst bs x) \<approx>raw (RAbst cs y) = (\<exists>p. (bs, x) \<approx>gen (op=) supp p (cs, y))" 

lemma alpha_reflp:
  shows "abst \<approx>raw abst"
apply(induct abst)
apply(simp)
apply(rule exI)
apply(rule alpha_gen_refl)
apply(simp)
done

lemma alpha_symp:
  assumes a: "abst1 \<approx>raw abst2"
  shows "abst2 \<approx>raw abst1"
using a
apply(induct rule: alpha_rabst.induct)
apply(simp)
apply(erule exE)
apply(rule exI)
apply(rule alpha_gen_sym)
apply(assumption)
apply(clarsimp)
done

lemma alpha_transp:
  assumes a1: "abst1 \<approx>raw abst2"
  and     a2: "abst2 \<approx>raw abst3"
  shows "abst1 \<approx>raw abst3"
using a1 a2
apply(induct rule: alpha_rabst.induct)
apply(induct rule: alpha_rabst.induct)
apply(simp)
apply(erule exE)+
apply(rule exI)
apply(rule alpha_gen_trans)
apply(assumption)
apply(assumption)
apply(simp)
done

lemma alpha_eqvt:
  assumes a: "abst1 \<approx>raw abst2"
  shows "(p \<bullet> abst1) \<approx>raw(p \<bullet> abst2)"
using a
apply(induct abst1 abst2 rule: alpha_rabst.induct)
apply(simp)
apply(erule exE)
apply(rule exI)
apply(rule alpha_gen_eqvt)
apply(assumption)
apply(simp)
apply(simp add: supp_eqvt)
apply(simp add: supp_eqvt)
done

lemma test1:
  assumes a1: "a \<notin> (supp x) - bs"
  and     a2: "b \<notin> (supp x) - bs"
  shows "(RAbst bs x) \<approx>raw (RAbst ((a \<rightleftharpoons> b) \<bullet> bs) ((a \<rightleftharpoons> b) \<bullet> x))"
apply(simp)
apply(rule_tac x="(a \<rightleftharpoons> b)" in exI)
apply(simp add: alpha_gen)
apply(simp add: supp_eqvt[symmetric] Diff_eqvt[symmetric])
apply(simp add: swap_set_fresh[OF a1 a2])
apply(subgoal_tac "supp (a \<rightleftharpoons> b) \<subseteq> {a, b}")
using a1 a2
apply(simp add: fresh_star_def fresh_def)
apply(blast)
apply(simp add: supp_swap)
done

fun
  s_test
where
  "s_test (RAbst bs x) = (supp x) - bs"

lemma s_test_lemma:
  assumes a: "x \<approx>raw y" 
  shows "s_test x = s_test y"
using a
apply(induct rule: alpha_rabst.induct)
apply(simp add: alpha_gen)
done
  

quotient_type 'a abst = "('a::pt) rabst" / "alpha_rabst::('a::pt) rabst \<Rightarrow> 'a rabst \<Rightarrow> bool"
  apply(rule equivpI)
  unfolding reflp_def symp_def transp_def
  apply(auto intro: alpha_reflp alpha_symp alpha_transp)
  done

quotient_definition
   "Abst::atom set \<Rightarrow> ('a::pt) \<Rightarrow> 'a abst"
as
   "RAbst"

lemma [quot_respect]:
  shows "((op =) ===> (op =) ===> alpha_rabst) RAbst RAbst"
apply(simp del: alpha_rabst.simps add: alpha_reflp)
done

lemma [quot_respect]:
  shows "((op =) ===> alpha_rabst ===> alpha_rabst) permute permute"
apply(simp add: alpha_eqvt)
done

lemma [quot_respect]:
  shows "(alpha_rabst ===> (op =)) s_test s_test"
apply(simp add: s_test_lemma)
done

lemma abst_induct:
  "\<lbrakk>\<And>as (x::'a::pt). P (Abst as x)\<rbrakk> \<Longrightarrow> P t"
apply(lifting rabst.induct)
done

instantiation abst :: (pt) pt
begin

quotient_definition
  "permute_abst::perm \<Rightarrow> ('a::pt abst) \<Rightarrow> 'a abst"
as
  "permute::perm \<Rightarrow> ('a::pt rabst) \<Rightarrow> 'a rabst"

lemma permute_ABS [simp]:
  fixes x::"'a::pt"  (* ??? has to be 'a \<dots> 'b does not work *)
  shows "(p \<bullet> (Abst as x)) = Abst (p \<bullet> as) (p \<bullet> x)"
apply(lifting permute_rabst.simps(1))
done

instance
  apply(default)
  apply(induct_tac [!] x rule: abst_induct)
  apply(simp_all)
  done

end

lemma test1_lifted:
  assumes a1: "a \<notin> (supp x) - bs"
  and     a2: "b \<notin> (supp x) - bs"
  shows "(Abst bs x) = (Abst ((a \<rightleftharpoons> b) \<bullet> bs) ((a \<rightleftharpoons> b) \<bullet> x))"
using a1 a2
apply(lifting test1)
done

lemma Abst_supports:
  shows "((supp x) - as) supports (Abst as x)"
unfolding supports_def
apply(clarify)
apply(simp (no_asm))
apply(subst test1_lifted[symmetric])
apply(simp_all)
done

quotient_definition
  "s_test_lifted :: ('a::pt) abst \<Rightarrow> atom \<Rightarrow> bool"
as
  "s_test::('a::pt) rabst \<Rightarrow> atom \<Rightarrow> bool"

lemma s_test_lifted_simp:
  shows "s_test_lifted (Abst bs x) = (supp x) - bs"
apply(lifting s_test.simps(1))
done

lemma s_test_lifted_eqvt:
  shows "(p \<bullet> (s_test_lifted ab)) = s_test_lifted (p \<bullet> ab)"
apply(induct ab rule: abst_induct)
apply(simp add: s_test_lifted_simp supp_eqvt Diff_eqvt)
done

lemma fresh_f_empty_supp:
  assumes a: "\<forall>p. p \<bullet> f = f"
  shows "a \<sharp> x \<Longrightarrow> a \<sharp> (f x)"
apply(simp add: fresh_def)
apply(simp add: supp_def)
apply(simp add: permute_fun_app_eq)
apply(simp add: a)
apply(rule finite_subset)
prefer 2
apply(assumption)
apply(auto)
done


lemma s_test_fresh_lemma:
  shows "(a \<sharp> Abst bs x) \<Longrightarrow> (a \<sharp> s_test_lifted (Abst bs x))"
apply(rule fresh_f_empty_supp)
apply(rule allI)
apply(subst permute_fun_def)
apply(simp add: s_test_lifted_eqvt)
apply(simp)
done

lemma supp_finite_set:
  fixes S::"atom set"
  assumes "finite S"
  shows "supp S = S"
  apply(rule finite_supp_unique)
  apply(simp add: supports_def)
  apply(auto simp add: permute_set_eq swap_atom)[1]
  apply(metis)
  apply(rule assms)
  apply(auto simp add: permute_set_eq swap_atom)[1]
done

lemma s_test_subset:
  fixes x::"'a::fs"
  shows "((supp x) - as) \<subseteq> (supp (Abst as x))"
apply(rule subsetI)
apply(rule contrapos_pp)
apply(assumption)
unfolding fresh_def[symmetric]
apply(drule_tac s_test_fresh_lemma)
apply(simp only: s_test_lifted_simp)
apply(simp add: fresh_def)
apply(subgoal_tac "finite (supp x - as)")
apply(simp add: supp_finite_set)
apply(simp add: finite_supp)
done

lemma supp_Abst:
  fixes x::"'a::fs"
  shows "supp (Abst as x) = (supp x) - as"
apply(rule subset_antisym)
apply(rule supp_is_subset)
apply(rule Abst_supports)
apply(simp add: finite_supp)
apply(rule s_test_subset)
done

instance abst :: (fs) fs
apply(default)
apply(induct_tac x rule: abst_induct)
apply(simp add: supp_Abst)
apply(simp add: finite_supp)
done

lemma fresh_abs:
  fixes x::"'a::fs"
  shows "a \<sharp> Abst bs x = (a \<in> bs \<or> (a \<notin> bs \<and> a \<sharp> x))"
apply(simp add: fresh_def)
apply(simp add: supp_Abst)
apply(auto)
done

thm alpha_rabst.simps(1)

lemma abs_eq:
  shows "(Abst bs x) = (Abst cs y) \<longleftrightarrow> (\<exists>p. (bs, x) \<approx>gen (op =) supp p (cs, y))"
apply(lifting alpha_rabst.simps(1))
done

end

