theory SingleLet
imports "../NewParser"
begin

atom_decl name

declare [[STEPS = 16]]

nominal_datatype trm  =
  Var "name"
| App "trm" "trm"
| Lam x::"name" t::"trm"  bind_set x in t
| Let a::"assg" t::"trm"  bind_set "bn a" in t
| Foo x::"name" y::"name" t::"trm" t1::"trm" t2::"trm" bind_set x in y t t1 t2
| Bar x::"name" y::"name" t::"trm" bind y x in t x y
| Baz x::"name" t1::"trm" t2::"trm" bind x in t1, bind x in t2 
and assg =
  As "name" x::"name" t::"trm" bind x in t
binder
  bn::"assg \<Rightarrow> atom set"
where
  "bn (As x y t) = {atom x}"

typ trm
typ assg
term Var 
term App
term Baz
term bn
term fv_trm

lemma [quot_respect]: 
  "(op =  ===> alpha_trm_raw) Var_raw Var_raw"
  "(alpha_trm_raw ===> alpha_trm_raw ===> alpha_trm_raw) App_raw App_raw"
apply(auto)
apply(rule alpha_trm_raw_alpha_assg_raw_alpha_bn_raw.intros)
apply(rule refl)
apply(rule alpha_trm_raw_alpha_assg_raw_alpha_bn_raw.intros)
apply(assumption)
apply(assumption)
done



lemma "Var x \<noteq> App y1 y2"
apply(descending)
apply(simp add: trm_raw.distinct)



ML {*
  map (lift_thm [@{typ trm}, @{typ assg}] @{context}) @{thms trm_raw.distinct(1)}
*}




typ trm
typ assg

thm trm_assg.fv
thm trm_assg.supp
thm trm_assg.eq_iff
thm trm_assg.bn
thm trm_assg.perm
thm trm_assg.induct
thm trm_assg.inducts
thm trm_assg.distinct
ML {* Sign.of_sort @{theory} (@{typ trm}, @{sort fs}) *}

(* TEMPORARY
thm trm_assg.fv[simplified trm_assg.supp(1-2)]
*)

end



