theory Abs
imports "Nominal2_Atoms" "Nominal2_Eqvt" "Nominal2_Supp" "Quotient" "Quotient_Product"
begin

lemma permute_boolI:
  fixes P::"bool"
  shows "p \<bullet> P \<Longrightarrow> P"
apply(simp add: permute_bool_def)
done

lemma permute_boolE:
  fixes P::"bool"
  shows "P \<Longrightarrow> p \<bullet> P"
apply(simp add: permute_bool_def)
done

fun
  alpha_tst
where
  alpha_tst[simp del]:
  "alpha_tst (bs, x) R bv bv' fv p (cs, y) \<longleftrightarrow> 
     fv x - bv bs = fv y - bv' cs \<and> 
     (fv x - bv bs) \<sharp>* p \<and> 
     R (p \<bullet> x) y \<and> 
     (p \<bullet> bv bs) = bv' cs"

notation
  alpha_tst ("_ \<approx>tst _ _ _ _ _ _" [100, 100, 100, 100, 100, 100] 100)

(*
fun
  alpha_tst_rec
where
  alpha_tst_rec[simp del]:
  "alpha_tst_rec (bs, x) R1 R2 bv fv p (cs, y) \<longleftrightarrow> 
     fv x - bv bs = fv y - bv cs \<and> 
     (fv x - bv bs) \<sharp>* p \<and> 
     R1 (p \<bullet> x) y \<and> 
     R2 (p \<bullet> bs) cs \<and> 
     (p \<bullet> bv bs) = bv cs"

notation
  alpha_tst_rec ("_ \<approx>tstrec _ _ _ _ _ _" [100, 100, 100, 100, 100, 100] 100)
*)

fun
  alpha_gen 
where
  alpha_gen[simp del]:
  "alpha_gen (bs, x) R fv pi (cs, y) \<longleftrightarrow> 
     fv x - bs = fv y - cs \<and> (fv x - bs) \<sharp>* pi \<and> R (pi \<bullet> x) y \<and> pi \<bullet> bs = cs"

notation
  alpha_gen ("_ \<approx>gen _ _ _ _" [100, 100, 100, 100, 100] 100)

fun
  alpha_res
where
  alpha_res[simp del]:
  "alpha_res (bs, x) R fv pi (cs, y) \<longleftrightarrow> 
     fv x - bs = fv y - cs \<and> (fv x - bs) \<sharp>* pi \<and> R (pi \<bullet> x) y"

notation
  alpha_res ("_ \<approx>res _ _ _ _" [100, 100, 100, 100, 100] 100)

fun
  alpha_lst
where
  alpha_lst[simp del]:
  "alpha_lst (bs, x) R fv pi (cs, y) \<longleftrightarrow> 
     fv x - set bs = fv y - set cs \<and> (fv x - set bs) \<sharp>* pi \<and> R (pi \<bullet> x) y"

notation
  alpha_lst ("_ \<approx>lst _ _ _ _" [100, 100, 100, 100, 100] 100)


lemma [mono]: 
  shows "R1 \<le> R2 \<Longrightarrow> alpha_gen x R1 \<le> alpha_gen x R2"
  and   "R1 \<le> R2 \<Longrightarrow> alpha_res x R1 \<le> alpha_res x R2"
apply(case_tac [!] x) 
apply(auto simp add: le_fun_def le_bool_def alpha_gen.simps alpha_res.simps)
done

lemma alpha_gen_refl:
  assumes a: "R x x"
  shows "(bs, x) \<approx>gen R fv 0 (bs, x)"
  using a by (simp add: alpha_gen fresh_star_def fresh_zero_perm)

lemma alpha_gen_refl_tst:
  assumes a: "R1 x x" "bv bs = bv' bs"
  shows "(bs, x) \<approx>tst R1 bv bv' fv 0 (bs, x)"
  using a 
  apply (simp add: alpha_tst fresh_star_def fresh_zero_perm)
  done
  

lemma alpha_gen_sym:
  assumes a: "(bs, x) \<approx>gen R fv p (cs, y)"
  and     b: "R (p \<bullet> x) y \<Longrightarrow> R (- p \<bullet> y) x"
  shows "(cs, y) \<approx>gen R fv (- p) (bs, x)"
  using a
  apply(auto simp add: alpha_gen fresh_star_def fresh_def supp_minus_perm)
  apply(simp add: b)
  done  
  
lemma alpha_gen_sym_tst:
  assumes a: "(bs, x) \<approx>tst R1 bv bv' fv p (cs, y)"
  and     b: "R1 (p \<bullet> x) y \<Longrightarrow> R1 (- p \<bullet> y) x"
  shows "(cs, y) \<approx>tst R1 bv' bv fv (- p) (bs, x)"
  using a
  apply(auto simp add: alpha_tst fresh_star_def fresh_def supp_minus_perm)
  apply(simp add: b)
  apply(rule_tac p="p" in permute_boolI)
  apply(simp add: mem_eqvt)
  apply(rule_tac p="- p" in permute_boolI)
  apply(simp add: mem_eqvt)
  apply(rotate_tac 3)
  apply(drule sym)
  apply(simp)
  done  

lemma alpha_gen_trans:
  assumes a: "(bs, x) \<approx>gen R fv p (cs, y)"
  and     b: "(cs, y) \<approx>gen R fv q (ds, z)"
  and     c: "\<lbrakk>R (p \<bullet> x) y; R (q \<bullet> y) z\<rbrakk> \<Longrightarrow> R ((q + p) \<bullet> x) z"
  shows "(bs, x) \<approx>gen R fv (q + p) (ds, z)"
  using a b c 
  using supp_plus_perm
  apply(simp add: alpha_gen fresh_star_def fresh_def)
  apply(blast)
  done

lemma alpha_gen_trans_tst:
  assumes a: "(bs, x) \<approx>tst R1 bv bv' fv p (cs, y)"
  and     b: "(cs, y) \<approx>tst R1 bv' bv'' fv q (ds, z)"
  and     c: "\<lbrakk>R1 (p \<bullet> x) y; R1 (q \<bullet> y) z\<rbrakk> \<Longrightarrow> R1 ((q + p) \<bullet> x) z"
  shows "(bs, x) \<approx>tst R1 bv bv'' fv (q + p) (ds, z)"
  using a b c
  using supp_plus_perm
  apply(simp add: alpha_tst fresh_star_def fresh_def)
  apply(blast)
  done

lemma alpha_gen_eqvt:
  assumes a: "(bs, x) \<approx>gen R f q (cs, y)"
  and     b: "R (q \<bullet> x) y \<Longrightarrow> R (p \<bullet> (q \<bullet> x)) (p \<bullet> y)"
  and     c: "p \<bullet> (f x) = f (p \<bullet> x)"
  and     d: "p \<bullet> (f y) = f (p \<bullet> y)"
  shows "(p \<bullet> bs, p \<bullet> x) \<approx>gen R f (p \<bullet> q) (p \<bullet> cs, p \<bullet> y)"
  using a b
  apply(simp add: alpha_gen c[symmetric] d[symmetric] Diff_eqvt[symmetric])
  apply(simp add: permute_eqvt[symmetric])
  apply(simp add: fresh_star_permute_iff)
  apply(clarsimp)
  done

lemma alpha_gen_eqvt_tst:
  assumes a: "(bs, x) \<approx>tst R1 bv bv' fv q (cs, y)"
  and     b1: "R1 (q \<bullet> x) y \<Longrightarrow> R1 (p \<bullet> (q \<bullet> x)) (p \<bullet> y)"
  and     c: "p \<bullet> (fv x) = fv (p \<bullet> x)"
  and     d: "p \<bullet> (fv y) = fv (p \<bullet> y)"
  and     e: "p \<bullet> (bv bs) = bv (p \<bullet> bs)"
  and     f: "p \<bullet> (bv cs) = bv (p \<bullet> cs)"
  and     e': "p \<bullet> (bv' bs) = bv' (p \<bullet> bs)"
  and     f': "p \<bullet> (bv' cs) = bv' (p \<bullet> cs)"
  shows "(p \<bullet> bs, p \<bullet> x) \<approx>tst R1 bv bv' fv (p \<bullet> q) (p \<bullet> cs, p \<bullet> y)"
  using a b1
  apply(simp add: alpha_tst c[symmetric] d[symmetric] 
    e'[symmetric] f'[symmetric] e[symmetric] f[symmetric] Diff_eqvt[symmetric])
  apply(simp add: permute_eqvt[symmetric])
  apply(simp add: fresh_star_permute_iff)
  apply(clarsimp)
  done

fun
  alpha_abs 
where
  "alpha_abs (bs, x) (cs, y) \<longleftrightarrow> (\<exists>p. (bs, x) \<approx>gen (op=) supp p (cs, y))"

notation
  alpha_abs ("_ \<approx>abs _")

fun
  alpha_abs_tst
where
  "alpha_abs_tst (bv, bs, x) (bv',cs, y) \<longleftrightarrow> (\<exists>p. (bs, x) \<approx>tst (op=) bv bv' supp p (cs, y))"

notation
  alpha_abs_tst ("_ \<approx>abstst _")

lemma alpha_abs_swap:
  assumes a1: "a \<notin> (supp x) - bs"
  and     a2: "b \<notin> (supp x) - bs"
  shows "(bs, x) \<approx>abs ((a \<rightleftharpoons> b) \<bullet> bs, (a \<rightleftharpoons> b) \<bullet> x)"
  apply(simp)
  apply(rule_tac x="(a \<rightleftharpoons> b)" in exI)
  unfolding alpha_gen
  apply(simp)
  apply(simp add: supp_eqvt[symmetric] Diff_eqvt[symmetric])
  apply(simp add: swap_set_not_in[OF a1 a2])
  apply(subgoal_tac "supp (a \<rightleftharpoons> b) \<subseteq> {a, b}")
  using a1 a2
  apply(simp add: fresh_star_def fresh_def)
  apply(blast)
  apply(simp add: supp_swap)
  done

lemma alpha_abs_tst_swap:
  assumes a1: "a \<notin> (supp x) - bv bs"
  and     a2: "b \<notin> (supp x) - bv bs"
  shows "(bv, bs, x) \<approx>abstst ((a \<rightleftharpoons> b) \<bullet> bv, (a \<rightleftharpoons> b) \<bullet> bs, (a \<rightleftharpoons> b) \<bullet> x)"
  apply(simp)
  apply(rule_tac x="(a \<rightleftharpoons> b)" in exI)
  unfolding alpha_tst
  apply(simp)
  apply(simp add: supp_eqvt[symmetric] Diff_eqvt[symmetric] eqvt_apply[symmetric])
  apply(simp add: swap_set_not_in[OF a1 a2])
  apply(subgoal_tac "supp (a \<rightleftharpoons> b) \<subseteq> {a, b}")
  using a1 a2
  apply(simp add: fresh_star_def fresh_def)
  apply(blast)
  apply(simp add: supp_swap)
  done

fun
  supp_abs_fun
  where
  "supp_abs_fun (bs, x) = (supp x) - bs"

fun
  supp_abstst_fun::"('b::pt \<Rightarrow> atom set) \<times> 'b \<times> ('a::pt) \<Rightarrow> atom set" 
  where
  "supp_abstst_fun (bv, bs, x) = (supp x - bv bs)"

lemma supp_abs_fun_lemma:
  assumes a: "x \<approx>abs y" 
  shows "supp_abs_fun x = supp_abs_fun y"
  using a
  apply(induct rule: alpha_abs.induct)
  apply(simp add: alpha_gen)
  done

lemma supp_abstst_fun_lemma:
  assumes a: "(bv, bs, x) \<approx>abstst (bv', cs, y)"
  shows "supp_abstst_fun (bv, bs, x) = supp_abstst_fun (bv', cs, y)"
  using a
  apply(induct x\<equiv>"(bv, bs, x)" y\<equiv>"(bv', cs, y)" rule: alpha_abs_tst.induct)
  apply(simp add: alpha_tst)
  done
  
quotient_type 'a abs = "(atom set \<times> 'a::pt)" / "alpha_abs"
  apply(rule equivpI)
  unfolding reflp_def symp_def transp_def
  apply(simp_all)
  (* refl *)
  apply(clarify)
  apply(rule exI)
  apply(rule alpha_gen_refl)
  apply(simp)
  (* symm *)
  apply(clarify)
  apply(rule exI)
  apply(rule alpha_gen_sym)
  apply(assumption)
  apply(clarsimp)
  (* trans *)
  apply(clarify)
  apply(rule exI)
  apply(rule alpha_gen_trans)
  apply(assumption)
  apply(assumption)
  apply(simp)
  done

quotient_type ('a,'b) abs_tst = "(('a \<Rightarrow>atom set) \<times> 'a::pt \<times> 'b::pt)" / "alpha_abs_tst"
  apply(rule equivpI)
  unfolding reflp_def symp_def transp_def
  apply(simp_all)
  (* refl *)
  apply(clarify)
  apply(rule exI)
  apply(rule alpha_gen_refl_tst)
  apply(simp)
  apply(simp)
  (* symm *)
  apply(clarify)
  apply(rule exI)
  apply(rule alpha_gen_sym_tst)
  apply(assumption)
  apply(clarsimp)
  (* trans *)
  apply(clarify)
  apply(rule exI)
  apply(rule alpha_gen_trans_tst)
  apply(assumption)
  apply(assumption)
  apply(simp)
  done

quotient_definition
  "Abs::atom set \<Rightarrow> ('a::pt) \<Rightarrow> 'a abs"
is
  "Pair::atom set \<Rightarrow> ('a::pt) \<Rightarrow> (atom set \<times> 'a)"

fun
  Pair_tst
where
  "Pair_tst a b c = (a, b, c)"

quotient_definition
  "Abs_tst::('b::pt \<Rightarrow> atom set) \<Rightarrow> 'b \<Rightarrow> ('a::pt) \<Rightarrow> ('b, 'a) abs_tst"
is
  "Pair_tst::('b::pt \<Rightarrow> atom set) \<Rightarrow> 'b \<Rightarrow> ('a::pt) \<Rightarrow> (('b \<Rightarrow> atom set) \<times> 'b \<times> 'a)"

lemma [quot_respect]:
  shows "((op =) ===> (op =) ===> alpha_abs) Pair Pair"
  apply(clarsimp)
  apply(rule exI)
  apply(rule alpha_gen_refl)
  apply(simp)
  done

lemma [quot_respect]:
  shows "((op =) ===> (op =) ===> (op =) ===> alpha_abs_tst) Pair_tst Pair_tst"
  apply(clarsimp)
  apply(rule exI)
  apply(rule alpha_gen_refl_tst)
  apply(simp_all)
  done

lemma [quot_respect]:
  shows "((op =) ===> (op =) ===> (op =) ===> alpha_abs_tst) Pair_tst Pair_tst"
  apply(clarsimp)
  apply(rule exI)
  apply(rule alpha_gen_refl_tst)
  apply(simp_all)
  done

lemma [quot_respect]:
  shows "((op =) ===> alpha_abs ===> alpha_abs) permute permute"
  apply(clarsimp)
  apply(rule exI)
  apply(rule alpha_gen_eqvt)
  apply(assumption)
  apply(simp_all add: supp_eqvt)
  done

lemma [quot_respect]:
  shows "(alpha_abs ===> (op =)) supp_abs_fun supp_abs_fun"
  apply(simp add: supp_abs_fun_lemma)
  done

lemma [quot_respect]:
  shows "(alpha_abs_tst ===> (op =)) supp_abstst_fun supp_abstst_fun"
  apply(simp)
  apply(clarify)
  apply(simp add: alpha_tst.simps)
  sorry


lemma abs_induct:
  "\<lbrakk>\<And>as (x::'a::pt). P (Abs as x)\<rbrakk> \<Longrightarrow> P t"
  apply(lifting prod.induct[where 'a="atom set" and 'b="'a"])
  done

lemma abs_tst_induct:
  "\<lbrakk>\<And>bv as (x::'a::pt). P (Abs_tst bv as x)\<rbrakk> \<Longrightarrow> P t"
  sorry

(* TEST case *)
lemmas abs_induct2 = prod.induct[where 'a="atom set" and 'b="'a::pt", quot_lifted]
thm abs_induct abs_induct2

instantiation abs :: (pt) pt
begin

quotient_definition
  "permute_abs::perm \<Rightarrow> ('a::pt abs) \<Rightarrow> 'a abs"
is
  "permute:: perm \<Rightarrow> (atom set \<times> 'a::pt) \<Rightarrow> (atom set \<times> 'a::pt)"

lemma permute_ABS [simp]:
  fixes x::"'a::pt"  (* ??? has to be 'a \<dots> 'b does not work *)
  shows "(p \<bullet> (Abs as x)) = Abs (p \<bullet> as) (p \<bullet> x)"
  by (lifting permute_prod.simps(1)[where 'a="atom set" and 'b="'a"])

instance
  apply(default)
  apply(induct_tac [!] x rule: abs_induct)
  apply(simp_all)
  done

end

instantiation abs_tst :: (pt, pt) pt
begin

quotient_definition
  "permute_abs_tst::perm \<Rightarrow> (('a::pt, 'b::pt) abs_tst) \<Rightarrow> ('a, 'b) abs_tst"
is
  "permute:: perm \<Rightarrow> ((('a::pt) \<Rightarrow> atom set) \<times> 'a \<times> 'b::pt) \<Rightarrow> (('a \<Rightarrow> atom set) \<times> 'a \<times> 'b)"

lemma permute_ABS_tst [simp]:
  fixes x::"'a::pt"  
  shows "(p \<bullet> (Abs_tst bv as x)) = Abs_tst (p \<bullet> bv) (p \<bullet> as) (p \<bullet> x)"
  sorry

instance
  apply(default)
  apply(induct_tac [!] x rule: abs_tst_induct)
  apply(simp_all)
  done

end

quotient_definition
  "supp_Abs_fun :: ('a::pt) abs \<Rightarrow> atom \<Rightarrow> bool"
is
  "supp_abs_fun"

term supp_abstst_fun

quotient_definition
  "supp_Abstst_fun :: ('a::pt, 'b::pt) abs_tst \<Rightarrow> atom \<Rightarrow> bool"
is
  "supp_abstst_fun :: (('a::pt \<Rightarrow> atom \<Rightarrow> bool) \<times> 'a \<times> 'b::pt) \<Rightarrow> atom \<Rightarrow> bool"
(* leave out type *)

lemma supp_Abs_fun_simp:
  shows "supp_Abs_fun (Abs bs x) = (supp x) - bs"
  by (lifting supp_abs_fun.simps(1))
thm supp_abs_fun.simps(1)

term supp_Abs_fun
term supp_Abstst_fun

lemma supp_Abs_tst_fun_simp:
  fixes bv::"'b::pt \<Rightarrow> atom set"
  shows "supp_Abstst_fun (Abs_tst bv bs x) = (supp x) - (bv bs)"
sorry
(* PROBLEM: regularisation fails
  by (lifting supp_abstst_fun.simps(1))
*)


lemma supp_Abs_fun_eqvt [eqvt]:
  shows "(p \<bullet> supp_Abs_fun x) = supp_Abs_fun (p \<bullet> x)"
  apply(induct_tac x rule: abs_induct)
  apply(simp add: supp_Abs_fun_simp supp_eqvt Diff_eqvt)
  done

lemma supp_Abs_test_fun_eqvt [eqvt]:
  shows "(p \<bullet> supp_Abstst_fun x) = supp_Abstst_fun (p \<bullet> x)"
  apply(induct_tac x rule: abs_tst_induct)
  apply(simp add: supp_Abs_tst_fun_simp supp_eqvt Diff_eqvt)
  apply(simp add: eqvt_apply)
  done

lemma supp_Abs_fun_fresh:
  shows "a \<sharp> Abs bs x \<Longrightarrow> a \<sharp> supp_Abs_fun (Abs bs x)"
  apply(rule fresh_fun_eqvt_app)
  apply(simp add: eqvts_raw)
  apply(simp)
  done


lemma supp_Abs_tst_fun_fresh:
  shows "a \<sharp> Abs_tst bv bs x \<Longrightarrow> a \<sharp> supp_Abstst_fun (Abs_tst bv bs x)"
  apply(rule fresh_fun_eqvt_app)
  apply(simp add: eqvts_raw)
  apply(simp)
  done

lemma Abs_swap:
  assumes a1: "a \<notin> (supp x) - bs"
  and     a2: "b \<notin> (supp x) - bs"
  shows "(Abs bs x) = (Abs ((a \<rightleftharpoons> b) \<bullet> bs) ((a \<rightleftharpoons> b) \<bullet> x))"
  using a1 a2 
  by (lifting alpha_abs_swap)

thm alpha_abs_swap
thm alpha_abs_tst_swap

lemma Abs_tst_swap:
  assumes a1: "a \<notin> (supp x) - bv bs"
  and     a2: "b \<notin> (supp x) - bv bs"
  shows "(Abs_tst bv bs x) = (Abs_tst ((a \<rightleftharpoons> b) \<bullet> bv) ((a \<rightleftharpoons> b) \<bullet> bs) ((a \<rightleftharpoons> b) \<bullet> x))"
  using a1 a2
  sorry
(* PROBLEM
  by (lifting alpha_abs_tst_swap)
*)

lemma Abs_supports:
  shows "(supp x - as) supports (Abs as x)"
  unfolding supports_def
  apply(clarify)
  apply(simp (no_asm))
  apply(subst Abs_swap[symmetric])
  apply(simp_all)
  done

lemma Abs_tst_supports:
  shows "(supp x - bv as) supports (Abs_tst bv as x)"
  unfolding supports_def
  apply(clarify)
  apply(simp (no_asm))
  apply(subst Abs_tst_swap[symmetric])
  apply(simp_all)
  done

lemma supp_Abs_subset1:
  fixes x::"'a::fs"
  shows "(supp x) - as \<subseteq> supp (Abs as x)"
  apply(simp add: supp_conv_fresh)
  apply(auto)
  apply(drule_tac supp_Abs_fun_fresh)
  apply(simp only: supp_Abs_fun_simp)
  apply(simp add: fresh_def)
  apply(simp add: supp_finite_atom_set finite_supp)
  done

lemma supp_Abs_tst_subset1:
  fixes x::"'a::fs"
  shows "(supp x - bv as) \<subseteq> supp (Abs_tst bv as x)"
  apply(simp add: supp_conv_fresh)
  apply(auto)
  apply(drule_tac supp_Abs_tst_fun_fresh)
  apply(simp only: supp_Abs_tst_fun_simp)
  apply(simp add: fresh_def)
  apply(simp add: supp_finite_atom_set finite_supp)
  done

lemma supp_Abs_subset2:
  fixes x::"'a::fs"
  shows "supp (Abs as x) \<subseteq> (supp x) - as"
  apply(rule supp_is_subset)
  apply(rule Abs_supports)
  apply(simp add: finite_supp)
  done

lemma supp_Abs_tst_subset2:
  fixes x::"'a::fs"
  shows "supp (Abs_tst bv as x) \<subseteq> (supp x - bv as)"
  apply(rule supp_is_subset)
  apply(rule Abs_tst_supports)
  apply(simp add: finite_supp)
  done

lemma supp_Abs:
  fixes x::"'a::fs"
  shows "supp (Abs as x) = (supp x) - as"
  apply(rule_tac subset_antisym)
  apply(rule supp_Abs_subset2)
  apply(rule supp_Abs_subset1)
  done

lemma supp_Abs_tst:
  fixes x::"'a::fs"
  shows "supp (Abs_tst bv as x) = (supp x - bv as)"
  apply(rule_tac subset_antisym)
  apply(rule supp_Abs_tst_subset2)
  apply(rule supp_Abs_tst_subset1)
  done

instance abs :: (fs) fs
  apply(default)
  apply(induct_tac x rule: abs_induct)
  apply(simp add: supp_Abs)
  apply(simp add: finite_supp)
  done

instance abs_tst :: (pt, fs) fs
  apply(default)
  apply(induct_tac x rule: abs_tst_induct)
  apply(simp add: supp_Abs_tst)
  apply(simp add: finite_supp)
  done

lemma Abs_fresh_iff:
  fixes x::"'a::fs"
  shows "a \<sharp> Abs bs x \<longleftrightarrow> a \<in> bs \<or> (a \<notin> bs \<and> a \<sharp> x)"
  apply(simp add: fresh_def)
  apply(simp add: supp_Abs)
  apply(auto)
  done

lemma Abs_tst_fresh_iff:
  fixes x::"'a::fs"
  shows "a \<sharp> Abs_tst bv bs x \<longleftrightarrow> a \<in> bv bs \<or> (a \<notin> bv bs \<and> a \<sharp> x)"
  apply(simp add: fresh_def)
  apply(simp add: supp_Abs_tst)
  apply(auto)
  done

lemma Abs_eq_iff:
  shows "Abs bs x = Abs cs y \<longleftrightarrow> (\<exists>p. (bs, x) \<approx>gen (op =) supp p (cs, y))"
  by (lifting alpha_abs.simps(1))

term alpha_tst

lemma Abs_tst_eq_iff:
  shows "Abs_tst bv bs x = Abs_tst bv cs y \<longleftrightarrow> (\<exists>p. (bs, x) \<approx>tst (op =) bv bv supp p (cs, y))"
sorry
(* PROBLEM  
by (lifting alpha_abs_tst.simps(1))
*)


(* 
  below is a construction site for showing that in the
  single-binder case, the old and new alpha equivalence 
  coincide
*)

fun
  alpha1
where
  "alpha1 (a, x) (b, y) \<longleftrightarrow> (a = b \<and> x = y) \<or> (a \<noteq> b \<and> x = (a \<rightleftharpoons> b) \<bullet> y \<and> a \<sharp> y)"

notation 
  alpha1 ("_ \<approx>abs1 _")

lemma
  assumes a: "(a, x) \<approx>abs1 (b, y)" "sort_of a = sort_of b"
  shows "({a}, x) \<approx>abs ({b}, y)"
using a
apply(simp)
apply(erule disjE)
apply(simp)
apply(rule exI)
apply(rule alpha_gen_refl)
apply(simp)
apply(simp)
apply(rule_tac x="(a \<rightleftharpoons> b)" in  exI)
apply(simp add: alpha_gen)
apply(simp add: fresh_def)
apply(rule conjI)
apply(rule_tac p1="(a \<rightleftharpoons> b)" in  permute_eq_iff[THEN iffD1])
apply(rule trans)
apply(simp add: Diff_eqvt supp_eqvt)
apply(subst swap_set_not_in)
back
apply(simp)
apply(simp)
apply(simp add: permute_set_eq)
apply(simp add: eqvts)
apply(rule_tac p1="(a \<rightleftharpoons> b)" in fresh_star_permute_iff[THEN iffD1])
apply(simp add: permute_self)
apply(simp add: Diff_eqvt supp_eqvt)
apply(simp add: permute_set_eq)
apply(subgoal_tac "supp (a \<rightleftharpoons> b) \<subseteq> {a, b}")
apply(simp add: fresh_star_def fresh_def)
apply(blast)
apply(simp add: supp_swap)
done

lemma perm_zero:
  assumes a: "\<forall>x::atom. p \<bullet> x = x"
  shows "p = 0"
using a
by (simp add: expand_perm_eq)

fun
  add_perm 
where
  "add_perm [] = 0"
| "add_perm ((a, b) # xs) = (a \<rightleftharpoons> b) + add_perm xs"

fun
  elem_perm
where
  "elem_perm [] = {}"
| "elem_perm ((a, b) # xs) = {a, b} \<union> elem_perm xs"


lemma add_perm_apend:
  shows "add_perm (xs @ ys) = add_perm xs + add_perm ys"
apply(induct xs arbitrary: ys)
apply(auto simp add: add_assoc)
done

lemma perm_list_exists:
  fixes p::perm
  shows "\<exists>xs. p = add_perm xs \<and> supp xs \<subseteq> supp p"
apply(induct p taking: "\<lambda>p::perm. card (supp p)" rule: measure_induct)
apply(rename_tac p)
apply(case_tac "supp p = {}")
apply(simp)
apply(simp add: supp_perm)
apply(drule perm_zero)
apply(simp)
apply(rule_tac x="[]" in exI)
apply(simp add: supp_Nil)
apply(subgoal_tac "\<exists>x. x \<in> supp p")
defer
apply(auto)[1]
apply(erule exE)
apply(drule_tac x="p + (((- p) \<bullet> x) \<rightleftharpoons> x)" in spec)
apply(drule mp)
defer
apply(erule exE)
apply(rule_tac x="xs @ [((- p) \<bullet> x, x)]" in exI)
apply(simp add: add_perm_apend)
apply(erule conjE)
apply(drule sym)
apply(simp)
apply(simp add: expand_perm_eq)
apply(simp add: supp_append)
apply(simp add: supp_perm supp_Cons supp_Nil supp_Pair supp_atom)
apply(rule conjI)
prefer 2
apply(auto)[1]
apply (metis left_minus minus_unique permute_atom_def_raw permute_minus_cancel(2))
defer
apply(rule psubset_card_mono)
apply(simp add: finite_supp)
apply(rule psubsetI)
defer
apply(subgoal_tac "x \<notin> supp (p + (- p \<bullet> x \<rightleftharpoons> x))")
apply(blast)
apply(simp add: supp_perm)
defer
apply(auto simp add: supp_perm)[1]
apply(case_tac "x = xa")
apply(simp)
apply(case_tac "((- p) \<bullet> x) = xa")
apply(simp)
apply(case_tac "sort_of xa = sort_of x")
apply(simp)
apply(auto)[1]
apply(simp)
apply(simp)
apply(subgoal_tac "{a. p \<bullet> (- p \<bullet> x \<rightleftharpoons> x) \<bullet> a \<noteq> a} \<subseteq> {a. p \<bullet> a \<noteq> a}")
apply(blast)
apply(auto simp add: supp_perm)[1]
apply(case_tac "x = xa")
apply(simp)
apply(case_tac "((- p) \<bullet> x) = xa")
apply(simp)
apply(case_tac "sort_of xa = sort_of x")
apply(simp)
apply(auto)[1]
apply(simp)
apply(simp)
done

lemma tt0:
  fixes p::perm
  shows "(supp x) \<sharp>* p \<Longrightarrow> \<forall>a \<in> supp p. a \<sharp> x"
apply(auto simp add: fresh_star_def supp_perm fresh_def)
done

lemma uu0:
  shows "(\<forall>a \<in> elem_perm xs. a \<sharp> x) \<Longrightarrow> (add_perm xs \<bullet> x) = x"
apply(induct xs rule: add_perm.induct)
apply(simp)
apply(simp add: swap_fresh_fresh)
done

lemma yy0:
  fixes xs::"(atom \<times> atom) list"
  shows "supp xs = elem_perm xs"
apply(induct xs rule: elem_perm.induct)
apply(auto simp add: supp_Nil supp_Cons supp_Pair supp_atom)
done

lemma tt1:
  shows "(supp x) \<sharp>* p \<Longrightarrow> p \<bullet> x = x"
apply(drule tt0)
apply(subgoal_tac "\<exists>xs. p = add_perm xs \<and> supp xs \<subseteq> supp p")
prefer 2
apply(rule perm_list_exists)
apply(erule exE)
apply(simp only: yy0)
apply(rule uu0)
apply(auto)
done


lemma perm_induct_test:
  fixes P :: "perm => bool"
  assumes fin: "finite (supp p)" 
  assumes zero: "P 0"
  assumes swap: "\<And>a b. \<lbrakk>sort_of a = sort_of b; a \<noteq> b\<rbrakk> \<Longrightarrow> P (a \<rightleftharpoons> b)"
  assumes plus: "\<And>p1 p2. \<lbrakk>supp p1 \<inter> supp p2 = {}; P p1; P p2\<rbrakk> \<Longrightarrow> P (p1 + p2)"
  shows "P p"
using fin
apply(induct F\<equiv>"supp p" arbitrary: p rule: finite_induct)
apply(simp add: supp_perm)
apply(drule perm_zero)
apply(simp add: zero)
apply(rotate_tac 3)
oops

lemma yy:
  assumes "S1 - {x} = S2 - {x}" "x \<in> S1" "x \<in> S2"
  shows "S1 = S2"
using assms
apply (metis insert_Diff_single insert_absorb)
done

lemma kk:
  assumes a: "p \<bullet> x = y"
  shows "\<forall>a \<in> supp x. (p \<bullet> a) \<in> supp y"
using a
apply(auto)
apply(rule_tac p="- p" in permute_boolI)
apply(simp add: mem_eqvt supp_eqvt)
done

lemma ww:
  assumes "a \<notin> supp x" "b \<in> supp x" "a \<noteq> b" "sort_of a = sort_of b"
  shows "((a \<rightleftharpoons> b) \<bullet> x) \<noteq> x"
apply(subgoal_tac "(supp x) supports x")
apply(simp add: supports_def)
using assms
apply -
apply(drule_tac x="a" in spec)
defer
apply(rule supp_supports)
apply(auto)
apply(rotate_tac 1)
apply(drule_tac p="(a \<rightleftharpoons> b)" in permute_boolE)
apply(simp add: mem_eqvt supp_eqvt)
done

lemma alpha_abs_sym:
  assumes a: "({a}, x) \<approx>abs ({b}, y)"
  shows "({b}, y) \<approx>abs ({a}, x)"
using a
apply(simp)
apply(erule exE)
apply(rule_tac x="- p" in exI)
apply(simp add: alpha_gen)
apply(simp add: fresh_star_def fresh_minus_perm)
apply (metis permute_minus_cancel(2))
done

lemma alpha_abs_trans:
  assumes a: "({a1}, x1) \<approx>abs ({a2}, x2)"
  assumes b: "({a2}, x2) \<approx>abs ({a3}, x3)"
  shows "({a1}, x1) \<approx>abs ({a3}, x3)"
using a b
apply(simp)
apply(erule exE)+
apply(rule_tac x="pa + p" in exI)
apply(simp add: alpha_gen)
apply(simp add: fresh_star_def fresh_plus_perm)
done

lemma alpha_equal:
  assumes a: "({a}, x) \<approx>abs ({a}, y)" 
  shows "(a, x) \<approx>abs1 (a, y)"
using a
apply(simp)
apply(erule exE)
apply(simp add: alpha_gen)
apply(erule conjE)+
apply(case_tac "a \<notin> supp x")
apply(simp)
apply(subgoal_tac "supp x \<sharp>* p")
apply(drule tt1)
apply(simp)
apply(simp)
apply(simp)
apply(case_tac "a \<notin> supp y")
apply(simp)
apply(drule tt1)
apply(clarify)
apply(simp (no_asm_use))
apply(simp)
apply(simp)
apply(drule yy)
apply(simp)
apply(simp)
apply(simp)
apply(case_tac "a \<sharp> p")
apply(subgoal_tac "supp y \<sharp>* p")
apply(drule tt1)
apply(clarify)
apply(simp (no_asm_use))
apply(metis)
apply(auto simp add: fresh_star_def)[1]
apply(frule_tac kk)
apply(drule_tac x="a" in bspec)
apply(simp)
apply(simp add: fresh_def)
apply(simp add: supp_perm)
apply(subgoal_tac "((p \<bullet> a) \<sharp> p)")
apply(simp add: fresh_def supp_perm)
apply(simp add: fresh_star_def)
done

lemma alpha_unequal:
  assumes a: "({a}, x) \<approx>abs ({b}, y)" "sort_of a = sort_of b" "a \<noteq> b"
  shows "(a, x) \<approx>abs1 (b, y)"
using a
apply -
apply(subgoal_tac "a \<notin> supp x - {a}")
apply(subgoal_tac "b \<notin> supp x - {a}")
defer
apply(simp add: alpha_gen)
apply(simp)
apply(drule_tac alpha_abs_swap)
apply(assumption)
apply(simp only: insert_eqvt empty_eqvt swap_atom_simps)
apply(drule alpha_abs_sym)
apply(rotate_tac 4)
apply(drule_tac alpha_abs_trans)
apply(assumption)
apply(drule alpha_equal)
apply(simp)
apply(rule_tac p="(a \<rightleftharpoons> b)" in permute_boolI)
apply(simp add: fresh_eqvt)
apply(simp add: fresh_def)
done

lemma alpha_new_old:
  assumes a: "({a}, x) \<approx>abs ({b}, y)" "sort_of a = sort_of b" 
  shows "(a, x) \<approx>abs1 (b, y)"
using a
apply(case_tac "a=b")
apply(simp only: alpha_equal)
apply(drule alpha_unequal)
apply(simp)
apply(simp)
apply(simp)
done

(* support of concrete atom sets *)

lemma atom_eqvt_raw:
  fixes p::"perm"
  shows "(p \<bullet> atom) = atom"
by (simp add: expand_fun_eq permute_fun_def atom_eqvt)

lemma atom_image_cong:
  shows "(atom ` X = atom ` Y) = (X = Y)"
apply(rule inj_image_eq_iff)
apply(simp add: inj_on_def)
done

lemma supp_atom_image:
  fixes as::"'a::at_base set"
  shows "supp (atom ` as) = supp as"
apply(simp add: supp_def)
apply(simp add: image_eqvt)
apply(simp add: atom_eqvt_raw)
apply(simp add: atom_image_cong)
done

lemma swap_atom_image_fresh: 
  "\<lbrakk>a \<sharp> atom ` (fn :: ('a :: at_base set)); b \<sharp> atom ` fn\<rbrakk> \<Longrightarrow> (a \<rightleftharpoons> b) \<bullet> fn = fn"
apply (simp add: fresh_def)
apply (simp add: supp_atom_image)
apply (fold fresh_def)
apply (simp add: swap_fresh_fresh)
done


(******************************************************)
lemma alpha_gen_compose_sym:
  fixes pi
  assumes b: "(aa, t) \<approx>gen (\<lambda>x1 x2. R x1 x2 \<and> R x2 x1) f pi (ab, s)"
  and a: "\<And>pi t s. (R t s \<Longrightarrow> R (pi \<bullet> t) (pi \<bullet> s))"
  shows "(ab, s) \<approx>gen R f (- pi) (aa, t)"
  using b 
  apply -
  apply(simp add: alpha_gen.simps)
  apply(erule conjE)+
  apply(rule conjI)
  apply(simp add: fresh_star_def fresh_minus_perm)
  apply(subgoal_tac "R (- pi \<bullet> s) ((- pi) \<bullet> (pi \<bullet> t))")
  apply simp
  apply(clarsimp)
  apply(rule a)
  apply assumption
  done

lemma alpha_gen_compose_trans:
  fixes pi pia
  assumes b: "(aa, t) \<approx>gen (\<lambda>x1 x2. R x1 x2 \<and> (\<forall>x. R x2 x \<longrightarrow> R x1 x)) f pi (ab, ta)"
  and c: "(ab, ta) \<approx>gen R f pia (ac, sa)"
  and a: "\<And>pi t s. (R t s \<Longrightarrow> R (pi \<bullet> t) (pi \<bullet> s))"
  shows "(aa, t) \<approx>gen R f (pia + pi) (ac, sa)"
  using b c apply -
  apply(simp add: alpha_gen.simps)
  apply(erule conjE)+
  apply(simp add: fresh_star_plus)
  apply(drule_tac x="- pia \<bullet> sa" in spec)
  apply(drule mp)
  apply(rotate_tac 5)
  apply(drule_tac pi="- pia" in a)
  apply(simp)
  apply(rotate_tac 7)
  apply(drule_tac pi="pia" in a)
  apply(simp)
  done


end

