theory Classical
imports "../Nominal2"
begin

(* example from Urban's PhD *)

atom_decl name
atom_decl coname

nominal_datatype trm =
  Ax "name" "coname"
| Cut c::"coname" t1::"trm" n::"name" t2::"trm"             bind n in t1, bind c in t2  
     ("Cut <_>._ '(_')._" [100,100,100,100] 100)
| NotR n::"name" t::"trm" "coname"                            bind n in t
     ("NotR '(_')._ _" [100,100,100] 100)
| NotL c::"coname" t::"trm" "name"                            bind c in t   
     ("NotL <_>._ _" [100,100,100] 100)
| AndR c1::"coname" t1::"trm" c2::"coname" t2::"trm" "coname" bind c1 in t1, bind c2 in t2
     ("AndR <_>._ <_>._ _" [100,100,100,100,100] 100)
| AndL1 n::"name" t::"trm" "name"                             bind n in t
     ("AndL1 '(_')._ _" [100,100,100] 100)
| AndL2 n::"name" t::"trm" "name"                             bind n in t
     ("AndL2 '(_')._ _" [100,100,100] 100)
| OrR1 c::"coname" t::"trm" "coname"                          bind c in t             
     ("OrR1 <_>._ _" [100,100,100] 100)
| OrR2 c::"coname" t::"trm" "coname"                          bind c in t     
     ("OrR2 <_>._ _" [100,100,100] 100)
| OrL n1::"name" t1::"trm" n2::"name" t2::"trm" "name"        bind n1 in t1, bind n2 in t2       
     ("OrL '(_')._ '(_')._ _" [100,100,100,100,100] 100)
| ImpL c::"coname" t1::"trm" n::"name" t2::"trm" "name"       bind c in t1, bind n in t2
     ("ImpL <_>._ '(_')._ _" [100,100,100,100,100] 100)
| ImpR n::"name" c::"coname" t::"trm" "coname"                bind n c in t
     ("ImpR '(_').<_>._ _" [100,100,100,100] 100)

thm trm.distinct
thm trm.induct
thm trm.exhaust
thm trm.strong_exhaust
thm trm.strong_exhaust[simplified]
thm trm.fv_defs
thm trm.bn_defs
thm trm.perm_simps
thm trm.eq_iff
thm trm.fv_bn_eqvt
thm trm.size_eqvt
thm trm.supp
thm trm.supp[simplified]

lemma Abs_lst1_fcb2:
  fixes a b :: "'a :: at"
    and S T :: "'b :: fs"
    and c::"'c::fs"
  assumes e: "(Abs_lst [atom a] T) = (Abs_lst [atom b] S)"
  and fcb1: "atom a \<sharp> f a T c"
  and fresh: "{atom a, atom b} \<sharp>* c"
  and perm1: "\<And>p. supp p \<sharp>* c \<Longrightarrow> p \<bullet> (f a T c) = f (p \<bullet> a) (p \<bullet> T) c"
  and perm2: "\<And>p. supp p \<sharp>* c \<Longrightarrow> p \<bullet> (f b S c) = f (p \<bullet> b) (p \<bullet> S) c"
  shows "f a T c = f b S c"
proof -
  have fcb2: "atom b \<sharp> f b S c"
    using e[symmetric]
    apply(simp add: Abs_eq_iff2)
    apply(erule exE)
    apply(simp add: alphas)
    apply(rule_tac p="p" in permute_boolE)
    apply(simp add: fresh_eqvt)
    apply(subst perm2)
    using fresh
    apply(auto simp add: fresh_star_def)[1]
    apply(simp add: atom_eqvt)
    apply(rule fcb1)
    done
  have fin1: "finite (supp (f a T c))"
    apply(rule_tac S="supp (a, T, c)" in supports_finite)
    apply(simp add: supports_def)
    apply(simp add: fresh_def[symmetric])
    apply(clarify)
    apply(subst perm1)
    apply(simp add: supp_swap fresh_star_def)
    apply(simp add: swap_fresh_fresh fresh_Pair)
    apply(simp add: finite_supp)
    done
  have fin2: "finite (supp (f b S c))"
    apply(rule_tac S="supp (b, S, c)" in supports_finite)
    apply(simp add: supports_def)
    apply(simp add: fresh_def[symmetric])
    apply(clarify)
    apply(subst perm2)
    apply(simp add: supp_swap fresh_star_def)
    apply(simp add: swap_fresh_fresh fresh_Pair)
    apply(simp add: finite_supp)
    done
  obtain d::"'a::at" where fr: "atom d \<sharp> (a, b, S, T, c, f a T c, f b S c)" 
    using obtain_fresh'[where x="(a, b, S, T, c, f a T c, f b S c)"]
    apply(auto simp add: finite_supp supp_Pair fin1 fin2)
    done
  have "(a \<leftrightarrow> d) \<bullet> (Abs_lst [atom a] T) = (b \<leftrightarrow> d) \<bullet> (Abs_lst [atom b] S)" 
    apply(simp (no_asm_use) only: flip_def)
    apply(subst swap_fresh_fresh)
    apply(simp add: Abs_fresh_iff)
    using fr
    apply(simp add: Abs_fresh_iff)
    apply(subst swap_fresh_fresh)
    apply(simp add: Abs_fresh_iff)
    using fr
    apply(simp add: Abs_fresh_iff)
    apply(rule e)
    done
  then have "Abs_lst [atom d] ((a \<leftrightarrow> d) \<bullet> T) = Abs_lst [atom d] ((b \<leftrightarrow> d) \<bullet> S)"
    apply (simp add: swap_atom flip_def)
    done
  then have eq: "(a \<leftrightarrow> d) \<bullet> T = (b \<leftrightarrow> d) \<bullet> S"
    by (simp add: Abs1_eq_iff)
  have "f a T c = (a \<leftrightarrow> d) \<bullet> f a T c"
    unfolding flip_def
    apply(rule sym)
    apply(rule swap_fresh_fresh)
    using fcb1 
    apply(simp)
    using fr
    apply(simp add: fresh_Pair)
    done
  also have "... = f d ((a \<leftrightarrow> d) \<bullet> T) c"
    unfolding flip_def
    apply(subst perm1)
    using fresh fr
    apply(simp add: supp_swap fresh_star_def fresh_Pair)
    apply(simp)
    done
  also have "... = f d ((b \<leftrightarrow> d) \<bullet> S) c" using eq by simp
  also have "... = (b \<leftrightarrow> d) \<bullet> f b S c"
    unfolding flip_def
    apply(subst perm2)
    using fresh fr
    apply(simp add: supp_swap fresh_star_def fresh_Pair)
    apply(simp)
    done
  also have "... = f b S c"   
    apply(rule flip_fresh_fresh)
    using fcb2
    apply(simp)
    using fr
    apply(simp add: fresh_Pair)
    done
  finally show ?thesis by simp
qed

(*
lemma Abs_lst_fcb2:
  fixes as bs :: "atom list"
    and x y :: "'b :: fs"
    and c::"'c::fs"
  assumes e: "(Abs_lst as x) = (Abs_lst bs y)"
  and fcb1: "(set as) \<sharp>* f as x c"
  and fcb2: "(set bs) \<sharp>* f bs y c"
  and fresh1: "set as \<sharp>* c"
  and fresh2: "set bs \<sharp>* c"
  and perm1: "\<And>p. supp p \<sharp>* c \<Longrightarrow> p \<bullet> (f as x c) = f (p \<bullet> as) (p \<bullet> x) c"
  and perm2: "\<And>p. supp p \<sharp>* c \<Longrightarrow> p \<bullet> (f bs y c) = f (p \<bullet> bs) (p \<bullet> y) c"
  shows "f as x c = f bs y c"
*)

lemma supp_zero_perm_zero:
  shows "supp (p :: perm) = {} \<longleftrightarrow> p = 0"
  by (metis supp_perm_singleton supp_zero_perm)

lemma permute_atom_list_id:
  shows "p \<bullet> l = l \<longleftrightarrow> supp p \<inter> set l = {}"
  by (induct l) (auto simp add: supp_Nil supp_perm)

lemma Abs_lst_binder_length:
  shows "[xs]lst. T = [ys]lst. S \<Longrightarrow> length xs = length ys"
  by (auto simp add: Abs_eq_iff alphas length_eqvt[symmetric] permute_pure)

lemma Abs_lst_binder_eq:
  shows "Abs_lst l T = Abs_lst l S \<longleftrightarrow> T = S"
  by (rule, simp_all add: Abs_eq_iff2 alphas)
     (metis fresh_star_zero inf_absorb1 permute_atom_list_id supp_perm_eq
       supp_zero_perm_zero)

nominal_primrec 
  crename :: "trm \<Rightarrow> coname \<Rightarrow> coname \<Rightarrow> trm"  ("_[_\<turnstile>c>_]" [100,100,100] 100) 
where
  "(Ax x a)[d\<turnstile>c>e] = (if a=d then Ax x e else Ax x a)" 
| "atom a \<sharp> (d, e) \<Longrightarrow> (Cut <a>.M (x).N)[d\<turnstile>c>e] = Cut <a>.(M[d\<turnstile>c>e]) (x).(N[d\<turnstile>c>e])" 
| "(NotR (x).M a)[d\<turnstile>c>e] = (if a=d then NotR (x).(M[d\<turnstile>c>e]) e else NotR (x).(M[d\<turnstile>c>e]) a)" 
| "atom a \<sharp> (d, e) \<Longrightarrow> (NotL <a>.M x)[d\<turnstile>c>e] = (NotL <a>.(M[d\<turnstile>c>e]) x)" 
| "\<lbrakk>atom a \<sharp> (d, e); atom b \<sharp> (d, e)\<rbrakk> \<Longrightarrow> (AndR <a>.M <b>.N c)[d\<turnstile>c>e] = 
          (if c=d then AndR <a>.(M[d\<turnstile>c>e]) <b>.(N[d \<turnstile>c>e]) e else AndR <a>.(M[d\<turnstile>c>e]) <b>.(N[d\<turnstile>c>e]) c)" 
| "(AndL1 (x).M y)[d\<turnstile>c>e] = AndL1 (x).(M[d\<turnstile>c>e]) y"
| "(AndL2 (x).M y)[d\<turnstile>c>e] = AndL2 (x).(M[d\<turnstile>c>e]) y"
| "atom a \<sharp> (d, e) \<Longrightarrow> (OrR1 <a>.M b)[d\<turnstile>c>e] = 
          (if b=d then OrR1 <a>.(M[d\<turnstile>c>e]) e else OrR1 <a>.(M[d\<turnstile>c>e]) b)"
| "atom a \<sharp> (d, e) \<Longrightarrow> (OrR2 <a>.M b)[d\<turnstile>c>e] = 
          (if b=d then OrR2 <a>.(M[d\<turnstile>c>e]) e else OrR2 <a>.(M[d\<turnstile>c>e]) b)"
| "(OrL (x).M (y).N z)[d\<turnstile>c>e] = OrL (x).(M[d\<turnstile>c>e]) (y).(N[d\<turnstile>c>e]) z"
| "atom a \<sharp> (d, e) \<Longrightarrow> (ImpR (x).<a>.M b)[d\<turnstile>c>e] = 
          (if b=d then ImpR (x).<a>.(M[d\<turnstile>c>e]) e else ImpR (x).<a>.(M[d\<turnstile>c>e]) b)"
| "atom a \<sharp> (d, e) \<Longrightarrow> (ImpL <a>.M (x).N y)[d\<turnstile>c>e] = ImpL <a>.(M[d\<turnstile>c>e]) (x).(N[d\<turnstile>c>e]) y"
  apply(simp only: eqvt_def)
  apply(simp only: crename_graph_def)
  apply (rule, perm_simp, rule)
  apply(rule TrueI)
  -- "covered all cases"
  apply(case_tac x)
  apply(rule_tac y="a" and c="(b, c)" in trm.strong_exhaust)
  apply (simp_all add: fresh_star_def)[12]
  apply(metis)+
  -- "compatibility"
  apply(simp_all)
  apply(rule conjI)
  apply(elim conjE)
  apply(erule_tac c="(da,ea)" in Abs_lst1_fcb2)
  apply(simp add: Abs_fresh_iff)
  apply(simp add: fresh_at_base fresh_star_def fresh_Pair)
  apply(simp add: eqvt_at_def atom_eqvt fresh_star_Pair perm_supp_eq)
  apply(simp add: eqvt_at_def atom_eqvt fresh_star_Pair perm_supp_eq)
  apply(elim conjE)
  apply(erule_tac c="(da,ea)" in Abs_lst1_fcb2)
  apply(simp add: Abs_fresh_iff)
  apply(simp add: fresh_at_base fresh_star_def fresh_Pair)
  apply(simp add: eqvt_at_def atom_eqvt fresh_star_Pair perm_supp_eq)
  apply(simp add: eqvt_at_def atom_eqvt fresh_star_Pair perm_supp_eq)
  apply(elim conjE)
  apply(subgoal_tac "eqvt_at crename_sumC (M, da, ea)")
  apply(subgoal_tac "eqvt_at crename_sumC (Ma, da, ea)")
  apply(erule Abs_lst1_fcb2)
  apply(simp add: Abs_fresh_iff)
  apply(simp add: fresh_at_base fresh_star_def fresh_Pair)
  apply(simp add: eqvt_at_def atom_eqvt fresh_star_Pair perm_supp_eq)
  apply(simp add: eqvt_at_def atom_eqvt fresh_star_Pair perm_supp_eq)
  apply(blast)
  apply(blast)
  apply(elim conjE)
  apply(erule_tac c="(da,ea)" in Abs_lst1_fcb2)
  apply(simp add: Abs_fresh_iff)
  apply(simp add: fresh_at_base fresh_star_def fresh_Pair)
  apply(simp add: eqvt_at_def atom_eqvt fresh_star_Pair perm_supp_eq)
  apply(simp add: eqvt_at_def atom_eqvt fresh_star_Pair perm_supp_eq)
  apply(rule conjI)
  apply(elim conjE)
  apply(subgoal_tac "eqvt_at crename_sumC (M, da, ea)")
  apply(subgoal_tac "eqvt_at crename_sumC (Ma, da, ea)")
  apply(erule Abs_lst1_fcb2)
  apply(simp add: Abs_fresh_iff)
  apply(simp add: fresh_at_base fresh_star_def fresh_Pair)
  apply(simp add: eqvt_at_def atom_eqvt fresh_star_Pair perm_supp_eq)
  apply(simp add: eqvt_at_def atom_eqvt fresh_star_Pair perm_supp_eq)
  apply(blast)
  apply(blast)
  apply(erule conjE)+
  apply(subgoal_tac "eqvt_at crename_sumC (N, da, ea)")
  apply(subgoal_tac "eqvt_at crename_sumC (Na, da, ea)")
  apply(erule Abs_lst1_fcb2)
  apply(simp add: Abs_fresh_iff)
  apply(simp add: fresh_at_base fresh_star_def fresh_Pair)
  apply(simp add: eqvt_at_def atom_eqvt fresh_star_Pair perm_supp_eq)
  apply(simp add: eqvt_at_def atom_eqvt fresh_star_Pair perm_supp_eq)
  apply(blast)
  apply(blast)
  apply(elim conjE)
  apply(erule_tac c="(da,ea)" in Abs_lst1_fcb2)
  apply(simp add: Abs_fresh_iff)
  apply(simp add: fresh_at_base fresh_star_def fresh_Pair)
  apply(simp add: eqvt_at_def atom_eqvt fresh_star_Pair perm_supp_eq)
  apply(simp add: eqvt_at_def atom_eqvt fresh_star_Pair perm_supp_eq)
  apply(elim conjE)
  apply(erule_tac c="(da,ea)" in Abs_lst1_fcb2)
  apply(simp add: Abs_fresh_iff)
  apply(simp add: fresh_at_base fresh_star_def fresh_Pair)
  apply(simp add: eqvt_at_def atom_eqvt fresh_star_Pair perm_supp_eq)
  apply(simp add: eqvt_at_def atom_eqvt fresh_star_Pair perm_supp_eq)
  apply(elim conjE)
  apply(subgoal_tac "eqvt_at crename_sumC (M, da, ea)")
  apply(subgoal_tac "eqvt_at crename_sumC (Ma, da, ea)")
  apply(erule Abs_lst1_fcb2)
  apply(simp add: Abs_fresh_iff)
  apply(simp add: fresh_at_base fresh_star_def fresh_Pair)
  apply(simp add: eqvt_at_def atom_eqvt fresh_star_Pair perm_supp_eq)
  apply(simp add: eqvt_at_def atom_eqvt fresh_star_Pair perm_supp_eq)
  apply(blast)
  apply(blast)
  apply(erule conjE)+
  apply(subgoal_tac "eqvt_at crename_sumC (M, da, ea)")
  apply(subgoal_tac "eqvt_at crename_sumC (Ma, da, ea)")
  apply(erule Abs_lst1_fcb2)
  apply(simp add: Abs_fresh_iff)
  apply(simp add: fresh_at_base fresh_star_def fresh_Pair)
  apply(simp add: eqvt_at_def atom_eqvt fresh_star_Pair perm_supp_eq)
  apply(simp add: eqvt_at_def atom_eqvt fresh_star_Pair perm_supp_eq)
  apply(blast)
  apply(blast)
  apply(rule conjI)
  apply(erule conjE)+
  apply(subgoal_tac "eqvt_at crename_sumC (M, da, ea)")
  apply(subgoal_tac "eqvt_at crename_sumC (Ma, da, ea)")
  apply(erule Abs_lst1_fcb2)
  apply(simp add: Abs_fresh_iff)
  apply(simp add: fresh_at_base fresh_star_def fresh_Pair)
  apply(simp add: eqvt_at_def atom_eqvt fresh_star_Pair perm_supp_eq)
  apply(simp add: eqvt_at_def atom_eqvt fresh_star_Pair perm_supp_eq)
  apply(blast)
  apply(blast)
  apply(erule conjE)+
  apply(subgoal_tac "eqvt_at crename_sumC (N, da, ea)")
  apply(subgoal_tac "eqvt_at crename_sumC (Na, da, ea)")
  apply(erule Abs_lst1_fcb2)
  apply(simp add: Abs_fresh_iff)
  apply(simp add: fresh_at_base fresh_star_def fresh_Pair)
  apply(simp add: eqvt_at_def atom_eqvt fresh_star_Pair perm_supp_eq)
  apply(simp add: eqvt_at_def atom_eqvt fresh_star_Pair perm_supp_eq)
  apply(blast)
  apply(blast)
  defer
  apply(erule conjE)+
  apply(rule conjI)
  apply(subgoal_tac "eqvt_at crename_sumC (M, da, ea)")
  apply(subgoal_tac "eqvt_at crename_sumC (Ma, da, ea)")
  apply(erule Abs_lst1_fcb2)
  apply(simp add: Abs_fresh_iff)
  apply(simp add: fresh_at_base fresh_star_def fresh_Pair)
  apply(simp add: eqvt_at_def atom_eqvt fresh_star_Pair perm_supp_eq)
  apply(simp add: eqvt_at_def atom_eqvt fresh_star_Pair perm_supp_eq)
  apply(blast)
  apply(blast)  
  apply(subgoal_tac "eqvt_at crename_sumC (N, da, ea)")
  apply(subgoal_tac "eqvt_at crename_sumC (Na, da, ea)")
  apply(erule Abs_lst1_fcb2)
  apply(simp add: Abs_fresh_iff)
  apply(simp add: fresh_at_base fresh_star_def fresh_Pair)
  apply(simp add: eqvt_at_def atom_eqvt fresh_star_Pair perm_supp_eq)
  apply(simp add: eqvt_at_def atom_eqvt fresh_star_Pair perm_supp_eq)
  apply(blast)
  apply(blast)
  oops

end



